package riakdemo.console;

import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import riakdemo.backend.ContextStore;

public class UseContextCommand extends AbstractCommand {

	private static final Logger LOGGER = LoggerFactory.getLogger(UseContextCommand.class);
	
	private boolean active = true;
	private ContextStore contextStore;

	public UseContextCommand(ContextStore contextStore, String... commandNames) {
		super(commandNames);
		this.contextStore = contextStore;
	}

	@Override
	public String getUsageArguments() {
		return "<true/false>";
	}

	@Override
	public String getUsageDescription() {
		return String.format("Use context between fetch/upsert/delete operations. Currently: %s.", active);
	}

	@Override
	public int execute(List<String> arguments) {
		if (arguments.size() != 1) {
			System.err.println(getWrongArgumentsMessage());
			return 1;
		}

		boolean newActive = false;
		try {
			newActive = Boolean.parseBoolean(arguments.get(0));
		} catch (Exception e) {
			System.err.println(getWrongArgumentsMessage());
			return 1;
		}

		active = newActive;

		if (active == false) {
			contextStore.clear();
		}

		System.out.println("Use context: " + active);

		return 0;
	}

	public boolean isActive() {
		return active;
	}

	
}
