package riakdemo.console;

import java.util.List;

import com.basho.riak.client.api.cap.VClock;

import riakdemo.backend.BackendException;
import riakdemo.backend.BackendSession;
import riakdemo.backend.ContextStore;
import riakdemo.backend.User;
import riakdemo.tools.Pair;

public class StoreCommand extends AbstractCommand {

	private BackendSession session;
	private ContextStore contextStore;
	private NamespaceCommand namespaceCommand;
	private UseContextCommand useContextCommand;

	public StoreCommand(BackendSession session, ContextStore contextStore, NamespaceCommand namespaceCommand,
			UseContextCommand useContextCommand, String... commandNames) {
		super(commandNames);
		this.session = session;
		this.contextStore = contextStore;
		this.namespaceCommand = namespaceCommand;
		this.useContextCommand = useContextCommand;
	}

	@Override
	public String getUsageArguments() {
		return "<name (key)> <company name> [<phone> [<street>]]";
	}

	@Override
	public String getUsageDescription() {
		return "Insert or update user info.";
	}

	@Override
	public int execute(List<String> arguments) {
		boolean error = false;
		if (arguments.size() < 2)
			error = true;

		Integer phone = null;
		if (arguments.size() >= 3) {
			try {
				phone = Integer.parseInt(arguments.get(2));
			} catch (NumberFormatException e) {
				error = true;
			}
		}

		String street = null;
		if (arguments.size() >= 4) {
			street = arguments.get(3);
		}

		if (error) {
			System.err.println(getWrongArgumentsMessage());
			return 1;
		}

		String name = arguments.get(0);
		String companyName = arguments.get(1);

		User user = new User(name, companyName, phone, street);
		Pair<Boolean, VClock> pair = contextStore.get(namespaceCommand.getNamespaceAsString(), name);

		try {
			session.upsertUser(namespaceCommand.getNamespace(), name, user, pair.second,
					pair.first & useContextCommand.isActive());
		} catch (BackendException e) {
			e.printStackTrace();
		}

		return 0;
	}
}
