package riakdemo.console;

import java.util.List;

import com.basho.riak.client.core.query.Namespace;

public class NamespaceCommand extends AbstractCommand {

	private static final String DEFAULT_NAMESPACE = "users";
	
	private String namespace = DEFAULT_NAMESPACE;
	private BucketTypeCommand bucketTypeCommand;
	
	public NamespaceCommand(BucketTypeCommand bucketTypeCommand, String... commandNames) {
		super(commandNames);
		this.bucketTypeCommand = bucketTypeCommand;
	}
	
	@Override
	public String getUsageArguments() {
		return "<namespace>";
	}

	@Override
	public String getUsageDescription() {
		return String.format("Set default namespace. Currently: %s.", getNamespace().getBucketNameAsString());
	}

	@Override
	public int execute(List<String> arguments) {
		if (arguments.size() != 1) {
			System.err.println(getWrongArgumentsMessage());
			return 1;
		}
		
		namespace = arguments.get(0);
		
		System.out.println("Current namespace: " + namespace);
		
		return 0;
	}
	
	public Namespace getNamespace() {
		Namespace ret = new Namespace(bucketTypeCommand.getBucketType(), namespace);
		return ret;
	}
	
	public String getNamespaceAsString() {
		Namespace ret = new Namespace(bucketTypeCommand.getBucketType(), namespace);
		return String.join("/", ret.getBucketTypeAsString(), ret.getBucketNameAsString());
	}

}
