package riakdemo.console;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Menu {
	public static final Pattern LINE_PATTERN = Pattern.compile("([^\"]\\S*|\".+?\")\\s*");

	private Map<String, AbstractCommand> commands = new HashMap<String, AbstractCommand>();
	private Set<MenuEntry> sortedMenuEntries = new TreeSet<MenuEntry>(new Comparator<MenuEntry>() {

		@Override
		public int compare(MenuEntry o1, MenuEntry o2) {
			return o1.priority - o2.priority;
		}
	});

	public Menu() {
		AbstractCommand helpCommand = new HelpCommand(sortedMenuEntries, "help", "h");
		this.register(helpCommand, 100);
	}

	public void register(AbstractCommand command, int menuPriority) {
		String[] commandNames = command.getCommandNames();

		for (String c : commandNames) {
			AbstractCommand oldCommand = commands.put(c, command);
			if (oldCommand != null)
				throw new RuntimeException("Duplicated key " + c + ". Exitting.");
			MenuEntry entry = new MenuEntry(command, menuPriority);
			sortedMenuEntries.add(entry);
		}
	}

	public static List<String> splitString(String line) {
		List<String> list = new ArrayList<String>();
		Matcher m = LINE_PATTERN.matcher(line);
		while (m.find()) {
			String entry = m.group(1);
			if (entry.startsWith("\"") && entry.endsWith("\""))
				entry = entry.subSequence(1, entry.length() - 1).toString();
			list.add(entry);
		}
		return list;
	}

	public void execute() {
		Scanner scanner = new Scanner(System.in);

		while (true) {
			System.out.print("> ");
			System.out.flush();
			String line = scanner.nextLine();

			List<String> tokens = splitString(line.trim());

			if (tokens.size() == 0)
				continue;

			String commandName = tokens.get(0);
			tokens.remove(0);
			List<String> arguments = tokens;

			AbstractCommand command = commands.get(commandName);

			if (command == null) {
				System.err.println("No such command");
				continue;
			}

			if (command.execute(arguments) == -1)
				break;
		}

		scanner.close();
	}
}
