package riakdemo.console;

import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public class HelpCommand extends AbstractCommand {

	private static final String ENTRY_FORMAT = "  %-64s %s\n";

	private Set<MenuEntry> sortedMenuEntries;

	public HelpCommand(Set<MenuEntry> sortedMenuEntries, String... commandNames) {
		super(commandNames);
		this.sortedMenuEntries = sortedMenuEntries;
	}

	@Override
	public String getUsageArguments() {
		return "";
	}

	@Override
	public String getUsageDescription() {
		return "Show this help.";
	}

	@Override
	public int execute(List<String> arguments) {
		StringBuilder builder = new StringBuilder();

		builder.append("RiakDemo menu:\n");

		// Comparator<AbstractCommand> comparator = new Comparator<AbstractCommand>() {
		// @Override
		// public int compare(AbstractCommand left, AbstractCommand right) {
		// return left.getCommandNames()[0].compareTo(right.getCommandNames()[0]);
		// }
		// };

		int currentPriority = Integer.MIN_VALUE;
		for (MenuEntry e : sortedMenuEntries) {
			int priority = e.priority;
			AbstractCommand command = e.command;

			if (priority - currentPriority > 1 && currentPriority != Integer.MIN_VALUE)
				builder.append("\n");
			currentPriority = priority;

			String allAliases = commandsAliasesString(command.getCommandNames());
			String usageArguments = command.getUsageArguments();
			String commandStub = allAliases + " " + usageArguments;
			String usage = command.getUsageDescription();
			builder.append(String.format(ENTRY_FORMAT, commandStub, usage));
		}

		System.out.print(builder.toString());

		return 0;
	}

}
