package riakdemo.console;

import java.util.List;

import com.basho.riak.client.api.cap.VClock;

import riakdemo.backend.BackendException;
import riakdemo.backend.BackendSession;
import riakdemo.backend.ContextStore;
import riakdemo.backend.User;
import riakdemo.tools.Pair;

public class FetchCommand extends AbstractCommand {
	
	private BackendSession session;
	private ContextStore contextStore;
	private NamespaceCommand namespaceCommand;
	private UseContextCommand useContextCommand;

	public FetchCommand(BackendSession session, ContextStore contextStore, NamespaceCommand namespaceCommand, UseContextCommand useContextCommand, String... commandNames) {
		super(commandNames);
		this.session = session;
		this.contextStore = contextStore;
		this.namespaceCommand = namespaceCommand;
		this.useContextCommand = useContextCommand;
	}

	@Override
	public String getUsageArguments() {
		return "<name (key)>";
	}

	@Override
	public String getUsageDescription() {
		return "Fetch user by name and print the retrieved data.";
	}

	@Override
	public int execute(List<String> arguments) {
		if (arguments.size() != 1) {
			System.err.println(getWrongArgumentsMessage());
			return 1;
		}

		String name = arguments.get(0);
		Pair<List<User>,VClock> response = null;
		try {
			response = session.fetchUserSiblings(namespaceCommand.getNamespace(), name);
		} catch (BackendException e) {
			e.printStackTrace();
		} 
		
		List<User> siblings = response.first;
		VClock vclock = response.second;
		
		if (useContextCommand.isActive() && vclock != null) {
			contextStore.put(namespaceCommand.getNamespaceAsString(), name, vclock);
		}
		
		if (siblings == null || siblings.size() == 0) {
			System.out.println(String.format("There's no user %s.", name));
			return 0;
		}
		
		StringBuilder builder = new StringBuilder();
		for (User user : siblings) {
			builder.append(String.format("%s\n", user));
		}
		
		System.out.print(builder.toString());

		return 0;
	}

}
