package riakdemo.console;

import java.util.List;

import com.basho.riak.client.api.cap.VClock;

import riakdemo.backend.BackendException;
import riakdemo.backend.BackendSession;
import riakdemo.backend.ContextStore;
import riakdemo.tools.Pair;

public class DeleteCommand extends AbstractCommand {

	private BackendSession session;
	private ContextStore contextStore;
	private NamespaceCommand namespaceCommand;
	private UseContextCommand useContextCommand;

	public DeleteCommand(BackendSession session, ContextStore contextStore, NamespaceCommand namespaceCommand, UseContextCommand useContextCommand,
			String... commandNames) {
		super(commandNames);
		this.session = session;
		this.contextStore = contextStore;
		this.namespaceCommand = namespaceCommand;
		this.useContextCommand = useContextCommand;
	}

	@Override
	public String getUsageArguments() {
		return "<name (key)>";
	}

	@Override
	public String getUsageDescription() {
		return "Delete user by name.";
	}

	@Override
	public int execute(List<String> arguments) {
		if (arguments.size() != 1) {
			System.err.println(getWrongArgumentsMessage());
			return 1;
		}

		String name = arguments.get(0);
		Pair<Boolean, VClock> pair = contextStore.get(namespaceCommand.getNamespaceAsString(), name);

		try {
			session.deleteUser(namespaceCommand.getNamespace(), name, pair.second,
					pair.first & useContextCommand.isActive());
		} catch (BackendException e) {
			e.printStackTrace();
		}

		return 0;
	}
}
