package riakdemo.console;

import java.util.List;

public class BucketTypeCommand extends AbstractCommand {

	private static final String DEFAULT_BUCKET_TYPE = "default";

	private String bucketType = DEFAULT_BUCKET_TYPE;

	public BucketTypeCommand(String... commandNames) {
		super(commandNames);
	}

	@Override
	public String getUsageArguments() {
		return "<bucket-type>";
	}

	@Override
	public String getUsageDescription() {
		return String.format("Set default bucket-type. Currently: %s.", bucketType);
	}

	@Override
	public int execute(List<String> arguments) {
		if (arguments.size() != 1) {
			System.err.println(getWrongArgumentsMessage());
			return 1;
		}

		bucketType = arguments.get(0);

		System.out.println("Current bucket-type: " + bucketType);

		return 0;
	}

	public String getBucketType() {
		return bucketType;
	}
}
