package riakdemo.console;

import java.util.List;

public abstract class AbstractCommand {
	
	private String[] commandNames;
	
	public AbstractCommand(String... commandNames) {
		this.commandNames = commandNames;
	}
	
	public String[] getCommandNames() {
		return commandNames;
	}
	
	protected String commandsAliasesString(String[] commandNames) {
		return String.join("/", commandNames);
	}
	
	public String getUsage() {
		return commandsAliasesString(commandNames) + " " + getUsageArguments();
	}
	
	public abstract String getUsageArguments();
	
	public abstract String getUsageDescription();
	
	public abstract int execute(List<String> arguments);
	
	public String getWrongArgumentsMessage() {
		return "Wrong arguments. " + getUsage();
	}
}
