package riakdemo.backend;

import java.util.HashMap;
import java.util.Map;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.basho.riak.client.api.cap.VClock;

import riakdemo.tools.Pair;

public class ContextStore {
	private static final Logger LOGGER = LoggerFactory.getLogger(ContextStore.class);
	private static final VClock SENTINEL_VCLOCK = new VClock() {

		@Override
		public byte[] getBytes() {
			return null;
		}

		@Override
		public String asString() {
			return null;
		}
	};
	
	private Map<String, VClock> vclockMap = new HashMap<String, VClock>();

	public ContextStore() {
	}
	
	private String getLocation(String prefix, String key) {
		return String.join("/", prefix, key).toString();
	}

	public Pair<Boolean, VClock> get(String path, String key) {
		String location = getLocation(path, key);
		VClock vclock = vclockMap.getOrDefault(location, SENTINEL_VCLOCK);
		Pair<Boolean, VClock> ret = new Pair<Boolean, VClock>(vclock != SENTINEL_VCLOCK, vclock);
		return ret;
	}

	public void put(String path, String key, VClock vclock) {
		vclockMap.put(getLocation(path, key), vclock);
		// LOGGER.info(
		//	"vclockMap.put(" + getLocation(path, key) + ", " + (vclock == null ? "null" : vclock.toString()) + ")");
	}

	public void remove(String path, String key) {
		vclockMap.remove(getLocation(path, key));
		// LOGGER.info("vclockMap.remove(" + getLocation(path, key) + ")");
	}
	
	public void clear() {
		vclockMap.clear();
	}

}
