package riakdemo;

import java.io.IOException;
import java.util.Properties;

import com.basho.riak.client.core.util.DefaultCharset;

import java.nio.charset.StandardCharsets;

import riakdemo.backend.BackendException;
import riakdemo.backend.BackendSession;
import riakdemo.backend.ContextStore;
import riakdemo.console.BucketTypeCommand;
import riakdemo.console.DeleteCommand;
import riakdemo.console.FetchCommand;
import riakdemo.console.Menu;
import riakdemo.console.NamespaceCommand;
import riakdemo.console.QuitCommand;
import riakdemo.console.StoreCommand;
import riakdemo.console.UseContextCommand;

public class Main {
	private static final String PROPERTIES_FILENAME = "config.properties";

	public static void main(String[] args) throws BackendException {
		String contactPoint = null;
		Integer contactPointPort = null;

		Properties properties = new Properties();
		try {
			properties.load(Main.class.getClassLoader().getResourceAsStream(PROPERTIES_FILENAME));

			contactPoint = properties.getProperty("contact_point");
			contactPointPort = Integer.parseInt(properties.getProperty("contact_point_port"));
		} catch (IOException ex) {
			ex.printStackTrace();
		}
		
		BackendSession session = new BackendSession(contactPoint, contactPointPort);
		ContextStore contextStore = new ContextStore();

		Menu menu = new Menu();
		QuitCommand quitCommand = new QuitCommand("quit", "q");
		BucketTypeCommand bucketTypeCommand = new BucketTypeCommand("type", "t");
		NamespaceCommand namespaceCommand = new NamespaceCommand(bucketTypeCommand, "namespace", "n");
		UseContextCommand useContextCommand = new UseContextCommand(contextStore, "context", "c");
		DeleteCommand deleteCommand = new DeleteCommand(session, contextStore, namespaceCommand, useContextCommand,
				"delete", "d");
		FetchCommand fetchCommand = new FetchCommand(session, contextStore, namespaceCommand, useContextCommand,
				"fetch", "f");
		StoreCommand storeCommand = new StoreCommand(session, contextStore, namespaceCommand, useContextCommand,
				"store", "s");
		
		menu.register(quitCommand, 20);
		menu.register(useContextCommand, 1);
		menu.register(namespaceCommand, 2);
		menu.register(bucketTypeCommand, 3);
		menu.register(deleteCommand, 10);
		menu.register(fetchCommand, 11);
		menu.register(storeCommand, 12);

		menu.execute();
		
		System.exit(0);
	}
}
