/*
 * Decompiled with CFR 0.152.
 */
package rcaller;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import rcaller.EventHandler;

public class RStreamHandler
implements Runnable {
    private InputStream stream = null;
    private BufferedReader reader = null;
    private final Thread consumerThread;
    private boolean closeSignal = false;
    private String name = null;
    private ArrayList<EventHandler> eventHandlers = null;

    public RStreamHandler(InputStream stream, String name) {
        this.stream = stream;
        this.name = name;
        this.consumerThread = new Thread((Runnable)this, name + "ProcessorThread");
        this.eventHandlers = new ArrayList();
    }

    public void setStream(InputStream stream) {
        this.stream = stream;
    }

    public void addEventHandler(EventHandler eh) {
        this.eventHandlers.add(eh);
    }

    public void removeEventHandler(EventHandler eh) {
        this.eventHandlers.remove(eh);
    }

    public void setCloseSignal(boolean closeSignal) {
        this.closeSignal = closeSignal;
    }

    public void start() {
        this.closeSignal = false;
        this.consumerThread.start();
    }

    public boolean isAlive() {
        return this.consumerThread.isAlive();
    }

    public void run() {
        if (this.reader == null) {
            this.reader = new BufferedReader(new InputStreamReader(this.stream));
        }
        while (!this.closeSignal) {
            try {
                String s = this.reader.readLine();
                if (s == null) continue;
                for (EventHandler eventHandler : this.eventHandlers) {
                    eventHandler.messageReceived(this.name, s);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

