/*
 * Decompiled with CFR 0.152.
 */
package rcaller;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import rcaller.exception.ParseException;
import rcaller.exception.XMLParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ROutputParser {
    protected File XMLFile;
    protected DocumentBuilderFactory factory;
    protected DocumentBuilder builder;
    protected Document document;
    private final String variable_tag_name = "variable";

    public Document getDocument() {
        return this.document;
    }

    public void setDocument(Document document) {
        this.document = document;
    }

    public File getXMLFile() {
        return this.XMLFile;
    }

    public String getXMLFileAsString() throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(this.XMLFile));
        long filesize = this.XMLFile.length();
        char[] chars = new char[(int)filesize];
        reader.read(chars);
        String result = new String(chars);
        return result;
    }

    public void setXMLFile(File XMLFile) {
        this.XMLFile = XMLFile;
    }

    public void parse() throws ParseException {
        if (this.XMLFile.length() == 0L) {
            throw new ParseException("Can not parse output: The generated file " + this.XMLFile.toString() + " is empty");
        }
        this.factory = DocumentBuilderFactory.newInstance();
        try {
            this.builder = this.factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new ParseException("Can not create parser builder: " + e.toString());
        }
        try {
            this.document = this.builder.parse(this.XMLFile);
        }
        catch (Exception e) {
            throw new XMLParseException("Can not parse the R output: " + e.toString());
        }
        this.document.getDocumentElement().normalize();
    }

    public ROutputParser(File XMLFile) {
        this.XMLFile = XMLFile;
    }

    public ROutputParser() {
    }

    public ArrayList<String> getNames() {
        ArrayList<String> names = new ArrayList<String>();
        NodeList nodes = this.document.getElementsByTagName("variable");
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            names.add(node.getAttributes().getNamedItem("name").getNodeValue());
        }
        return names;
    }

    public int[] getDimensions(String name) {
        int[] result = new int[2];
        int n = 0;
        int m = 0;
        NodeList nodes = this.document.getElementsByTagName("variable");
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (!node.getAttributes().getNamedItem("name").getNodeValue().equals(name)) continue;
            String sn = node.getAttributes().getNamedItem("n").getNodeValue();
            String sm = node.getAttributes().getNamedItem("m").getNodeValue();
            n = Integer.parseInt(sn);
            m = Integer.parseInt(sm);
            break;
        }
        result[0] = n;
        result[1] = m;
        return result;
    }

    public NodeList getValueNodes(String name) {
        NodeList nodes = this.document.getElementsByTagName("variable");
        NodeList content = null;
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (!node.getAttributes().getNamedItem("name").getNodeValue().equals(name)) continue;
            content = node.getChildNodes();
            break;
        }
        return content;
    }

    public String[] getAsStringArray(String name) throws ParseException {
        NodeList nodes = this.getValueNodes(name);
        if (nodes == null) {
            throw new ParseException("Variable " + name + " not found");
        }
        ArrayList<String> values = new ArrayList<String>();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (node.getNodeType() != 1) continue;
            values.add(node.getTextContent());
        }
        String[] result = new String[values.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (String)values.get(i);
        }
        return result;
    }

    public double[] getAsDoubleArray(String name) throws ParseException {
        String[] strResults = this.getAsStringArray(name);
        double[] d = new double[strResults.length];
        for (int i = 0; i < strResults.length; ++i) {
            try {
                d[i] = Double.parseDouble(strResults[i]);
                continue;
            }
            catch (NumberFormatException e) {
                throw new ParseException("String value '" + strResults[i] + "' can not convert to double");
            }
        }
        return d;
    }

    public float[] getAsFloatArray(String name) throws ParseException {
        String[] strResults = this.getAsStringArray(name);
        float[] f = new float[strResults.length];
        for (int i = 0; i < strResults.length; ++i) {
            try {
                f[i] = Float.parseFloat(strResults[i]);
                continue;
            }
            catch (NumberFormatException e) {
                throw new ParseException("String value '" + strResults[i] + "' can not convert to float");
            }
        }
        return f;
    }

    public int[] getAsIntArray(String name) throws ParseException {
        String[] strResults = this.getAsStringArray(name);
        int[] ints = new int[strResults.length];
        for (int i = 0; i < strResults.length; ++i) {
            try {
                ints[i] = Integer.parseInt(strResults[i]);
                continue;
            }
            catch (NumberFormatException e) {
                throw new ParseException("String value '" + strResults[i] + "' can not convert to int");
            }
        }
        return ints;
    }

    public long[] getAsLongArray(String name) throws ParseException {
        String[] strResults = this.getAsStringArray(name);
        long[] longs = new long[strResults.length];
        for (int i = 0; i < strResults.length; ++i) {
            try {
                longs[i] = Long.parseLong(strResults[i]);
                continue;
            }
            catch (NumberFormatException e) {
                throw new ParseException("String value '" + strResults[i] + "' can not convert to long");
            }
        }
        return longs;
    }

    public boolean[] getAsLogicalArray(String name) throws ParseException {
        String[] strResults = this.getAsStringArray(name);
        boolean[] bools = new boolean[strResults.length];
        for (int i = 0; i < strResults.length; ++i) {
            try {
                bools[i] = Boolean.parseBoolean(strResults[i]);
                continue;
            }
            catch (Exception e) {
                throw new ParseException("String value '" + strResults[i] + "' can not convert to boolean");
            }
        }
        return bools;
    }

    public double[][] getAsDoubleMatrix(String name, int n, int m) throws ParseException {
        double[][] result = new double[n][m];
        double[] arr = this.getAsDoubleArray(name);
        int c = 0;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < m; ++j) {
                result[i][j] = arr[c];
                ++c;
            }
        }
        return result;
    }
}

