/*
 * Decompiled with CFR 0.152.
 */
package rcaller;

import graphics.GraphicsType;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.swing.ImageIcon;
import rcaller.CodeUtils;
import rcaller.Globals;
import rcaller.RPlotViewer;
import rcaller.TempFileService;
import rcaller.exception.ExecutionException;

public class RCode {
    protected StringBuffer code = new StringBuffer();
    protected TempFileService tempFileService = null;

    public void setCode(StringBuffer sb) {
        this.code = new StringBuffer();
        this.clear();
        this.code.append(sb);
    }

    public StringBuffer getCode() {
        return this.code;
    }

    public RCode() {
        this.clear();
    }

    public RCode(StringBuffer sb) {
        this.clear();
        this.code.append(sb);
    }

    public final void clear() {
        this.code.setLength(0);
        try {
            String s;
            InputStream is = this.getClass().getResourceAsStream("runiversal.r");
            InputStreamReader reader = new InputStreamReader(is);
            BufferedReader breader = new BufferedReader(reader);
            while ((s = breader.readLine()) != null) {
                this.addRCode(s);
            }
            this.addRCode("\n");
        }
        catch (IOException e) {
            throw new ExecutionException("runiversal.R in package: " + e.toString());
        }
    }

    public void clearOnline() {
        this.code.setLength(0);
    }

    public void addRCode(String code) {
        this.code.append(code).append("\n");
    }

    public void addStringArray(String name, String[] arr) {
        CodeUtils.addStringArray(this.code, name, arr, false);
    }

    public void addDoubleArray(String name, double[] arr) {
        CodeUtils.addDoubleArray(this.code, name, arr, false);
    }

    public void addFloatArray(String name, float[] arr) {
        CodeUtils.addFloatArray(this.code, name, arr, false);
    }

    public void addIntArray(String name, int[] arr) {
        CodeUtils.addIntArray(this.code, name, arr, false);
    }

    public void addShortArray(String name, short[] arr) {
        CodeUtils.addShortArray(this.code, name, arr, false);
    }

    public void addLogicalArray(String name, boolean[] arr) {
        CodeUtils.addLogicalArray(this.code, name, arr, false);
    }

    public void addJavaObject(String name, Object o) throws IllegalAccessException {
        CodeUtils.addJavaObject(this.code, name, o, false);
    }

    public void addDoubleMatrix(String name, double[][] matrix) {
        CodeUtils.addDoubleMatrix(this.code, name, matrix, false);
    }

    public File startPlot() throws IOException {
        return this.startPlot(GraphicsType.png);
    }

    public File startPlot(GraphicsType type) throws IOException {
        if (this.tempFileService == null) {
            this.tempFileService = new TempFileService();
        }
        File f = this.tempFileService.createTempFile("RPlot", "." + type.name());
        switch (type) {
            case png: {
                this.addRCode("png(\"" + f.toString().replace("\\", "/") + "\")");
                break;
            }
            case jpeg: {
                this.addRCode("jpeg(\"" + f.toString().replace("\\", "/") + "\")");
                break;
            }
            case tiff: {
                this.addRCode("tiff(\"" + f.toString().replace("\\", "/") + "\")");
                break;
            }
            case bmp: {
                this.addRCode("bmp(\"" + f.toString().replace("\\", "/") + "\")");
                break;
            }
            default: {
                this.addRCode("png(\"" + f.toString().replace("\\", "/") + "\")");
            }
        }
        this.addRCode(Globals.theme.generateRCode());
        return f;
    }

    public void endPlot() {
        this.addRCode("dev.off()");
    }

    public ImageIcon getPlot(File f) {
        ImageIcon img = new ImageIcon(f.toString());
        return img;
    }

    public void showPlot(File f) {
        ImageIcon plot = this.getPlot(f);
        RPlotViewer plotter = new RPlotViewer(plot);
        plotter.setVisible(true);
    }

    public void R_require(String pkg) {
        this.code = this.code.insert(0, "require(" + pkg + ")\n");
    }

    public void R_source(String sourceFile) {
        this.addRCode("source(\"" + sourceFile + "\")\n");
    }

    public void deleteTempFiles() {
        if (this.tempFileService != null) {
            this.tempFileService.deleteRCallerTempFiles();
        }
    }

    public String toString() {
        return this.code.toString();
    }
}

