/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.core;

import org.simpleframework.xml.core.Detail;
import org.simpleframework.xml.core.ObjectScanner;
import org.simpleframework.xml.core.PrimitiveScanner;
import org.simpleframework.xml.core.Scanner;
import org.simpleframework.xml.core.Support;
import org.simpleframework.xml.util.Cache;
import org.simpleframework.xml.util.ConcurrentCache;

class ScannerFactory {
    private final Cache<Scanner> cache = new ConcurrentCache<Scanner>();
    private final Support support;

    public ScannerFactory(Support support) {
        this.support = support;
    }

    public Scanner getInstance(Class type) throws Exception {
        Scanner schema = this.cache.fetch(type);
        if (schema == null) {
            Detail detail = this.support.getDetail(type);
            schema = this.support.isPrimitive(type) ? new PrimitiveScanner(detail) : new ObjectScanner(detail, this.support);
            this.cache.cache(type, schema);
        }
        return schema;
    }
}

