/*
 * Decompiled with CFR 0.152.
 */
package org.nfunk.jep.function;

import java.util.Stack;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.function.PostfixMathCommand;
import org.nfunk.jep.type.Complex;

public class Comparative
extends PostfixMathCommand {
    int id;
    double tolerance;

    public Comparative(int n) {
        this.id = n;
        this.numberOfParameters = 2;
        this.tolerance = 1.0E-6;
    }

    public void run(Stack stack) throws ParseException {
        this.checkStack(stack);
        Object e = stack.pop();
        Object e2 = stack.pop();
        if (e2 instanceof Number && e instanceof Number) {
            boolean bl;
            double d = ((Number)e2).doubleValue();
            double d2 = ((Number)e).doubleValue();
            switch (this.id) {
                case 0: {
                    bl = d < d2;
                    break;
                }
                case 1: {
                    bl = d > d2;
                    break;
                }
                case 2: {
                    bl = d <= d2;
                    break;
                }
                case 3: {
                    bl = d >= d2;
                    break;
                }
                case 4: {
                    bl = d != d2;
                    break;
                }
                case 5: {
                    bl = d == d2;
                    break;
                }
                default: {
                    throw new ParseException("Unknown relational operator");
                }
            }
            stack.push(new Double((double)bl));
        } else if (e2 instanceof Complex && e instanceof Complex) {
            boolean bl;
            switch (this.id) {
                case 4: {
                    bl = !((Complex)e2).equals((Complex)e, this.tolerance);
                    break;
                }
                case 5: {
                    bl = ((Complex)e2).equals((Complex)e, this.tolerance);
                    break;
                }
                default: {
                    throw new ParseException("Relational operator type error");
                }
            }
            stack.push(new Double((double)bl));
        } else if (e2 instanceof String && e instanceof String) {
            boolean bl;
            switch (this.id) {
                case 4: {
                    bl = !((String)e2).equals((String)e);
                    break;
                }
                case 5: {
                    bl = ((String)e2).equals((String)e);
                    break;
                }
                default: {
                    throw new ParseException("Relational operator type error");
                }
            }
            stack.push(new Double((double)bl));
        } else {
            throw new ParseException("Invalid parameter type");
        }
    }
}

