/*
 * Decompiled with CFR 0.152.
 */
package holmes.workspace;

import holmes.graphpanel.GraphPanel;
import holmes.workspace.Workspace;
import java.awt.Dimension;
import java.awt.Toolkit;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;

public class WorkspaceSheet
extends JScrollPane {
    private static final long serialVersionUID = -3216362854094205041L;
    private final int id;
    private GraphPanel graphPanel;
    private Workspace workspace;
    private SheetPanel sheetPanel;
    public JScrollPane scrollPane;

    public WorkspaceSheet(int ID, Workspace work) {
        this.workspace = work;
        this.sheetPanel = new SheetPanel(this);
        this.sheetPanel.setLayout(null);
        this.setGraphPanel(this.workspace.getProject().createAndAddGraphPanel(ID));
        this.getGraphPanel().setBounds(0, 0, Toolkit.getDefaultToolkit().getScreenSize().width, Toolkit.getDefaultToolkit().getScreenSize().height);
        this.sheetPanel.add(this.getGraphPanel());
        this.sheetPanel.setOpaque(true);
        this.graphPanel.setOriginSize(this.graphPanel.getSize());
        this.id = ID;
    }

    public JScrollPane getScrollPane() {
        return this.scrollPane;
    }

    public void setScrollPane(JScrollPane sp) {
        this.scrollPane = sp;
    }

    public int getId() {
        return this.id;
    }

    public JPanel getContainerPanel() {
        return this.sheetPanel;
    }

    public GraphPanel getGraphPanel() {
        return this.graphPanel;
    }

    private void setGraphPanel(GraphPanel graphPanel) {
        this.graphPanel = graphPanel;
    }

    public void scrollHorizontal(int delta) {
        JScrollBar bar = this.scrollPane.getHorizontalScrollBar();
        int value = bar.getValue();
        bar.setValue(value += delta);
    }

    public void scrollVertical(int delta) {
        JScrollBar bar = this.scrollPane.getVerticalScrollBar();
        int value = bar.getValue();
        bar.setValue(value += delta);
    }

    public static class SheetPanel
    extends JPanel {
        private static final long serialVersionUID = -1440470091168792811L;
        private WorkspaceSheet sheet;

        SheetPanel(WorkspaceSheet sheet) {
            this.sheet = sheet;
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension dim = new Dimension();
            dim = this.sheet.getGraphPanel().getSize();
            return dim;
        }
    }
}

