/*
 * Decompiled with CFR 0.152.
 */
package holmes.workspace;

import holmes.darkgui.GUIManager;
import holmes.darkgui.LanguageManager;
import holmes.graphpanel.GraphPanel;
import holmes.graphpanel.SelectionActionListener;
import holmes.petrinet.data.IdGenerator;
import holmes.petrinet.data.PetriNet;
import holmes.petrinet.elements.MetaNode;
import holmes.workspace.WorkspaceSheet;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.plaf.basic.BasicTabbedPaneUI;

public class Workspace
implements SelectionActionListener {
    private static final GUIManager overlord = GUIManager.getDefaultGUIManager();
    private static final LanguageManager lang = GUIManager.getLanguageManager();
    private JTabbedPane tp = new JTabbedPane();
    private ArrayList<WorkspaceSheet> sheets = new ArrayList();
    private ArrayList<Integer> sheetsIDtable = new ArrayList();
    private PetriNet project;

    public Workspace() {
        Point position = new Point(0, 0);
        this.setProject(new PetriNet(this, "default"));
        this.setTablePane(new JTabbedPane());
        this.tp.setUI(new BasicTabbedPaneUI(){

            @Override
            protected int calculateTabHeight(int tabPlacement, int tabIndex, int fontHeight) {
                return 26;
            }

            @Override
            protected void paintTab(Graphics g, int tabPlacement, Rectangle[] rects, int tabIndex, Rectangle iconRect, Rectangle textRect) {
                super.paintTab(g, tabPlacement, rects, tabIndex, iconRect, textRect);
            }
        });
        overlord.setTabbedWorkspace(this.getTablePane());
        this.getProject().addActionListener(this);
    }

    public int newTab(boolean addMetaNode, Point pos, int whichSubnet, MetaNode.MetaType type) {
        int id = this.sheetsIDtable.size();
        if (this.sheetsIDtable.contains(id)) {
            id = this.getMaximumSubnetID() + 1;
        }
        this.sheetsIDtable.add(id);
        WorkspaceSheet ws = new WorkspaceSheet(id, this);
        this.sheets.add(ws);
        JScrollPane scroll = new JScrollPane(ws.getContainerPanel());
        scroll.setHorizontalScrollBarPolicy(32);
        scroll.setVerticalScrollBarPolicy(22);
        ws.setScrollPane(scroll);
        this.tp.add("Subnet " + id, scroll);
        if (addMetaNode) {
            this.addMetaNode(pos, whichSubnet, id, type);
        }
        return id;
    }

    private void addMetaNode(Point pos, int whichSubnet, int representedSubnet, MetaNode.MetaType type) {
        MetaNode metanode = new MetaNode(whichSubnet, IdGenerator.getNextId(), pos, type);
        metanode.setName("Subnet" + representedSubnet);
        metanode.setRepresentedSheetID(representedSubnet);
        overlord.getWorkspace().getProject().getNodes().add(metanode);
        overlord.getWorkspace().getProject().repaintAllGraphPanels();
    }

    public void setGraphMode(GraphPanel.DrawModes mode) {
        this.getProject().setDrawMode(mode);
    }

    public void deleteSheetFromArrays(WorkspaceSheet sheet) {
        int sheetID = sheet.getId();
        boolean result = this.getProject().removeGraphPanel(sheetID);
        if (!result) {
            overlord.log(lang.getText("LOGentry00502critError") + " " + sheet.getId(), "error", true);
        }
        int id = this.sheets.indexOf(sheet);
        this.sheets.remove(id);
        this.sheetsIDtable.remove(id);
        this.tp.remove(id);
    }

    public void deleteAllSheetButFirst() {
        for (int i = this.sheets.size() - 1; i > 0; --i) {
            int subnetID = this.sheets.get(i).getId();
            boolean result = this.getProject().removeGraphPanel(subnetID);
            if (!result) {
                overlord.log(lang.getText("LOGentry00503critError") + " " + subnetID, "error", true);
            }
            this.tp.remove(i);
            this.sheets.remove(i);
            this.sheetsIDtable.remove(i);
        }
    }

    public void globalDeselection() {
        for (WorkspaceSheet ws : this.sheets) {
            ws.getGraphPanel().getSelectionManager().deselectAllElements();
        }
    }

    public int getMaximumSubnetID() {
        int index = 0;
        for (int x : this.sheetsIDtable) {
            if (x <= index) continue;
            index = x;
        }
        return index;
    }

    public ArrayList<Integer> accessSheetsIDtable() {
        return this.sheetsIDtable;
    }

    public ArrayList<WorkspaceSheet> getSheets() {
        return this.sheets;
    }

    public PetriNet getProject() {
        return this.project;
    }

    private void setProject(PetriNet project) {
        this.project = project;
    }

    public int getIndexOfId(int id) {
        Integer ajDi = id;
        return this.sheetsIDtable.lastIndexOf(ajDi);
    }

    @Override
    public void actionPerformed(SelectionActionListener.SelectionActionEvent e) {
        overlord.getPropertiesBox().selectElement(e);
        overlord.getSelectionBox().getSelectionPanel().actionPerformed(e);
    }

    public WorkspaceSheet getSelectedSheet() {
        Component component = this.getTablePane().getSelectedComponent();
        return this.sheets.stream().filter(sheet -> sheet.getScrollPane() == component).findAny().orElseThrow();
    }

    public WorkspaceSheet getSheetById(int sheetId) {
        return this.sheets.stream().filter(sheet -> sheet.getId() == sheetId).findAny().orElseThrow();
    }

    public void repaintAllGraphPanels() {
        this.getProject().repaintAllGraphPanels();
    }

    public JTabbedPane getTablePane() {
        return this.tp;
    }

    public void setTablePane(JTabbedPane tp) {
        this.tp = tp;
    }
}

