/*
 * Decompiled with CFR 0.152.
 */
package holmes.windows.xtpn.managers;

import holmes.darkgui.GUIManager;
import holmes.darkgui.LanguageManager;
import holmes.petrinet.data.MultisetM;
import holmes.petrinet.data.P_StateManager;
import holmes.petrinet.data.PetriNet;
import holmes.petrinet.elements.Place;
import holmes.petrinet.elements.PlaceXTPN;
import holmes.tables.RXTable;
import holmes.tables.managers.StatesPlacesEditorTableModelXTPN;
import holmes.utilities.Tools;
import holmes.windows.managers.HolmesStatesManager;
import holmes.windows.xtpn.HolmesXTPNtokens;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.table.DefaultTableCellRenderer;

public class HolmesStatesEditorXTPN
extends JFrame {
    private static final long serialVersionUID = 3176765993380657329L;
    private static final GUIManager overlord = GUIManager.getDefaultGUIManager();
    private static final LanguageManager lang = GUIManager.getLanguageManager();
    private HolmesStatesManager parentWindow;
    private RXTable multisetsTable;
    private StatesPlacesEditorTableModelXTPN tableModel;
    private MultisetM multisetM;
    private int stateIndex;
    private ArrayList<Place> places;
    private P_StateManager statesManager;
    public boolean doNotUpdate;

    public HolmesStatesEditorXTPN(HolmesStatesManager parent, MultisetM stateVector, int stateIndex) {
        this.setTitle(lang.getText("HSEXwin_entry001title"));
        try {
            this.setIconImage(Tools.getImageFromIcon("/icons/holmesicon.png"));
        }
        catch (Exception ex) {
            overlord.log(lang.getText("LOGentry00533exception") + " " + ex.getMessage(), "error", true);
        }
        this.doNotUpdate = true;
        PetriNet pn = overlord.getWorkspace().getProject();
        this.parentWindow = parent;
        this.multisetM = stateVector;
        this.stateIndex = stateIndex;
        this.places = pn.getPlaces();
        this.statesManager = pn.accessStatesManager();
        this.initalizeComponents();
        this.initiateListeners();
        this.fillTable();
        this.setVisible(true);
        this.parentWindow.setEnabled(false);
        this.doNotUpdate = false;
    }

    public void fillTable() {
        this.tableModel.clearModel();
        int size = this.multisetM.getMultiset_M_Size();
        if (size != this.places.size()) {
            String strB = "err.";
            try {
                strB = String.format(lang.getText("HSEXwin_entry002"), size, this.places.size());
            }
            catch (Exception e) {
                overlord.log(lang.getText("LOGentryLNGexc") + " HSEXwin_entry002", "error", true);
            }
            overlord.log(strB, "error", true);
            return;
        }
        for (int placeIndex = 0; placeIndex < size; ++placeIndex) {
            ArrayList<Double> multisetK = this.multisetM.accessMultiset_K(placeIndex);
            boolean isXTPNplace = this.multisetM.isPlaceStoredAsGammaActive(placeIndex);
            StringBuilder line = new StringBuilder();
            if (multisetK.isEmpty()) {
                if (isXTPNplace) {
                    line.append(" <empty> ");
                } else {
                    line.append(0).append(" <ClassicalPlace> ");
                }
            } else if (isXTPNplace) {
                for (Double d : multisetK) {
                    line.append(d).append(" | ");
                }
            } else {
                double tokensNumber = multisetK.get(0);
                line.append((int)tokensNumber).append(" <ClassicalPlace> ");
            }
            this.tableModel.addNew(placeIndex, this.places.get(placeIndex).getName(), line.toString());
        }
        this.tableModel.fireTableDataChanged();
    }

    private void initalizeComponents() {
        this.setLayout(new BorderLayout());
        this.setSize(new Dimension(900, 650));
        this.setLocation(50, 50);
        this.setResizable(true);
        this.setLayout(new BorderLayout());
        JPanel tablePanel = this.getMainTablePanel();
        this.add((Component)this.getTopPanel(), "North");
        this.add((Component)tablePanel, "Center");
    }

    private JPanel getTopPanel() {
        JPanel result = new JPanel(new BorderLayout());
        result.setLocation(0, 0);
        result.setBorder(BorderFactory.createTitledBorder(lang.getText("HSEXwin_entry003")));
        result.setPreferredSize(new Dimension(500, 100));
        JPanel filler = new JPanel(null);
        int posX = 5;
        int posY = 0;
        JLabel label0 = new JLabel(lang.getText("HSEXwin_entry004"));
        label0.setBounds(posX, posY, 100, 20);
        filler.add(label0);
        JLabel labelID = new JLabel("" + this.stateIndex);
        labelID.setBounds(posX + 110, posY, 100, 20);
        filler.add(labelID);
        JTextArea vectorDescrTextArea = new JTextArea(this.statesManager.accessStateMatrixXTPN().get(this.stateIndex).getDescription());
        vectorDescrTextArea.setLineWrap(true);
        vectorDescrTextArea.setEditable(true);
        vectorDescrTextArea.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                JTextArea field = (JTextArea)e.getSource();
                if (field != null) {
                    String newComment = field.getText();
                    HolmesStatesEditorXTPN.this.statesManager.accessStateMatrixXTPN().get(HolmesStatesEditorXTPN.this.stateIndex).setDescription(newComment);
                    HolmesStatesEditorXTPN.this.fillTable();
                    HolmesStatesEditorXTPN.this.parentWindow.fillDescriptionFieldXTPN();
                }
            }
        });
        JPanel CreationPanel = new JPanel();
        CreationPanel.setLayout(new BorderLayout());
        CreationPanel.add((Component)new JScrollPane(vectorDescrTextArea), "Center");
        CreationPanel.setBounds(posX, posY + 20, 600, 50);
        filler.add(CreationPanel);
        result.add((Component)filler, "Center");
        return result;
    }

    public JPanel getMainTablePanel() {
        JPanel result = new JPanel(new BorderLayout());
        result.setLocation(0, 0);
        result.setBorder(BorderFactory.createTitledBorder(lang.getText("HSEXwin_entry005")));
        result.setPreferredSize(new Dimension(500, 500));
        this.tableModel = new StatesPlacesEditorTableModelXTPN(this, this.stateIndex);
        this.multisetsTable = new RXTable(this.tableModel);
        this.multisetsTable.setSelectAllForEdit(false);
        this.multisetsTable.getColumnModel().getColumn(0).setHeaderValue("ID");
        this.multisetsTable.getColumnModel().getColumn(0).setPreferredWidth(30);
        this.multisetsTable.getColumnModel().getColumn(0).setMinWidth(30);
        this.multisetsTable.getColumnModel().getColumn(0).setMaxWidth(30);
        this.multisetsTable.getColumnModel().getColumn(1).setHeaderValue("Place name");
        this.multisetsTable.getColumnModel().getColumn(1).setPreferredWidth(200);
        this.multisetsTable.getColumnModel().getColumn(1).setMinWidth(100);
        this.multisetsTable.getColumnModel().getColumn(2).setHeaderValue("Tokens");
        this.multisetsTable.getColumnModel().getColumn(2).setPreferredWidth(500);
        this.multisetsTable.getColumnModel().getColumn(2).setMinWidth(50);
        this.multisetsTable.setName("p-stateVectorTable");
        this.multisetsTable.setFillsViewportHeight(true);
        DefaultTableCellRenderer tableRenderer = new DefaultTableCellRenderer();
        this.multisetsTable.setDefaultRenderer(Integer.class, tableRenderer);
        this.multisetsTable.setDefaultRenderer(String.class, tableRenderer);
        this.multisetsTable.getSelectionModel().addListSelectionListener(event -> {
            if (this.doNotUpdate) {
                return;
            }
            this.cellClickAction();
        });
        this.multisetsTable.setRowSelectionAllowed(true);
        this.multisetsTable.setAutoResizeMode(4);
        JScrollPane tableScrollPane = new JScrollPane(this.multisetsTable, 20, 30);
        result.add((Component)tableScrollPane, "Center");
        return result;
    }

    protected void cellClickAction() {
        try {
            int selectedPlace = this.multisetsTable.getSelectedRow();
            new HolmesXTPNtokens((PlaceXTPN)this.places.get(selectedPlace), this, this.multisetM.accessMultiset_K(selectedPlace), this.multisetM.isPlaceStoredAsGammaActive(selectedPlace));
        }
        catch (Exception ex) {
            overlord.log(lang.getText("LOGentry00534exception") + " " + ex.getMessage(), "error", true);
        }
    }

    private void initiateListeners() {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                if (HolmesStatesEditorXTPN.this.parentWindow != null) {
                    HolmesStatesEditorXTPN.this.parentWindow.setEnabled(true);
                }
            }
        });
    }
}

