/*
 * Decompiled with CFR 0.152.
 */
package holmes.windows.xtpn;

import holmes.darkgui.GUIManager;
import holmes.darkgui.LanguageManager;
import holmes.darkgui.holmesInterface.HolmesRoundedButton;
import holmes.petrinet.elements.Place;
import holmes.petrinet.elements.Transition;
import holmes.petrinet.simulators.GraphicalSimulator;
import holmes.petrinet.simulators.xtpn.GraphicalSimulatorXTPN;
import holmes.petrinet.simulators.xtpn.StateSimDataContainer;
import holmes.petrinet.simulators.xtpn.StateSimulatorXTPN;
import holmes.utilities.Tools;
import holmes.windows.HolmesNotepad;
import holmes.windows.managers.HolmesStatesManager;
import holmes.windows.xtpn.HolmesSimXTPNActions;
import holmes.workspace.ExtensionFileFilter;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileFilter;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.labels.CategoryToolTipGenerator;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class HolmesSimXTPN
extends JFrame {
    private static final long serialVersionUID = 5381991734385357453L;
    private static final GUIManager overlord = GUIManager.getDefaultGUIManager();
    private static final LanguageManager lang = GUIManager.getLanguageManager();
    private JFrame ego;
    private HolmesSimXTPNActions action = new HolmesSimXTPNActions();
    private StateSimulatorXTPN ssim;
    public boolean doNotUpdate = false;
    private JProgressBar progressBar;
    private int transInterval = 100;
    private int placesStepsInterval = 100;
    private int placesTimeInterval = 10;
    private boolean sortedP = false;
    private boolean sortedT = false;
    private ArrayList<Integer> placesInChart;
    private ArrayList<String> placesInChartStr;
    private ArrayList<Integer> transInChart;
    private ArrayList<String> transInChartStr;
    private XYSeriesCollection placesSeriesDataSet = null;
    private XYSeriesCollection transitionsSeriesDataSet = null;
    private JFreeChart placesChart;
    private JFreeChart transitionsChart;
    private int transChartType = 0;
    private int placesChartType = 0;
    private JPanel placesJPanel;
    private JPanel transitionsJPanel;
    private JSpinner transIntervalSpinner;
    private JSpinner placesStepsIntervalSpinner;
    private JSpinner placesTimeIntervalSpinner;
    private SpinnerModel placeRepsSpinnerModel = null;
    private JCheckBox qSimXTPNRecordStepsCheckbox = null;
    private SpinnerModel selStepsSpinnerModel = null;
    private JCheckBox qSimXTPNCompStatsCheckbox = null;
    private SpinnerModel placeStepsSpinnerModel = null;
    private SpinnerModel intervalPlaceStepsSpinnerModel = null;
    private JCheckBox qSimXTPNStatsTimeCheckbox = null;
    private SpinnerModel placeTimeSpinnerModel = null;
    private JComboBox<String> placesCombo = null;
    private JComboBox<String> transitionsCombo = null;
    private ChartPropertiesXTPN chartDetails;
    private JLabel selStateLabel;
    private HolmesRoundedButton stateManagerButton;
    private HolmesRoundedButton acqDataButton;
    private JPanel knockoutTab;
    private boolean workInProgress;
    public JTabbedPane mainTabPanel;
    StateSimDataContainer simDataBox = new StateSimDataContainer();
    private boolean isTimeSimulationXTPN = false;
    private JLabel placeSimSteps = null;
    private JLabel placeSimTime = null;
    private JLabel placeSimCompTime = null;

    public HolmesSimXTPN(GUIManager overlord) {
        this.ego = this;
        this.ssim = new StateSimulatorXTPN();
        this.chartDetails = new ChartPropertiesXTPN();
        this.placesInChart = new ArrayList();
        this.placesInChartStr = new ArrayList();
        this.transInChart = new ArrayList();
        this.transInChartStr = new ArrayList();
        this.initializeComponents();
        this.initiateListeners();
    }

    public HolmesSimXTPN returnFrame() {
        return this;
    }

    private void initializeComponents() {
        this.setVisible(false);
        this.setTitle(lang.getText("HSXTPNwin_entry001title"));
        this.setLocation(30, 30);
        try {
            this.setIconImage(Tools.getImageFromIcon("/icons/holmesicon.png"));
        }
        catch (Exception ex) {
            overlord.log(lang.getText("LOGentry00606exception") + "\n" + ex.getMessage(), "error", true);
        }
        this.setSize(new Dimension(1120, 750));
        JPanel main = new JPanel(new BorderLayout());
        this.add(main);
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.addTab(lang.getText("HSXTPNwin_entry002"), Tools.getResIcon16("/icons/stateSim/placesDyn.png"), this.createPlacesTabPanel(), lang.getText("HSXTPNwin_entry002t"));
        tabbedPane.setMnemonicAt(0, 49);
        tabbedPane.addTab(lang.getText("HSXTPNwin_entry003"), Tools.getResIcon16("/icons/stateSim/transDyn.png"), this.createTransitionsTabPanel(), lang.getText("HSXTPNwin_entry003t"));
        tabbedPane.setMnemonicAt(1, 50);
        this.mainTabPanel = new JTabbedPane();
        JPanel firstTab = new JPanel(new BorderLayout());
        firstTab.add((Component)this.craeteDataAcquisitionPanel(), "North");
        firstTab.add((Component)tabbedPane, "Center");
        this.mainTabPanel.addTab(lang.getText("HSXTPNwin_entry004"), Tools.getResIcon16("/icons/stateSim/simpleSimTab.png"), firstTab, lang.getText("HSXTPNwin_entry004t"));
        this.knockoutTab = new JPanel();
        this.mainTabPanel.addTab(lang.getText("HSXTPNwin_entry005"), Tools.getResIcon16("/icons/stateSim/knockSimTab.png"), this.knockoutTab, lang.getText("HSXTPNwin_entry005t"));
        main.add((Component)this.mainTabPanel, "Center");
        this.repaint();
    }

    private JPanel craeteDataAcquisitionPanel() {
        JPanel dataAcquisitionPanel = new JPanel(null);
        dataAcquisitionPanel.setBackground(Color.WHITE);
        dataAcquisitionPanel.setBorder(BorderFactory.createTitledBorder(lang.getText("HSXTPNwin_entry006")));
        dataAcquisitionPanel.setPreferredSize(new Dimension(670, 110));
        int posXda = 10;
        int posYda = 20;
        this.acqDataButton = new HolmesRoundedButton(lang.getText("HSXTPNwin_entry007"), "pearl_bH1_neutr.png", "pearl_bH2_hover.png", "pearl_bH3_press.png");
        this.acqDataButton.setBounds(posXda, posYda, 110, 40);
        this.acqDataButton.setMargin(new Insets(0, 0, 0, 0));
        this.acqDataButton.setFocusPainted(false);
        this.acqDataButton.setIcon(Tools.getResIcon32("/icons/stateSim/computeData.png"));
        this.acqDataButton.setToolTipText(lang.getText("HSXTPNwin_entry007t"));
        this.acqDataButton.addActionListener(actionEvent -> this.acquireDataFromSimulation());
        dataAcquisitionPanel.add(this.acqDataButton);
        HolmesRoundedButton cancelButton = new HolmesRoundedButton(lang.getText("HSXTPNwin_entry008"), "pearl_bH1_neutr.png", "pearl_bH2_hover.png", "pearl_bH3_press.png");
        cancelButton.setText(lang.getText("HSXTPNwin_entry008t"));
        cancelButton.setIcon(Tools.getResIcon32("/icons/simulationKnockout/stopIcon.png"));
        cancelButton.setBounds(posXda, posYda + 45, 110, 30);
        cancelButton.setMargin(new Insets(0, 0, 0, 0));
        cancelButton.addActionListener(actionEvent -> this.ssim.setCancelStatus(true));
        cancelButton.setFocusPainted(false);
        dataAcquisitionPanel.add(cancelButton);
        HolmesRoundedButton simSettingsButton = new HolmesRoundedButton(lang.getText("HSXTPNwin_entry009"), "pearl_bH1_neutr.png", "pearl_bH2_hover.png", "pearl_bH3_press.png");
        simSettingsButton.setBounds(posXda + 120, posYda, 130, 40);
        simSettingsButton.setMargin(new Insets(0, 0, 0, 0));
        simSettingsButton.setFocusPainted(false);
        simSettingsButton.setIcon(Tools.getResIcon32("/icons/simSettings/setupIcon.png"));
        simSettingsButton.setToolTipText(lang.getText("HSXTPNwin_entry009t"));
        simSettingsButton.setEnabled(false);
        simSettingsButton.setEnabled(false);
        dataAcquisitionPanel.add(simSettingsButton);
        this.stateManagerButton = new HolmesRoundedButton(lang.getText("HSXTPNwin_entry010"), "pearl_bH1_neutr.png", "pearl_bH2_hover.png", "pearl_bH3_press.png");
        this.stateManagerButton.setIcon(Tools.getResIcon32("/icons/stateManager/stManIcon.png"));
        this.stateManagerButton.setBounds(posXda + 260, posYda, 130, 40);
        this.stateManagerButton.setMargin(new Insets(0, 0, 0, 0));
        this.stateManagerButton.setFocusPainted(false);
        this.stateManagerButton.addActionListener(actionEvent -> new HolmesStatesManager());
        dataAcquisitionPanel.add(this.stateManagerButton);
        JLabel stateLabel0 = new JLabel(lang.getText("HSXTPNwin_entry011"));
        stateLabel0.setBounds(posXda + 400, posYda, 130, 20);
        dataAcquisitionPanel.add(stateLabel0);
        this.selStateLabel = new JLabel("" + HolmesSimXTPN.overlord.getWorkspace().getProject().accessStatesManager().selectedStateXTPN);
        this.selStateLabel.setBounds(posXda + 530, posYda, 40, 20);
        dataAcquisitionPanel.add(this.selStateLabel);
        HolmesRoundedButton clearDataButton = new HolmesRoundedButton(lang.getText("HSXTPNwin_entry012"), "pearl_bH1_neutr.png", "pearl_bH2_hover.png", "pearl_bH3_press.png");
        clearDataButton.setBounds(posXda + 550, posYda, 110, 40);
        clearDataButton.setIcon(Tools.getResIcon32("/icons/stateSim/clearData.png"));
        clearDataButton.setToolTipText(lang.getText("HSXTPNwin_entry012t"));
        clearDataButton.setFocusPainted(false);
        clearDataButton.addActionListener(actionEvent -> {
            this.clearPlacesChart();
            this.clearTransitionsChart();
            this.clearAllData();
        });
        dataAcquisitionPanel.add(clearDataButton);
        this.progressBar = new JProgressBar();
        this.progressBar.setBounds(posXda + 120, posYda + 40, 540, 40);
        this.progressBar.setMaximum(100);
        this.progressBar.setMinimum(0);
        this.progressBar.setValue(0);
        this.progressBar.setStringPainted(true);
        TitledBorder border = BorderFactory.createTitledBorder(lang.getText("HSXTPNwin_entry013"));
        this.progressBar.setBorder(border);
        this.progressBar.setBackground(Color.WHITE);
        dataAcquisitionPanel.add(this.progressBar);
        JPanel XTPNoptionsPanel = new JPanel(null);
        XTPNoptionsPanel.setBackground(Color.WHITE);
        XTPNoptionsPanel.setBorder(BorderFactory.createTitledBorder(lang.getText("HSXTPNwin_entry014")));
        XTPNoptionsPanel.setBounds(posXda + 670, posYda - 20, 380, 110);
        dataAcquisitionPanel.add(XTPNoptionsPanel);
        int internalX = 10;
        int internalY = 20;
        JLabel labelReps = new JLabel(lang.getText("HSXTPNwin_entry015"));
        labelReps.setBounds(internalX, internalY, 70, 20);
        XTPNoptionsPanel.add(labelReps);
        this.placeRepsSpinnerModel = new SpinnerNumberModel(1, 1, 100, 10);
        JSpinner placesRepsSpinner = new JSpinner(this.placeRepsSpinnerModel);
        placesRepsSpinner.setBounds(internalX + 70, internalY, 50, 20);
        placesRepsSpinner.addChangeListener(e -> {
            if (this.doNotUpdate) {
                return;
            }
            JSpinner spinner = (JSpinner)e.getSource();
            int tmp = (Integer)spinner.getValue();
            HolmesSimXTPN.overlord.simSettings.setSimRepetitions_XTPN(tmp);
        });
        XTPNoptionsPanel.add(placesRepsSpinner);
        this.qSimXTPNRecordStepsCheckbox = new JCheckBox(lang.getText("HSXTPNwin_entry016"));
        this.qSimXTPNRecordStepsCheckbox.setBackground(Color.WHITE);
        this.qSimXTPNRecordStepsCheckbox.setBounds(internalX + 130, internalY, 90, 20);
        this.qSimXTPNRecordStepsCheckbox.setSelected(HolmesSimXTPN.overlord.simSettings.isTimeSimulation_XTPN());
        this.qSimXTPNRecordStepsCheckbox.addItemListener(e -> {
            if (this.doNotUpdate) {
                return;
            }
            JCheckBox box = (JCheckBox)e.getSource();
            HolmesSimXTPN.overlord.simSettings.setPartialRecordingStetsStatus(box.isSelected());
        });
        XTPNoptionsPanel.add(this.qSimXTPNRecordStepsCheckbox);
        this.selStepsSpinnerModel = new SpinnerNumberModel(10, 2, 100, 10);
        JSpinner selStepsSpinner = new JSpinner(this.selStepsSpinnerModel);
        selStepsSpinner.setBounds(internalX + 220, internalY, 50, 20);
        selStepsSpinner.addChangeListener(e -> {
            if (this.doNotUpdate) {
                return;
            }
            JSpinner spinner = (JSpinner)e.getSource();
            int tmp = (Integer)spinner.getValue();
            HolmesSimXTPN.overlord.simSettings.setRecordedSteps(tmp);
        });
        XTPNoptionsPanel.add(selStepsSpinner);
        this.qSimXTPNCompStatsCheckbox = new JCheckBox(lang.getText("HSXTPNwin_entry017"));
        this.qSimXTPNCompStatsCheckbox.setBackground(Color.WHITE);
        this.qSimXTPNCompStatsCheckbox.setBounds(internalX + 130, internalY, 90, 20);
        this.qSimXTPNCompStatsCheckbox.setSelected(HolmesSimXTPN.overlord.simSettings.isTimeSimulation_XTPN());
        this.qSimXTPNCompStatsCheckbox.addItemListener(e -> {
            if (this.doNotUpdate) {
                return;
            }
            JCheckBox box = (JCheckBox)e.getSource();
            HolmesSimXTPN.overlord.simSettings.setStatsRecordingStatus(box.isSelected());
        });
        XTPNoptionsPanel.add(this.qSimXTPNCompStatsCheckbox);
        JLabel labelSteps = new JLabel(lang.getText("HSXTPNwin_entry018"));
        labelSteps.setBounds(internalX, internalY += 20, 40, 20);
        XTPNoptionsPanel.add(labelSteps);
        long stepValue = HolmesSimXTPN.overlord.simSettings.getSimSteps_XTPN();
        this.placeStepsSpinnerModel = new SpinnerNumberModel((int)stepValue, 0, 100000000, 10000);
        JSpinner placesStepsSpinner = new JSpinner(this.placeStepsSpinnerModel);
        placesStepsSpinner.setBounds(internalX + 45, internalY, 90, 20);
        placesStepsSpinner.addChangeListener(e -> {
            JSpinner spinner = (JSpinner)e.getSource();
            int tmp = (Integer)spinner.getValue();
            HolmesSimXTPN.overlord.simSettings.setSimSteps_XTPN(tmp);
        });
        XTPNoptionsPanel.add(placesStepsSpinner);
        JLabel labelPInterval = new JLabel(lang.getText("HSXTPNwin_entry019"));
        labelPInterval.setBounds(internalX + 140, internalY, 50, 20);
        XTPNoptionsPanel.add(labelPInterval);
        int placeStepsInterval = (int)HolmesSimXTPN.overlord.simSettings.getSimSteps_XTPN() / 10;
        this.intervalPlaceStepsSpinnerModel = new SpinnerNumberModel(this.placesStepsInterval, 0, placeStepsInterval, 100);
        this.placesStepsIntervalSpinner = new JSpinner(this.intervalPlaceStepsSpinnerModel);
        this.placesStepsIntervalSpinner.setBounds(internalX + 190, internalY, 60, 20);
        this.placesStepsIntervalSpinner.addChangeListener(e -> {
            int tmp;
            if (this.doNotUpdate) {
                return;
            }
            JSpinner spinner = (JSpinner)e.getSource();
            this.placesStepsInterval = tmp = ((Integer)spinner.getValue()).intValue();
            this.clearPlacesChart();
        });
        XTPNoptionsPanel.add(this.placesStepsIntervalSpinner);
        this.qSimXTPNStatsTimeCheckbox = new JCheckBox(lang.getText("HSXTPNwin_entry020"));
        this.qSimXTPNStatsTimeCheckbox.setBackground(Color.WHITE);
        this.qSimXTPNStatsTimeCheckbox.setBounds(internalX, internalY += 20, 120, 20);
        this.qSimXTPNStatsTimeCheckbox.setSelected(HolmesSimXTPN.overlord.simSettings.isTimeSimulation_XTPN());
        this.qSimXTPNStatsTimeCheckbox.addItemListener(e -> {
            if (this.doNotUpdate) {
                return;
            }
            JCheckBox box = (JCheckBox)e.getSource();
            HolmesSimXTPN.overlord.simSettings.setTimeSimulationStatus_XTPN(box.isSelected());
        });
        XTPNoptionsPanel.add(this.qSimXTPNStatsTimeCheckbox);
        JLabel labelTime = new JLabel(lang.getText("HSXTPNwin_entry021"));
        labelTime.setBounds(internalX, internalY += 20, 40, 20);
        XTPNoptionsPanel.add(labelTime);
        double timeValue = HolmesSimXTPN.overlord.simSettings.getSimTime_XTPN();
        this.placeTimeSpinnerModel = new SpinnerNumberModel((int)timeValue, 0, 1000000, 5000);
        JSpinner placesTimeSpinner = new JSpinner(this.placeTimeSpinnerModel);
        placesTimeSpinner.setBounds(internalX + 45, internalY, 90, 20);
        placesTimeSpinner.addChangeListener(e -> {
            JSpinner spinner = (JSpinner)e.getSource();
            int tmp = (Integer)spinner.getValue();
            HolmesSimXTPN.overlord.simSettings.setSimTime_XTPN(tmp);
        });
        XTPNoptionsPanel.add(placesTimeSpinner);
        JLabel labelPTimeInterval = new JLabel(lang.getText("HSXTPNwin_entry022"));
        labelPTimeInterval.setBounds(internalX + 140, internalY, 50, 20);
        XTPNoptionsPanel.add(labelPTimeInterval);
        int placeTimeMaxInterval = (int)HolmesSimXTPN.overlord.simSettings.getSimTime_XTPN() / 100;
        SpinnerNumberModel intervalPlaceTimeSpinnerModel = new SpinnerNumberModel(this.placesTimeInterval, 0, placeTimeMaxInterval, 10);
        this.placesTimeIntervalSpinner = new JSpinner(intervalPlaceTimeSpinnerModel);
        this.placesTimeIntervalSpinner.setBounds(internalX + 190, internalY, 60, 20);
        this.placesTimeIntervalSpinner.addChangeListener(e -> {
            int tmp;
            JSpinner spinner = (JSpinner)e.getSource();
            this.placesTimeInterval = tmp = ((Integer)spinner.getValue()).intValue();
            this.clearPlacesChart();
        });
        XTPNoptionsPanel.add(this.placesTimeIntervalSpinner);
        return dataAcquisitionPanel;
    }

    private JPanel createPlacesTabPanel() {
        JPanel result = new JPanel(new BorderLayout());
        result.setBackground(Color.WHITE);
        JPanel topPanel = new JPanel(new BorderLayout());
        topPanel.setBackground(Color.WHITE);
        result.add((Component)topPanel, "First");
        JPanel placesChartOptionsPanel = new JPanel(null);
        placesChartOptionsPanel.setBackground(Color.WHITE);
        placesChartOptionsPanel.setBorder(BorderFactory.createTitledBorder(lang.getText("HSXTPNwin_entry023")));
        placesChartOptionsPanel.setPreferredSize(new Dimension(500, 120));
        int posXchart = 10;
        int posYchart = 20;
        HolmesRoundedButton showAllButton = new HolmesRoundedButton(lang.getText("HSXTPNwin_entry024"), "pearl_bH1_neutr.png", "pearl_bH2_hover.png", "pearl_bH3_press.png");
        showAllButton.setBounds(posXchart, posYchart, 120, 24);
        showAllButton.setMargin(new Insets(0, 0, 0, 0));
        showAllButton.setFocusPainted(false);
        showAllButton.setIcon(Tools.getResIcon16("/icons/stateSim/showAll.png"));
        showAllButton.setToolTipText(lang.getText("HSXTPNwin_entry024t"));
        showAllButton.addActionListener(actionEvent -> this.showAllPlacesData());
        placesChartOptionsPanel.add(showAllButton);
        HolmesRoundedButton showNotepadButton = new HolmesRoundedButton(lang.getText("HSXTPNwin_entry025"), "pearl_bH1_neutr.png", "pearl_bH2_hover.png", "pearl_bH3_press.png");
        showNotepadButton.setBounds(posXchart + 130, posYchart, 120, 24);
        showNotepadButton.setMargin(new Insets(0, 0, 0, 0));
        showNotepadButton.setFocusPainted(false);
        showNotepadButton.setIcon(Tools.getResIcon16("/icons/stateSim/showNotepad.png"));
        showNotepadButton.setToolTipText(lang.getText("HSXTPNwin_entry025t"));
        showNotepadButton.addActionListener(actionEvent -> this.showPlacesAllInNotepad());
        placesChartOptionsPanel.add(showNotepadButton);
        placesChartOptionsPanel.setEnabled(false);
        JCheckBox sortedCheckBox = new JCheckBox(lang.getText("HSXTPNwin_entry026"));
        sortedCheckBox.setBounds(posXchart + 460, posYchart + 10, 130, 20);
        sortedCheckBox.setBackground(Color.WHITE);
        sortedCheckBox.addActionListener(actionEvent -> {
            AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
            this.sortedP = abstractButton.getModel().isSelected();
            this.fillPlacesAndTransitionsData();
        });
        placesChartOptionsPanel.add(sortedCheckBox);
        JLabel label1 = new JLabel(lang.getText("HSXTPNwin_entry027"));
        label1.setBounds(posXchart, posYchart += 30, 70, 20);
        placesChartOptionsPanel.add(label1);
        String[] dataP = new String[]{"---"};
        this.placesCombo = new JComboBox<String>(dataP);
        this.placesCombo.setLocation(posXchart + 75, posYchart + 2);
        this.placesCombo.setSize(500, 20);
        this.placesCombo.setSelectedIndex(0);
        this.placesCombo.setMaximumRowCount(12);
        this.placesCombo.addActionListener(actionEvent -> {});
        placesChartOptionsPanel.add(this.placesCombo);
        HolmesRoundedButton addPlaceButton = new HolmesRoundedButton(lang.getText("HSXTPNwin_entry028"), "pearl_bH1_neutr.png", "pearl_bH2_hover.png", "pearl_bH3_press.png");
        addPlaceButton.setBounds(posXchart, (posYchart += 30) + 2, 110, 24);
        addPlaceButton.setMargin(new Insets(0, 0, 0, 0));
        addPlaceButton.setFocusPainted(false);
        addPlaceButton.setIcon(Tools.getResIcon16("/icons/stateSim/addChart.png"));
        addPlaceButton.setToolTipText(lang.getText("HSXTPNwin_entry028t"));
        addPlaceButton.addActionListener(actionEvent -> {
            if (this.simDataBox == null) {
                return;
            }
            int selected = this.placesCombo.getSelectedIndex();
            if (selected > 0) {
                try {
                    String name = Objects.requireNonNull(this.placesCombo.getSelectedItem()).toString();
                    int sel = this.action.getRealNodeID(name);
                    if (sel == -1) {
                        return;
                    }
                    name = this.trimNodeName(name);
                    this.placesInChart.set(sel, 1);
                    this.placesInChartStr.set(sel, name);
                    this.addNewPlaceSeries(sel, name);
                    this.updatePlacesGraphicChart("places");
                }
                catch (Exception e) {
                    overlord.log(lang.getText("LOGentry00607exception") + "\n" + e.getMessage(), "error", true);
                }
            }
        });
        placesChartOptionsPanel.add(addPlaceButton);
        HolmesRoundedButton removePlaceButton = new HolmesRoundedButton(lang.getText("HSXTPNwin_entry029"), "pearl_bH1_neutr.png", "pearl_bH2_hover.png", "pearl_bH3_press.png");
        removePlaceButton.setBounds(posXchart + 120, posYchart + 2, 110, 24);
        removePlaceButton.setMargin(new Insets(0, 0, 0, 0));
        removePlaceButton.setFocusPainted(false);
        removePlaceButton.setIcon(Tools.getResIcon16("/icons/stateSim/removeChart.png"));
        removePlaceButton.setToolTipText(lang.getText("HSXTPNwin_entry029t"));
        removePlaceButton.addActionListener(actionEvent -> {
            if (this.simDataBox == null) {
                return;
            }
            int selected = this.placesCombo.getSelectedIndex();
            if (selected > 0) {
                try {
                    String name = Objects.requireNonNull(this.placesCombo.getSelectedItem()).toString();
                    int sel = this.action.getRealNodeID(name);
                    if (sel == -1) {
                        return;
                    }
                    name = this.trimNodeName(name);
                    this.placesInChart.set(sel, -1);
                    this.placesInChartStr.set(sel, "");
                    this.removePlaceSeries(name);
                }
                catch (Exception e) {
                    overlord.log(lang.getText("LOGentry00608exception") + "\n" + e.getMessage(), "error", true);
                }
            }
        });
        placesChartOptionsPanel.add(removePlaceButton);
        HolmesRoundedButton clearPlacesChartButton = new HolmesRoundedButton(lang.getText("HSXTPNwin_entry030"), "pearl_bH1_neutr.png", "pearl_bH2_hover.png", "pearl_bH3_press.png");
        clearPlacesChartButton.setBounds(posXchart + 240, posYchart + 2, 110, 24);
        clearPlacesChartButton.setMargin(new Insets(0, 0, 0, 0));
        clearPlacesChartButton.setFocusPainted(false);
        clearPlacesChartButton.setIcon(Tools.getResIcon16("/icons/stateSim/clearChart.png"));
        clearPlacesChartButton.setToolTipText(lang.getText("HSXTPNwin_entry030t"));
        clearPlacesChartButton.addActionListener(actionEvent -> this.clearPlacesChart());
        placesChartOptionsPanel.add(clearPlacesChartButton);
        HolmesRoundedButton savePlacesChartButton = new HolmesRoundedButton(lang.getText("HSXTPNwin_entry031"), "pearl_bH1_neutr.png", "pearl_bH2_hover.png", "pearl_bH3_press.png");
        savePlacesChartButton.setBounds(posXchart + 360, posYchart + 2, 110, 24);
        savePlacesChartButton.setMargin(new Insets(0, 0, 0, 0));
        savePlacesChartButton.setFocusPainted(false);
        savePlacesChartButton.setIcon(Tools.getResIcon16("/icons/stateSim/saveImage.png"));
        savePlacesChartButton.setToolTipText(lang.getText("HSXTPNwin_entry031t"));
        savePlacesChartButton.addActionListener(actionEvent -> this.saveChartImage("places", 1200, 1024));
        placesChartOptionsPanel.add(savePlacesChartButton);
        HolmesRoundedButton showPlaceButton = new HolmesRoundedButton(lang.getText("HSXTPNwin_entry032"), "pearl_bH1_neutr.png", "pearl_bH2_hover.png", "pearl_bH3_press.png");
        showPlaceButton.setBounds(posXchart + 480, posYchart + 2, 110, 24);
        showPlaceButton.setMargin(new Insets(0, 0, 0, 0));
        showPlaceButton.setFocusPainted(false);
        showPlaceButton.setIcon(Tools.getResIcon16("/icons/stateSim/findNode.png"));
        showPlaceButton.setToolTipText(lang.getText("HSXTPNwin_entry032t"));
        showPlaceButton.addActionListener(actionEvent -> {
            int selected = this.placesCombo.getSelectedIndex();
            if (selected > 0) {
                try {
                    String name = Objects.requireNonNull(this.placesCombo.getSelectedItem()).toString();
                    int sel = this.action.getRealNodeID(name);
                    if (sel == -1) {
                        return;
                    }
                    overlord.getSearchWindow().fillComboBoxesData();
                    overlord.getSearchWindow().selectedManually(true, sel);
                }
                catch (Exception e) {
                    overlord.log(lang.getText("LOGentry00609exception") + "\n" + e.getMessage(), "error", true);
                }
            }
        });
        placesChartOptionsPanel.add(showPlaceButton);
        topPanel.add((Component)placesChartOptionsPanel, "Center");
        this.placeSimSteps = new JLabel(lang.getText("HSXTPNwin_entry033"));
        this.placeSimSteps.setBounds(posXchart + 620, posYchart - 60, 200, 20);
        placesChartOptionsPanel.add(this.placeSimSteps);
        this.placeSimTime = new JLabel(lang.getText("HSXTPNwin_entry034"));
        this.placeSimTime.setBounds(posXchart + 620, posYchart - 40, 200, 20);
        placesChartOptionsPanel.add(this.placeSimTime);
        this.placeSimCompTime = new JLabel(lang.getText("HSXTPNwin_entry035"));
        this.placeSimCompTime.setBounds(posXchart + 620, posYchart - 20, 230, 20);
        placesChartOptionsPanel.add(this.placeSimCompTime);
        JPanel placesChartGraphicPanel = new JPanel(null);
        placesChartGraphicPanel.setBackground(Color.WHITE);
        placesChartGraphicPanel.setBorder(BorderFactory.createTitledBorder(lang.getText("HSXTPNwin_entry036")));
        placesChartGraphicPanel.setPreferredSize(new Dimension(200, 100));
        int posXGchart = 10;
        int posYGchart = 20;
        ButtonGroup groupWidth = new ButtonGroup();
        JRadioButton width1 = new JRadioButton(lang.getText("HSXTPNwin_entry037"));
        width1.setBackground(Color.WHITE);
        width1.setBounds(posXGchart, posYGchart, 90, 20);
        width1.setActionCommand("0");
        width1.addActionListener(actionEvent -> {
            if (((AbstractButton)actionEvent.getSource()).isSelected()) {
                this.chartDetails.p_StrokeWidth = 1.0f;
                this.updatePlacesGraphicChart("places");
            }
        });
        placesChartGraphicPanel.add(width1);
        groupWidth.add(width1);
        groupWidth.setSelected(width1.getModel(), true);
        JRadioButton width2 = new JRadioButton(lang.getText("HSXTPNwin_entry038"));
        width2.setBackground(Color.WHITE);
        width2.setBounds(posXGchart, posYGchart + 20, 90, 20);
        width2.setActionCommand("1");
        width2.addActionListener(actionEvent -> {
            if (((AbstractButton)actionEvent.getSource()).isSelected()) {
                this.chartDetails.p_StrokeWidth = 2.0f;
                this.updatePlacesGraphicChart("places");
            }
        });
        placesChartGraphicPanel.add(width2);
        groupWidth.add(width2);
        JRadioButton width3 = new JRadioButton(lang.getText("HSXTPNwin_entry039"));
        width3.setBackground(Color.WHITE);
        width3.setBounds(posXGchart, posYGchart + 40, 90, 20);
        width3.setActionCommand("2");
        width3.addActionListener(actionEvent -> {
            if (((AbstractButton)actionEvent.getSource()).isSelected()) {
                this.chartDetails.p_StrokeWidth = 3.0f;
                this.updatePlacesGraphicChart("places");
            }
        });
        placesChartGraphicPanel.add(width3);
        groupWidth.add(width3);
        topPanel.add((Component)placesChartGraphicPanel, "East");
        this.placesJPanel = new JPanel(new BorderLayout());
        this.placesJPanel.setBorder(BorderFactory.createTitledBorder(lang.getText("HSXTPNwin_entry040")));
        this.placesJPanel.add((Component)this.createPlacesChartPanel(), "Center");
        result.add((Component)this.placesJPanel, "Center");
        return result;
    }

    private JPanel createTransitionsTabPanel() {
        JPanel result = new JPanel(new BorderLayout());
        JPanel topPanel = new JPanel(new BorderLayout());
        topPanel.setBackground(Color.WHITE);
        result.add((Component)topPanel, "First");
        JPanel transChartOptionsPanel = new JPanel(null);
        transChartOptionsPanel.setBackground(Color.WHITE);
        transChartOptionsPanel.setBorder(BorderFactory.createTitledBorder(lang.getText("HSXTPNwin_entry041")));
        transChartOptionsPanel.setPreferredSize(new Dimension(500, 120));
        int posXchart = 10;
        int posYchart = 20;
        HolmesRoundedButton showAllButton = new HolmesRoundedButton(lang.getText("HSXTPNwin_entry042"), "pearl_bH1_neutr.png", "pearl_bH2_hover.png", "pearl_bH3_press.png");
        showAllButton.setBounds(posXchart, posYchart, 120, 24);
        showAllButton.setMargin(new Insets(0, 0, 0, 0));
        showAllButton.setFocusPainted(false);
        showAllButton.setIcon(Tools.getResIcon16("/icons/stateSim/showAll.png"));
        showAllButton.setToolTipText(lang.getText("HSXTPNwin_entry042t"));
        showAllButton.addActionListener(actionEvent -> this.showAllTransData());
        showAllButton.setEnabled(false);
        transChartOptionsPanel.add(showAllButton);
        HolmesRoundedButton showNotepadButton = new HolmesRoundedButton(lang.getText("HSXTPNwin_entry043"), "pearl_bH1_neutr.png", "pearl_bH2_hover.png", "pearl_bH3_press.png");
        showNotepadButton.setBounds(posXchart + 130, posYchart, 120, 24);
        showNotepadButton.setMargin(new Insets(0, 0, 0, 0));
        showNotepadButton.setFocusPainted(false);
        showNotepadButton.setIcon(Tools.getResIcon16("/icons/stateSim/showNotepad.png"));
        showNotepadButton.setToolTipText(lang.getText("HSXTPNwin_entry043t"));
        showNotepadButton.addActionListener(actionEvent -> this.showTransAllInNotepad());
        showNotepadButton.setEnabled(false);
        transChartOptionsPanel.add(showNotepadButton);
        JLabel label1 = new JLabel(lang.getText("HSXTPNwin_entry044"));
        label1.setBounds(posXchart + 280, posYchart + 2, 70, 20);
        transChartOptionsPanel.add(label1);
        int mValue = (int)HolmesSimXTPN.overlord.simSettings.getSimSteps_XTPN() / 10;
        SpinnerNumberModel intervSpinnerModel = new SpinnerNumberModel(this.transInterval, 1, mValue, 10);
        this.transIntervalSpinner = new JSpinner(intervSpinnerModel);
        this.transIntervalSpinner.setBounds(posXchart + 330, posYchart + 3, 60, 20);
        this.transIntervalSpinner.addChangeListener(e -> {
            JSpinner spinner = (JSpinner)e.getSource();
            this.transInterval = (Integer)spinner.getValue();
            this.clearTransitionsChart();
        });
        transChartOptionsPanel.add(this.transIntervalSpinner);
        JCheckBox sortedCheckBox = new JCheckBox(lang.getText("HSXTPNwin_entry045"));
        sortedCheckBox.setBounds(posXchart + 460, posYchart + 10, 130, 20);
        sortedCheckBox.setBackground(Color.WHITE);
        sortedCheckBox.addActionListener(actionEvent -> {
            AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
            this.sortedT = abstractButton.getModel().isSelected();
            this.fillPlacesAndTransitionsData();
        });
        transChartOptionsPanel.add(sortedCheckBox);
        JLabel label2 = new JLabel(lang.getText("HSXTPNwin_entry046"));
        label2.setBounds(posXchart, posYchart += 30, 70, 20);
        transChartOptionsPanel.add(label2);
        String[] dataP = new String[]{"---"};
        this.transitionsCombo = new JComboBox<String>(dataP);
        this.transitionsCombo.setLocation(posXchart + 75, posYchart + 2);
        this.transitionsCombo.setSize(500, 20);
        this.transitionsCombo.setSelectedIndex(0);
        this.transitionsCombo.setMaximumRowCount(12);
        transChartOptionsPanel.add(this.transitionsCombo);
        HolmesRoundedButton addTransitionButton = new HolmesRoundedButton(lang.getText("HSXTPNwin_entry047"), "pearl_bH1_neutr.png", "pearl_bH2_hover.png", "pearl_bH3_press.png");
        addTransitionButton.setBounds(posXchart, (posYchart += 30) + 2, 110, 24);
        addTransitionButton.setMargin(new Insets(0, 0, 0, 0));
        addTransitionButton.setFocusPainted(false);
        addTransitionButton.setIcon(Tools.getResIcon16("/icons/stateSim/addChart.png"));
        addTransitionButton.setToolTipText(lang.getText("HSXTPNwin_entry047t"));
        addTransitionButton.addActionListener(actionEvent -> {
            if (this.simDataBox == null) {
                return;
            }
            int selected = this.transitionsCombo.getSelectedIndex();
            if (selected > 0) {
                try {
                    String name = Objects.requireNonNull(this.transitionsCombo.getSelectedItem()).toString();
                    int sel = this.action.getRealNodeID(name);
                    if (sel == -1) {
                        return;
                    }
                    name = this.trimNodeName(name);
                    this.transInChart.set(sel, 1);
                    this.transInChartStr.set(sel, name);
                    this.addNewTransitionSeries(sel, name);
                    this.updatePlacesGraphicChart("transitions");
                }
                catch (Exception e) {
                    overlord.log(lang.getText("LOGentry00610exception") + "\n" + e.getMessage(), "error", true);
                }
            }
        });
        transChartOptionsPanel.add(addTransitionButton);
        HolmesRoundedButton removeTransitionButton = new HolmesRoundedButton(lang.getText("HSXTPNwin_entry048"), "pearl_bH1_neutr.png", "pearl_bH2_hover.png", "pearl_bH3_press.png");
        removeTransitionButton.setBounds(posXchart + 120, posYchart + 2, 110, 24);
        removeTransitionButton.setMargin(new Insets(0, 0, 0, 0));
        removeTransitionButton.setFocusPainted(false);
        removeTransitionButton.setIcon(Tools.getResIcon16("/icons/stateSim/removeChart.png"));
        removeTransitionButton.setToolTipText(lang.getText("HSXTPNwin_entry048t"));
        removeTransitionButton.addActionListener(actionEvent -> {
            if (this.simDataBox == null) {
                return;
            }
            int selected = this.transitionsCombo.getSelectedIndex();
            if (selected > 0) {
                try {
                    String name = Objects.requireNonNull(this.transitionsCombo.getSelectedItem()).toString();
                    int sel = this.action.getRealNodeID(name);
                    if (sel == -1) {
                        return;
                    }
                    name = this.trimNodeName(name);
                    this.transInChart.set(sel, -1);
                    this.transInChartStr.set(sel, "");
                    this.removeTransitionSeries(name);
                }
                catch (Exception e) {
                    overlord.log(lang.getText("LOGentry00611exception") + "\n" + e.getMessage(), "error", true);
                }
            }
        });
        transChartOptionsPanel.add(removeTransitionButton);
        HolmesRoundedButton clearTransChartButton = new HolmesRoundedButton(lang.getText("HSXTPNwin_entry049"), "pearl_bH1_neutr.png", "pearl_bH2_hover.png", "pearl_bH3_press.png");
        clearTransChartButton.setBounds(posXchart + 240, posYchart + 2, 110, 24);
        clearTransChartButton.setMargin(new Insets(0, 0, 0, 0));
        clearTransChartButton.setFocusPainted(false);
        clearTransChartButton.setIcon(Tools.getResIcon16("/icons/stateSim/clearChart.png"));
        clearTransChartButton.setToolTipText(lang.getText("HSXTPNwin_entry049t"));
        clearTransChartButton.addActionListener(actionEvent -> this.clearTransitionsChart());
        transChartOptionsPanel.add(clearTransChartButton);
        HolmesRoundedButton saveTransitionsChartButton = new HolmesRoundedButton(lang.getText("HSXTPNwin_entry050"), "pearl_bH1_neutr.png", "pearl_bH2_hover.png", "pearl_bH3_press.png");
        saveTransitionsChartButton.setBounds(posXchart + 360, posYchart + 2, 110, 24);
        saveTransitionsChartButton.setMargin(new Insets(0, 0, 0, 0));
        saveTransitionsChartButton.setFocusPainted(false);
        saveTransitionsChartButton.setIcon(Tools.getResIcon16("/icons/stateSim/saveImage.png"));
        saveTransitionsChartButton.setToolTipText(lang.getText("HSXTPNwin_entry050t"));
        saveTransitionsChartButton.addActionListener(actionEvent -> this.saveChartImage("transitions", 1200, 1024));
        transChartOptionsPanel.add(saveTransitionsChartButton);
        HolmesRoundedButton showTransButton = new HolmesRoundedButton(lang.getText("HSXTPNwin_entry051"), "pearl_bH1_neutr.png", "pearl_bH2_hover.png", "pearl_bH3_press.png");
        showTransButton.setBounds(posXchart + 480, posYchart + 2, 110, 24);
        showTransButton.setMargin(new Insets(0, 0, 0, 0));
        showTransButton.setFocusPainted(false);
        showTransButton.setIcon(Tools.getResIcon16("/icons/stateSim/findNode.png"));
        showTransButton.setToolTipText(lang.getText("HSXTPNwin_entry051t"));
        showTransButton.addActionListener(actionEvent -> {
            int selected = this.transitionsCombo.getSelectedIndex();
            if (selected > 0) {
                try {
                    int sel = this.action.getRealNodeID(Objects.requireNonNull(this.transitionsCombo.getSelectedItem()).toString());
                    if (sel == -1) {
                        return;
                    }
                    overlord.getSearchWindow().fillComboBoxesData();
                    overlord.getSearchWindow().selectedManually(false, sel);
                }
                catch (Exception e) {
                    overlord.log(lang.getText("LOGentry00612exception") + "\n" + e.getMessage(), "error", true);
                }
            }
        });
        transChartOptionsPanel.add(showTransButton);
        topPanel.add((Component)transChartOptionsPanel, "Center");
        JPanel transChartGraphicPanel = new JPanel(null);
        transChartGraphicPanel.setBackground(Color.WHITE);
        transChartGraphicPanel.setBorder(BorderFactory.createTitledBorder(lang.getText("HSXTPNwin_entry052")));
        transChartGraphicPanel.setPreferredSize(new Dimension(200, 100));
        int posXGchart = 10;
        int posYGchart = 20;
        ButtonGroup groupWidth = new ButtonGroup();
        JRadioButton width1 = new JRadioButton(lang.getText("HSXTPNwin_entry053"));
        width1.setBackground(Color.WHITE);
        width1.setBounds(posXGchart, posYGchart, 70, 20);
        width1.setActionCommand("0");
        width1.addActionListener(actionEvent -> {
            if (((AbstractButton)actionEvent.getSource()).isSelected()) {
                this.chartDetails.t_StrokeWidth = 1.0f;
                this.updatePlacesGraphicChart("transitions");
            }
        });
        transChartGraphicPanel.add(width1);
        groupWidth.add(width1);
        groupWidth.setSelected(width1.getModel(), true);
        JRadioButton width2 = new JRadioButton(lang.getText("HSXTPNwin_entry054"));
        width2.setBackground(Color.WHITE);
        width2.setBounds(posXGchart, posYGchart + 20, 70, 20);
        width2.setActionCommand("1");
        width2.addActionListener(actionEvent -> {
            if (((AbstractButton)actionEvent.getSource()).isSelected()) {
                this.chartDetails.t_StrokeWidth = 2.0f;
                this.updatePlacesGraphicChart("transitions");
            }
        });
        transChartGraphicPanel.add(width2);
        groupWidth.add(width2);
        JRadioButton width3 = new JRadioButton(lang.getText("HSXTPNwin_entry055"));
        width3.setBackground(Color.WHITE);
        width3.setBounds(posXGchart, posYGchart + 40, 70, 20);
        width3.setActionCommand("2");
        width3.addActionListener(actionEvent -> {
            if (((AbstractButton)actionEvent.getSource()).isSelected()) {
                this.chartDetails.t_StrokeWidth = 3.0f;
                this.updatePlacesGraphicChart("transitions");
            }
        });
        transChartGraphicPanel.add(width3);
        groupWidth.add(width3);
        topPanel.add((Component)transChartGraphicPanel, "East");
        this.transitionsJPanel = new JPanel(new BorderLayout());
        this.transitionsJPanel.setBorder(BorderFactory.createTitledBorder(lang.getText("HSXTPNwin_entry056")));
        this.transitionsJPanel.add((Component)this.createTransChartPanel(), "Center");
        result.add((Component)this.transitionsJPanel, "Center");
        return result;
    }

    private JPanel createPlacesChartPanel() {
        String chartTitle = lang.getText("HSXTPNwin_entry057");
        String xAxisLabel = lang.getText("HSXTPNwin_entry058");
        String yAxisLabel = lang.getText("HSXTPNwin_entry059");
        boolean showLegend = true;
        boolean createTooltip = true;
        boolean createURL = false;
        this.placesSeriesDataSet = new XYSeriesCollection();
        this.placesChart = ChartFactory.createXYLineChart(chartTitle, xAxisLabel, yAxisLabel, this.placesSeriesDataSet, PlotOrientation.VERTICAL, showLegend, createTooltip, createURL);
        return new ChartPanel(this.placesChart);
    }

    private void addNewPlaceSeries(int selPlaceID, String name) {
        if (this.placesChartType == 0) {
            this.placesJPanel.removeAll();
            this.placesJPanel.add((Component)this.createPlacesChartPanel(), "Center");
            this.placesJPanel.revalidate();
            this.placesJPanel.repaint();
            this.placesChartType = 1;
            this.placesSeriesDataSet.removeAllSeries();
        }
        List x = this.placesSeriesDataSet.getSeries();
        for (XYSeries xys : x) {
            if (!xys.getKey().equals(name)) continue;
            return;
        }
        XYSeries series = new XYSeries((Comparable)((Object)name));
        if (this.isTimeSimulationXTPN) {
            int step = 0;
            int intervalIteration = 1;
            while (step < this.simDataBox.fullTokensHistory.size()) {
                if (this.simDataBox.avgTimeForStep.get(step) < (double)(intervalIteration * this.placesTimeInterval)) {
                    double value = 0.0;
                    int getIndex = 0;
                    while (this.simDataBox.avgTimeForStep.get(step) < (double)(intervalIteration * this.placesTimeInterval)) {
                        value += this.simDataBox.fullTokensHistory.get(step).get(selPlaceID).doubleValue();
                        getIndex = ++step;
                        if (step < this.simDataBox.avgTimeForStep.size()) continue;
                        getIndex = this.simDataBox.avgTimeForStep.size() - 1;
                        break;
                    }
                    series.add(this.simDataBox.avgTimeForStep.get(getIndex), (Number)value);
                    continue;
                }
                ++intervalIteration;
            }
        } else {
            int interval = this.placesStepsInterval;
            int maxStep = this.simDataBox.fullTokensHistory.size() - interval - 1;
            if (this.simDataBox.fullTokensHistory.size() > 10 * interval) {
                for (int step = 0; step < maxStep; step += interval) {
                    double value = 0.0;
                    for (int j = 0; j < interval; ++j) {
                        value += this.simDataBox.fullTokensHistory.get(step + j).get(selPlaceID).doubleValue();
                    }
                    series.add((double)step, value /= (double)interval);
                }
            } else {
                for (int step = 0; step < this.simDataBox.fullTokensHistory.size(); ++step) {
                    double value = this.simDataBox.fullTokensHistory.get(step).get(selPlaceID);
                    series.add((double)step, value);
                }
            }
        }
        this.placesSeriesDataSet.addSeries(series);
    }

    private void removePlaceSeries(String name) {
        List x = this.placesSeriesDataSet.getSeries();
        for (XYSeries xys : x) {
            if (!xys.getKey().equals(name)) continue;
            this.placesSeriesDataSet.removeSeries(xys);
            return;
        }
    }

    private void clearPlacesChart() {
        this.placesSeriesDataSet.removeAllSeries();
        this.placesInChart = new ArrayList();
        this.placesInChartStr = new ArrayList();
        for (int i = 0; i < overlord.getWorkspace().getProject().getPlaces().size(); ++i) {
            this.placesInChart.add(-1);
            this.placesInChartStr.add("");
        }
    }

    private void showAllPlacesData() {
    }

    public static double calculateSD(Double[] numArray) {
        double sum = 0.0;
        double standardDeviation = 0.0;
        int length = numArray.length;
        Double[] doubleArray = numArray;
        int n = doubleArray.length;
        for (int i = 0; i < n; ++i) {
            double num = doubleArray[i];
            sum += num;
        }
        double mean = sum / (double)length;
        Double[] doubleArray2 = numArray;
        int n2 = doubleArray2.length;
        for (int i = 0; i < n2; ++i) {
            double num = doubleArray2[i];
            standardDeviation += Math.pow(num - mean, 2.0);
        }
        return Math.sqrt(standardDeviation / (double)length);
    }

    private void showPlacesAllInNotepad() {
        HolmesNotepad notePad = new HolmesNotepad(900, 600);
        notePad.setVisible(true);
        ArrayList<Place> places_tmp = overlord.getWorkspace().getProject().getPlaces();
    }

    private JPanel createTransChartPanel() {
        String chartTitle = lang.getText("HSXTPNwin_entry060");
        String xAxisLabel = lang.getText("HSXTPNwin_entry061");
        String yAxisLabel = lang.getText("HSXTPNwin_entry062");
        boolean showLegend = true;
        boolean createTooltip = true;
        boolean createURL = false;
        this.transitionsSeriesDataSet = new XYSeriesCollection();
        this.transitionsChart = ChartFactory.createXYLineChart(chartTitle, xAxisLabel, yAxisLabel, this.transitionsSeriesDataSet, PlotOrientation.VERTICAL, showLegend, createTooltip, createURL);
        return new ChartPanel(this.transitionsChart);
    }

    private void addNewTransitionSeries(int selTransID, String name) {
        if (this.transChartType == 0) {
            this.transitionsJPanel.removeAll();
            this.transitionsJPanel.add((Component)this.createTransChartPanel(), "Center");
            this.transitionsJPanel.revalidate();
            this.transitionsJPanel.repaint();
            this.transChartType = 1;
            this.transitionsSeriesDataSet.removeAllSeries();
        }
        List x = this.transitionsSeriesDataSet.getSeries();
        for (XYSeries xys : x) {
            if (!xys.getKey().equals(name)) continue;
            return;
        }
        XYSeries series = new XYSeries((Comparable)((Object)name));
        for (int step = 0; step < this.simDataBox.transitionsSimHistory.get(selTransID).size(); ++step) {
            if (this.transInterval > this.simDataBox.transitionsSimHistory.get(selTransID).size() / 10) {
                this.transInterval = this.simDataBox.transitionsSimHistory.get(selTransID).size() / 10;
            }
            double value = 0.0;
            for (int i = 0; i < this.transInterval; ++i) {
                value += this.simDataBox.transitionsSimHistory.get((int)selTransID).get((int)(step + i)).fired;
            }
            series.add((double)step, value);
            step += this.transInterval;
            if (this.transInterval <= 1) continue;
            --step;
        }
        this.transitionsSeriesDataSet.addSeries(series);
    }

    private void removeTransitionSeries(String name) {
        List x = this.transitionsSeriesDataSet.getSeries();
        for (XYSeries xys : x) {
            if (!xys.getKey().equals(name)) continue;
            this.transitionsSeriesDataSet.removeSeries(xys);
            return;
        }
    }

    private void clearTransitionsChart() {
        this.transitionsSeriesDataSet.removeAllSeries();
        this.transInChart = new ArrayList();
        this.transInChartStr = new ArrayList();
        for (int i = 0; i < overlord.getWorkspace().getProject().getTransitions().size(); ++i) {
            this.transInChart.add(-1);
            this.transInChartStr.add("");
        }
    }

    private void showAllTransData() {
    }

    private void showTransAllInNotepad() {
    }

    private void saveChartImage(String chartType, int w, int h) {
        String lastPath = overlord.getLastPath();
        FileFilter[] filters = new FileFilter[]{new ExtensionFileFilter("Portable Network Graphics (.png)", new String[]{"PNG"})};
        Object selectedFile = Tools.selectFileDialog(lastPath, filters, lang.getText("save"), "", "");
        if (((String)selectedFile).isEmpty()) {
            return;
        }
        if (!((String)selectedFile).contains(".png")) {
            selectedFile = (String)selectedFile + ".png";
        }
        File imageFile = new File((String)selectedFile);
        try {
            if (chartType.equals("places")) {
                ChartUtilities.saveChartAsPNG(imageFile, this.placesChart, w, h);
            } else if (chartType.equals("transitions")) {
                ChartUtilities.saveChartAsPNG(imageFile, this.transitionsChart, w, h);
            }
        }
        catch (IOException ex) {
            overlord.log(lang.getText("LOGentry00613exception") + "\n" + ex.getMessage(), "error", true);
        }
    }

    private void fillPlacesAndTransitionsData() {
        ArrayList<Transition> transitions;
        this.doNotUpdate = true;
        this.placeRepsSpinnerModel.setValue(HolmesSimXTPN.overlord.simSettings.getRepetitions());
        this.qSimXTPNRecordStepsCheckbox.setSelected(HolmesSimXTPN.overlord.simSettings.isPartialRecordingSteps());
        this.selStepsSpinnerModel.setValue(HolmesSimXTPN.overlord.simSettings.getRecordedSteps());
        this.qSimXTPNCompStatsCheckbox.setSelected(HolmesSimXTPN.overlord.simSettings.isStatsRecorded());
        this.placeStepsSpinnerModel.setValue((int)HolmesSimXTPN.overlord.simSettings.getSimSteps_XTPN());
        this.qSimXTPNStatsTimeCheckbox.setSelected(HolmesSimXTPN.overlord.simSettings.isTimeSimulation_XTPN());
        this.placeTimeSpinnerModel.setValue((int)HolmesSimXTPN.overlord.simSettings.getSimTime_XTPN());
        this.doNotUpdate = false;
        if (this.simDataBox == null) {
            this.simDataBox = new StateSimDataContainer();
        }
        this.selStateLabel.setText("" + HolmesSimXTPN.overlord.getWorkspace().getProject().accessStatesManager().selectedStatePN);
        ArrayList<Place> places = overlord.getWorkspace().getProject().getPlaces();
        if (places == null || places.isEmpty()) {
            this.placesCombo.removeAllItems();
            this.placesCombo.addItem("---");
            this.transitionsCombo.removeAllItems();
            this.transitionsCombo.addItem("---");
            return;
        }
        this.placesCombo.removeAllItems();
        this.placesCombo.addItem("---");
        if (this.simDataBox.avgTokens.size() == places.size()) {
            if (!this.sortedP) {
                for (int p = 0; p < places.size(); ++p) {
                    this.placesCombo.addItem("p" + p + "." + places.get(p).getName() + " " + this.formatD(this.simDataBox.avgTokens.get(p)));
                }
            } else {
                HashMap<Integer, Double> map = new HashMap<Integer, Double>();
                for (int j = 0; j < this.simDataBox.avgTokens.size(); ++j) {
                    map.put(j, this.simDataBox.avgTokens.get(j));
                }
                Map sortedByValues = HolmesSimXTPNActions.crunchifySortMapXTPN(map);
                for (Map.Entry entry : sortedByValues.entrySet()) {
                    this.placesCombo.addItem("p" + String.valueOf(entry.getKey()) + "." + places.get((Integer)entry.getKey()).getName() + " " + this.formatD((Double)entry.getValue()));
                }
            }
        } else {
            for (int p = 0; p < places.size(); ++p) {
                this.placesCombo.addItem("p" + p + "." + places.get(p).getName());
            }
        }
        if ((transitions = overlord.getWorkspace().getProject().getTransitions()) == null || transitions.isEmpty()) {
            return;
        }
        this.transitionsCombo.removeAllItems();
        this.transitionsCombo.addItem("---");
        if (this.simDataBox.avgFired.size() == transitions.size()) {
            if (!this.sortedT) {
                for (int t = 0; t < transitions.size(); ++t) {
                    this.transitionsCombo.addItem("t" + t + "." + transitions.get(t).getName() + " " + this.formatD(this.simDataBox.avgFired.get(t)));
                }
            } else {
                HashMap<Integer, Double> map = new HashMap<Integer, Double>();
                for (int j = 0; j < this.simDataBox.avgFired.size(); ++j) {
                    map.put(j, this.simDataBox.avgFired.get(j));
                }
                Map sortedByValues = HolmesSimXTPNActions.crunchifySortMapXTPN(map);
                for (Map.Entry entry : sortedByValues.entrySet()) {
                    this.transitionsCombo.addItem("t" + String.valueOf(entry.getKey()) + "." + transitions.get((Integer)entry.getKey()).getName() + " " + this.formatD((Double)entry.getValue()));
                }
            }
        } else {
            for (int t = 0; t < transitions.size(); ++t) {
                this.transitionsCombo.addItem("t" + t + "." + transitions.get(t).getName());
            }
        }
    }

    private void acquireDataFromSimulation() {
        if (overlord.getSimulatorBox().getCurrentDockWindow().getSimulator().getSimulatorStatus() != GraphicalSimulator.SimulatorMode.STOPPED) {
            JOptionPane.showMessageDialog(this.ego, lang.getText("HSXTPNwin_entry063"), lang.getText("HSXTPNwin_entry063t"), 0);
            return;
        }
        if (overlord.getSimulatorBox().getCurrentDockWindow().getSimulatorXTPN().getsimulatorStatusXTPN() != GraphicalSimulatorXTPN.SimulatorModeXTPN.STOPPED) {
            JOptionPane.showMessageDialog(this.ego, lang.getText("HSXTPNwin_entry064"), lang.getText("HSXTPNwin_entry064t"), 0);
            return;
        }
        ArrayList<Place> places = overlord.getWorkspace().getProject().getPlaces();
        if (places == null || places.isEmpty()) {
            return;
        }
        this.clearTransitionsChart();
        this.clearPlacesChart();
        this.clearAllData();
        this.progressBar.setMaximum(HolmesSimXTPN.overlord.simSettings.getSimSteps());
        boolean success = this.ssim.initiateSim(HolmesSimXTPN.overlord.simSettings);
        if (!success) {
            return;
        }
        this.setSimWindowComponentsStatus(false);
        this.setWorkInProgress(true);
        this.ssim.setThreadDetails(4, this, HolmesSimXTPN.overlord.simSettings, this.progressBar);
        Thread myThread = new Thread(this.ssim);
        myThread.start();
    }

    private void setSimWindowComponentsStatus(boolean value) {
        this.acqDataButton.setEnabled(value);
        this.stateManagerButton.setEnabled(value);
        overlord.getFrame().setEnabled(value);
    }

    public void completeSimulationProcedures_Mk1(StateSimDataContainer result) {
        int i;
        this.simDataBox = result;
        this.isTimeSimulationXTPN = HolmesSimXTPN.overlord.simSettings.isTimeSimulation_XTPN();
        this.placesInChart = new ArrayList();
        this.placesInChartStr = new ArrayList();
        for (i = 0; i < overlord.getWorkspace().getProject().getPlaces().size(); ++i) {
            this.placesInChart.add(-1);
            this.placesInChartStr.add("");
        }
        this.transInChart = new ArrayList();
        this.transInChartStr = new ArrayList();
        for (i = 0; i < overlord.getWorkspace().getProject().getTransitions().size(); ++i) {
            this.transInChart.add(-1);
            this.transInChartStr.add("");
        }
        this.placeSimSteps.setText(lang.getText("HSXTPNwin_entry065") + " " + this.simDataBox.avgTimeForStep.size());
        this.placeSimTime.setText(lang.getText("HSXTPNwin_entry066") + " " + Tools.cutValue(this.simDataBox.avgTimeForStep.get(this.simDataBox.avgTimeForStep.size() - 1)));
        this.placeSimCompTime.setText(lang.getText("HSXTPNwin_entry067") + " " + Tools.getTime(this.simDataBox.compTime));
        this.fillPlacesAndTransitionsData();
        this.setSimWindowComponentsStatus(true);
        this.setWorkInProgress(false);
    }

    private void clearAllData() {
        this.ssim = new StateSimulatorXTPN();
        this.simDataBox = null;
        this.placesInChart.clear();
        this.placesInChartStr.clear();
        this.transInChart.clear();
        this.transInChartStr.clear();
    }

    private String formatD(double value) {
        DecimalFormat df = new DecimalFormat("#.#######");
        Object txt = "(avg: ";
        txt = (String)txt + df.format(value);
        txt = (String)txt + ")";
        txt = ((String)txt).replace(",", ".");
        return txt;
    }

    private String trimNodeName(String name) {
        int i = name.indexOf("(avg");
        if (i < 0) {
            return name;
        }
        name = name.substring(0, i - 1);
        return name;
    }

    private void updatePlacesGraphicChart(String chartType) {
        block5: {
            block4: {
                if (!chartType.equals("places")) break block4;
                if (this.placesChartType == 0) {
                    return;
                }
                XYPlot plot = this.placesChart.getXYPlot();
                int count = this.placesChart.getXYPlot().getSeriesCount();
                for (int i = 0; i < count; ++i) {
                    plot.getRenderer().setSeriesStroke(i, new BasicStroke(this.chartDetails.p_StrokeWidth));
                }
                break block5;
            }
            if (!chartType.equals("transitions")) break block5;
            if (this.transChartType == 0) {
                return;
            }
            XYPlot plot = this.transitionsChart.getXYPlot();
            int count = this.transitionsChart.getXYPlot().getSeriesCount();
            for (int i = 0; i < count; ++i) {
                plot.getRenderer().setSeriesStroke(i, new BasicStroke(this.chartDetails.t_StrokeWidth));
            }
        }
    }

    private void initiateListeners() {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent e) {
                HolmesSimXTPN.this.fillPlacesAndTransitionsData();
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                if (HolmesSimXTPN.this.isWorkInProgress()) {
                    JOptionPane.showMessageDialog(HolmesSimXTPN.this.ego, lang.getText("HSXTPNwin_entry068"), lang.getText("HSXTPNwin_entry068t"), 1);
                    HolmesSimXTPN.this.setDefaultCloseOperation(0);
                } else {
                    HolmesSimXTPN.this.setDefaultCloseOperation(1);
                    overlord.getFrame().setEnabled(true);
                }
            }
        });
    }

    public void setWorkInProgress(boolean value) {
        this.workInProgress = value;
    }

    public boolean isWorkInProgress() {
        return this.workInProgress;
    }

    public void resetSimWindow() {
        this.doNotUpdate = true;
        this.clearTransitionsChart();
        this.clearPlacesChart();
        this.clearAllData();
        this.fillPlacesAndTransitionsData();
        this.transInterval = 100;
        this.placesStepsInterval = 100;
        this.transChartType = 0;
        this.placesChartType = 0;
        int mValue = HolmesSimXTPN.overlord.simSettings.getSimSteps() / 10;
        SpinnerNumberModel intervSpinnerModel = new SpinnerNumberModel(100, 0, mValue, 10);
        this.transIntervalSpinner.setModel(intervSpinnerModel);
        this.placesStepsIntervalSpinner.setValue(this.placesStepsInterval);
        this.placesTimeIntervalSpinner.setValue(this.placesTimeInterval);
        this.doNotUpdate = false;
    }

    public void updateIntervalSpinner() {
        int mValue = HolmesSimXTPN.overlord.simSettings.getSimSteps() / 10;
        SpinnerNumberModel intervSpinnerModel = new SpinnerNumberModel(100, 0, mValue, 10);
        this.transIntervalSpinner.setModel(intervSpinnerModel);
        SpinnerNumberModel intervSpinnerModel2 = new SpinnerNumberModel(100, 0, mValue, 10);
        this.placesStepsIntervalSpinner.setModel(intervSpinnerModel2);
    }

    public JFrame getFrame() {
        return this.ego;
    }

    private static class ChartPropertiesXTPN {
        public float p_StrokeWidth = 1.0f;
        public float t_StrokeWidth = 1.0f;
    }

    public static class CustomToolTipPlacesGeneratorXTPN
    implements CategoryToolTipGenerator {
        ArrayList<Place> places;
        ArrayList<Double> dataVector;
        double max;
        DecimalFormat formatter;

        public CustomToolTipPlacesGeneratorXTPN(ArrayList<Place> places, ArrayList<Double> dataVector, double max) {
            this.places = places;
            this.dataVector = dataVector;
            this.max = max;
            this.formatter = new DecimalFormat("#.###");
        }

        @Override
        public String generateToolTip(CategoryDataset dataset, int bar, int nodeIndex) {
            Object text = "<html><font size=\"5\">";
            text = (String)text + "p" + nodeIndex + "_" + this.places.get(nodeIndex).getName() + "<br>";
            String strB = "err.";
            try {
                strB = String.format(lang.getText("HSXTPNwin_entry070"), this.dataVector.get(nodeIndex), this.max);
            }
            catch (Exception e) {
                overlord.log(lang.getText("LOGentryLNGexc") + " HSXTPNwin_entry070", "error", true);
            }
            text = (String)text + strB;
            text = (String)text + "</font></html>";
            return text;
        }
    }

    public static class CustomToolTipTransGeneratorXTPN
    implements CategoryToolTipGenerator {
        ArrayList<Transition> transitions;
        ArrayList<Integer> dataVector;
        double max;
        DecimalFormat formatter;

        public CustomToolTipTransGeneratorXTPN(ArrayList<Transition> transitions, ArrayList<Integer> dataVector, double max) {
            this.transitions = transitions;
            this.dataVector = dataVector;
            this.max = max;
            this.formatter = new DecimalFormat("#.###");
        }

        @Override
        public String generateToolTip(CategoryDataset dataset, int bar, int nodeIndex) {
            Object text = "<html><font size=\"5\">";
            text = (String)text + "t" + nodeIndex + "_" + this.transitions.get(nodeIndex).getName() + "<br>";
            String strB = "err.";
            try {
                strB = String.format(lang.getText("HSXTPNwin_entry069"), this.dataVector.get(nodeIndex), this.max);
            }
            catch (Exception e) {
                overlord.log(lang.getText("LOGentryLNGexc") + " HSXTPNwin_entry069", "error", true);
            }
            text = (String)text + strB;
            text = (String)text + "</font></html>";
            return text;
        }
    }
}

