/*
 * Decompiled with CFR 0.152.
 */
package holmes.windows.xtpn;

import holmes.darkgui.GUIManager;
import holmes.darkgui.LanguageManager;
import holmes.darkgui.holmesInterface.HolmesRoundedButton;
import holmes.graphpanel.GraphPanel;
import holmes.petrinet.elements.ElementLocation;
import holmes.petrinet.elements.Node;
import holmes.petrinet.elements.PlaceXTPN;
import holmes.workspace.WorkspaceSheet;
import java.awt.event.ActionEvent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class HolmesNodeInfoXTPNactions {
    private static final GUIManager overlord = GUIManager.getDefaultGUIManager();
    private static final LanguageManager lang = GUIManager.getLanguageManager();
    private JFrame parentFrame;

    public HolmesNodeInfoXTPNactions(JFrame parent) {
        this.parentFrame = parent;
    }

    public void buttonGammaModeSwitch(ActionEvent e, PlaceXTPN place, HolmesRoundedButton tokensWindowButton, HolmesRoundedButton gammaVisibilityButton) {
        HolmesRoundedButton button = (HolmesRoundedButton)e.getSource();
        int tokensNum = place.getTokensNumber();
        if (place.isGammaModeActive()) {
            Object[] options = new String[]{lang.getText("HNIXTPNAwin_entry001op1"), lang.getText("HNIXTPNAwin_entry001op2")};
            int answer = JOptionPane.showOptionDialog(null, lang.getText("HNIXTPNAwin_entry001a") + tokensNum + lang.getText("HNIXTPNAwin_entry001b"), lang.getText("HNIXTPNAwin_entry001t"), -1, 3, null, options, options[0]);
            if (answer == 0) {
                button.setNewText(lang.getText("HNIXTPNAwin_entry002"));
                button.repaintBackground("amber_bH1_neutr.png", "jade_bH2_hover.png", "jade_bH3_press.png");
                place.transformXTPNintoPNpace();
                overlord.getWorkspace().getProject().repaintAllGraphPanels();
                button.setFocusPainted(false);
                tokensWindowButton.setEnabled(false);
                gammaVisibilityButton.setEnabled(false);
            }
        } else {
            Object[] options = new String[]{lang.getText("HNIXTPNAwin_entry003op1"), lang.getText("HNIXTPNAwin_entry003op2")};
            int answer = JOptionPane.showOptionDialog(null, lang.getText("HNIXTPNAwin_entry003a") + tokensNum + lang.getText("HNIXTPNAwin_entry003b"), lang.getText("HNIXTPNAwin_entry003t"), -1, 3, null, options, options[0]);
            if (answer == 0) {
                button.setNewText(lang.getText("HNIXTPNAwin_entry004"));
                button.repaintBackground("jade_bH1_neutr.png", "amber_bH2_hover.png", "amber_bH3_press.png");
                place.transformIntoXTPNplace();
                overlord.getWorkspace().getProject().repaintAllGraphPanels();
                button.setFocusPainted(false);
                tokensWindowButton.setEnabled(true);
                gammaVisibilityButton.setEnabled(true);
            }
        }
    }

    public void gammaVisButtonSwitch(ActionEvent e, PlaceXTPN place) {
        HolmesRoundedButton button = (HolmesRoundedButton)e.getSource();
        if (place.isGammaRangeVisible()) {
            place.setGammaRangeVisibility(false);
            button.setNewText(lang.getText("HNIXTPNAwin_entry005invis"));
            button.repaintBackground("amber_bH1_neutr.png", "jade_bH2_hover.png", "jade_bH3_press.png");
            overlord.getWorkspace().getProject().repaintAllGraphPanels();
            button.setFocusPainted(false);
        } else {
            place.setGammaRangeVisibility(true);
            button.setNewText(lang.getText("HNIXTPNAwin_entry005vis"));
            button.repaintBackground("jade_bH1_neutr.png", "amber_bH2_hover.png", "amber_bH3_press.png");
            overlord.getWorkspace().getProject().repaintAllGraphPanels();
            button.setFocusPainted(false);
        }
        overlord.getWorkspace().getProject().repaintAllGraphPanels();
        button.setFocusPainted(false);
    }

    public void repaintGraphPanel(Node node) {
        int sheetIndex = overlord.IDtoIndex(node.getElementLocations().get(0).getSheetID());
        GraphPanel graphPanel = overlord.getWorkspace().getSheets().get(sheetIndex).getGraphPanel();
        graphPanel.repaint();
    }

    public void reselectElement(ElementLocation elementLocation) {
        WorkspaceSheet ws = overlord.getWorkspace().getSheets().get(0);
        ws.getGraphPanel().getSelectionManager().selectOneElementLocation(elementLocation);
    }
}

