/*
 * Decompiled with CFR 0.152.
 */
package holmes.windows.statespace;

import holmes.darkgui.GUIManager;
import holmes.petrinet.elements.Place;
import holmes.petrinet.elements.Transition;
import holmes.utilities.Tools;
import holmes.windows.HolmesNotepad;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.text.DefaultCaret;

public class HolmesStSpRG
extends JFrame {
    private static final GUIManager overlord = GUIManager.getDefaultGUIManager();
    private static JTextArea logField1stTab = null;
    private JPanel mainPanel;
    private JPanel upperPanel;
    private JPanel lowerPanel;

    public HolmesStSpRG() {
        this.setTitle("State space analysis");
        try {
            this.setIconImage(Tools.getImageFromIcon("/icons/holmesicon.png"));
        }
        catch (Exception ex) {
            GUIManager.getDefaultGUIManager().log("Error (533315487) | Exception:  " + ex.getMessage(), "error", true);
        }
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                overlord.getFrame().setEnabled(true);
            }
        });
        overlord.getFrame().setEnabled(false);
        this.setResizable(false);
        this.initializeComponents();
        this.setVisible(true);
    }

    private void initializeComponents() {
        this.setLocation(20, 20);
        this.setLayout(new BorderLayout());
        this.setSize(new Dimension(1024, 768));
        this.setLocation(50, 50);
        this.setResizable(false);
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(null);
        this.mainPanel.setBounds(0, 0, 1024, 768);
        this.mainPanel.setLocation(0, 0);
        this.mainPanel.add(this.uppedPanel());
        this.mainPanel.add(this.lowerPanel());
        this.add((Component)this.mainPanel, "Center");
    }

    private JPanel uppedPanel() {
        this.upperPanel = new JPanel();
        this.upperPanel.setLayout(null);
        this.upperPanel.setBounds(0, 0, this.mainPanel.getWidth() - 20, 200);
        this.upperPanel.setLocation(0, 0);
        this.upperPanel.setBorder(BorderFactory.createTitledBorder("First panel:"));
        int panX = 20;
        int panY = 20;
        JButton button1 = new JButton("ExampleB1");
        button1.setText("<html><center>Example<br />B1<center></html>");
        button1.setBounds(panX, panY, 150, 40);
        button1.setMargin(new Insets(0, 0, 0, 0));
        button1.addActionListener(actionEvent -> {
            HolmesNotepad notePad = new HolmesNotepad(800, 500);
            notePad.setVisible(true);
            notePad.addTextLine("Przyk\u0142adowy tekst dla notatnika: ", "text");
            notePad.addTextLineNL("a po nim enter", "italic");
            notePad.addTextLineNL("Przyk\u0142adowy tekst dla notatnika", "bold");
            notePad.addTextLineNL("Przyk\u0142adowy tekst dla notatnika", "small");
        });
        button1.setFocusPainted(false);
        this.upperPanel.add(button1);
        JButton button2 = new JButton("ExampleB1");
        button2.setText("<html><center>Example<br />B1<center></html>");
        button2.setBounds(panX + 160, panY, 150, 40);
        button2.setMargin(new Insets(0, 0, 0, 0));
        button2.addActionListener(actionEvent -> HolmesStSpRG.exampleMethod());
        button2.setFocusPainted(false);
        this.upperPanel.add(button2);
        return this.upperPanel;
    }

    private JPanel lowerPanel() {
        this.lowerPanel = new JPanel(new BorderLayout());
        this.lowerPanel.setLayout(null);
        this.lowerPanel.setBounds(0, 0, this.mainPanel.getWidth() - 20, 550);
        this.lowerPanel.setLocation(0, this.upperPanel.getHeight());
        this.lowerPanel.setBorder(BorderFactory.createTitledBorder("Second panel:"));
        logField1stTab = new JTextArea();
        logField1stTab.setLineWrap(true);
        logField1stTab.setEditable(true);
        logField1stTab.setFont(new Font("Monospaced", 0, 12));
        DefaultCaret caret = (DefaultCaret)logField1stTab.getCaret();
        caret.setUpdatePolicy(2);
        JPanel logFieldPanel = new JPanel();
        logFieldPanel.setLayout(new BorderLayout());
        logFieldPanel.add((Component)new JScrollPane(logField1stTab), "Center");
        logFieldPanel.setBounds(10, 20, this.lowerPanel.getWidth() - 35, this.lowerPanel.getHeight() - 50);
        this.lowerPanel.add(logFieldPanel);
        return this.lowerPanel;
    }

    private static void exampleMethod() {
        ArrayList<Transition> transitions = overlord.getWorkspace().getProject().getTransitions();
        ArrayList<Place> places = overlord.getWorkspace().getProject().getPlaces();
        if (transitions.size() > 1) {
            Transition t1 = overlord.getWorkspace().getProject().getTransitions().get(0);
            logField1stTab.append("Transition 1: " + t1.getName() + "\n");
            ArrayList<Place> inputPlaces = t1.getInputPlaces();
            for (Place place : inputPlaces) {
                logField1stTab.append("Input place: " + place.getName() + "\n");
            }
            ArrayList<Place> outputPlaces = t1.getOutputPlaces();
            Iterator<Place> iterator = outputPlaces.iterator();
            while (iterator.hasNext()) {
                Place p3 = iterator.next();
                logField1stTab.append("Output place: " + p3.getName() + "\n");
            }
        } else {
            logField1stTab.append("No transitions in the project.\n");
        }
        if (places.size() > 1) {
            Place p1 = overlord.getWorkspace().getProject().getPlaces().get(0);
            logField1stTab.append("Place 1: " + p1.getName() + "\n");
            ArrayList<Transition> inputTransitions = p1.getInputTransitions();
            for (Transition transition : inputTransitions) {
                logField1stTab.append("Input transition: " + transition.getName() + "\n");
            }
            ArrayList<Transition> outputTransitions = p1.getOutputTransitions();
            for (Transition t : outputTransitions) {
                logField1stTab.append("Output transition: " + t.getName() + "\n");
            }
        } else {
            logField1stTab.append("No places in the project.\n");
        }
    }
}

