/*
 * Decompiled with CFR 0.152.
 */
package holmes.windows.ssim;

import holmes.darkgui.GUIManager;
import holmes.darkgui.LanguageManager;
import holmes.petrinet.simulators.SimulatorGlobals;
import holmes.utilities.Tools;
import holmes.windows.managers.HolmesSPNmanager;
import holmes.windows.managers.HolmesSSAwindowManager;
import holmes.windows.managers.HolmesStatesManager;
import holmes.windows.ssim.HolmesSim;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;

public class HolmesSimSetup
extends JFrame {
    private static final long serialVersionUID = -240275069200534886L;
    private static final GUIManager overlord = GUIManager.getDefaultGUIManager();
    private static final LanguageManager lang = GUIManager.getLanguageManager();
    private JFrame parentWindow;
    private JFrame ego;
    private boolean doNotUpdate = false;
    private SimulatorGlobals settings;
    private ButtonGroup groupNetType = new ButtonGroup();
    private JRadioButton classPNRadioButton;
    private JRadioButton timeNetRadioButtion;
    private JRadioButton hybridNetRadioButton;
    private ButtonGroup groupSimMode = new ButtonGroup();
    private JRadioButton fiftyModeRadioButton;
    private JRadioButton maxModeRadioButton;
    private JRadioButton singleModeRadioButton;
    private ButtonGroup immSPNmode = new ButtonGroup();
    private JRadioButton immOnly1RadioButton;
    private JRadioButton immSchedRadioButton;
    private JRadioButton immProbRadioButton;
    private JCheckBox allowEmptySteps;
    private JCheckBox useMassActionKinetics;
    private JCheckBox detRemoveMode;
    private JComboBox<String> generatorType;
    private JComboBox<String> simulatorType;

    public HolmesSimSetup(JFrame parent) {
        this.ego = this;
        this.parentWindow = parent;
        this.settings = HolmesSimSetup.overlord.simSettings;
        this.parentWindow.setEnabled(false);
        this.initializeComponents();
        this.initiateListeners();
    }

    private void initializeComponents() {
        this.setTitle(lang.getText("HSSetwin_entry001title"));
        this.setLocation(this.parentWindow.getX() + 150, this.parentWindow.getY() + 150);
        try {
            this.setIconImage(Tools.getImageFromIcon("/icons/holmesicon.png"));
        }
        catch (Exception ex) {
            overlord.log(lang.getText("LOGentry00566exception") + "\n" + ex.getMessage(), "error", true);
        }
        this.setSize(new Dimension(620, 490));
        JPanel main = new JPanel(null);
        this.add(main);
        main.add(this.createGlobalOptionsPanel(0, 0, 600, 110));
        main.add(this.createStdSimulatorSettingsPanel(0, 110, 600, 110));
        main.add(this.createStochasticSimSettingsPanel(0, 220, 600, 160));
        main.add(this.createGillespieSSASimSettingsPanel(0, 380, 600, 70));
        this.setVisible(true);
    }

    private JPanel createGlobalOptionsPanel(int x, int y, int width, int height) {
        JPanel panel = new JPanel(null);
        panel.setBounds(x, y, width, height);
        panel.setBorder(BorderFactory.createTitledBorder(lang.getText("HSSetwin_entry002")));
        int posX = 10;
        int posY = 15;
        JLabel simStepsLabel = new JLabel(lang.getText("HSSetwin_entry003"));
        simStepsLabel.setBounds(posX, posY, 80, 20);
        panel.add(simStepsLabel);
        SpinnerNumberModel simStepsSpinnerModel = new SpinnerNumberModel(this.settings.getSimSteps(), 100, 10000000, 100);
        JSpinner simStepsSpinner = new JSpinner(simStepsSpinnerModel);
        simStepsSpinner.setBounds(posX, posY + 20, 80, 20);
        simStepsSpinner.addChangeListener(e -> {
            if (this.doNotUpdate) {
                return;
            }
            JSpinner spinner = (JSpinner)e.getSource();
            int value = (Integer)spinner.getValue();
            this.settings.setSimSteps(value);
            if (this.parentWindow instanceof HolmesSim) {
                ((HolmesSim)this.parentWindow).updateIntervalSpinner();
            }
        });
        panel.add(simStepsSpinner);
        JLabel repetLabel = new JLabel(lang.getText("HSSetwin_entry004"));
        repetLabel.setBounds(posX + 85, posY, 105, 20);
        panel.add(repetLabel);
        SpinnerNumberModel simRepetsSpinnerModel = new SpinnerNumberModel(this.settings.getRepetitions(), 1, 100000, 10);
        JSpinner simRepsSpinner = new JSpinner(simRepetsSpinnerModel);
        simRepsSpinner.setBounds(posX + 110, posY + 20, 70, 20);
        simRepsSpinner.addChangeListener(e -> {
            if (this.doNotUpdate) {
                return;
            }
            JSpinner spinner = (JSpinner)e.getSource();
            int value = (Integer)spinner.getValue();
            this.settings.setRepetitions(value);
        });
        panel.add(simRepsSpinner);
        JLabel generatorLabel = new JLabel(lang.getText("HSSetwin_entry005"));
        generatorLabel.setBounds(posX + 190, posY, 180, 20);
        panel.add(generatorLabel);
        String[] simulator = new String[]{lang.getText("HSSetwin_entry006op1"), lang.getText("HSSetwin_entry006op2")};
        this.generatorType = new JComboBox<String>(simulator);
        this.generatorType.setBounds(posX + 190, posY + 20, 180, 20);
        this.generatorType.setSelectedIndex(0);
        this.generatorType.addActionListener(actionEvent -> {
            if (this.doNotUpdate) {
                return;
            }
            int selected = this.generatorType.getSelectedIndex();
            if (selected == 1) {
                HolmesSimSetup.overlord.simSettings.setGeneratorType(1);
            } else {
                HolmesSimSetup.overlord.simSettings.setGeneratorType(0);
            }
            this.doNotUpdate = false;
        });
        panel.add(this.generatorType);
        JButton stateManagerButton = new JButton();
        stateManagerButton.setText(lang.getText("HSSetwin_entry006"));
        stateManagerButton.setIcon(Tools.getResIcon32("/icons/stateManager/stManIcon.png"));
        stateManagerButton.setBounds(posX + 380, posY, 140, 40);
        stateManagerButton.setMargin(new Insets(0, 0, 0, 0));
        stateManagerButton.setFocusPainted(false);
        stateManagerButton.addActionListener(actionEvent -> new HolmesStatesManager());
        panel.add(stateManagerButton);
        JLabel simulatorLabel = new JLabel(lang.getText("HSSetwin_entry007"));
        simulatorLabel.setBounds(posX, posY + 40, 180, 20);
        panel.add(simulatorLabel);
        String[] simulatorName = new String[]{lang.getText("HSSetwin_entry008op1"), lang.getText("HSSetwin_entry008op2"), lang.getText("HSSetwin_entry008op3"), lang.getText("HSSetwin_entry008op4")};
        this.simulatorType = new JComboBox<String>(simulatorName);
        this.simulatorType.setBounds(posX, posY + 60, 250, 20);
        this.simulatorType.setSelectedIndex(0);
        this.simulatorType.addActionListener(actionEvent -> {
            if (this.doNotUpdate) {
                return;
            }
            int selected = this.simulatorType.getSelectedIndex();
            if (selected == 0) {
                HolmesSimSetup.overlord.simSettings.setSimulatorType(0);
            } else if (selected == 1) {
                HolmesSimSetup.overlord.simSettings.setSimulatorType(1);
            } else if (selected == 2) {
                HolmesSimSetup.overlord.simSettings.setSimulatorType(2);
            } else {
                JOptionPane.showMessageDialog(this.ego, lang.getText("HSSetwin_entry009"), lang.getText("unimplementedTitle"), 1);
            }
            this.doNotUpdate = false;
        });
        panel.add(this.simulatorType);
        return panel;
    }

    private JPanel createStdSimulatorSettingsPanel(int x, int y, int width, int height) {
        JPanel panel = new JPanel(null);
        panel.setBounds(x, y, width, height);
        panel.setBorder(BorderFactory.createTitledBorder(lang.getText("HSSetwin_entry010")));
        int posX = 10;
        int posY = 15;
        JPanel netTypeModePanel = new JPanel(null);
        netTypeModePanel.setBounds(posX, posY, 195, 90);
        netTypeModePanel.setBorder(BorderFactory.createTitledBorder(lang.getText("HSSetwin_entry011")));
        panel.add(netTypeModePanel);
        this.classPNRadioButton = new JRadioButton(lang.getText("HSSetwin_entry012"));
        this.classPNRadioButton.setBounds(5, 20, 180, 20);
        this.classPNRadioButton.setActionCommand("0");
        this.classPNRadioButton.addActionListener(actionEvent -> {
            AbstractButton aButton = (AbstractButton)actionEvent.getSource();
            if (aButton.isSelected()) {
                if (this.doNotUpdate) {
                    return;
                }
                this.settings.setNetType(0);
            }
        });
        netTypeModePanel.add(this.classPNRadioButton);
        this.groupNetType.add(this.classPNRadioButton);
        this.timeNetRadioButtion = new JRadioButton(lang.getText("HSSetwin_entry013"));
        this.timeNetRadioButtion.setBounds(5, 40, 180, 20);
        this.timeNetRadioButtion.setActionCommand("1");
        this.timeNetRadioButtion.addActionListener(actionEvent -> {
            AbstractButton aButton = (AbstractButton)actionEvent.getSource();
            if (aButton.isSelected()) {
                if (this.doNotUpdate) {
                    return;
                }
                int res = this.settings.setNetType(1);
                if (res == 0) {
                    this.groupNetType.setSelected(this.classPNRadioButton.getModel(), true);
                } else if (res == 2) {
                    this.groupNetType.setSelected(this.hybridNetRadioButton.getModel(), true);
                }
                this.doNotUpdate = false;
            }
        });
        netTypeModePanel.add(this.timeNetRadioButtion);
        this.groupNetType.add(this.timeNetRadioButtion);
        this.hybridNetRadioButton = new JRadioButton(lang.getText("HSSetwin_entry014"));
        this.hybridNetRadioButton.setBounds(5, 60, 180, 20);
        this.hybridNetRadioButton.setActionCommand("2");
        this.hybridNetRadioButton.addActionListener(actionEvent -> {
            AbstractButton aButton = (AbstractButton)actionEvent.getSource();
            if (aButton.isSelected()) {
                if (this.doNotUpdate) {
                    return;
                }
                this.settings.setNetType(2);
            }
        });
        netTypeModePanel.add(this.hybridNetRadioButton);
        this.groupNetType.add(this.hybridNetRadioButton);
        JPanel subModeModePanel = new JPanel(null);
        subModeModePanel.setBounds(posX + 195, posY, 210, 90);
        subModeModePanel.setBorder(BorderFactory.createTitledBorder(lang.getText("HSSetwin_entry015")));
        panel.add(subModeModePanel);
        this.fiftyModeRadioButton = new JRadioButton(lang.getText("HSSetwin_entry016"));
        this.fiftyModeRadioButton.setBounds(5, 20, 200, 20);
        this.fiftyModeRadioButton.setActionCommand("0");
        this.fiftyModeRadioButton.addActionListener(actionEvent -> {
            if (this.doNotUpdate) {
                return;
            }
            AbstractButton aButton = (AbstractButton)actionEvent.getSource();
            if (aButton.isSelected()) {
                this.settings.setSingleMode(false);
                this.settings.setMaxMode(false);
            }
        });
        subModeModePanel.add(this.fiftyModeRadioButton);
        this.groupSimMode.add(this.fiftyModeRadioButton);
        this.maxModeRadioButton = new JRadioButton(lang.getText("HSSetwin_entry017"));
        this.maxModeRadioButton.setBounds(5, 40, 200, 20);
        this.maxModeRadioButton.setActionCommand("1");
        this.maxModeRadioButton.addActionListener(actionEvent -> {
            if (this.doNotUpdate) {
                return;
            }
            AbstractButton aButton = (AbstractButton)actionEvent.getSource();
            if (aButton.isSelected()) {
                this.settings.setSingleMode(false);
                this.settings.setMaxMode(true);
            }
        });
        subModeModePanel.add(this.maxModeRadioButton);
        this.groupSimMode.add(this.maxModeRadioButton);
        this.singleModeRadioButton = new JRadioButton(lang.getText("HSSetwin_entry018"));
        this.singleModeRadioButton.setBounds(5, 60, 200, 20);
        this.singleModeRadioButton.setActionCommand("2");
        this.singleModeRadioButton.addActionListener(actionEvent -> {
            if (this.doNotUpdate) {
                return;
            }
            AbstractButton aButton = (AbstractButton)actionEvent.getSource();
            if (aButton.isSelected()) {
                this.settings.setSingleMode(true);
            }
        });
        subModeModePanel.add(this.singleModeRadioButton);
        this.groupSimMode.add(this.singleModeRadioButton);
        this.allowEmptySteps = new JCheckBox(lang.getText("HSSetwin_entry019"));
        this.allowEmptySteps.setBounds(posX + 410, posY, 180, 20);
        this.allowEmptySteps.setToolTipText(lang.getText("HSSetwin_entry019t"));
        this.allowEmptySteps.addActionListener(actionEvent -> {
            if (this.doNotUpdate) {
                return;
            }
            AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
            this.settings.setEmptySteps(abstractButton.getModel().isSelected());
        });
        panel.add(this.allowEmptySteps);
        return panel;
    }

    private JPanel createStochasticSimSettingsPanel(int x, int y, int width, int height) {
        JPanel panel = new JPanel(null);
        panel.setBounds(x, y, width, height);
        panel.setBorder(BorderFactory.createTitledBorder(lang.getText("HSSetwin_entry020")));
        int posX = 10;
        int posY = 20;
        JButton createFRWindowButton = new JButton(lang.getText("HSSetwin_entry021"));
        createFRWindowButton.setIcon(Tools.getResIcon16("/icons/fRatesManager/fireRateIcon.png"));
        createFRWindowButton.setBounds(posX, posY, 120, 45);
        createFRWindowButton.setFocusPainted(false);
        createFRWindowButton.setToolTipText(lang.getText("HSSetwin_entry021t"));
        createFRWindowButton.addActionListener(actionEvent -> new HolmesSPNmanager(this.ego));
        panel.add(createFRWindowButton);
        this.useMassActionKinetics = new JCheckBox(lang.getText("HSSetwin_entry022"));
        this.useMassActionKinetics.setToolTipText(lang.getText("HSSetwin_entry022t"));
        this.useMassActionKinetics.setBounds(posX + 130, posY, 370, 20);
        this.useMassActionKinetics.addActionListener(actionEvent -> {
            if (this.doNotUpdate) {
                return;
            }
            AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
            this.settings.setSSAmassAction(abstractButton.getModel().isSelected());
        });
        panel.add(this.useMassActionKinetics);
        this.detRemoveMode = new JCheckBox(lang.getText("HSSetwin_entry023"));
        this.detRemoveMode.setToolTipText(lang.getText("HSSetwin_entry023t"));
        this.detRemoveMode.setBounds(posX + 130, posY + 20, 370, 20);
        this.detRemoveMode.addActionListener(actionEvent -> {
            if (this.doNotUpdate) {
                return;
            }
            AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
            this.settings.setSPNdetRemoveMode(abstractButton.getModel().isSelected());
        });
        panel.add(this.detRemoveMode);
        JPanel immSPNModePanel = new JPanel(null);
        immSPNModePanel.setBounds(posX, posY + 45, 300, 90);
        immSPNModePanel.setBorder(BorderFactory.createTitledBorder(lang.getText("HSSetwin_entry024")));
        panel.add(immSPNModePanel);
        this.immOnly1RadioButton = new JRadioButton(lang.getText("HSSetwin_entry025"));
        this.immOnly1RadioButton.setBounds(5, 20, 280, 20);
        this.immOnly1RadioButton.setToolTipText(lang.getText("HSSetwin_entry025t"));
        this.immOnly1RadioButton.setActionCommand("0");
        this.immOnly1RadioButton.addActionListener(actionEvent -> {
            AbstractButton aButton = (AbstractButton)actionEvent.getSource();
            if (aButton.isSelected()) {
                if (this.doNotUpdate) {
                    return;
                }
                this.settings.setSPNimmediateMode(0);
            }
        });
        immSPNModePanel.add(this.immOnly1RadioButton);
        this.immSPNmode.add(this.immOnly1RadioButton);
        this.immSchedRadioButton = new JRadioButton(lang.getText("HSSetwin_entry026"));
        this.immSchedRadioButton.setBounds(5, 40, 280, 20);
        this.immOnly1RadioButton.setToolTipText(lang.getText("HSSetwin_entry026t"));
        this.immSchedRadioButton.setActionCommand("1");
        this.immSchedRadioButton.setToolTipText(lang.getText("HSSetwin_entry026t"));
        this.immSchedRadioButton.addActionListener(actionEvent -> {
            AbstractButton aButton = (AbstractButton)actionEvent.getSource();
            if (aButton.isSelected()) {
                if (this.doNotUpdate) {
                    return;
                }
                this.settings.setSPNimmediateMode(1);
            }
        });
        immSPNModePanel.add(this.immSchedRadioButton);
        this.immSPNmode.add(this.immSchedRadioButton);
        this.immProbRadioButton = new JRadioButton(lang.getText("HSSetwin_entry027"));
        this.immProbRadioButton.setBounds(5, 60, 280, 20);
        this.immProbRadioButton.setToolTipText(lang.getText("HSSetwin_entry027t"));
        this.immProbRadioButton.setActionCommand("2");
        this.immProbRadioButton.addActionListener(actionEvent -> {
            AbstractButton aButton = (AbstractButton)actionEvent.getSource();
            if (aButton.isSelected()) {
                if (this.doNotUpdate) {
                    return;
                }
                this.settings.setSPNimmediateMode(2);
            }
        });
        immSPNModePanel.add(this.immProbRadioButton);
        this.immSPNmode.add(this.immProbRadioButton);
        return panel;
    }

    private JPanel createGillespieSSASimSettingsPanel(int x, int y, int width, int height) {
        JPanel panel = new JPanel(null);
        panel.setBounds(x, y, width, height);
        panel.setBorder(BorderFactory.createTitledBorder(lang.getText("HSSetwin_entry028")));
        int posX = 10;
        int posY = 20;
        JButton createFRWindowButton = new JButton(lang.getText("HSSetwin_entry029"));
        createFRWindowButton.setIcon(Tools.getResIcon16("/icons/fRatesManager/fireRateIcon.png"));
        createFRWindowButton.setBounds(posX, posY, 120, 45);
        createFRWindowButton.setFocusPainted(false);
        createFRWindowButton.setToolTipText(lang.getText("HSSetwin_entry029t"));
        createFRWindowButton.addActionListener(actionEvent -> new HolmesSPNmanager(this.ego));
        panel.add(createFRWindowButton);
        JButton createCompoundsEditorWindowButton = new JButton(lang.getText("HSSetwin_entry030"));
        createCompoundsEditorWindowButton.setIcon(Tools.getResIcon16("/icons/componentsManager/compIcon.png"));
        createCompoundsEditorWindowButton.setMargin(new Insets(0, 0, 0, 0));
        createCompoundsEditorWindowButton.setFocusPainted(false);
        createCompoundsEditorWindowButton.setBounds(posX + 130, posY, 120, 45);
        createCompoundsEditorWindowButton.setToolTipText(lang.getText("HSSetwin_entry030t"));
        createCompoundsEditorWindowButton.addActionListener(actionEvent -> new HolmesSSAwindowManager(this.ego));
        panel.add(createCompoundsEditorWindowButton);
        return panel;
    }

    private void configureWindow() {
        this.doNotUpdate = true;
        SimulatorGlobals.SimNetType netType = this.settings.getNetType();
        if (netType == SimulatorGlobals.SimNetType.BASIC) {
            this.groupNetType.setSelected(this.classPNRadioButton.getModel(), true);
        } else if (netType == SimulatorGlobals.SimNetType.TIME) {
            this.groupNetType.setSelected(this.timeNetRadioButtion.getModel(), true);
        } else if (netType == SimulatorGlobals.SimNetType.HYBRID) {
            this.groupNetType.setSelected(this.hybridNetRadioButton.getModel(), true);
        }
        if (this.settings.isSingleMode()) {
            this.groupSimMode.setSelected(this.singleModeRadioButton.getModel(), true);
        } else if (this.settings.isMaxMode()) {
            this.groupSimMode.setSelected(this.maxModeRadioButton.getModel(), true);
        } else {
            this.groupSimMode.setSelected(this.fiftyModeRadioButton.getModel(), true);
        }
        this.allowEmptySteps.setSelected(this.settings.isEmptySteps());
        this.useMassActionKinetics.setSelected(this.settings.isSSAMassAction());
        this.detRemoveMode.setSelected(this.settings.isSPNdetRemoveMode());
        if (this.settings.getGeneratorType() == 0) {
            this.generatorType.setSelectedIndex(0);
        } else {
            this.generatorType.setSelectedIndex(1);
        }
        if (this.settings.getSimulatorType() == 0) {
            this.simulatorType.setSelectedIndex(0);
        } else {
            this.simulatorType.setSelectedIndex(1);
        }
        int imSPNmode = this.settings.getSPNimmediateMode();
        if (imSPNmode == 0) {
            this.immSPNmode.setSelected(this.immOnly1RadioButton.getModel(), true);
        } else if (imSPNmode == 1) {
            this.immSPNmode.setSelected(this.immSchedRadioButton.getModel(), true);
        } else if (imSPNmode == 2) {
            this.immSPNmode.setSelected(this.immProbRadioButton.getModel(), true);
        }
        this.doNotUpdate = false;
    }

    private void initiateListeners() {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent e) {
                HolmesSimSetup.this.configureWindow();
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                HolmesSimSetup.this.setDefaultCloseOperation(2);
                HolmesSimSetup.this.parentWindow.setEnabled(true);
            }
        });
    }
}

