/*
 * Decompiled with CFR 0.152.
 */
package holmes.windows.ssim;

import holmes.darkgui.GUIManager;
import holmes.darkgui.LanguageManager;
import holmes.petrinet.data.NetSimulationData;
import holmes.petrinet.data.PetriNet;
import holmes.petrinet.elements.Transition;
import holmes.petrinet.simulators.StateSimulator;
import holmes.utilities.Tools;
import holmes.windows.managers.HolmesStatesManager;
import holmes.windows.ssim.HolmesSim;
import holmes.windows.ssim.HolmesSimKnockActions;
import holmes.windows.ssim.HolmesSimKnockVis;
import holmes.windows.ssim.HolmesSimSetup;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.TitledBorder;

public class HolmesSimKnock
extends JPanel {
    private static final long serialVersionUID = 4257940971120618716L;
    private static final GUIManager overlord = GUIManager.getDefaultGUIManager();
    private static final LanguageManager lang = GUIManager.getLanguageManager();
    public HolmesSimKnockActions action;
    public StateSimulator ssimKnock;
    public HolmesSim mainSimWindow;
    public JProgressBar refProgressBarKnockout;
    public boolean refShowNotepad = false;
    private JComboBox<String> referencesCombo = null;
    private JLabel refLabelDate;
    private JLabel refLabelSimNetMode;
    private JLabel refLabelMaxMode;
    private JLabel refLabelSteps;
    private JLabel refLabelReps;
    private JComboBox<String> dataCombo = null;
    private JLabel dataLabelDate;
    private JLabel dataLabelSimNetMode;
    private JLabel dataLabelMaxMode;
    private JLabel dataLabelSteps;
    private JLabel dataLabelReps;
    private JLabel dataLabelDisabled;
    private JComboBox<String> dataTransitionsCombo = null;
    private JComboBox<String> dataMctCombo = null;
    public JProgressBar dataProgressBarKnockout;
    public JTextArea dataSelectedTransTextArea;
    public boolean dataSimUseEditorOffline = false;
    public boolean dataSimComputeAll = false;
    public boolean dataShowNotepad = false;
    public JCheckBox dataSimUseEditorOfflineCheckBox;
    public JCheckBox dataSimComputeForAllTransitions;
    private JButton acqRefDataButton;
    private JButton acqDataSimButton;
    private JButton simSettingsButton;
    private JButton loadAllButton;
    private JButton saveAllButton;
    public boolean refSimInProgress = false;
    public boolean dataSimInProgress = false;
    private JLabel selStateLabel;
    private JLabel selStateDescrLabel;
    private JButton stateManagerButton;

    public HolmesSimKnock(HolmesSim holmesStateSimulator) {
        this.mainSimWindow = holmesStateSimulator;
        this.ssimKnock = new StateSimulator();
        this.action = new HolmesSimKnockActions(this);
        this.setLayout(new BorderLayout());
        this.add((Component)this.getMainOptionsPanel(), "North");
        JPanel allTheRest = new JPanel(new BorderLayout());
        this.add(allTheRest);
        allTheRest.add((Component)this.getRefAcqPanel(), "North");
        JPanel refAndDataPanel = new JPanel(new BorderLayout());
        refAndDataPanel.add((Component)this.getRefDetailsPanel(), "North");
        JPanel dataAndChartsPanel = new JPanel(new BorderLayout());
        dataAndChartsPanel.add((Component)this.getSimDataAcqPanel(), "North");
        dataAndChartsPanel.add((Component)this.getSimDataDetailsPanel(), "Center");
        refAndDataPanel.add((Component)dataAndChartsPanel, "Center");
        allTheRest.add((Component)refAndDataPanel, "Center");
    }

    public JPanel getRefAcqPanel() {
        JPanel result = new JPanel(null);
        result.setBorder(BorderFactory.createTitledBorder("Reference data acquisition panel"));
        result.setPreferredSize(new Dimension(670, 100));
        int posXda = 10;
        int posYda = 10;
        this.acqRefDataButton = new JButton(lang.getText("HSKwin_entry001"));
        this.acqRefDataButton.setBounds(posXda, posYda + 10, 110, 40);
        this.acqRefDataButton.setMargin(new Insets(0, 0, 0, 0));
        this.acqRefDataButton.setFocusPainted(false);
        this.acqRefDataButton.setIcon(Tools.getResIcon32("/icons/stateSim/computeData.png"));
        this.acqRefDataButton.setToolTipText(lang.getText("HSKwin_entry001t"));
        this.acqRefDataButton.addActionListener(actionEvent -> this.action.acquireDataForRefSet());
        result.add(this.acqRefDataButton);
        JButton cancelButton = new JButton();
        cancelButton.setText(lang.getText("HSKwin_entry002"));
        cancelButton.setIcon(Tools.getResIcon32("/icons/simulationKnockout/stopIcon.png"));
        cancelButton.setToolTipText(lang.getText("HSKwin_entry002t"));
        cancelButton.setBounds(posXda, posYda + 55, 110, 25);
        cancelButton.setMargin(new Insets(0, 0, 0, 0));
        cancelButton.setFocusPainted(false);
        cancelButton.addActionListener(actionEvent -> {
            if (this.refSimInProgress) {
                this.ssimKnock.setCancelStatus(true);
            }
        });
        result.add(cancelButton);
        this.refProgressBarKnockout = new JProgressBar();
        this.refProgressBarKnockout.setBounds(posXda + 120, posYda + 3, 830, 40);
        this.refProgressBarKnockout.setMaximum(100);
        this.refProgressBarKnockout.setMinimum(0);
        this.refProgressBarKnockout.setValue(0);
        this.refProgressBarKnockout.setStringPainted(true);
        TitledBorder border = BorderFactory.createTitledBorder(lang.getText("HSKwin_entry003"));
        this.refProgressBarKnockout.setBorder(border);
        result.add(this.refProgressBarKnockout);
        JCheckBox showdataCheckBox = new JCheckBox(lang.getText("HSKwin_entry004"));
        showdataCheckBox.setBounds(posXda + 120, posYda + 50, 300, 20);
        showdataCheckBox.addActionListener(actionEvent -> {
            AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
            this.refShowNotepad = abstractButton.getModel().isSelected();
        });
        result.add(showdataCheckBox);
        return result;
    }

    public JPanel getRefDetailsPanel() {
        JPanel result = new JPanel(null);
        result.setBorder(BorderFactory.createTitledBorder(lang.getText("HSKwin_entry005")));
        result.setPreferredSize(new Dimension(500, 100));
        this.mainSimWindow.doNotUpdate = true;
        int posXda = 10;
        int posYda = 20;
        JLabel label1 = new JLabel(lang.getText("HSKwin_entry006"));
        label1.setBounds(posXda, posYda, 70, 20);
        result.add(label1);
        String[] data = new String[]{" ----- "};
        this.referencesCombo = new JComboBox<String>(data);
        this.referencesCombo.setBounds(posXda + 80, posYda, 420, 20);
        this.referencesCombo.setMaximumRowCount(12);
        this.referencesCombo.addActionListener(actionEvent -> {
            if (this.mainSimWindow.doNotUpdate) {
                return;
            }
            int selected = this.referencesCombo.getSelectedIndex();
            if (selected > 0) {
                this.updateRefDetails(selected - 1);
            }
        });
        result.add(this.referencesCombo);
        JButton removeRefButton = new JButton(lang.getText("HSKwin_entry007"));
        removeRefButton.setBounds(posXda + 505, posYda, 100, 20);
        removeRefButton.setMargin(new Insets(0, 0, 0, 0));
        removeRefButton.setFocusPainted(false);
        removeRefButton.setIcon(Tools.getResIcon16("/icons/simulationKnockout/removeIcon.png"));
        removeRefButton.setToolTipText(lang.getText("HSKwin_entry007t"));
        removeRefButton.addActionListener(actionEvent -> {
            int selected = this.referencesCombo.getSelectedIndex();
            if (selected > 0 && this.action.removeRedDataSet(selected - 1)) {
                this.updateFreshKnockoutTab();
            }
        });
        result.add(removeRefButton);
        JLabel dateTxtLabel = new JLabel(lang.getText("HSKwin_entry008"));
        dateTxtLabel.setBounds(posXda, posYda + 20, 90, 20);
        result.add(dateTxtLabel);
        this.refLabelDate = new JLabel("---");
        this.refLabelDate.setBounds(posXda + 100, posYda + 20, 120, 20);
        result.add(this.refLabelDate);
        JLabel modeTxtLabel = new JLabel(lang.getText("HSKwin_entry009"));
        modeTxtLabel.setBounds(posXda + 250, posYda + 20, 110, 20);
        result.add(modeTxtLabel);
        this.refLabelSimNetMode = new JLabel("---");
        this.refLabelSimNetMode.setBounds(posXda + 370, posYda + 20, 70, 20);
        result.add(this.refLabelSimNetMode);
        JLabel maxModeTxtLabel = new JLabel(lang.getText("HSKwin_entry010"));
        maxModeTxtLabel.setBounds(posXda + 450, posYda + 20, 90, 20);
        result.add(maxModeTxtLabel);
        this.refLabelMaxMode = new JLabel("---");
        this.refLabelMaxMode.setBounds(posXda + 550, posYda + 20, 90, 20);
        result.add(this.refLabelMaxMode);
        JLabel stepsTxtLabel = new JLabel(lang.getText("HSKwin_entry011"));
        stepsTxtLabel.setBounds(posXda, posYda + 40, 90, 20);
        result.add(stepsTxtLabel);
        this.refLabelSteps = new JLabel("---");
        this.refLabelSteps.setBounds(posXda + 100, posYda + 40, 80, 20);
        result.add(this.refLabelSteps);
        JLabel repsTxtLabel = new JLabel(lang.getText("HSKwin_entry012"));
        repsTxtLabel.setBounds(posXda + 250, posYda + 40, 110, 20);
        result.add(repsTxtLabel);
        this.refLabelReps = new JLabel("---");
        this.refLabelReps.setBounds(posXda + 370, posYda + 40, 90, 20);
        result.add(this.refLabelReps);
        this.mainSimWindow.doNotUpdate = false;
        return result;
    }

    public JPanel getSimDataAcqPanel() {
        JPanel result = new JPanel(null);
        result.setBorder(BorderFactory.createTitledBorder(lang.getText("HSKwin_entry013")));
        result.setPreferredSize(new Dimension(670, 165));
        this.mainSimWindow.doNotUpdate = true;
        int posXda = 10;
        int posYda = 20;
        JLabel transitionsLabel = new JLabel(lang.getText("HSKwin_entry014"));
        transitionsLabel.setBounds(posXda, posYda, 70, 20);
        result.add(transitionsLabel);
        String[] data = new String[]{" ----- "};
        this.dataTransitionsCombo = new JComboBox<String>(data);
        this.dataTransitionsCombo.setBounds(posXda + 80, posYda, 400, 20);
        this.dataTransitionsCombo.setMaximumRowCount(12);
        this.dataTransitionsCombo.addActionListener(actionEvent -> {});
        result.add(this.dataTransitionsCombo);
        JButton addTransButton = new JButton(lang.getText("HSKwin_entry015"));
        addTransButton.setBounds(posXda + 485, posYda, 100, 20);
        addTransButton.setMargin(new Insets(0, 0, 0, 0));
        addTransButton.setFocusPainted(false);
        addTransButton.setIcon(Tools.getResIcon16("/icons/simulationKnockout/addIcon.png"));
        addTransButton.setToolTipText(lang.getText("HSKwin_entry015t"));
        addTransButton.addActionListener(actionEvent -> {
            int selected = this.dataTransitionsCombo.getSelectedIndex();
            if (selected > 0) {
                this.action.addOfflineElement(1, selected - 1, this.dataSelectedTransTextArea);
            }
        });
        result.add(addTransButton);
        JButton removeTransButton = new JButton(lang.getText("HSKwin_entry016"));
        removeTransButton.setBounds(posXda + 590, posYda, 100, 20);
        removeTransButton.setMargin(new Insets(0, 0, 0, 0));
        removeTransButton.setFocusPainted(false);
        removeTransButton.setIcon(Tools.getResIcon16("/icons/simulationKnockout/removeIcon.png"));
        removeTransButton.setToolTipText(lang.getText("HSKwin_entry016t"));
        removeTransButton.addActionListener(actionEvent -> {
            int selected = this.dataTransitionsCombo.getSelectedIndex();
            if (selected > 0) {
                this.action.removeOfflineElement(1, selected - 1, this.dataSelectedTransTextArea);
            }
        });
        result.add(removeTransButton);
        JLabel MCTsLabel = new JLabel(lang.getText("HSKwin_entry017"));
        MCTsLabel.setBounds(posXda, posYda + 25, 70, 20);
        result.add(MCTsLabel);
        String[] data2 = new String[]{" ----- "};
        this.dataMctCombo = new JComboBox<String>(data2);
        this.dataMctCombo.setBounds(posXda + 80, posYda + 25, 400, 20);
        this.dataMctCombo.setMaximumRowCount(12);
        this.dataMctCombo.addActionListener(actionEvent -> {});
        result.add(this.dataMctCombo);
        JButton addMCTButton = new JButton(lang.getText("HSKwin_entry018"));
        addMCTButton.setBounds(posXda + 485, posYda + 25, 100, 20);
        addMCTButton.setMargin(new Insets(0, 0, 0, 0));
        addMCTButton.setFocusPainted(false);
        addMCTButton.setIcon(Tools.getResIcon16("/icons/simulationKnockout/addIcon.png"));
        addMCTButton.setToolTipText(lang.getText("HSKwin_entry018t"));
        addMCTButton.addActionListener(actionEvent -> {
            int selected = this.dataMctCombo.getSelectedIndex();
            if (selected > 0) {
                this.action.addOfflineElement(2, selected, this.dataSelectedTransTextArea);
            }
        });
        result.add(addMCTButton);
        JButton removeMCTButton = new JButton(lang.getText("HSKwin_entry019"));
        removeMCTButton.setBounds(posXda + 590, posYda + 25, 100, 20);
        removeMCTButton.setMargin(new Insets(0, 0, 0, 0));
        removeMCTButton.setFocusPainted(false);
        removeMCTButton.setIcon(Tools.getResIcon16("/icons/simulationKnockout/removeIcon.png"));
        removeMCTButton.setToolTipText(lang.getText("HSKwin_entry019t"));
        removeMCTButton.addActionListener(actionEvent -> {
            int selected = this.dataMctCombo.getSelectedIndex();
            if (selected > 0) {
                this.action.removeOfflineElement(2, selected, this.dataSelectedTransTextArea);
            }
        });
        result.add(removeMCTButton);
        this.dataSelectedTransTextArea = new JTextArea();
        this.dataSelectedTransTextArea.setLineWrap(true);
        this.dataSelectedTransTextArea.setEditable(true);
        JPanel dataFieldPanel = new JPanel();
        dataFieldPanel.setLayout(new BorderLayout());
        dataFieldPanel.add((Component)new JScrollPane(this.dataSelectedTransTextArea), "Center");
        dataFieldPanel.setBounds(posXda + 700, posYda, 165, 45);
        result.add(dataFieldPanel);
        JButton clearButton = new JButton(lang.getText("HSKwin_entry020"));
        clearButton.setBounds(posXda + 870, posYda, 90, 45);
        clearButton.setMargin(new Insets(0, 0, 0, 0));
        clearButton.setFocusPainted(false);
        clearButton.setIcon(Tools.getResIcon16("/icons/simulationKnockout/clearIcon.png"));
        clearButton.setToolTipText(lang.getText("HSKwin_entry020t"));
        clearButton.addActionListener(actionEvent -> this.dataSelectedTransTextArea.setText(""));
        result.add(clearButton);
        this.acqDataSimButton = new JButton(lang.getText("HSKwin_entry021"));
        this.acqDataSimButton.setBounds(posXda, (posYda += 50) + 10, 110, 40);
        this.acqDataSimButton.setMargin(new Insets(0, 0, 0, 0));
        this.acqDataSimButton.setFocusPainted(false);
        this.acqDataSimButton.setIcon(Tools.getResIcon32("/icons/stateSim/computeData.png"));
        this.acqDataSimButton.setToolTipText(lang.getText("HSKwin_entry021t"));
        this.acqDataSimButton.addActionListener(actionEvent -> {
            if (this.dataSimUseEditorOffline && this.dataSimComputeAll) {
                JOptionPane.showMessageDialog(this.mainSimWindow.getFrame(), lang.getText("HSKwin_entry022"), lang.getText("problem"), 2);
                return;
            }
            if (this.dataSimComputeAll) {
                this.action.acquireAll();
                return;
            }
            this.action.acquireDataForKnockoutSet(this.dataSelectedTransTextArea, this.dataSimUseEditorOffline);
        });
        result.add(this.acqDataSimButton);
        JButton cancelButton = new JButton();
        cancelButton.setText(lang.getText("HSKwin_entry023"));
        cancelButton.setIcon(Tools.getResIcon32("/icons/simulationKnockout/stopIcon.png"));
        cancelButton.setBounds(posXda, posYda + 55, 110, 25);
        cancelButton.setMargin(new Insets(0, 0, 0, 0));
        cancelButton.setFocusPainted(false);
        cancelButton.addActionListener(actionEvent -> {
            if (this.dataSimComputeAll && this.dataSimInProgress) {
                Object[] options = new Object[]{"Stop and remove", "Proceed with simulation"};
                int n = JOptionPane.showOptionDialog(null, lang.getText("HSKwin_entry023msg"), lang.getText("HSKwin_entry023t"), 0, 3, null, options, options[1]);
                if (n == 0) {
                    this.ssimKnock.setCancelStatus(true);
                    JOptionPane.showMessageDialog(this.mainSimWindow.getFrame(), lang.getText("HSKwin_entry024"), lang.getText("HSKwin_entry024t"), 2);
                }
            }
        });
        result.add(cancelButton);
        JPanel special = new JPanel(null);
        special.setBorder(BorderFactory.createTitledBorder(lang.getText("HSKwin_entry025")));
        special.setBounds(posXda + 120, posYda, 770, 40);
        result.add(special);
        this.dataSimUseEditorOfflineCheckBox = new JCheckBox(lang.getText("HSKwin_entry026"));
        this.dataSimUseEditorOfflineCheckBox.setBounds(10, 15, 240, 20);
        this.dataSimUseEditorOfflineCheckBox.addActionListener(actionEvent -> {
            AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
            this.dataSimUseEditorOffline = abstractButton.getModel().isSelected();
        });
        special.add(this.dataSimUseEditorOfflineCheckBox);
        this.dataSimComputeForAllTransitions = new JCheckBox(lang.getText("HSKwin_entry027"));
        this.dataSimComputeForAllTransitions.setBounds(260, 15, 200, 20);
        this.dataSimComputeForAllTransitions.addActionListener(actionEvent -> {
            AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
            this.dataSimComputeAll = abstractButton.getModel().isSelected();
        });
        special.add(this.dataSimComputeForAllTransitions);
        JCheckBox showdataCheckBox = new JCheckBox(lang.getText("HSKwin_entry028"));
        showdataCheckBox.setBounds(480, 15, 260, 20);
        showdataCheckBox.addActionListener(actionEvent -> {
            AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
            this.dataShowNotepad = abstractButton.getModel().isSelected();
        });
        special.add(showdataCheckBox);
        this.dataProgressBarKnockout = new JProgressBar();
        this.dataProgressBarKnockout.setBounds(posXda + 120, posYda + 45, 830, 40);
        this.dataProgressBarKnockout.setMaximum(100);
        this.dataProgressBarKnockout.setMinimum(0);
        this.dataProgressBarKnockout.setValue(0);
        this.dataProgressBarKnockout.setStringPainted(true);
        TitledBorder border = BorderFactory.createTitledBorder(lang.getText("HSKwin_entry029"));
        this.dataProgressBarKnockout.setBorder(border);
        result.add(this.dataProgressBarKnockout);
        this.mainSimWindow.doNotUpdate = false;
        return result;
    }

    public JPanel getSimDataDetailsPanel() {
        JPanel result = new JPanel(null);
        result.setBorder(BorderFactory.createTitledBorder(lang.getText("HSKwin_entry030")));
        result.setPreferredSize(new Dimension(670, 110));
        this.mainSimWindow.doNotUpdate = true;
        int posXda = 10;
        int posYda = 20;
        JLabel label1 = new JLabel(lang.getText("HSKwin_entry031"));
        label1.setBounds(posXda, posYda, 70, 20);
        result.add(label1);
        String[] data = new String[]{" ----- "};
        this.dataCombo = new JComboBox<String>(data);
        this.dataCombo.setBounds(posXda + 80, posYda, 600, 20);
        this.dataCombo.setMaximumRowCount(12);
        this.dataCombo.addActionListener(actionEvent -> {
            if (this.mainSimWindow.doNotUpdate) {
                return;
            }
            int selected = this.dataCombo.getSelectedIndex();
            if (selected > 0) {
                this.updateDataDetails(selected - 1);
            }
        });
        result.add(this.dataCombo);
        JButton removeDataButton = new JButton(lang.getText("HSKwin_entry032"));
        removeDataButton.setBounds(posXda + 685, posYda, 85, 20);
        removeDataButton.setMargin(new Insets(0, 0, 0, 0));
        removeDataButton.setFocusPainted(false);
        removeDataButton.setIcon(Tools.getResIcon16("/icons/simulationKnockout/removeIcon.png"));
        removeDataButton.setToolTipText(lang.getText("HSKwin_entry032t"));
        removeDataButton.addActionListener(actionEvent -> {
            int selected = this.dataCombo.getSelectedIndex();
            if (selected > 0 && this.action.removeKnockDataSet(selected - 1)) {
                this.updateFreshKnockoutTab();
            }
        });
        result.add(removeDataButton);
        JLabel dateTxtLabel = new JLabel(lang.getText("HSKwin_entry033"));
        dateTxtLabel.setBounds(posXda, posYda + 20, 90, 20);
        result.add(dateTxtLabel);
        this.dataLabelDate = new JLabel("---");
        this.dataLabelDate.setBounds(posXda + 100, posYda + 20, 120, 20);
        result.add(this.dataLabelDate);
        JLabel modeTxtLabel = new JLabel(lang.getText("HSKwin_entry034"));
        modeTxtLabel.setBounds(posXda + 250, posYda + 20, 110, 20);
        result.add(modeTxtLabel);
        this.dataLabelSimNetMode = new JLabel("---");
        this.dataLabelSimNetMode.setBounds(posXda + 370, posYda + 20, 70, 20);
        result.add(this.dataLabelSimNetMode);
        JLabel maxModeTxtLabel = new JLabel(lang.getText("HSKwin_entry035"));
        maxModeTxtLabel.setBounds(posXda + 450, posYda + 20, 90, 20);
        result.add(maxModeTxtLabel);
        this.dataLabelMaxMode = new JLabel("---");
        this.dataLabelMaxMode.setBounds(posXda + 550, posYda + 20, 90, 20);
        result.add(this.dataLabelMaxMode);
        JLabel stepsTxtLabel = new JLabel(lang.getText("HSKwin_entry036"));
        stepsTxtLabel.setBounds(posXda, posYda + 40, 90, 20);
        result.add(stepsTxtLabel);
        this.dataLabelSteps = new JLabel("---");
        this.dataLabelSteps.setBounds(posXda + 100, posYda + 40, 80, 20);
        result.add(this.dataLabelSteps);
        JLabel repsTxtLabel = new JLabel(lang.getText("HSKwin_entry037"));
        repsTxtLabel.setBounds(posXda + 250, posYda + 40, 110, 20);
        result.add(repsTxtLabel);
        this.dataLabelReps = new JLabel("---");
        this.dataLabelReps.setBounds(posXda + 370, posYda + 40, 90, 20);
        result.add(this.dataLabelReps);
        JLabel disabledTxtLabel = new JLabel(lang.getText("HSKwin_entry038"));
        disabledTxtLabel.setBounds(posXda, posYda + 60, 90, 20);
        result.add(disabledTxtLabel);
        this.dataLabelDisabled = new JLabel("----- ----- -----");
        this.dataLabelDisabled.setBounds(posXda + 100, posYda + 60, 350, 20);
        result.add(this.dataLabelDisabled);
        this.mainSimWindow.doNotUpdate = false;
        return result;
    }

    private JPanel getMainOptionsPanel() {
        JPanel result = new JPanel(null);
        result.setBorder(BorderFactory.createTitledBorder(lang.getText("HSKwin_entry039")));
        result.setPreferredSize(new Dimension(670, 120));
        this.mainSimWindow.doNotUpdate = true;
        int posXda = 10;
        int posYda = 20;
        this.loadAllButton = new JButton(lang.getText("HSKwin_entry040"));
        this.loadAllButton.setBounds(posXda, posYda, 130, 40);
        this.loadAllButton.setMargin(new Insets(0, 0, 0, 0));
        this.loadAllButton.setFocusPainted(false);
        this.loadAllButton.setIcon(Tools.getResIcon32("/icons/simulationKnockout/loadIcon.png"));
        this.loadAllButton.setToolTipText(lang.getText("HSKwin_entry040t"));
        this.loadAllButton.addActionListener(actionEvent -> this.action.loadDataSets());
        result.add(this.loadAllButton);
        this.saveAllButton = new JButton(lang.getText("HSKwin_entry041"));
        this.saveAllButton.setBounds(posXda + 140, posYda, 130, 40);
        this.saveAllButton.setMargin(new Insets(0, 0, 0, 0));
        this.saveAllButton.setFocusPainted(false);
        this.saveAllButton.setIcon(Tools.getResIcon32("/icons/simulationKnockout/saveIcon.png"));
        this.saveAllButton.setToolTipText(lang.getText("HSKwin_entry041t"));
        this.saveAllButton.addActionListener(actionEvent -> this.action.saveDataSets());
        result.add(this.saveAllButton);
        JButton showVisualsButton = new JButton(lang.getText("HSKwin_entry042"));
        showVisualsButton.setBounds(posXda + 280, posYda, 130, 40);
        showVisualsButton.setMargin(new Insets(0, 0, 0, 0));
        showVisualsButton.setFocusPainted(false);
        showVisualsButton.setToolTipText(lang.getText("HSKwin_entry042t"));
        showVisualsButton.setIcon(Tools.getResIcon32("/icons/simulationKnockout/showIcon.png"));
        showVisualsButton.addActionListener(actionEvent -> new HolmesSimKnockVis(this.mainSimWindow.returnFrame()));
        result.add(showVisualsButton);
        this.simSettingsButton = new JButton(lang.getText("HSKwin_entry043"));
        this.simSettingsButton.setBounds(posXda, posYda + 45, 130, 40);
        this.simSettingsButton.setMargin(new Insets(0, 0, 0, 0));
        this.simSettingsButton.setFocusPainted(false);
        this.simSettingsButton.setIcon(Tools.getResIcon32("/icons/simSettings/setupIcon.png"));
        this.simSettingsButton.setToolTipText(lang.getText("HSKwin_entry043t"));
        this.simSettingsButton.addActionListener(actionEvent -> new HolmesSimSetup(this.mainSimWindow.getFrame()));
        result.add(this.simSettingsButton);
        this.stateManagerButton = new JButton();
        this.stateManagerButton.setText(lang.getText("HSKwin_entry044"));
        this.stateManagerButton.setIcon(Tools.getResIcon32("/icons/stateManager/stManIcon.png"));
        this.stateManagerButton.setBounds(posXda + 140, posYda + 45, 130, 40);
        this.stateManagerButton.setMargin(new Insets(0, 0, 0, 0));
        this.stateManagerButton.setToolTipText(lang.getText("HSKwin_entry044t"));
        this.stateManagerButton.setFocusPainted(false);
        this.stateManagerButton.addActionListener(actionEvent -> new HolmesStatesManager());
        this.stateManagerButton.setFocusPainted(false);
        result.add(this.stateManagerButton);
        JLabel stateLabel0 = new JLabel(lang.getText("HSKwin_entry045"));
        stateLabel0.setBounds(posXda + 280, posYda + 45, 220, 20);
        result.add(stateLabel0);
        int selState = HolmesSimKnock.overlord.getWorkspace().getProject().accessStatesManager().selectedStatePN;
        this.selStateLabel = new JLabel("" + selState);
        this.selStateLabel.setBounds(posXda + 510, posYda + 45, 60, 20);
        result.add(this.selStateLabel);
        this.selStateDescrLabel = new JLabel(overlord.getWorkspace().getProject().accessStatesManager().getStateDescriptionPN(selState));
        this.selStateDescrLabel.setBounds(posXda + 280, posYda + 65, 650, 20);
        result.add(this.selStateDescrLabel);
        return result;
    }

    public void setSimWindowComponentsStatus(boolean state) {
        this.acqRefDataButton.setEnabled(state);
        this.acqDataSimButton.setEnabled(state);
        this.simSettingsButton.setEnabled(state);
        this.stateManagerButton.setEnabled(state);
        this.loadAllButton.setEnabled(state);
        this.saveAllButton.setEnabled(state);
        this.mainSimWindow.mainTabPanel.setEnabledAt(0, state);
        overlord.getFrame().setEnabled(state);
    }

    public void resetWindow() {
        this.mainSimWindow.doNotUpdate = true;
        this.refProgressBarKnockout.setValue(0);
        this.mainSimWindow.doNotUpdate = false;
    }

    public void updateFreshKnockoutTab() {
        PetriNet pn = overlord.getWorkspace().getProject();
        int sel = pn.accessStatesManager().selectedStatePN;
        this.selStateLabel.setText("" + sel);
        this.selStateDescrLabel.setText(pn.accessStatesManager().getStateDescriptionPN(sel));
        ArrayList<NetSimulationData> references = pn.accessSimKnockoutData().accessReferenceSets();
        int refSize = references.size();
        this.mainSimWindow.doNotUpdate = true;
        int oldSelected = this.referencesCombo.getSelectedIndex();
        this.referencesCombo.removeAllItems();
        this.referencesCombo.addItem(" ----- ");
        if (refSize > 0) {
            for (int r = 0; r < refSize; ++r) {
                String strB = "err.";
                try {
                    strB = String.format(lang.getText("HSKwin_entry046"), new Object[]{r, references.get((int)r).date, references.get((int)r).netSimType, references.get((int)r).maxMode});
                }
                catch (Exception e) {
                    overlord.log(lang.getText("LOGentryLNGexc") + " HSKwin_entry046", "error", true);
                }
                this.referencesCombo.addItem(strB);
            }
            this.refLabelDate.setText("---");
            this.refLabelSimNetMode.setText("---");
            this.refLabelMaxMode.setText("---");
            this.refLabelSteps.setText("---");
            this.refLabelReps.setText("---");
            if (oldSelected < this.referencesCombo.getItemCount()) {
                this.referencesCombo.setSelectedIndex(oldSelected);
            } else {
                this.referencesCombo.setSelectedIndex(0);
            }
        }
        ArrayList<NetSimulationData> knockout = pn.accessSimKnockoutData().accessKnockoutDataSets();
        int knockSize = knockout.size();
        this.mainSimWindow.doNotUpdate = true;
        int oldKnockSelected = this.dataCombo.getSelectedIndex();
        this.dataCombo.removeAllItems();
        this.dataCombo.addItem(" ----- ");
        if (knockSize > 0) {
            for (int r = 0; r < knockSize; ++r) {
                StringBuilder disTxt = new StringBuilder(lang.getText("HSKwin_entry047"));
                for (int t : knockout.get((int)r).disabledTransitionsIDs) {
                    disTxt.append("t").append(t).append(", ");
                }
                for (int t : knockout.get((int)r).disabledMCTids) {
                    disTxt.append("MCT").append(t + 1).append(", ");
                }
                disTxt = new StringBuilder(disTxt.toString().replace(", ", " "));
                String strB = "err.";
                try {
                    strB = String.format(lang.getText("HSKwin_entry048"), new Object[]{r, disTxt, knockout.get((int)r).netSimType, knockout.get((int)r).maxMode});
                }
                catch (Exception e) {
                    overlord.log(lang.getText("LOGentryLNGexc") + " HSKwin_entry048", "error", true);
                }
                this.dataCombo.addItem(strB);
            }
            this.dataLabelDate.setText("---");
            this.dataLabelSimNetMode.setText("---");
            this.dataLabelMaxMode.setText("---");
            this.dataLabelSteps.setText("---");
            this.dataLabelReps.setText("---");
            if (oldKnockSelected < this.dataCombo.getItemCount()) {
                this.dataCombo.setSelectedIndex(oldKnockSelected);
            } else {
                this.dataCombo.setSelectedIndex(0);
            }
        }
        ArrayList<Transition> transitions = pn.getTransitions();
        int oldTsel = this.dataTransitionsCombo.getSelectedIndex();
        int oldTsize = this.dataTransitionsCombo.getItemCount() - 1;
        this.dataTransitionsCombo.removeAllItems();
        this.dataTransitionsCombo.addItem("---");
        if (!transitions.isEmpty()) {
            for (int t = 0; t < transitions.size(); ++t) {
                this.dataTransitionsCombo.addItem("t" + t + "." + transitions.get(t).getName());
            }
            if (this.dataTransitionsCombo.getItemCount() > oldTsel && oldTsize == transitions.size()) {
                this.dataTransitionsCombo.setSelectedIndex(oldTsel);
            }
            int oldMsel = this.dataMctCombo.getSelectedIndex();
            this.dataMctCombo.removeAllItems();
            this.dataMctCombo.addItem("---");
            ArrayList<ArrayList<Transition>> mcts = pn.getMCTMatrix();
            ArrayList<String> mctNames = pn.accessMCTnames();
            if (mcts != null && !mcts.isEmpty()) {
                for (int m = 0; m < mcts.size(); ++m) {
                    this.dataMctCombo.addItem("MCT" + (m + 1) + ": " + mctNames.get(m));
                }
            }
            if (this.dataMctCombo.getItemCount() > oldMsel) {
                this.dataMctCombo.setSelectedIndex(oldMsel);
            }
        }
        this.mainSimWindow.doNotUpdate = false;
    }

    public void updateRefDetails(int selected) {
        PetriNet pn = overlord.getWorkspace().getProject();
        ArrayList<NetSimulationData> references = pn.accessSimKnockoutData().accessReferenceSets();
        NetSimulationData selectedRef = references.get(selected);
        this.refLabelDate.setText(selectedRef.date);
        this.refLabelSimNetMode.setText(selectedRef.netSimType.toString());
        if (selectedRef.maxMode) {
            this.refLabelMaxMode.setText(lang.getText("HSKwin_entry049"));
        } else {
            this.refLabelMaxMode.setText(lang.getText("HSKwin_entry050"));
        }
        this.refLabelSteps.setText("" + selectedRef.steps);
        this.refLabelReps.setText("" + selectedRef.reps);
    }

    public void updateDataDetails(int selected) {
        PetriNet pn = overlord.getWorkspace().getProject();
        ArrayList<NetSimulationData> data = pn.accessSimKnockoutData().accessKnockoutDataSets();
        NetSimulationData selectedData = data.get(selected);
        this.dataLabelDate.setText(selectedData.date);
        this.dataLabelSimNetMode.setText(selectedData.netSimType.toString());
        if (selectedData.maxMode) {
            this.dataLabelMaxMode.setText(lang.getText("HSKwin_entry049"));
        } else {
            this.dataLabelMaxMode.setText(lang.getText("HSKwin_entry050"));
        }
        this.dataLabelSteps.setText("" + selectedData.steps);
        this.dataLabelReps.setText("" + selectedData.reps);
        StringBuilder disTxt = new StringBuilder();
        for (int t : selectedData.disabledTransitionsIDs) {
            disTxt.append("t").append(t).append(", ");
        }
        for (int t : selectedData.disabledMCTids) {
            disTxt.append("MCT").append(t + 1).append(", ");
        }
        disTxt = new StringBuilder(disTxt.toString().replace(", ", " "));
        this.dataLabelDisabled.setText(disTxt.toString());
    }
}

