/*
 * Decompiled with CFR 0.152.
 */
package holmes.windows.managers;

import holmes.darkgui.GUIController;
import holmes.darkgui.GUIManager;
import holmes.darkgui.LanguageManager;
import holmes.darkgui.holmesInterface.HolmesRoundedButton;
import holmes.petrinet.data.MultisetM;
import holmes.petrinet.data.P_StateManager;
import holmes.petrinet.data.PetriNet;
import holmes.petrinet.data.StatePlacesVector;
import holmes.petrinet.elements.Place;
import holmes.tables.RXTable;
import holmes.tables.managers.StatesPlacesTableModel;
import holmes.tables.managers.StatesPlacesTableModelXTPN;
import holmes.tables.managers.StatesPlacesTableRenderer;
import holmes.tables.managers.StatesPlacesTableRendererXTPN;
import holmes.utilities.Tools;
import holmes.windows.managers.HolmesStatesEditor;
import holmes.windows.xtpn.managers.HolmesStatesEditorXTPN;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.plaf.basic.BasicTabbedPaneUI;

public class HolmesStatesManager
extends JFrame {
    private static final long serialVersionUID = -4590055483268695118L;
    private final JFrame ego;
    private static final GUIManager overlord = GUIManager.getDefaultGUIManager();
    private static final LanguageManager lang = GUIManager.getLanguageManager();
    private StatesPlacesTableModel tableModelPN;
    private StatesPlacesTableModelXTPN tableModelXTPN;
    private JTable statesTablePN;
    private JTable statesTableXTPN;
    private JTextArea stateDescrTextAreaPN;
    private JTextArea stateDescrTextAreaXTPN;
    private final ArrayList<Place> places;
    private final PetriNet pn;
    private final P_StateManager statesManager;
    private int selectedRow;
    private final int cellWidth;

    public HolmesStatesManager() {
        this.setTitle(lang.getText("HSMwin_entry001title"));
        try {
            this.setIconImage(Tools.getImageFromIcon("/icons/holmesicon.png"));
        }
        catch (Exception ex) {
            overlord.log(lang.getText("LOGentry00530exception") + "\n" + ex.getMessage(), "error", true);
        }
        this.ego = this;
        this.pn = overlord.getWorkspace().getProject();
        this.places = this.pn.getPlaces();
        this.statesManager = this.pn.accessStatesManager();
        this.selectedRow = 0;
        this.cellWidth = 50;
        this.initalizeComponents();
        this.initiateListeners();
        overlord.getFrame().setEnabled(false);
        this.fillTable();
        this.fillTableXTPN();
        this.statesTableXTPN.setRowSelectionInterval(0, 0);
        this.setVisible(true);
    }

    private void initalizeComponents() {
        this.setLayout(new BorderLayout());
        this.setSize(new Dimension(900, 660));
        this.setLocation(50, 50);
        this.setResizable(true);
        this.setLayout(new BorderLayout());
        JPanel main = new JPanel(new BorderLayout());
        JPanel submain = new JPanel(new BorderLayout());
        JPanel tablePanelPN = this.getMainTablePanel();
        submain.add((Component)tablePanelPN, "Center");
        submain.add((Component)this.getBottomPanel(), "South");
        main.add((Component)submain, "Center");
        main.add((Component)this.getButtonsPanel(), "East");
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.setUI(new BasicTabbedPaneUI(){

            @Override
            protected int calculateTabHeight(int tabPlacement, int tabIndex, int fontHeight) {
                return 32;
            }

            @Override
            protected void paintTab(Graphics g, int tabPlacement, Rectangle[] rects, int tabIndex, Rectangle iconRect, Rectangle textRect) {
                super.paintTab(g, tabPlacement, rects, tabIndex, iconRect, textRect);
            }
        });
        tabbedPane.addTab(lang.getText("HSMwin_entry002"), Tools.getResIcon22("/icons/stateManager/PNtab.png"), main, lang.getText("HSMwin_entry002t"));
        tabbedPane.setMnemonicAt(0, 49);
        JPanel mainXTPN = new JPanel(new BorderLayout());
        JPanel submainXTPN = new JPanel(new BorderLayout());
        JPanel tablePanelXTPN = this.getMainTablePanelXTPN();
        submainXTPN.add((Component)tablePanelXTPN, "Center");
        submainXTPN.add((Component)this.getBottomPanelXTPN(), "South");
        mainXTPN.add((Component)submainXTPN, "Center");
        mainXTPN.add((Component)this.getButtonsPanelXTPN(), "East");
        tabbedPane.addTab(lang.getText("HSMwin_entry003"), Tools.getResIcon22("/icons/stateManager/XTPNtab.png"), mainXTPN, lang.getText("HSMwin_entry003t"));
        tabbedPane.setMnemonicAt(1, 50);
        this.add((Component)tabbedPane, "Center");
        tabbedPane.addChangeListener(e -> {
            int selected = ((JTabbedPane)e.getSource()).getSelectedIndex();
            if (selected == 1 && GUIController.access().getCurrentNetType() != PetriNet.GlobalNetType.XTPN) {
                JOptionPane.showMessageDialog(null, lang.getText("HSMwin_entry004"), lang.getText("problem"), 1);
                ((JTabbedPane)e.getSource()).setSelectedIndex(0);
            } else if (selected == 0 && GUIController.access().getCurrentNetType() == PetriNet.GlobalNetType.XTPN) {
                JOptionPane.showMessageDialog(null, lang.getText("HSMwin_entry005"), lang.getText("problem"), 1);
                ((JTabbedPane)e.getSource()).setSelectedIndex(1);
            }
        });
        if (GUIController.access().getCurrentNetType() == PetriNet.GlobalNetType.XTPN) {
            tabbedPane.setSelectedIndex(1);
        }
    }

    public JPanel getMainTablePanel() {
        JPanel result = new JPanel(new BorderLayout());
        result.setLocation(0, 0);
        result.setBorder(BorderFactory.createTitledBorder(lang.getText("HSMwin_entry006")));
        result.setPreferredSize(new Dimension(500, 500));
        this.tableModelPN = new StatesPlacesTableModel(this.places.size(), this);
        this.statesTablePN = new RXTable(this.tableModelPN);
        ((RXTable)this.statesTablePN).setSelectAllForEdit(true);
        this.statesTablePN.getColumnModel().getColumn(0).setHeaderValue("Sel:");
        this.statesTablePN.getColumnModel().getColumn(0).setPreferredWidth(30);
        this.statesTablePN.getColumnModel().getColumn(0).setMinWidth(30);
        this.statesTablePN.getColumnModel().getColumn(0).setMaxWidth(30);
        this.statesTablePN.getColumnModel().getColumn(1).setHeaderValue("State ID");
        this.statesTablePN.getColumnModel().getColumn(1).setPreferredWidth(50);
        this.statesTablePN.getColumnModel().getColumn(1).setMinWidth(50);
        this.statesTablePN.getColumnModel().getColumn(1).setMaxWidth(50);
        for (int i = 0; i < this.places.size(); ++i) {
            this.statesTablePN.getColumnModel().getColumn(i + 2).setHeaderValue("p" + i);
            this.statesTablePN.getColumnModel().getColumn(i + 2).setPreferredWidth(this.cellWidth);
            this.statesTablePN.getColumnModel().getColumn(i + 2).setMinWidth(this.cellWidth);
            this.statesTablePN.getColumnModel().getColumn(i + 2).setMaxWidth(this.cellWidth);
        }
        this.statesTablePN.setName("StatesTable");
        this.statesTablePN.setFillsViewportHeight(true);
        StatesPlacesTableRenderer tableRendererPN = new StatesPlacesTableRenderer(this.statesTablePN);
        this.statesTablePN.setDefaultRenderer(Object.class, tableRendererPN);
        this.statesTablePN.setDefaultRenderer(Double.class, tableRendererPN);
        this.statesTablePN.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 1 && !e.isControlDown()) {
                    HolmesStatesManager.this.cellClickAction();
                }
            }
        });
        this.statesTablePN.setRowSelectionAllowed(false);
        this.statesTablePN.setAutoResizeMode(0);
        JScrollPane tableScrollPane = new JScrollPane(this.statesTablePN, 20, 30);
        result.add((Component)tableScrollPane, "Center");
        return result;
    }

    public JPanel getButtonsPanel() {
        JPanel result = new JPanel(null);
        result.setBorder(BorderFactory.createTitledBorder(lang.getText("HSMwin_entry007")));
        result.setPreferredSize(new Dimension(150, 500));
        int posXda = 10;
        int posYda = 25;
        JButton selectStateButton = new JButton(lang.getText("HSMwin_entry008"));
        selectStateButton.setBounds(posXda, posYda, 130, 50);
        selectStateButton.setMargin(new Insets(0, 0, 0, 0));
        selectStateButton.setFocusPainted(false);
        selectStateButton.setToolTipText(lang.getText("HSMwin_entry008t"));
        selectStateButton.setIcon(Tools.getResIcon16("/icons/stateManager/selectStateIcon.png"));
        selectStateButton.addActionListener(actionEvent -> {
            if (this.places.isEmpty()) {
                this.noNetInfo();
                return;
            }
            int selected = this.statesTablePN.getSelectedRow();
            if (selected == -1) {
                JOptionPane.showMessageDialog(null, lang.getText("HSMwin_entry009"), lang.getText("problem"), 1);
            }
            Object[] options = new Object[]{lang.getText("HSMwin_entry010op1"), lang.getText("HSMwin_entry010op2")};
            String strB = "err.";
            try {
                strB = String.format(lang.getText("HSMwin_entry010"), selected + 1);
            }
            catch (Exception e) {
                overlord.log(lang.getText("LOGentryLNGexc") + " HSMwin_entry010", "error", true);
            }
            int n = JOptionPane.showOptionDialog(null, strB, lang.getText("HSMwin_entry010t"), 0, 3, null, options, options[1]);
            if (n == 0) {
                this.tableModelPN.setSelected(selected);
                this.statesManager.setNetworkStatePN(selected);
                this.pn.repaintAllGraphPanels();
                this.tableModelPN.fireTableDataChanged();
                overlord.markNetChange();
            }
        });
        result.add(selectStateButton);
        JButton addNewStateButton = new JButton(lang.getText("HSMwin_entry011"));
        addNewStateButton.setBounds(posXda, posYda += 60, 130, 50);
        addNewStateButton.setMargin(new Insets(0, 0, 0, 0));
        addNewStateButton.setFocusPainted(false);
        addNewStateButton.setToolTipText(lang.getText("HSMwin_entry011t"));
        addNewStateButton.setIcon(Tools.getResIcon16("/icons/stateManager/addStateIcon.png"));
        addNewStateButton.addActionListener(actionEvent -> {
            if (this.places.isEmpty()) {
                this.noNetInfo();
                return;
            }
            Object[] options = new Object[]{lang.getText("HSMwin_entry012op1"), lang.getText("HSMwin_entry012op2")};
            int n = JOptionPane.showOptionDialog(null, lang.getText("HSMwin_entry012"), lang.getText("HSMwin_entry012t"), 0, 3, null, options, options[1]);
            if (n == 0) {
                this.statesManager.addCurrentStatePN();
                this.addLastStateToTable();
                this.tableModelPN.fireTableDataChanged();
            }
        });
        result.add(addNewStateButton);
        JButton addNewCleanStateButton = new JButton(lang.getText("HSMwin_entry013"));
        addNewCleanStateButton.setBounds(posXda, posYda += 60, 130, 50);
        addNewCleanStateButton.setMargin(new Insets(0, 0, 0, 0));
        addNewCleanStateButton.setFocusPainted(false);
        addNewCleanStateButton.setToolTipText(lang.getText("HSMwin_entry013t"));
        addNewCleanStateButton.setIcon(Tools.getResIcon16("/icons/stateManager/addCleanState.png"));
        addNewCleanStateButton.addActionListener(actionEvent -> {
            if (this.places.isEmpty()) {
                this.noNetInfo();
                return;
            }
            Object[] options = new Object[]{lang.getText("HSMwin_entry014op1"), lang.getText("HSMwin_entry014op2")};
            int n = JOptionPane.showOptionDialog(null, lang.getText("HSMwin_entry014"), lang.getText("HSMwin_entry014t"), 0, 3, null, options, options[1]);
            if (n == 0) {
                this.statesManager.addNewCleanStatePN();
                this.addLastStateToTable();
                this.tableModelPN.fireTableDataChanged();
            }
        });
        result.add(addNewCleanStateButton);
        JButton replaceStateButton = new JButton(lang.getText("HSMwin_entry015"));
        replaceStateButton.setBounds(posXda, posYda += 60, 130, 50);
        replaceStateButton.setMargin(new Insets(0, 0, 0, 0));
        replaceStateButton.setFocusPainted(false);
        replaceStateButton.setToolTipText(lang.getText("HSMwin_entry015t"));
        replaceStateButton.setIcon(Tools.getResIcon16("/icons/stateManager/replaceStateIcon.png"));
        replaceStateButton.addActionListener(actionEvent -> {
            if (this.places.isEmpty()) {
                this.noNetInfo();
                return;
            }
            int selected = this.statesTablePN.getSelectedRow();
            if (selected == -1) {
                JOptionPane.showMessageDialog(null, lang.getText("HSMwin_entry016"), lang.getText("problem"), 1);
            }
            this.replaceStateAction();
        });
        result.add(replaceStateButton);
        JButton removeStateButton = new JButton(lang.getText("HSMwin_entry017"));
        removeStateButton.setBounds(posXda, posYda += 60, 130, 50);
        removeStateButton.setMargin(new Insets(0, 0, 0, 0));
        removeStateButton.setFocusPainted(false);
        removeStateButton.setToolTipText(lang.getText("HSMwin_entry017t"));
        removeStateButton.setIcon(Tools.getResIcon16("/icons/stateManager/removeStateIcon.png"));
        removeStateButton.addActionListener(actionEvent -> {
            if (this.places.isEmpty()) {
                this.noNetInfo();
                return;
            }
            int selected = this.statesTablePN.getSelectedRow();
            if (selected == -1) {
                JOptionPane.showMessageDialog(null, lang.getText("HSMwin_entry018"), lang.getText("problem"), 1);
            }
            this.removeStateAction();
        });
        result.add(removeStateButton);
        JButton editStateButton = new JButton(lang.getText("HSMwin_entry019"));
        editStateButton.setBounds(posXda, posYda += 60, 130, 50);
        editStateButton.setMargin(new Insets(0, 0, 0, 0));
        editStateButton.setFocusPainted(false);
        editStateButton.setIcon(Tools.getResIcon32("/icons/stateManager/stateEdit.png"));
        editStateButton.addActionListener(actionEvent -> {
            if (this.places.isEmpty()) {
                this.noNetInfo();
                return;
            }
            int selected = this.statesTablePN.getSelectedRow();
            if (selected > -1) {
                new HolmesStatesEditor((HolmesStatesManager)this.ego, this.statesManager.getStatePN(selected), selected);
            } else {
                JOptionPane.showMessageDialog(null, lang.getText("HSMwin_entry020"), lang.getText("problem"), 1);
            }
        });
        result.add(editStateButton);
        return result;
    }

    private void noNetInfo() {
        JOptionPane.showMessageDialog(this, lang.getText("HSMwin_entry021"), lang.getText("problem"), 2);
    }

    private void removeStateAction() {
        int selected = this.statesTablePN.getSelectedRow();
        int states = this.statesManager.accessStateMatrix().size();
        if (states == 1) {
            JOptionPane.showMessageDialog(null, lang.getText("HSMwin_entry022"), lang.getText("warning"), 2);
            return;
        }
        Object[] options = new Object[]{lang.getText("HSMwin_entry023op1"), lang.getText("HSMwin_entry023op2")};
        String strB = "err.";
        try {
            strB = String.format(lang.getText("HSMwin_entry023"), selected + 1);
        }
        catch (Exception e) {
            overlord.log(lang.getText("LOGentryLNGexc") + " HSMwin_entry023", "error", true);
        }
        int n = JOptionPane.showOptionDialog(null, strB, lang.getText("HSMwin_entry023t"), 0, 3, null, options, options[1]);
        if (n == 1) {
            return;
        }
        this.statesManager.removeStatePN(selected);
        this.fillTable();
        overlord.markNetChange();
    }

    private void replaceStateAction() {
        int selected = this.statesTablePN.getSelectedRow();
        Object[] options = new Object[]{lang.getText("HSMwin_entry024op1"), lang.getText("HSMwin_entry024op2")};
        String strB = "err.";
        try {
            strB = String.format(lang.getText("HSMwin_entry024"), selected + 1);
        }
        catch (Exception e) {
            overlord.log(lang.getText("LOGentryLNGexc") + " HSMwin_entry024", "error", true);
        }
        int n = JOptionPane.showOptionDialog(null, strB, lang.getText("HSMwin_entry024t"), 0, 3, null, options, options[1]);
        if (n == 1) {
            return;
        }
        this.statesManager.replaceStoredStateWithNetStatePN(selected);
        this.fillTable();
        overlord.markNetChange();
    }

    public void changeTableCell(int index, int placeID, double newValue, boolean update) {
        this.tableModelPN.setQuietlyValueAt(newValue, index, placeID);
        if (update) {
            this.tableModelPN.fireTableDataChanged();
        }
    }

    private void addLastStateToTable() {
        int states = this.statesManager.accessStateMatrix().size();
        StatePlacesVector psVector = this.statesManager.getStatePN(states - 1);
        ArrayList<String> rowVector = new ArrayList<String>();
        rowVector.add("");
        rowVector.add("m0(" + states + ")");
        for (int p = 0; p < psVector.getSize(); ++p) {
            rowVector.add("" + psVector.getTokens(p));
        }
        this.tableModelPN.addNew(rowVector);
        overlord.markNetChange();
    }

    private void fillTable() {
        this.tableModelPN.clearModel(this.places.size());
        for (int row = 0; row < this.statesManager.accessStateMatrix().size(); ++row) {
            ArrayList<String> rowVector = new ArrayList<String>();
            if (this.statesManager.selectedStatePN == row) {
                rowVector.add("X");
            } else {
                rowVector.add("");
            }
            StatePlacesVector psVector = this.statesManager.getStatePN(row);
            rowVector.add("m0(" + (row + 1) + ")");
            for (int p = 0; p < psVector.getSize(); ++p) {
                rowVector.add("" + psVector.getTokens(p));
            }
            this.tableModelPN.addNew(rowVector);
        }
        this.tableModelPN.fireTableDataChanged();
    }

    public JPanel getBottomPanel() {
        JPanel result = new JPanel(new BorderLayout());
        result.setBorder(BorderFactory.createTitledBorder(lang.getText("HSMwin_entry025")));
        result.setPreferredSize(new Dimension(900, 150));
        int posXda = 10;
        int posYda = 15;
        this.stateDescrTextAreaPN = new JTextArea();
        this.stateDescrTextAreaPN.setLineWrap(true);
        this.stateDescrTextAreaPN.setEditable(true);
        this.stateDescrTextAreaPN.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                JTextArea field = (JTextArea)e.getSource();
                if (field != null) {
                    String newComment = field.getText();
                    HolmesStatesManager.this.statesManager.setStateDescriptionPN(HolmesStatesManager.this.selectedRow, newComment);
                }
            }
        });
        JPanel CreationPanel = new JPanel();
        CreationPanel.setLayout(new BorderLayout());
        CreationPanel.add((Component)new JScrollPane(this.stateDescrTextAreaPN), "Center");
        CreationPanel.setBounds(posXda, posYda + 25, 600, 100);
        result.add((Component)CreationPanel, "Center");
        return result;
    }

    public void changeState(int row, int column, double value) {
        this.statesManager.getStatePN(row).accessVector().set(column - 2, value);
        overlord.markNetChange();
        this.tableModelPN.fireTableDataChanged();
    }

    public void fillDescriptionField() {
        String description = this.statesManager.getStateDescriptionPN(this.selectedRow);
        this.stateDescrTextAreaPN.setText(description);
    }

    protected void cellClickAction() {
        try {
            this.selectedRow = this.statesTablePN.getSelectedRow();
            this.fillDescriptionField();
        }
        catch (Exception ex) {
            overlord.log(lang.getText("LOGentry00531exception") + "\n" + ex.getMessage(), "error", true);
        }
    }

    public JPanel getMainTablePanelXTPN() {
        JPanel result = new JPanel(new BorderLayout());
        result.setLocation(0, 0);
        result.setBorder(BorderFactory.createTitledBorder(lang.getText("HSMwin_entry026title")));
        result.setPreferredSize(new Dimension(500, 500));
        this.tableModelXTPN = new StatesPlacesTableModelXTPN(this.places.size(), this);
        this.statesTableXTPN = new RXTable(this.tableModelXTPN);
        ((RXTable)this.statesTableXTPN).setSelectAllForEdit(true);
        this.statesTableXTPN.getColumnModel().getColumn(0).setHeaderValue("Sel:");
        this.statesTableXTPN.getColumnModel().getColumn(0).setPreferredWidth(30);
        this.statesTableXTPN.getColumnModel().getColumn(0).setMinWidth(30);
        this.statesTableXTPN.getColumnModel().getColumn(0).setMaxWidth(30);
        this.statesTableXTPN.getColumnModel().getColumn(1).setHeaderValue("State ID");
        this.statesTableXTPN.getColumnModel().getColumn(1).setPreferredWidth(50);
        this.statesTableXTPN.getColumnModel().getColumn(1).setMinWidth(50);
        this.statesTableXTPN.getColumnModel().getColumn(1).setMaxWidth(50);
        for (int i = 0; i < this.places.size(); ++i) {
            this.statesTableXTPN.getColumnModel().getColumn(i + 2).setHeaderValue("p" + i);
            this.statesTableXTPN.getColumnModel().getColumn(i + 2).setPreferredWidth(this.cellWidth);
            this.statesTableXTPN.getColumnModel().getColumn(i + 2).setMinWidth(this.cellWidth);
            this.statesTableXTPN.getColumnModel().getColumn(i + 2).setMaxWidth(this.cellWidth);
        }
        this.statesTableXTPN.setName("XTPNStatesTable");
        this.statesTableXTPN.setFillsViewportHeight(true);
        StatesPlacesTableRendererXTPN tableRendererXTPN = new StatesPlacesTableRendererXTPN(this.statesTableXTPN);
        this.statesTableXTPN.setDefaultRenderer(Object.class, tableRendererXTPN);
        this.statesTableXTPN.setDefaultRenderer(Double.class, tableRendererXTPN);
        this.statesTableXTPN.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 1 && !e.isControlDown()) {
                    HolmesStatesManager.this.cellClickActionXTPN();
                }
            }
        });
        this.statesTableXTPN.setRowSelectionAllowed(false);
        this.statesTableXTPN.setAutoResizeMode(0);
        JScrollPane tableScrollPane = new JScrollPane(this.statesTableXTPN, 20, 30);
        result.add((Component)tableScrollPane, "Center");
        return result;
    }

    public JPanel getButtonsPanelXTPN() {
        JPanel result = new JPanel(null);
        result.setBorder(BorderFactory.createTitledBorder(lang.getText("HSMwin_entry027")));
        result.setPreferredSize(new Dimension(150, 500));
        int posXda = 10;
        int posYda = 25;
        HolmesRoundedButton selectStateButton = new HolmesRoundedButton(lang.getText("HSMwin_entry028"), "pearl_bH1_neutr.png", "pearl_bH2_hover.png", "pearl_bH3_press.png");
        selectStateButton.setBounds(posXda, posYda, 130, 55);
        selectStateButton.setMargin(new Insets(0, 0, 0, 0));
        selectStateButton.setFocusPainted(false);
        selectStateButton.setToolTipText(lang.getText("HSMwin_entry028t"));
        selectStateButton.addActionListener(actionEvent -> {
            if (this.places.isEmpty()) {
                this.noNetInfoXTPN();
                return;
            }
            int selected = this.statesTableXTPN.getSelectedRow();
            if (selected == -1) {
                JOptionPane.showMessageDialog(null, lang.getText("HSMwin_entry029"), lang.getText("HSMwin_entry029t"), 1);
                return;
            }
            Object[] options = new Object[]{lang.getText("HSMwin_entry030op1"), lang.getText("HSMwin_entry030op2")};
            String strB = "err.";
            try {
                strB = String.format(lang.getText("HSMwin_entry030"), selected + 1);
            }
            catch (Exception e) {
                overlord.log(lang.getText("LOGentryLNGexc") + " HSMwin_entry030", "error", true);
            }
            int n = JOptionPane.showOptionDialog(null, strB, lang.getText("HSMwin_entry030t"), 0, 3, null, options, options[1]);
            if (n == 0) {
                this.tableModelXTPN.setSelected(selected);
                boolean status = this.statesManager.replaceNetStateWithSelectedMultiset_M(selected);
                if (status) {
                    this.pn.repaintAllGraphPanels();
                    this.tableModelXTPN.fireTableDataChanged();
                    overlord.markNetChange();
                } else {
                    JOptionPane.showMessageDialog(this, lang.getText("HSMwin_entry031"), lang.getText("error"), 0);
                }
            }
        });
        result.add(selectStateButton);
        HolmesRoundedButton addNewStateButton = new HolmesRoundedButton(lang.getText("HSMwin_entry032"), "pearl_bH1_neutr.png", "pearl_bH2_hover.png", "pearl_bH3_press.png");
        addNewStateButton.setBounds(posXda, posYda += 60, 130, 55);
        addNewStateButton.setMargin(new Insets(0, 0, 0, 0));
        addNewStateButton.setFocusPainted(false);
        addNewStateButton.setToolTipText(lang.getText("HSMwin_entry032t"));
        addNewStateButton.addActionListener(actionEvent -> {
            if (this.places.isEmpty()) {
                this.noNetInfoXTPN();
                return;
            }
            Object[] options = new Object[]{lang.getText("HSMwin_entry033op1"), lang.getText("HSMwin_entry033op2")};
            int n = JOptionPane.showOptionDialog(null, lang.getText("HSMwin_entry033"), lang.getText("HSMwin_entry033t"), 0, 3, null, options, options[1]);
            if (n == 0) {
                this.statesManager.createNewMultiset_M_basedOnNet();
                this.addLastStateToTableXTPN();
                this.tableModelXTPN.fireTableDataChanged();
            }
        });
        result.add(addNewStateButton);
        HolmesRoundedButton addNewCleanStateButton = new HolmesRoundedButton(lang.getText("HSMwin_entry034"), "pearl_bH1_neutr.png", "pearl_bH2_hover.png", "pearl_bH3_press.png");
        addNewCleanStateButton.setBounds(posXda, posYda += 60, 130, 55);
        addNewCleanStateButton.setMargin(new Insets(0, 0, 0, 0));
        addNewCleanStateButton.setFocusPainted(false);
        addNewCleanStateButton.setToolTipText(lang.getText("HSMwin_entry034t"));
        addNewCleanStateButton.addActionListener(actionEvent -> {
            if (this.places.isEmpty()) {
                this.noNetInfoXTPN();
                return;
            }
            Object[] options = new Object[]{lang.getText("HSMwin_entry035op1"), lang.getText("HSMwin_entry035op2")};
            int n = JOptionPane.showOptionDialog(null, lang.getText("HSMwin_entry035"), lang.getText("HSMwin_entry035t"), 0, 3, null, options, options[1]);
            if (n == 0) {
                this.statesManager.addNewCleanMultiset_M();
                this.addLastStateToTableXTPN();
                this.tableModelXTPN.fireTableDataChanged();
            }
        });
        result.add(addNewCleanStateButton);
        HolmesRoundedButton replaceStateButton = new HolmesRoundedButton(lang.getText("HSMwin_entry036"), "pearl_bH1_neutr.png", "pearl_bH2_hover.png", "pearl_bH3_press.png");
        replaceStateButton.setBounds(posXda, posYda += 60, 130, 55);
        replaceStateButton.setMargin(new Insets(0, 0, 0, 0));
        replaceStateButton.setFocusPainted(false);
        replaceStateButton.setToolTipText(lang.getText("HSMwin_entry036t"));
        replaceStateButton.addActionListener(actionEvent -> {
            if (this.places.isEmpty()) {
                this.noNetInfoXTPN();
                return;
            }
            int selected = this.statesTableXTPN.getSelectedRow();
            if (selected == -1) {
                JOptionPane.showMessageDialog(null, lang.getText("HSMwin_entry037"), lang.getText("problem"), 1);
            } else {
                this.replaceStateActionXTPN();
            }
        });
        result.add(replaceStateButton);
        HolmesRoundedButton removeStateButton = new HolmesRoundedButton(lang.getText("HSMwin_entry038"), "pearl_bH1_neutr.png", "pearl_bH2_hover.png", "pearl_bH3_press.png");
        removeStateButton.setBounds(posXda, posYda += 60, 130, 55);
        removeStateButton.setMargin(new Insets(0, 0, 0, 0));
        removeStateButton.setFocusPainted(false);
        removeStateButton.setToolTipText(lang.getText("HSMwin_entry038t"));
        removeStateButton.addActionListener(actionEvent -> {
            if (this.places.isEmpty()) {
                this.noNetInfoXTPN();
                return;
            }
            int selected = this.statesTableXTPN.getSelectedRow();
            if (selected == -1) {
                JOptionPane.showMessageDialog(null, lang.getText("HSMwin_entry039"), lang.getText("problem"), 1);
            } else {
                this.removeStateActionXTPN();
            }
        });
        result.add(removeStateButton);
        HolmesRoundedButton editStateButton = new HolmesRoundedButton(lang.getText("HSMwin_entry040"), "pearl_bH1_neutr.png", "pearl_bH2_hover.png", "pearl_bH3_press.png");
        editStateButton.setBounds(posXda, posYda + 60, 130, 55);
        editStateButton.setMargin(new Insets(0, 0, 0, 0));
        editStateButton.setFocusPainted(false);
        editStateButton.setToolTipText(lang.getText("HSMwin_entry041"));
        editStateButton.addActionListener(actionEvent -> {
            if (this.places.isEmpty()) {
                this.noNetInfoXTPN();
                return;
            }
            int selected = this.statesTableXTPN.getSelectedRow();
            if (selected > -1) {
                new HolmesStatesEditorXTPN((HolmesStatesManager)this.ego, this.statesManager.getMultiset_M(selected), selected);
            } else {
                JOptionPane.showMessageDialog(this.ego, lang.getText("HSMwin_entry042"), lang.getText("HSMwin_entry042t"), 2);
            }
        });
        result.add(editStateButton);
        return result;
    }

    private void noNetInfoXTPN() {
        JOptionPane.showMessageDialog(this, lang.getText("HSMwin_entry043"), lang.getText("error"), 0);
    }

    private void removeStateActionXTPN() {
        int selected = this.statesTableXTPN.getSelectedRow();
        int states = this.statesManager.accessStateMatrixXTPN().size();
        if (states == 1) {
            JOptionPane.showMessageDialog(null, lang.getText("HSMwin_entry044"), lang.getText("warning"), 2);
            return;
        }
        Object[] options = new Object[]{lang.getText("HSMwin_entry045op1"), lang.getText("HSMwin_entry045op2")};
        String strB = "err.";
        try {
            strB = String.format(lang.getText("HSMwin_entry045"), selected + 1);
        }
        catch (Exception e) {
            overlord.log(lang.getText("LOGentryLNGexc") + " HSMwin_entry045", "error", true);
        }
        int n = JOptionPane.showOptionDialog(null, strB, lang.getText("HSMwin_entry045t"), 0, 3, null, options, options[1]);
        if (n == 1) {
            return;
        }
        this.statesManager.removeMultiset_M(selected);
        this.fillTableXTPN();
        overlord.markNetChange();
    }

    private void replaceStateActionXTPN() {
        int selected = this.statesTableXTPN.getSelectedRow();
        if (selected == -1) {
            JOptionPane.showMessageDialog(null, lang.getText("HSMwin_entry046"), lang.getText("problem"), 1);
            return;
        }
        Object[] options = new Object[]{lang.getText("HSMwin_entry047op1"), lang.getText("HSMwin_entry047op2")};
        String strB = "err.";
        try {
            strB = String.format(lang.getText("HSMwin_entry047"), selected + 1);
        }
        catch (Exception e) {
            overlord.log(lang.getText("LOGentryLNGexc") + " HSMwin_entry047", "error", true);
        }
        int n = JOptionPane.showOptionDialog(null, strB, lang.getText("HSMwin_entry047t"), 0, 3, null, options, options[1]);
        if (n == 1) {
            return;
        }
        this.statesManager.replaceStoredMultiset_M_withCurrentNetState(selected);
        this.fillTableXTPN();
        overlord.markNetChange();
    }

    public void changeTableCellXTPN(int index, int placeID, double newValue, boolean update) {
        this.tableModelXTPN.setQuietlyValueAt(newValue, index, placeID);
        if (update) {
            this.tableModelXTPN.fireTableDataChanged();
        }
    }

    private void addLastStateToTableXTPN() {
        int states = this.statesManager.accessStateMatrixXTPN().size();
        MultisetM multisetM = this.statesManager.getMultiset_M(states - 1);
        ArrayList<String> rowVector = new ArrayList<String>();
        rowVector.add("");
        rowVector.add("m0(" + states + ")");
        for (int p = 0; p < multisetM.getMultiset_M_Size(); ++p) {
            if (multisetM.isPlaceStoredAsGammaActive(p)) {
                int value = multisetM.accessMultiset_K(p).size();
                rowVector.add("" + value);
                continue;
            }
            double value = multisetM.accessMultiset_K(p).get(0);
            rowVector.add((int)value + " (C)");
        }
        this.tableModelXTPN.addNew(rowVector);
        overlord.markNetChange();
    }

    private void fillTableXTPN() {
        this.tableModelXTPN.clearModel(this.places.size());
        for (int row = 0; row < this.statesManager.accessStateMatrixXTPN().size(); ++row) {
            ArrayList<String> rowVector = new ArrayList<String>();
            if (this.statesManager.selectedStateXTPN == row) {
                rowVector.add("X");
            } else {
                rowVector.add("");
            }
            MultisetM multisetM = this.statesManager.getMultiset_M(row);
            rowVector.add("m0(" + (row + 1) + ")");
            for (int placeIndex = 0; placeIndex < multisetM.getMultiset_M_Size(); ++placeIndex) {
                if (multisetM.isPlaceStoredAsGammaActive(placeIndex)) {
                    int value = multisetM.accessMultiset_K(placeIndex).size();
                    rowVector.add("" + value);
                    continue;
                }
                double value = multisetM.accessMultiset_K(placeIndex).get(0);
                rowVector.add((int)value + " (C)");
            }
            this.tableModelXTPN.addNew(rowVector);
        }
        this.tableModelXTPN.fireTableDataChanged();
    }

    public JPanel getBottomPanelXTPN() {
        JPanel result = new JPanel(new BorderLayout());
        result.setBorder(BorderFactory.createTitledBorder(lang.getText("HSMwin_entry048")));
        result.setPreferredSize(new Dimension(900, 150));
        int posXda = 10;
        int posYda = 15;
        this.stateDescrTextAreaXTPN = new JTextArea();
        this.stateDescrTextAreaXTPN.setLineWrap(true);
        this.stateDescrTextAreaXTPN.setEditable(true);
        this.stateDescrTextAreaXTPN.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                JTextArea field = (JTextArea)e.getSource();
                if (field != null) {
                    String newComment = field.getText();
                    HolmesStatesManager.this.statesManager.setMultiset_M_Description(HolmesStatesManager.this.selectedRow, newComment);
                }
            }
        });
        JPanel CreationPanel = new JPanel();
        CreationPanel.setLayout(new BorderLayout());
        CreationPanel.add((Component)new JScrollPane(this.stateDescrTextAreaXTPN), "Center");
        CreationPanel.setBounds(posXda, posYda + 25, 600, 100);
        result.add((Component)CreationPanel, "Center");
        return result;
    }

    public void changeStateXTPN(int row, int column, double value) {
        this.tableModelXTPN.fireTableDataChanged();
    }

    public void fillDescriptionFieldXTPN() {
        String description = this.statesManager.getMultiset_M_Description(this.selectedRow);
        this.stateDescrTextAreaXTPN.setText(description);
    }

    protected void cellClickActionXTPN() {
        try {
            this.selectedRow = this.statesTableXTPN.getSelectedRow();
            if (this.selectedRow > -1) {
                return;
            }
            this.fillDescriptionFieldXTPN();
        }
        catch (Exception ex) {
            overlord.log(lang.getText("LOGentry00532exception") + "\n" + ex.getMessage(), "error", true);
        }
    }

    private void initiateListeners() {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                overlord.getFrame().setEnabled(true);
            }
        });
    }
}

