/*
 * Decompiled with CFR 0.152.
 */
package holmes.windows.managers;

import holmes.darkgui.GUIManager;
import holmes.darkgui.LanguageManager;
import holmes.petrinet.data.P_StateManager;
import holmes.petrinet.data.PetriNet;
import holmes.petrinet.data.StatePlacesVector;
import holmes.petrinet.elements.Place;
import holmes.tables.RXTable;
import holmes.tables.managers.StatesPlacesEditorTableModel;
import holmes.utilities.Tools;
import holmes.windows.managers.HolmesStatesManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.SpinnerNumberModel;
import javax.swing.table.DefaultTableCellRenderer;

public class HolmesStatesEditor
extends JFrame {
    private static final long serialVersionUID = -2088768019289555918L;
    private static final GUIManager overlord = GUIManager.getDefaultGUIManager();
    private static final LanguageManager lang = GUIManager.getLanguageManager();
    private final HolmesStatesManager parentWindow;
    private StatesPlacesEditorTableModel tableModel;
    private final StatePlacesVector stateVector;
    private final int stateIndex;
    private final ArrayList<Place> places;
    private final P_StateManager statesManager;
    private long globalTokensNumber = 0L;

    public HolmesStatesEditor(HolmesStatesManager parent, StatePlacesVector stateVector, int stateIndex) {
        this.setTitle(lang.getText("HSEwin_entry001title"));
        try {
            this.setIconImage(Tools.getImageFromIcon("/icons/holmesicon.png"));
        }
        catch (Exception ex) {
            overlord.log(lang.getText("LOGentry00529exception") + "\n" + ex.getMessage(), "error", true);
        }
        PetriNet pn = overlord.getWorkspace().getProject();
        this.parentWindow = parent;
        this.stateVector = stateVector;
        this.stateIndex = stateIndex;
        this.places = pn.getPlaces();
        this.statesManager = pn.accessStatesManager();
        this.initalizeComponents();
        this.initiateListeners();
        this.fillTable();
        this.setVisible(true);
        this.parentWindow.setEnabled(false);
    }

    private void fillTable() {
        this.tableModel.clearModel();
        int size = this.stateVector.getSize();
        for (int p = 0; p < size; ++p) {
            this.tableModel.addNew(p, this.places.get(p).getName(), this.stateVector.getTokens(p));
        }
        this.tableModel.fireTableDataChanged();
    }

    private void initalizeComponents() {
        this.setLayout(new BorderLayout());
        this.setSize(new Dimension(900, 650));
        this.setLocation(50, 50);
        this.setResizable(true);
        this.setLayout(new BorderLayout());
        JPanel tablePanel = this.getMainTablePanel();
        this.add((Component)this.getTopPanel(), "North");
        this.add((Component)tablePanel, "Center");
    }

    private JPanel getTopPanel() {
        JPanel result = new JPanel(new BorderLayout());
        result.setLocation(0, 0);
        result.setBorder(BorderFactory.createTitledBorder(lang.getText("HSEwin_entry002")));
        result.setPreferredSize(new Dimension(500, 100));
        JPanel filler = new JPanel(null);
        int posX = 5;
        int posY = 0;
        JLabel label0 = new JLabel(lang.getText("HSEwin_entry003"));
        label0.setBounds(posX, posY, 160, 20);
        filler.add(label0);
        JLabel labelID = new JLabel("" + this.stateIndex);
        labelID.setBounds(posX + 170, posY, 100, 20);
        filler.add(labelID);
        JTextArea vectorDescrTextArea = new JTextArea(this.statesManager.accessStateMatrix().get(this.stateIndex).getDescription());
        vectorDescrTextArea.setLineWrap(true);
        vectorDescrTextArea.setEditable(true);
        vectorDescrTextArea.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                JTextArea field = (JTextArea)e.getSource();
                if (field != null) {
                    String newComment = field.getText();
                    HolmesStatesEditor.this.statesManager.accessStateMatrix().get(HolmesStatesEditor.this.stateIndex).setDescription(newComment);
                    HolmesStatesEditor.this.fillTable();
                    HolmesStatesEditor.this.parentWindow.fillDescriptionField();
                }
            }
        });
        JPanel CreationPanel = new JPanel();
        CreationPanel.setLayout(new BorderLayout());
        CreationPanel.add((Component)new JScrollPane(vectorDescrTextArea), "Center");
        CreationPanel.setBounds(posX, posY += 20, 600, 50);
        filler.add(CreationPanel);
        JLabel locLabel = new JLabel(lang.getText("HSEwin_entry005"), 2);
        locLabel.setBounds(posX + 620, posY - 10, 150, 20);
        result.add(locLabel);
        SpinnerNumberModel tokensSpinnerModel = new SpinnerNumberModel(0.0, 0.0, 9.223372036854776E18, 1.0);
        JSpinner tokensSpinner = new JSpinner(tokensSpinnerModel);
        tokensSpinner.setBounds(posX + 620, posY + 10, 60, 20);
        tokensSpinner.addChangeListener(e -> {
            double tokens = (Double)((JSpinner)e.getSource()).getValue();
            this.globalTokensNumber = (int)tokens;
        });
        result.add(tokensSpinner);
        JButton changeAllButton = new JButton(lang.getText("HSEwin_entry004"));
        changeAllButton.setBounds(posX + 690, posY + 10, 120, 40);
        changeAllButton.setMargin(new Insets(0, 0, 0, 0));
        changeAllButton.setFocusPainted(false);
        changeAllButton.setToolTipText(lang.getText("HSEwin_entry004t"));
        changeAllButton.setIcon(Tools.getResIcon16("/icons/stateManager/changeAll.png"));
        changeAllButton.addActionListener(actionEvent -> {
            if (this.places.isEmpty()) {
                return;
            }
            this.changeGlobalTokensNumber();
        });
        result.add(changeAllButton);
        result.add((Component)filler, "Center");
        return result;
    }

    protected void changeGlobalTokensNumber() {
        Object[] options = new Object[]{lang.getText("HSEwin_entry006op1"), lang.getText("HSEwin_entry006op2")};
        int n = JOptionPane.showOptionDialog(null, lang.getText("HSEwin_entry006") + " " + this.globalTokensNumber + "?", lang.getText("HSEwin_entry006t"), 0, 2, null, options, options[1]);
        if (n == 0) {
            int size = this.stateVector.getSize();
            for (int p = 0; p < size; ++p) {
                this.stateVector.setTokens(p, this.globalTokensNumber);
                this.tableModel.setQuietlyValueAt(this.globalTokensNumber, p, 2);
                this.parentWindow.changeTableCell(this.stateIndex, p + 2, this.globalTokensNumber, p == size - 1);
            }
            this.tableModel.fireTableDataChanged();
        }
    }

    public JPanel getMainTablePanel() {
        JPanel result = new JPanel(new BorderLayout());
        result.setLocation(0, 0);
        result.setBorder(BorderFactory.createTitledBorder(lang.getText("HSEwin_entry007")));
        result.setPreferredSize(new Dimension(500, 500));
        this.tableModel = new StatesPlacesEditorTableModel(this, this.stateIndex);
        RXTable table = new RXTable(this.tableModel);
        table.setSelectAllForEdit(true);
        table.getColumnModel().getColumn(0).setHeaderValue("ID");
        table.getColumnModel().getColumn(0).setPreferredWidth(30);
        table.getColumnModel().getColumn(0).setMinWidth(30);
        table.getColumnModel().getColumn(0).setMaxWidth(30);
        table.getColumnModel().getColumn(1).setHeaderValue("Place name");
        table.getColumnModel().getColumn(1).setPreferredWidth(600);
        table.getColumnModel().getColumn(1).setMinWidth(100);
        table.getColumnModel().getColumn(2).setHeaderValue("Tokens");
        table.getColumnModel().getColumn(2).setPreferredWidth(100);
        table.getColumnModel().getColumn(2).setMinWidth(50);
        table.setName("SSAplacesTable");
        table.setFillsViewportHeight(true);
        DefaultTableCellRenderer tableRenderer = new DefaultTableCellRenderer();
        table.setDefaultRenderer(Object.class, tableRenderer);
        table.setDefaultRenderer(Double.class, tableRenderer);
        table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() != 1 || !e.isControlDown()) {
                    // empty if block
                }
            }
        });
        table.setRowSelectionAllowed(false);
        table.setAutoResizeMode(4);
        JScrollPane tableScrollPane = new JScrollPane(table, 20, 30);
        result.add((Component)tableScrollPane, "Center");
        return result;
    }

    public void changeRealValue(int index, int placeID, double newValue) {
        this.statesManager.getStatePN(index).accessVector().set(placeID, newValue);
        this.parentWindow.changeTableCell(index, placeID + 2, newValue, true);
        overlord.markNetChange();
    }

    private void initiateListeners() {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                HolmesStatesEditor.this.parentWindow.setEnabled(true);
            }
        });
    }
}

