/*
 * Decompiled with CFR 0.152.
 */
package holmes.windows.managers;

import holmes.darkgui.GUIManager;
import holmes.darkgui.LanguageManager;
import holmes.petrinet.data.PetriNet;
import holmes.petrinet.data.SSAplacesManager;
import holmes.petrinet.data.SSAplacesVector;
import holmes.petrinet.elements.Place;
import holmes.tables.RXTable;
import holmes.tables.managers.SSAplacesEditorTableModel;
import holmes.tables.managers.SSAplacesTableRenderer;
import holmes.utilities.Tools;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class HolmesSSAplacesEditor
extends JFrame {
    private static final long serialVersionUID = -6810858686209063022L;
    private static final GUIManager overlord = GUIManager.getDefaultGUIManager();
    private static final LanguageManager lang = GUIManager.getLanguageManager();
    private JFrame parentWindow;
    private SSAplacesEditorTableModel tableModel;
    private SSAplacesVector ssaVector;
    private int ssaIndex;
    private SSAplacesVector.SSAdataType dataType;
    private String dataTypeUnits;
    private ArrayList<Place> places;
    private SSAplacesManager ssaManager;

    public HolmesSSAplacesEditor(JFrame parent, SSAplacesVector ssaVector, int ssaIndex) {
        this.setTitle(lang.getText("HSSAwin_entry001title"));
        try {
            this.setIconImage(Tools.getImageFromIcon("/icons/holmesicon.png"));
        }
        catch (Exception ex) {
            overlord.log(lang.getText("LOGentry00526exception") + "\n" + ex.getMessage(), "error", true);
        }
        PetriNet pn = overlord.getWorkspace().getProject();
        this.parentWindow = parent;
        this.ssaVector = ssaVector;
        this.ssaIndex = ssaIndex;
        this.places = pn.getPlaces();
        this.ssaManager = pn.accessSSAmanager();
        this.dataType = ssaVector.getType();
        this.dataTypeUnits = "";
        this.dataTypeUnits = this.dataType == SSAplacesVector.SSAdataType.MOLECULES ? this.dataTypeUnits + " [number]" : this.dataTypeUnits + " [mole/litre]";
        this.initalizeComponents();
        this.initiateListeners();
        this.fillTable();
        this.setVisible(true);
        this.parentWindow.setEnabled(false);
    }

    private void fillTable() {
        this.tableModel.clearModel();
        int size = this.ssaVector.getSize();
        for (int p = 0; p < size; ++p) {
            this.tableModel.addNew(p, this.places.get(p).getName(), this.ssaVector.getTokens(p));
        }
        this.tableModel.fireTableDataChanged();
    }

    private void initalizeComponents() {
        this.setLayout(new BorderLayout());
        this.setSize(new Dimension(900, 650));
        this.setLocation(50, 50);
        this.setResizable(true);
        this.setLayout(new BorderLayout());
        JPanel tablePanel = this.getMainTablePanel();
        this.add((Component)this.getTopPanel(), "North");
        this.add((Component)tablePanel, "Center");
    }

    private JPanel getTopPanel() {
        JPanel result = new JPanel(new BorderLayout());
        result.setLocation(0, 0);
        result.setBorder(BorderFactory.createTitledBorder(lang.getText("HSSAwin_entry002")));
        result.setPreferredSize(new Dimension(500, 100));
        JPanel filler = new JPanel(null);
        int posX = 5;
        int posY = 0;
        JLabel label0 = new JLabel(lang.getText("HSSAwin_entry003"));
        label0.setBounds(posX, posY, 100, 20);
        filler.add(label0);
        JLabel labelID = new JLabel("" + this.ssaIndex);
        labelID.setBounds(posX + 110, posY, 100, 20);
        filler.add(labelID);
        JLabel label1 = new JLabel(lang.getText("HSSAwin_entry004"));
        label1.setBounds(posX + 220, posY, 100, 20);
        filler.add(label1);
        JLabel label2 = new JLabel(String.valueOf((Object)this.dataType) + this.dataTypeUnits);
        label2.setBounds(posX + 330, posY, 230, 20);
        filler.add(label2);
        JTextArea vectorDescrTextArea = new JTextArea(this.ssaManager.accessSSAmatrix().get(this.ssaIndex).getDescription());
        vectorDescrTextArea.setLineWrap(true);
        vectorDescrTextArea.setEditable(true);
        vectorDescrTextArea.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                JTextArea field = (JTextArea)e.getSource();
                if (field != null) {
                    String newComment = field.getText();
                    HolmesSSAplacesEditor.this.ssaManager.accessSSAmatrix().get(HolmesSSAplacesEditor.this.ssaIndex).setDescription(newComment);
                    HolmesSSAplacesEditor.this.fillTable();
                }
            }
        });
        JPanel CreationPanel = new JPanel();
        CreationPanel.setLayout(new BorderLayout());
        CreationPanel.add((Component)new JScrollPane(vectorDescrTextArea), "Center");
        CreationPanel.setBounds(posX, posY += 20, 600, 50);
        filler.add(CreationPanel);
        result.add((Component)filler, "Center");
        return result;
    }

    public JPanel getMainTablePanel() {
        JPanel result = new JPanel(new BorderLayout());
        result.setLocation(0, 0);
        result.setBorder(BorderFactory.createTitledBorder(lang.getText("HSSAwin_entry005")));
        result.setPreferredSize(new Dimension(500, 500));
        this.tableModel = new SSAplacesEditorTableModel(this, this.ssaIndex, this.dataType);
        RXTable table = new RXTable(this.tableModel);
        table.setSelectAllForEdit(true);
        table.getColumnModel().getColumn(0).setHeaderValue("ID");
        table.getColumnModel().getColumn(0).setPreferredWidth(30);
        table.getColumnModel().getColumn(0).setMinWidth(30);
        table.getColumnModel().getColumn(0).setMaxWidth(30);
        table.getColumnModel().getColumn(1).setHeaderValue("Place name");
        table.getColumnModel().getColumn(1).setPreferredWidth(600);
        table.getColumnModel().getColumn(1).setMinWidth(100);
        table.getColumnModel().getColumn(2).setHeaderValue(this.dataTypeUnits);
        table.getColumnModel().getColumn(2).setPreferredWidth(100);
        table.getColumnModel().getColumn(2).setMinWidth(50);
        table.setName("SSAplacesTable");
        table.setFillsViewportHeight(true);
        SSAplacesTableRenderer tableRenderer = new SSAplacesTableRenderer();
        table.setDefaultRenderer(Object.class, tableRenderer);
        table.setDefaultRenderer(Double.class, tableRenderer);
        table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() != 1 || !e.isControlDown()) {
                    // empty if block
                }
            }
        });
        table.setRowSelectionAllowed(false);
        table.setAutoResizeMode(4);
        JScrollPane tableScrollPane = new JScrollPane(table, 20, 30);
        result.add((Component)tableScrollPane, "Center");
        return result;
    }

    public void changeRealValue(int index, int placeID, double newValue) {
        this.ssaManager.getSSAvector(index).accessVector().set(placeID, newValue);
        overlord.markNetChange();
    }

    private void initiateListeners() {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                HolmesSSAplacesEditor.this.parentWindow.setEnabled(true);
            }
        });
    }
}

