/*
 * Decompiled with CFR 0.152.
 */
package holmes.windows.managers;

import holmes.darkgui.GUIManager;
import holmes.darkgui.LanguageManager;
import holmes.petrinet.data.PetriNet;
import holmes.petrinet.data.SPNdataVector;
import holmes.petrinet.data.SPNdataVectorManager;
import holmes.petrinet.data.SPNtransitionData;
import holmes.petrinet.elements.Transition;
import holmes.tables.RXTable;
import holmes.tables.managers.SPNsingleVectorTableModel;
import holmes.tables.managers.SPNsingleVectorTableRenderer;
import holmes.utilities.Tools;
import holmes.windows.managers.HolmesSPNtransitionEditor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;

public class HolmesSPNeditor
extends JFrame {
    private static final long serialVersionUID = -6810858686209063022L;
    private static final GUIManager overlord = GUIManager.getDefaultGUIManager();
    private static final LanguageManager lang = GUIManager.getLanguageManager();
    private JFrame parentWindow;
    private JFrame ego;
    private SPNsingleVectorTableModel tableModel;
    private JTable table;
    private SPNdataVector frData;
    private int frIndex;
    private ArrayList<Transition> transitions;
    private SPNdataVectorManager firingRatesManager;

    public HolmesSPNeditor(JFrame parent, SPNdataVector frData, int frIndex) {
        this.setTitle(lang.getText("HSPNwin_entry001title"));
        try {
            this.setIconImage(Tools.getImageFromIcon("/icons/holmesicon.png"));
        }
        catch (Exception ex) {
            overlord.log(lang.getText("LOGentry00519exception") + "\n" + ex.getMessage(), "error", true);
        }
        PetriNet pn = overlord.getWorkspace().getProject();
        this.ego = this;
        this.parentWindow = parent;
        this.frData = frData;
        this.frIndex = frIndex;
        this.transitions = pn.getTransitions();
        this.firingRatesManager = pn.accessFiringRatesManager();
        this.initalizeComponents();
        this.initiateListeners();
        this.fillTable();
        this.setVisible(true);
        this.parentWindow.setEnabled(false);
        this.setDefaultCloseOperation(2);
    }

    public void fillTable() {
        this.tableModel.clearModel();
        int row = -1;
        for (SPNtransitionData frBox : this.frData.accessVector()) {
            Object postFix = "";
            Transition t = this.transitions.get(++row);
            int inSize = t.getInputArcs().size();
            int outSize = t.getOutputArcs().size();
            if (inSize == 0 && outSize != 0) {
                postFix = (String)postFix + "     - IN -    ";
            }
            if (inSize != 0 && outSize == 0) {
                postFix = (String)postFix + "     - OUT -    ";
            }
            if (inSize == 0 && outSize == 0) {
                postFix = (String)postFix + "     * IN/OUT *    ";
            }
            switch (frBox.sType) {
                case ST: {
                    this.tableModel.addNew(row, (String)postFix + this.transitions.get(row).getName(), "" + this.frData.getFiringRate(row), frBox.sType);
                    break;
                }
                case DT: {
                    this.tableModel.addNew(row, (String)postFix + this.transitions.get(row).getName(), "" + frBox.DET_delay, frBox.sType);
                    break;
                }
                case IM: {
                    this.tableModel.addNew(row, (String)postFix + this.transitions.get(row).getName(), "" + frBox.IM_priority, frBox.sType);
                    break;
                }
                case SchT: {
                    this.tableModel.addNew(row, (String)postFix + this.transitions.get(row).getName(), frBox.SCH_start + "; " + frBox.SCH_rep + "; " + frBox.SCH_end, frBox.sType);
                }
            }
        }
        this.tableModel.fireTableDataChanged();
    }

    private void initalizeComponents() {
        this.setLayout(new BorderLayout());
        this.setSize(new Dimension(900, 650));
        this.setLocation(50, 50);
        this.setResizable(true);
        this.setLayout(new BorderLayout());
        JPanel tablePanel = this.getMainTablePanel();
        this.add((Component)this.getTopPanel(), "North");
        this.add((Component)tablePanel, "Center");
    }

    private JPanel getTopPanel() {
        JPanel result = new JPanel(new BorderLayout());
        result.setLocation(0, 0);
        result.setBorder(BorderFactory.createTitledBorder(lang.getText("HSPNwin_entry002")));
        result.setPreferredSize(new Dimension(500, 100));
        JPanel filler = new JPanel(null);
        int posX = 5;
        int posY = 0;
        JLabel label0 = new JLabel(lang.getText("HSPNwin_entry003"));
        label0.setBounds(posX, posY, 120, 20);
        filler.add(label0);
        JLabel labelID = new JLabel("" + this.frIndex);
        labelID.setBounds(posX + 130, posY, 100, 20);
        filler.add(labelID);
        JTextArea vectorDescrTextArea = new JTextArea(this.firingRatesManager.getSPNvectorDescription(this.frIndex));
        vectorDescrTextArea.setLineWrap(true);
        vectorDescrTextArea.setEditable(true);
        vectorDescrTextArea.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                JTextArea field = (JTextArea)e.getSource();
                if (field != null) {
                    String newComment = field.getText();
                    HolmesSPNeditor.this.firingRatesManager.setSPNvectorDescription(HolmesSPNeditor.this.frIndex, newComment);
                    HolmesSPNeditor.this.fillTable();
                }
            }
        });
        JPanel CreationPanel = new JPanel();
        CreationPanel.setLayout(new BorderLayout());
        CreationPanel.add((Component)new JScrollPane(vectorDescrTextArea), "Center");
        CreationPanel.setBounds(posX, posY + 20, 600, 50);
        filler.add(CreationPanel);
        result.add((Component)filler, "Center");
        return result;
    }

    public JPanel getMainTablePanel() {
        JPanel result = new JPanel(new BorderLayout());
        result.setLocation(0, 0);
        result.setBorder(BorderFactory.createTitledBorder(lang.getText("HSPNwin_entry004")));
        result.setPreferredSize(new Dimension(500, 500));
        this.tableModel = new SPNsingleVectorTableModel(this, this.frIndex);
        this.table = new RXTable(this.tableModel);
        ((RXTable)this.table).setSelectAllForEdit(true);
        this.table.getColumnModel().getColumn(0).setHeaderValue("ID");
        this.table.getColumnModel().getColumn(0).setPreferredWidth(30);
        this.table.getColumnModel().getColumn(0).setMinWidth(30);
        this.table.getColumnModel().getColumn(0).setMaxWidth(30);
        this.table.getColumnModel().getColumn(1).setHeaderValue("Transition name");
        this.table.getColumnModel().getColumn(1).setPreferredWidth(600);
        this.table.getColumnModel().getColumn(1).setMinWidth(100);
        this.table.getColumnModel().getColumn(2).setHeaderValue("Data");
        this.table.getColumnModel().getColumn(2).setPreferredWidth(100);
        this.table.getColumnModel().getColumn(2).setMinWidth(50);
        this.table.getColumnModel().getColumn(3).setHeaderValue("SPN sub-type");
        this.table.getColumnModel().getColumn(3).setPreferredWidth(80);
        this.table.getColumnModel().getColumn(3).setMinWidth(70);
        this.table.setName("FiringRatesTransitionTable");
        this.table.setFillsViewportHeight(true);
        SPNsingleVectorTableRenderer tableRenderer = new SPNsingleVectorTableRenderer(this.table);
        this.table.setDefaultRenderer(Object.class, tableRenderer);
        this.table.setDefaultRenderer(Double.class, tableRenderer);
        this.table.getSelectionModel().addListSelectionListener(event -> {
            int selectedRow = this.table.getSelectedRow();
            if (selectedRow > -1) {
                new HolmesSPNtransitionEditor(this.ego, this.frData.getSPNtransitionContainer(selectedRow), this.transitions.get(selectedRow), new Point(400, 400));
            }
        });
        this.table.setRowSelectionAllowed(false);
        this.table.setAutoResizeMode(4);
        JScrollPane tableScrollPane = new JScrollPane(this.table, 20, 30);
        result.add((Component)tableScrollPane, "Center");
        return result;
    }

    public void changeRealValue(int index, int transID, String newValue) {
        this.firingRatesManager.getSPNdataVector((int)index).accessVector().get((int)transID).ST_function = newValue;
        overlord.markNetChange();
    }

    private void initiateListeners() {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                HolmesSPNeditor.this.parentWindow.setEnabled(true);
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent e) {
                HolmesSPNeditor.this.fillTable();
            }
        });
    }
}

