/*
 * Decompiled with CFR 0.152.
 */
package holmes.windows.decompositions;

import holmes.analyse.comparison.structures.GreatCommonSubnet;
import holmes.darkgui.GUIManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.imageio.ImageIO;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;

public class HolmesPrototypeComparison
extends JFrame {
    private GUIManager overlord;
    private JPanel mainPanel;
    private JPanel leftPanel;
    private JPanel rightPanel;
    private JPanel upPanel;
    private JPanel downPanel;
    public JTable comparisonTable;
    ArrayList<ArrayList<GreatCommonSubnet>> subNetArrayList;

    public HolmesPrototypeComparison() {
        this.setSize(1800, 700);
        AbstractListModel lm = new AbstractListModel(){
            String[] headers = new String[]{"a", "b", "c", "d", "e", "f", "g", "h", "i"};

            @Override
            public int getSize() {
                return this.headers.length;
            }

            @Override
            public Object getElementAt(int index) {
                return this.headers[index];
            }
        };
        DefaultTableModel dm = new DefaultTableModel(lm.getSize(), 20);
        JTable table = new JTable(dm);
        table.setAutoResizeMode(4);
        JList rowHeader = new JList(lm);
        rowHeader.setFixedCellWidth(50);
        rowHeader.setFixedCellHeight(18);
        rowHeader.setCellRenderer(new RowHeaderRenderer(table));
        JScrollPane scroll = new JScrollPane(table);
        scroll.setRowHeaderView(rowHeader);
        this.getContentPane().add((Component)scroll, "West");
        this.rightPanel = this.createInfoPanel(320, 0, 400, 150);
        this.getContentPane().add((Component)this.rightPanel, "East");
    }

    public HolmesPrototypeComparison(ArrayList<ArrayList<GreatCommonSubnet>> subNetArrayList) {
        this.setSize(1800, 700);
        this.createComparisonTable(subNetArrayList);
        ArrayList subMatrix = new ArrayList();
        this.rightPanel = this.createInfoPanel(320, 0, 400, 150);
        this.getContentPane().add((Component)this.rightPanel, "East");
    }

    private void createComparisonTable(ArrayList<ArrayList<GreatCommonSubnet>> snl) {
        this.subNetArrayList = snl;
        Object[] netLabels = new String[this.subNetArrayList.size()];
        for (int i = 0; i < this.subNetArrayList.size(); ++i) {
            netLabels[i] = "Sub :" + i;
        }
        AbstractListModel lm = new AbstractListModel((String[])netLabels){
            String[] headers;
            final /* synthetic */ String[] val$netLabels;
            {
                this.val$netLabels = stringArray;
                this.headers = this.val$netLabels;
            }

            @Override
            public int getSize() {
                return this.headers.length;
            }

            @Override
            public Object getElementAt(int index) {
                return this.headers[index];
            }
        };
        DefaultTableModel dm = new DefaultTableModel(lm.getSize(), netLabels.length);
        dm.setColumnIdentifiers(netLabels);
        Object[][] results = new String[this.subNetArrayList.size()][this.subNetArrayList.get(0).size()];
        for (int i = 0; i < this.subNetArrayList.size(); ++i) {
            for (int j = 0; j < this.subNetArrayList.get(i).size(); ++j) {
                results[i][j] = String.valueOf(this.subNetArrayList.get((int)i).get((int)j).gcsValue + " / " + this.subNetArrayList.get((int)i).get((int)j).firstNetNodeSize);
            }
        }
        this.comparisonTable = new JTable(results, netLabels){

            @Override
            public Component prepareRenderer(TableCellRenderer renderer, int row, int col) {
                Component comp = super.prepareRenderer(renderer, row, col);
                Object value = this.getModel().getValueAt(row, col);
                if (HolmesPrototypeComparison.this.subNetArrayList.get((int)row).get((int)col).gcsValue == (double)HolmesPrototypeComparison.this.subNetArrayList.get((int)row).get((int)col).firstNetNodeSize) {
                    comp.setBackground(Color.green);
                } else if (HolmesPrototypeComparison.this.subNetArrayList.get((int)row).get((int)col).gcsValue == 0.0) {
                    comp.setBackground(Color.red);
                } else if (HolmesPrototypeComparison.this.subNetArrayList.get((int)row).get((int)col).gcsValue > (double)HolmesPrototypeComparison.this.subNetArrayList.get((int)row).get((int)col).firstNetNodeSize || HolmesPrototypeComparison.this.subNetArrayList.get((int)row).get((int)col).gcsValue > (double)HolmesPrototypeComparison.this.subNetArrayList.get((int)row).get((int)col).secondNetNodeSize) {
                    comp.setBackground(Color.blue);
                } else {
                    comp.setBackground(Color.white);
                }
                return comp;
            }
        };
        this.comparisonTable.setAutoResizeMode(0);
        JList rowHeader = new JList(lm);
        rowHeader.setFixedCellWidth(50);
        rowHeader.setFixedCellHeight(this.comparisonTable.getRowHeight() + this.comparisonTable.getRowMargin());
        rowHeader.setCellRenderer(new RowHeaderRenderer(this.comparisonTable));
        this.comparisonTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent event) {
                HolmesPrototypeComparison.this.calcIndexes(HolmesPrototypeComparison.this.comparisonTable.getSelectedRow(), HolmesPrototypeComparison.this.comparisonTable.getSelectedColumn());
                HolmesPrototypeComparison.this.showSubNet(HolmesPrototypeComparison.this.comparisonTable.getSelectedRow(), HolmesPrototypeComparison.this.comparisonTable.getSelectedColumn());
            }
        });
        JScrollPane scroll = new JScrollPane(this.comparisonTable);
        scroll.setRowHeaderView(rowHeader);
        this.getContentPane().add(scroll);
    }

    private void showSubNet(int selectedRow, int selectedColumn) {
        this.subNetArrayList.get(selectedColumn).get(selectedRow);
    }

    private void calcIndexes(int selectedRow, int selectedColumn) {
    }

    private JPanel createInfoPanel(int x, int y, int width, int height) {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.setBorder(BorderFactory.createTitledBorder("Info"));
        panel.setLocation(x, y);
        panel.setPreferredSize(new Dimension(width, height));
        int posX = 10;
        int posY = 10;
        BufferedImage bi = null;
        try {
            bi = ImageIO.read(new File(this.getClass().getResource("/MockImageGraphComparison.png").getPath()));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        JLabel graphComp = new JLabel(new ImageIcon(bi));
        panel.add((Component)graphComp, "North");
        JLabel fs1 = new JLabel("There will be math");
        fs1.setLayout(new GridLayout());
        fs1.setEnabled(true);
        panel.add((Component)fs1, "South");
        return panel;
    }

    private JPanel createMainPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)this.leftPanel, "West");
        panel.repaint();
        return panel;
    }

    private JPanel createLeftPanel(int x, int y, int width, int height) {
        JPanel panel = new JPanel();
        panel.setLayout(null);
        panel.setBorder(BorderFactory.createTitledBorder("Decomposition types"));
        panel.setLocation(x, y);
        panel.setPreferredSize(new Dimension(width, height));
        int posX = 10;
        int posY = 20;
        return panel;
    }

    class RowHeaderRenderer
    extends JLabel
    implements ListCellRenderer {
        RowHeaderRenderer(JTable table) {
            JTableHeader header = table.getTableHeader();
            this.setOpaque(true);
            this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
            this.setHorizontalAlignment(0);
            this.setForeground(header.getForeground());
            this.setBackground(header.getBackground());
            this.setFont(header.getFont());
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setText(value == null ? "" : value.toString());
            return this;
        }
    }
}

