/*
 * Decompiled with CFR 0.152.
 */
package holmes.windows.decompositions;

import holmes.analyse.GraphletsCalculator;
import holmes.analyse.comparison.GraphletComparator;
import holmes.analyse.comparison.experiment.NetGenerator;
import holmes.darkgui.GUIManager;
import holmes.petrinet.elements.Arc;
import holmes.petrinet.elements.Node;
import holmes.petrinet.elements.PetriNetElement;
import holmes.petrinet.elements.Place;
import holmes.petrinet.elements.Transition;
import holmes.utilities.ColorPalette;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.stream.DoubleStream;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.TitledBorder;

public class HolmesGraphlets
extends JFrame {
    private GUIManager overlord;
    private JPanel mainPanel;
    JComboBox<String> orbit;
    private JTextArea comparisonResultsArea;
    private JTextArea graphletResultsArea;
    private JTextArea orbitResultsArea;
    private JComboBox graphletResult;
    private boolean firstNetLoaded = false;
    private boolean secondNetLoaded = false;
    JComboBox<String> graphletListSorted;
    JComboBox<String> graphletListUniq;
    JComboBox getSize;
    JComboBox getNode;
    JComboBox getSizeForComparison;
    String[] orbitData = new String[]{" ----- "};
    String[] graphDataUniq = new String[]{" ----- "};
    private String pathToFirstFile = "";
    private String pathToSecondFile = "";

    public HolmesGraphlets() {
        this.setTitle("Single net graphlet analysis");
        this.overlord = GUIManager.getDefaultGUIManager();
        JPanel panel = new JPanel(false);
        panel.setLayout(new BorderLayout());
        JPanel buttonPanel = new JPanel(new GridLayout(6, 1));
        JButton checknetForGraphlets = new JButton("Check net for graphlets");
        checknetForGraphlets.setVisible(true);
        checknetForGraphlets.addActionListener(actionEvent -> this.generateGraphletOrbits());
        checknetForGraphlets.setLayout(new BorderLayout());
        buttonPanel.add(checknetForGraphlets);
        JButton saveGDDA = new JButton("Save orbits");
        saveGDDA.addActionListener(actionEvent -> {
            JFileChooser fc = new JFileChooser();
            int returnVal = fc.showSaveDialog(this);
            this.saveGDDA(fc.getSelectedFile().getAbsolutePath());
        });
        buttonPanel.add(saveGDDA);
        String[] sizeString = new String[]{"3-node graphlets", "4-node graphlets", "5-node graphlets"};
        this.getSize = new JComboBox<String>(sizeString);
        this.getSize.setSelectedIndex(2);
        buttonPanel.add(this.getSize);
        String[] nodeString = new String[]{"Choose node"};
        this.getNode = new JComboBox<String>(nodeString);
        this.getNode.setSelectedIndex(0);
        this.getNode.addActionListener(actionEvent -> {
            JComboBox comboBox = (JComboBox)actionEvent.getSource();
            int selectedGraphlet = comboBox.getSelectedIndex();
            if (!comboBox.getModel().getSelectedItem().equals("Choose node")) {
                Node n = this.overlord.getWorkspace().getProject().getNodes().get(selectedGraphlet);
                int[] orbits = GraphletsCalculator.vectorOrbit(n, true);
                this.orbitResultsArea.setText("");
                for (int i = 0; i < orbits.length; ++i) {
                    if (orbits[i] <= 0) continue;
                    this.orbitResultsArea.append("Orbit-" + i + " : " + orbits[i] + "\n");
                }
            }
        });
        buttonPanel.add(this.getNode);
        JLabel title = new JLabel("Found Graphlets :");
        title.setFont(new Font("Dialog", 0, 11));
        buttonPanel.add(title);
        String[] resultString = new String[]{"None"};
        this.graphletResult = new JComboBox<String>(sizeString);
        this.graphletResult.setSelectedIndex(0);
        this.graphletResult.setEnabled(false);
        this.graphletResult.addActionListener(actionEvent -> {
            JComboBox comboBox = (JComboBox)actionEvent.getSource();
            int selectedGraphlet = comboBox.getSelectedIndex();
            GraphletsCalculator.Struct graphletStructure = GraphletsCalculator.uniqGraphlets.get(selectedGraphlet);
            this.paintGraphlet(graphletStructure);
        });
        buttonPanel.add(this.graphletResult);
        TitledBorder titleF = BorderFactory.createTitledBorder("Options");
        buttonPanel.setBorder(titleF);
        panel.add((Component)buttonPanel, "North");
        JPanel infoPanel = new JPanel(false);
        infoPanel.setLayout(new FlowLayout());
        this.graphletResultsArea = new JTextArea(40, 22);
        JScrollPane gscroll = new JScrollPane(this.graphletResultsArea);
        gscroll.setVerticalScrollBarPolicy(20);
        TitledBorder titleG = BorderFactory.createTitledBorder("Graphlets info");
        gscroll.setBorder(titleG);
        infoPanel.add(gscroll);
        this.orbitResultsArea = new JTextArea(40, 22);
        JScrollPane oscroll = new JScrollPane(this.orbitResultsArea);
        oscroll.setVerticalScrollBarPolicy(20);
        TitledBorder titleO = BorderFactory.createTitledBorder("Orbits info");
        oscroll.setBorder(titleO);
        infoPanel.add(oscroll);
        panel.add((Component)infoPanel, "South");
        this.add((Component)panel, "Center");
        this.setPreferredSize(new Dimension(600, 850));
        this.pack();
    }

    protected JComponent makeSingleNetPane() {
        JPanel panel = new JPanel(false);
        panel.setLayout(new GridLayout(3, 1));
        JPanel graphletPanel = new JPanel(false);
        graphletPanel.setLayout(new GridLayout(1, 3));
        JPanel graphletButtonPanel = new JPanel(false);
        graphletButtonPanel.setLayout(new GridLayout(2, 1));
        JButton checknetForGraphlets = new JButton("Check net for graphlets");
        checknetForGraphlets.addActionListener(actionEvent -> this.generateGraphletOrbits());
        String[] sizeString = new String[]{"3-node graphlets", "4-node graphlets", "5-node graphlets"};
        this.getSize = new JComboBox<String>(sizeString);
        this.getSize.setSelectedIndex(2);
        graphletButtonPanel.add(checknetForGraphlets);
        graphletButtonPanel.add(this.getSize);
        this.graphletResultsArea = new JTextArea(15, 20);
        JScrollPane gscroll = new JScrollPane(this.graphletResultsArea);
        gscroll.setVerticalScrollBarPolicy(20);
        String[] resultString = new String[]{"None"};
        this.graphletResult = new JComboBox<String>(sizeString);
        this.graphletResult.setSelectedIndex(0);
        this.graphletResult.setEnabled(false);
        this.graphletResult.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JComboBox comboBox = (JComboBox)actionEvent.getSource();
                int selectedGraphlet = comboBox.getSelectedIndex();
                GraphletsCalculator.Struct graphletStructure = GraphletsCalculator.uniqGraphlets.get(selectedGraphlet);
                HolmesGraphlets.this.paintGraphlet(graphletStructure);
            }
        });
        graphletPanel.add(graphletButtonPanel);
        graphletPanel.add(gscroll);
        graphletPanel.add(this.graphletResult);
        panel.add(graphletPanel);
        JPanel orbitPanel = new JPanel(false);
        orbitPanel.setLayout(new GridLayout(1, 2));
        String[] nodeString = new String[]{"Choose node"};
        this.getNode = new JComboBox<String>(nodeString);
        this.getNode.setSelectedIndex(0);
        this.getNode.addActionListener(actionEvent -> {
            JComboBox comboBox = (JComboBox)actionEvent.getSource();
            int selectedGraphlet = comboBox.getSelectedIndex();
            if (!comboBox.getModel().getSelectedItem().equals("Choose node")) {
                Node n = this.overlord.getWorkspace().getProject().getNodes().get(comboBox.getSelectedIndex());
                int[] orbits = GraphletsCalculator.vectorOrbit(n, false);
                this.orbitResultsArea.setText("");
                for (int i = 0; i < orbits.length; ++i) {
                    if (orbits[i] <= 0) continue;
                    this.orbitResultsArea.append("Orbit-" + i + " : " + orbits[i] + "\n");
                }
            }
        });
        orbitPanel.add(this.getNode);
        this.orbitResultsArea = new JTextArea(15, 20);
        JScrollPane oscroll = new JScrollPane(this.orbitResultsArea);
        oscroll.setVerticalScrollBarPolicy(20);
        orbitPanel.add(oscroll);
        panel.add(orbitPanel);
        JPanel saveButtons = new JPanel();
        JButton saveGDDA = new JButton("Save orbits");
        saveGDDA.addActionListener(actionEvent -> {
            JFileChooser fc = new JFileChooser();
            int returnVal = fc.showSaveDialog(this);
            this.saveGDDA(fc.getSelectedFile().getAbsolutePath());
        });
        saveButtons.setLayout(new GridLayout(1, 2));
        saveButtons.add(saveGDDA);
        panel.add(saveButtons);
        return panel;
    }

    private void saveGDDA(String path) {
        ArrayList<int[]> DGDV = new ArrayList<int[]>();
        for (Node startNode : this.overlord.getWorkspace().getProject().getNodes()) {
            int[] vectorOrbit = GraphletsCalculator.vectorOrbit(startNode, false);
            DGDV.add(vectorOrbit);
        }
        NetGenerator.writeDGDDA(path, DGDV);
    }

    protected JComponent makeComparisonNetPane() {
        JPanel panel = new JPanel(false);
        panel.setLayout(new GridLayout(2, 1));
        JPanel buttonPanel = new JPanel(false);
        JButton getFirstNet = new JButton("Get First Net Orbits");
        getFirstNet.setHorizontalAlignment(0);
        getFirstNet.addActionListener(actionEvent -> {
            JFileChooser fc = new JFileChooser();
            int returnVal = fc.showOpenDialog(this);
            if (returnVal == 0) {
                File file = fc.getSelectedFile();
                this.pathToFirstFile = file.getAbsolutePath();
                this.firstNetLoaded = true;
                this.comparisonResultsArea.append("First net : " + file.getAbsolutePath() + "\n");
            }
        });
        JButton getSecondNet = new JButton("Get Second Net orbits");
        getSecondNet.setHorizontalAlignment(0);
        getSecondNet.addActionListener(actionEvent -> {
            JFileChooser fc = new JFileChooser();
            int returnVal = fc.showOpenDialog(this);
            if (returnVal == 0) {
                File file = fc.getSelectedFile();
                this.pathToSecondFile = file.getAbsolutePath();
                this.secondNetLoaded = true;
                this.comparisonResultsArea.append("Second net  : " + file.getAbsolutePath() + "\n");
            }
        });
        String[] sizeString = new String[]{"3-node graphlets", "4-node graphlets", "5-node graphlets"};
        this.getSizeForComparison = new JComboBox<String>(sizeString);
        this.getSizeForComparison.setSelectedIndex(2);
        JButton compare = new JButton("Compare");
        compare.setHorizontalAlignment(0);
        compare.addActionListener(actionEvent -> {
            if (this.firstNetLoaded && this.secondNetLoaded) {
                this.graphletCompare();
            }
        });
        buttonPanel.setLayout(new GridLayout(1, 4));
        buttonPanel.add(getFirstNet);
        buttonPanel.add(getSecondNet);
        buttonPanel.add(this.getSizeForComparison);
        buttonPanel.add(compare);
        panel.add((Component)buttonPanel, "North");
        this.comparisonResultsArea = new JTextArea(15, 20);
        JScrollPane cscroll = new JScrollPane(this.comparisonResultsArea);
        cscroll.setVerticalScrollBarPolicy(20);
        panel.add((Component)cscroll, "South");
        return panel;
    }

    private void generateGraphletOrbits() {
        GraphletsCalculator.cleanAll();
        this.orbitResultsArea.selectAll();
        this.orbitResultsArea.replaceSelection("");
        this.graphletResultsArea.selectAll();
        this.graphletResultsArea.replaceSelection("");
        switch (this.getSize.getSelectedIndex()) {
            case 0: {
                GraphletsCalculator.generateGraphletsNode3();
                break;
            }
            case 1: {
                GraphletsCalculator.generateGraphletsNode4();
                break;
            }
            case 2: {
                GraphletsCalculator.generateGraphletsNode5();
            }
        }
        GraphletsCalculator.getFoundGraphlets();
        this.graphletResultsArea.setText("");
        for (int i = 0; i < GraphletsCalculator.graphetsList.size(); ++i) {
            int finalI = i;
            long val = GraphletsCalculator.uniqGraphlets.stream().filter(x -> x.getGraphletID() == finalI).count();
            this.graphletResultsArea.append("Graphlet-" + i + " : " + val + "\n");
        }
        String[] resultString = new String[GraphletsCalculator.uniqGraphlets.size()];
        for (int i = 0; i < GraphletsCalculator.uniqGraphlets.size(); ++i) {
            GraphletsCalculator.Struct st = GraphletsCalculator.uniqGraphlets.get(i);
            resultString[i] = i + " : Graphlet ID " + st.getGraphletID();
        }
        this.graphletResult.setModel(new DefaultComboBoxModel<String>(resultString));
        this.graphletResult.setEnabled(true);
        this.graphletResult.updateUI();
        String[] NoderesultString = new String[this.overlord.getWorkspace().getProject().getNodes().size()];
        for (int i = 0; i < this.overlord.getWorkspace().getProject().getNodes().size(); ++i) {
            Node n = this.overlord.getWorkspace().getProject().getNodes().get(i);
            NoderesultString[i] = i + " : " + String.valueOf((Object)n.getType()) + " - " + n.getName();
        }
        this.getNode.setModel(new DefaultComboBoxModel<String>(NoderesultString));
    }

    private void graphletCompare() {
        int orbNumber = 18;
        switch (this.getSizeForComparison.getSelectedIndex()) {
            case 0: {
                orbNumber = 18;
                break;
            }
            case 1: {
                orbNumber = 90;
                break;
            }
            case 2: {
                orbNumber = 592;
                break;
            }
            default: {
                orbNumber = 592;
            }
        }
        GraphletComparator gc = new GraphletComparator(orbNumber);
        double[] result = gc.calcDGDDApartitioned(this.pathToFirstFile, this.pathToSecondFile);
        this.comparisonResultsArea.append("Results:\n");
        this.comparisonResultsArea.append("GDDA : " + DoubleStream.of(result).sum() / (double)orbNumber + "\n");
        this.comparisonResultsArea.append("\nPartial :\n");
        for (int i = 0; i < result.length; ++i) {
            this.comparisonResultsArea.append("Orbit " + i + " : " + result[i] + "\n");
        }
    }

    private void paintGraphlet(GraphletsCalculator.Struct graphletStructure) {
        ColorPalette cp = new ColorPalette();
        this.overlord.getWorkspace().getProject().resetNetColors();
        for (Node node : graphletStructure.getNodeMap().values()) {
            if (node.getType().equals((Object)PetriNetElement.PetriNetElementType.PLACE)) {
                ((Place)node).drawGraphBoxP.setColorWithNumber(true, Color.red, false, 0.0, false, "");
                continue;
            }
            ((Transition)node).drawGraphBoxT.setColorWithNumber(true, Color.blue, false, 0.0, true, "");
        }
        this.overlord.getWorkspace().getProject().repaintAllGraphPanels();
        for (Arc arc : graphletStructure.getArcMap().values()) {
            arc.arcDecoBox.setColor(true, Color.green);
        }
    }
}

