/*
 * Decompiled with CFR 0.152.
 */
package holmes.windows.decompositions;

import holmes.analyse.SubnetCalculator;
import holmes.analyse.comparison.DecoComparisonCalculator;
import holmes.darkgui.GUIManager;
import holmes.petrinet.data.PetriNet;
import holmes.petrinet.elements.Arc;
import holmes.petrinet.elements.Node;
import holmes.petrinet.elements.PetriNetElement;
import holmes.petrinet.elements.Place;
import holmes.petrinet.elements.Transition;
import holmes.utilities.ColorPalette;
import holmes.utilities.Tools;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ItemListener;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.stream.Collectors;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;

public class HolmesDecomposition
extends JFrame {
    private JPanel mainPanel;
    private JPanel buttonPanel;
    private JPanel topButtonPanel;
    private JPanel logMainPanel;
    private JPanel infoPanel;
    private ArrayList<Integer> choosenDeco = new ArrayList();
    private JTextArea elementsOfDecomposedStructure;
    private int selectedSubNetindex = -1;
    private int selectedSecondSubNetindex = -1;
    private boolean colorSubNet = false;
    private boolean allSubNetsselected = false;
    private GUIManager overlord;
    private ArrayList<String> firstListElementsNames = new ArrayList();
    private JList decoListOne;
    private JList decoListTwo;
    private JTextArea textArea;
    DefaultListModel listModel = new DefaultListModel();
    DefaultListModel listModelTwo = new DefaultListModel();
    boolean dualMode = false;
    boolean properDecoMode = true;
    private ArrayList<JCheckBox> listOfCheckBoxs = new ArrayList();
    boolean showSimi = false;
    private int npfn = 0;
    private int npsn = 0;
    private int ntfn = 0;
    private int ntsn = 0;
    private int nafn = 0;
    private int nasn = 0;
    private int npcn = 0;
    private int ntcn = 0;
    private int nacn = 0;
    private ArrayList<Integer> listOfInvDep = new ArrayList<Integer>(Arrays.asList(1, 3, 99, 10, 11, 12));
    private float sorenIndex = 0.0f;
    private float jackobIndex = 0.0f;
    private float smc = 0.0f;
    JLabel vpfn;
    JLabel vpsn;
    JLabel vpcn;
    JLabel vtfn;
    JLabel vtsn;
    JLabel vtcn;
    JLabel vafn;
    JLabel vasn;
    JLabel vacn;
    JLabel valueOfSorensenIndex;
    JLabel valueOfJackobsenIndex;
    JLabel valueOfSMC;

    public HolmesDecomposition() {
        try {
            this.setIconImage(Tools.getImageFromIcon("/icons/holmesicon.png"));
        }
        catch (Exception e) {
            e.getMessage();
            e.printStackTrace();
        }
        this.overlord = GUIManager.getDefaultGUIManager();
        this.setVisible(false);
        this.setTitle("Decomposition");
        this.setLayout(new BorderLayout());
        this.setSize(new Dimension(1100, 700));
        this.setLocation(15, 15);
        this.mainPanel = this.createMainPanel();
        this.add((Component)this.mainPanel, "Center");
    }

    private JPanel createMainPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        this.buttonPanel = this.createLeftButtonPanel(0, 0, 300, 230);
        this.logMainPanel = this.createGraphPanel(0, 130, 500, 300);
        this.topButtonPanel = this.createTopButtonPanel(200, 130, 900, 75);
        panel.add((Component)this.buttonPanel, "West");
        panel.add((Component)this.logMainPanel, "Center");
        panel.add((Component)this.topButtonPanel, "North");
        panel.repaint();
        return panel;
    }

    private JPanel createLeftButtonPanel(int x, int y, int width, int height) {
        JPanel panel = new JPanel();
        panel.setLayout(new GridLayout(14, 1));
        panel.setBorder(BorderFactory.createTitledBorder("Decomposition types"));
        panel.setLocation(x, y);
        panel.setPreferredSize(new Dimension(width, height));
        int posX = 10;
        int posY = 20;
        ItemListener itemListener = itemEvent -> {
            AbstractButton abstractButton = (AbstractButton)itemEvent.getSource();
            Color foreground = abstractButton.getForeground();
            Color background = abstractButton.getBackground();
            int state = itemEvent.getStateChange();
            if (state == 1 || state == 2) {
                abstractButton.setForeground(background);
                abstractButton.setBackground(foreground);
            }
        };
        JLabel prop = new JLabel("Disjoined Decompositions", 0);
        panel.add(prop);
        JCheckBox functionalCheckBox = new JCheckBox();
        functionalCheckBox.setBounds(posX + 10, posY + 30, 150, 20);
        functionalCheckBox.addActionListener(actionEvent -> this.checkBoxAction(actionEvent, functionalCheckBox, panel, 0));
        functionalCheckBox.setSelected(false);
        functionalCheckBox.addItemListener(itemListener);
        panel.add(this.setOnPanel(functionalCheckBox, "Functional nets"));
        JCheckBox snetCheckBox = new JCheckBox();
        snetCheckBox.setBounds(posX + 10, posY + 60, 150, 20);
        snetCheckBox.addActionListener(actionEvent -> this.checkBoxAction(actionEvent, snetCheckBox, panel, 1));
        snetCheckBox.setSelected(false);
        snetCheckBox.addItemListener(itemListener);
        panel.add(this.setOnPanel(snetCheckBox, "S-net"));
        JCheckBox adtCheckBox = new JCheckBox();
        adtCheckBox.setBounds(posX + 10, posY + 90, 150, 20);
        adtCheckBox.addActionListener(actionEvent -> this.checkBoxAction(actionEvent, adtCheckBox, panel, 2));
        adtCheckBox.setSelected(false);
        adtCheckBox.addItemListener(itemListener);
        panel.add(this.setOnPanel(adtCheckBox, "T-net"));
        JCheckBox ssnetCheckBox = new JCheckBox();
        ssnetCheckBox.setBounds(posX + 10, posY + 120, 150, 20);
        ssnetCheckBox.addActionListener(actionEvent -> this.checkBoxAction(actionEvent, ssnetCheckBox, panel, 3));
        ssnetCheckBox.setSelected(false);
        ssnetCheckBox.addItemListener(itemListener);
        panel.add(this.setOnPanel(ssnetCheckBox, "connected ADT"));
        JCheckBox mctCheckBox = new JCheckBox();
        mctCheckBox.setBounds(posX + 10, posY + 150, 150, 20);
        mctCheckBox.addActionListener(actionEvent -> this.checkBoxAction(actionEvent, mctCheckBox, panel, 10));
        mctCheckBox.setSelected(false);
        mctCheckBox.addItemListener(itemListener);
        panel.add(this.setOnPanel(mctCheckBox, "maximal ADT (MCT)"));
        JCheckBox smcCheckBox = new JCheckBox();
        smcCheckBox.setBounds(posX + 10, posY + 330, 150, 20);
        smcCheckBox.addActionListener(actionEvent -> this.checkBoxAction(actionEvent, smcCheckBox, panel, 9));
        smcCheckBox.setSelected(false);
        smcCheckBox.addItemListener(itemListener);
        panel.add(this.setOnPanel(smcCheckBox, "State Machine Component (P1/S1-net)"));
        JLabel unprop = new JLabel("Other Decompositions", 0);
        panel.add(unprop);
        JCheckBox tinvCheckBox = new JCheckBox();
        tinvCheckBox.setBounds(posX + 10, posY + 360, 150, 20);
        tinvCheckBox.addActionListener(actionEvent -> this.checkBoxAction(actionEvent, tinvCheckBox, panel, 11));
        tinvCheckBox.setSelected(false);
        tinvCheckBox.addItemListener(itemListener);
        panel.add(this.setOnPanel(tinvCheckBox, "T-component (t-inv.)"));
        JCheckBox pinvCheckBox = new JCheckBox();
        pinvCheckBox.setBounds(posX + 10, posY + 390, 150, 20);
        pinvCheckBox.addActionListener(actionEvent -> this.checkBoxAction(actionEvent, pinvCheckBox, panel, 12));
        pinvCheckBox.setSelected(false);
        pinvCheckBox.addItemListener(itemListener);
        panel.add(this.setOnPanel(pinvCheckBox, "S-component (p-inv.)"));
        JCheckBox tzCheckBox = new JCheckBox();
        tzCheckBox.setBounds(posX + 10, posY + 180, 150, 20);
        tzCheckBox.addActionListener(actionEvent -> this.checkBoxAction(actionEvent, tzCheckBox, panel, 4));
        tzCheckBox.setSelected(false);
        tzCheckBox.addItemListener(itemListener);
        panel.add(this.setOnPanel(tzCheckBox, "Teng-Zeng subnets"));
        JCheckBox houCheckBox = new JCheckBox();
        houCheckBox.setBounds(posX + 10, posY + 210, 150, 20);
        houCheckBox.addActionListener(actionEvent -> this.checkBoxAction(actionEvent, houCheckBox, panel, 5));
        houCheckBox.setSelected(false);
        houCheckBox.addItemListener(itemListener);
        panel.add(this.setOnPanel(houCheckBox, "All source-sink paths"));
        JCheckBox nishiCheckBox = new JCheckBox();
        nishiCheckBox.setBounds(posX + 10, posY + 240, 150, 20);
        nishiCheckBox.addActionListener(actionEvent -> this.checkBoxAction(actionEvent, nishiCheckBox, panel, 6));
        nishiCheckBox.setSelected(false);
        nishiCheckBox.setToolTipText("Augmented Sequential Paths");
        nishiCheckBox.addItemListener(itemListener);
        panel.add(this.setOnPanel(nishiCheckBox, "Augmented Sequential Paths"));
        JCheckBox cycleCheckBox = new JCheckBox();
        cycleCheckBox.setBounds(posX + 10, posY + 270, 150, 20);
        cycleCheckBox.addActionListener(actionEvent -> this.checkBoxAction(actionEvent, cycleCheckBox, panel, 7));
        cycleCheckBox.setSelected(false);
        cycleCheckBox.addItemListener(itemListener);
        panel.add(this.setOnPanel(cycleCheckBox, "Cycles"));
        JCheckBox bvCheckBox = new JCheckBox("BV");
        bvCheckBox.setBounds(posX + 10, posY + 420, 150, 20);
        bvCheckBox.addActionListener(actionEvent -> this.checkBoxAction(actionEvent, bvCheckBox, panel, 13));
        bvCheckBox.setSelected(false);
        JCheckBox btCheckBox = new JCheckBox("BT");
        btCheckBox.setBounds(posX + 10, posY + 450, 150, 20);
        btCheckBox.addActionListener(actionEvent -> this.checkBoxAction(actionEvent, btCheckBox, panel, 14));
        btCheckBox.setSelected(false);
        JCheckBox bpCheckBox = new JCheckBox("BP");
        bpCheckBox.setBounds(posX + 10, posY + 480, 150, 20);
        bpCheckBox.addActionListener(actionEvent -> this.checkBoxAction(actionEvent, bpCheckBox, panel, 15));
        bpCheckBox.setSelected(false);
        JCheckBox ntzcCheckBox = new JCheckBox("Not SS cycle");
        ntzcCheckBox.setBounds(posX + 10, posY + 510, 150, 20);
        ntzcCheckBox.addActionListener(actionEvent -> this.checkBoxAction(actionEvent, ntzcCheckBox, panel, 16));
        ntzcCheckBox.setSelected(false);
        this.listOfCheckBoxs.add(functionalCheckBox);
        this.listOfCheckBoxs.add(snetCheckBox);
        this.listOfCheckBoxs.add(ssnetCheckBox);
        this.listOfCheckBoxs.add(adtCheckBox);
        this.listOfCheckBoxs.add(mctCheckBox);
        this.listOfCheckBoxs.add(tzCheckBox);
        this.listOfCheckBoxs.add(nishiCheckBox);
        this.listOfCheckBoxs.add(houCheckBox);
        this.listOfCheckBoxs.add(cycleCheckBox);
        this.listOfCheckBoxs.add(smcCheckBox);
        return panel;
    }

    private JPanel setOnPanel(JCheckBox functionalCheckBox, String text) {
        JPanel p = new JPanel(new BorderLayout());
        p.add((Component)new JLabel(text, 2), "West");
        p.add((Component)functionalCheckBox, "East");
        p.setBorder(BorderFactory.createLineBorder(Color.lightGray));
        return p;
    }

    public void checkBoxAction(ActionEvent actionEvent, JCheckBox checkBox, JPanel panel, Integer type) {
        AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
        if (!this.dualMode) {
            for (JCheckBox box : this.listOfCheckBoxs) {
                if (checkBox.equals(box)) continue;
                box.setSelected(false);
            }
            this.choosenDeco.clear();
            this.choosenDeco.add(type);
        } else {
            if (checkBox.isSelected()) {
                this.choosenDeco.add(type);
            } else {
                this.choosenDeco.remove(type);
            }
            if (this.choosenDeco.size() > 2) {
                checkBox.setSelected(false);
                this.choosenDeco.remove(type);
            }
        }
    }

    private JPanel createInfoPanel(int x, int y, int width, int height) {
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        panel.setBorder(BorderFactory.createTitledBorder("Info"));
        panel.setLocation(x, y);
        panel.setPreferredSize(new Dimension(width, height));
        int posX = 10;
        int posY = 10;
        GridBagConstraints c = new GridBagConstraints();
        JLabel fs1 = new JLabel("FIRST SUBNET");
        fs1.setLayout(new GridLayout());
        fs1.setEnabled(true);
        c.fill = 2;
        c.gridx = 0;
        c.gridy = 4;
        panel.add((Component)fs1, c);
        JLabel fs2 = new JLabel("Number of arcs");
        fs2.setLayout(new GridLayout());
        fs2.setEnabled(true);
        c.fill = 2;
        c.gridx = 0;
        c.gridy = 5;
        panel.add((Component)fs2, c);
        JLabel fs3 = new JLabel("Number of places");
        fs3.setLayout(new GridLayout());
        fs3.setEnabled(true);
        c.fill = 2;
        c.gridx = 0;
        c.gridy = 6;
        panel.add((Component)fs3, c);
        JLabel fs4 = new JLabel("Number of transitions");
        fs4.setLayout(new GridLayout());
        fs4.setEnabled(true);
        c.fill = 2;
        c.gridx = 0;
        c.gridy = 7;
        panel.add((Component)fs4, c);
        JSeparator separ = new JSeparator();
        separ.setLayout(new GridLayout());
        separ.setEnabled(true);
        c.fill = 2;
        c.gridx = 0;
        c.gridy = 8;
        panel.add((Component)separ, c);
        JLabel ss1 = new JLabel("SECOND SUBNET");
        ss1.setLayout(new GridLayout());
        ss1.setEnabled(true);
        c.fill = 2;
        c.gridx = 0;
        c.gridy = 9;
        panel.add((Component)ss1, c);
        JLabel ss2 = new JLabel("Number of arcs");
        ss2.setLayout(new GridLayout());
        ss2.setEnabled(true);
        c.fill = 2;
        c.gridx = 0;
        c.gridy = 10;
        panel.add((Component)ss2, c);
        JLabel ss3 = new JLabel("Number of places");
        ss3.setLayout(new GridLayout());
        ss3.setEnabled(true);
        c.fill = 2;
        c.gridx = 0;
        c.gridy = 11;
        panel.add((Component)ss3, c);
        JLabel ss4 = new JLabel("Number of transitions");
        ss4.setLayout(new GridLayout());
        ss4.setEnabled(true);
        c.fill = 2;
        c.gridx = 0;
        c.gridy = 12;
        panel.add((Component)ss4, c);
        JSeparator separ2 = new JSeparator();
        separ2.setLayout(new GridLayout());
        separ2.setEnabled(true);
        c.fill = 2;
        c.gridx = 0;
        c.gridy = 13;
        panel.add((Component)separ2, c);
        JLabel cs1 = new JLabel("COMMON SUBNET");
        cs1.setLayout(new GridLayout());
        cs1.setEnabled(true);
        c.fill = 2;
        c.gridx = 0;
        c.gridy = 14;
        panel.add((Component)cs1, c);
        JLabel cs2 = new JLabel("Number of arcs");
        cs2.setLayout(new GridLayout());
        cs2.setEnabled(true);
        c.fill = 2;
        c.gridx = 0;
        c.gridy = 15;
        panel.add((Component)cs2, c);
        JLabel cs3 = new JLabel("Number of places");
        cs3.setLayout(new GridLayout());
        cs3.setEnabled(true);
        c.fill = 2;
        c.gridx = 0;
        c.gridy = 16;
        panel.add((Component)cs3, c);
        JLabel cs4 = new JLabel("Number of transitions");
        cs4.setLayout(new GridLayout());
        cs4.setEnabled(true);
        c.fill = 2;
        c.gridx = 0;
        c.gridy = 17;
        panel.add((Component)cs4, c);
        JSeparator separ3 = new JSeparator();
        separ3.setLayout(new GridLayout());
        separ3.setEnabled(true);
        c.fill = 2;
        c.gridx = 0;
        c.gridy = 18;
        panel.add((Component)separ3, c);
        JLabel in0 = new JLabel("SMC Index");
        in0.setLayout(new GridLayout());
        in0.setEnabled(true);
        c.fill = 2;
        c.gridx = 0;
        c.gridy = 19;
        panel.add((Component)in0, c);
        JLabel in1 = new JLabel("S\u00f8rensen Index");
        in1.setLayout(new GridLayout());
        in1.setEnabled(true);
        c.fill = 2;
        c.gridx = 0;
        c.gridy = 20;
        panel.add((Component)in1, c);
        JLabel in2 = new JLabel("Jaccard  Index");
        in2.setLayout(new GridLayout());
        in2.setEnabled(true);
        c.fill = 2;
        c.gridx = 0;
        c.gridy = 21;
        panel.add((Component)in2, c);
        this.vafn = new JLabel(String.valueOf(this.nafn));
        this.vafn.setLayout(new GridLayout());
        this.vafn.setEnabled(true);
        c.fill = 2;
        c.gridx = 2;
        c.gridy = 5;
        panel.add((Component)this.vafn, c);
        this.vpfn = new JLabel(String.valueOf(this.npfn));
        this.vafn.setLayout(new GridLayout());
        this.vpfn.setEnabled(true);
        c.fill = 2;
        c.gridx = 2;
        c.gridy = 6;
        panel.add((Component)this.vpfn, c);
        this.vtfn = new JLabel(String.valueOf(this.ntfn));
        this.vtfn.setLayout(new GridLayout());
        this.vtfn.setEnabled(true);
        c.fill = 2;
        c.gridx = 2;
        c.gridy = 7;
        panel.add((Component)this.vtfn, c);
        this.vasn = new JLabel(String.valueOf(this.nasn));
        this.vasn.setLayout(new GridLayout());
        this.vasn.setEnabled(true);
        c.fill = 2;
        c.gridx = 2;
        c.gridy = 10;
        panel.add((Component)this.vasn, c);
        this.vpsn = new JLabel(String.valueOf(this.npsn));
        this.vpsn.setLayout(new GridLayout());
        this.vpsn.setEnabled(true);
        c.fill = 2;
        c.gridx = 2;
        c.gridy = 11;
        panel.add((Component)this.vpsn, c);
        this.vtsn = new JLabel(String.valueOf(this.ntsn));
        this.vtsn.setLayout(new GridLayout());
        this.vtsn.setEnabled(true);
        c.fill = 2;
        c.gridx = 2;
        c.gridy = 12;
        panel.add((Component)this.vtsn, c);
        this.vacn = new JLabel(String.valueOf(this.nacn));
        this.vacn.setLayout(new GridLayout());
        this.vacn.setEnabled(true);
        c.fill = 2;
        c.gridx = 2;
        c.gridy = 15;
        panel.add((Component)this.vacn, c);
        this.vpcn = new JLabel(String.valueOf(this.npcn));
        this.vpcn.setLayout(new GridLayout());
        this.vpcn.setEnabled(true);
        c.fill = 2;
        c.gridx = 2;
        c.gridy = 16;
        panel.add((Component)this.vpcn, c);
        this.vtcn = new JLabel(String.valueOf(this.ntcn));
        this.vtcn.setLayout(new GridLayout());
        this.vtcn.setEnabled(true);
        c.fill = 2;
        c.gridx = 2;
        c.gridy = 17;
        panel.add((Component)this.vtcn, c);
        this.valueOfSMC = new JLabel(String.valueOf(this.smc));
        this.valueOfSMC.setLayout(new GridLayout());
        this.valueOfSMC.setEnabled(true);
        c.fill = 2;
        c.gridx = 2;
        c.gridy = 19;
        panel.add((Component)this.valueOfSMC, c);
        this.valueOfSorensenIndex = new JLabel(String.valueOf(this.sorenIndex));
        this.valueOfSorensenIndex.setLayout(new GridLayout());
        this.valueOfSorensenIndex.setEnabled(true);
        c.fill = 2;
        c.gridx = 2;
        c.gridy = 20;
        panel.add((Component)this.valueOfSorensenIndex, c);
        this.valueOfJackobsenIndex = new JLabel(String.valueOf(this.jackobIndex));
        this.valueOfJackobsenIndex.setLayout(new GridLayout());
        this.valueOfJackobsenIndex.setEnabled(true);
        c.fill = 2;
        c.gridx = 2;
        c.gridy = 21;
        panel.add((Component)this.valueOfJackobsenIndex, c);
        return panel;
    }

    private JPanel createTopButtonPanel(int x, int y, int width, int height) {
        JPanel panel = new JPanel(new GridLayout(1, 4));
        panel.setBorder(BorderFactory.createTitledBorder("Options"));
        panel.setLocation(x, y);
        panel.setPreferredSize(new Dimension(width, height));
        int posX = 10;
        int posY = 20;
        JButton expDecoButton = new JButton("<html>Decompose</html>");
        expDecoButton.setBounds(posX, posY, 120, 36);
        expDecoButton.setMargin(new Insets(0, 0, 0, 0));
        expDecoButton.setIcon(Tools.getResIcon32("/icons/stateSim/computeData.png"));
        expDecoButton.addActionListener(actionEvent -> this.calculateDeco());
        expDecoButton.setFocusPainted(false);
        panel.add(expDecoButton);
        JCheckBox dualCheckBox = new JCheckBox();
        dualCheckBox.setBounds(posX + 300, posY + 10, 250, 20);
        dualCheckBox.addActionListener(actionEvent -> this.setDual());
        dualCheckBox.setSelected(false);
        panel.add(this.setOnPanel(dualCheckBox, "Compare two decompositions"));
        JButton compButton = new JButton("Compare");
        compButton.setBounds(posX + 620, posY, 120, 36);
        compButton.setMargin(new Insets(0, 0, 0, 0));
        compButton.addActionListener(actionEvent -> this.compareSubnets());
        compButton.setFocusPainted(false);
        compButton.setEnabled(true);
        panel.add(compButton);
        JButton infoButton = new JButton("Info");
        infoButton.setBounds(posX + 750, posY, 120, 36);
        infoButton.setMargin(new Insets(0, 0, 0, 0));
        infoButton.setIcon(Tools.getResIcon32("icons/stateSim/showNotepad.png"));
        infoButton.addActionListener(actionEvent -> this.showInfo());
        infoButton.setFocusPainted(false);
        infoButton.setEnabled(true);
        return panel;
    }

    private JPanel createGraphPanel(int x, int y, int width, int height) {
        JPanel panel = new JPanel();
        panel.setLayout(null);
        panel.setBorder(BorderFactory.createTitledBorder("Subnets"));
        panel.setLocation(x, y);
        panel.setPreferredSize(new Dimension(width, height));
        JPanel listPanel = new JPanel();
        this.listModel.addElement("--");
        this.decoListOne = new JList(this.listModel);
        this.decoListOne.setSelectionMode(0);
        this.decoListOne.addListSelectionListener(evt -> {
            int cimboboxSize;
            JList comboBox = (JList)evt.getSource();
            int selected = comboBox.getSelectedIndex();
            int subnetsize = this.getSubnetSize(this.choosenDeco.get(0));
            if (subnetsize + 3 == (cimboboxSize = comboBox.getModel().getSize())) {
                if (selected == 0) {
                    this.selectedSubNetindex = -1;
                    this.allSubNetsselected = false;
                    this.showSubNet(this.choosenDeco.get(0));
                } else if (selected == comboBox.getModel().getSize() - 1) {
                    this.allSubNetsselected = true;
                    this.showAllSubColors(true, this.choosenDeco.get(0));
                } else if (selected == comboBox.getModel().getSize() - 2) {
                    this.allSubNetsselected = true;
                    this.showAllSubColors(false, this.choosenDeco.get(0));
                } else if (this.dualMode) {
                    if (!this.decoListTwo.isSelectionEmpty()) {
                        this.showTwoSubnets();
                    }
                } else {
                    this.selectedSubNetindex = selected - 1;
                    this.allSubNetsselected = false;
                    this.showSubNet(this.choosenDeco.get(0));
                }
            } else if (selected == 0) {
                this.selectedSubNetindex = -1;
                this.allSubNetsselected = false;
                this.showSubNet(this.choosenDeco.get(0));
            } else if (selected == comboBox.getModel().getSize() - 1) {
                this.allSubNetsselected = true;
                this.showCoverageColors(this.choosenDeco.get(0));
            } else if (this.dualMode) {
                if (!this.decoListTwo.isSelectionEmpty()) {
                    this.showTwoSubnets();
                }
            } else {
                this.selectedSubNetindex = selected - 1;
                this.allSubNetsselected = false;
                this.showSubNet(this.choosenDeco.get(0));
            }
        });
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        JScrollPane jsp = new JScrollPane(this.decoListOne);
        this.decoListOne.setLayoutOrientation(0);
        listPanel.setLayout(new GridBagLayout());
        listPanel.add((Component)jsp, c);
        this.listModelTwo.addElement("--");
        this.decoListTwo = new JList(this.listModelTwo);
        this.decoListTwo.setSelectionMode(0);
        this.decoListTwo.addListSelectionListener(evt -> {
            int cimboboxSize;
            JList comboBox = (JList)evt.getSource();
            int selected = comboBox.getSelectedIndex();
            int subnetsize = this.getSubnetSize(this.choosenDeco.size() - 1);
            if (subnetsize + 3 == (cimboboxSize = comboBox.getModel().getSize())) {
                if (selected == 0) {
                    this.selectedSecondSubNetindex = -1;
                    this.allSubNetsselected = false;
                    this.showSubNet(this.choosenDeco.get(this.choosenDeco.size() - 1));
                } else if (selected == comboBox.getModel().getSize() - 1) {
                    this.allSubNetsselected = true;
                    this.showAllSubColors(true, this.choosenDeco.get(this.choosenDeco.size() - 1));
                } else if (selected == comboBox.getModel().getSize() - 2) {
                    this.allSubNetsselected = true;
                    this.showAllSubColors(false, this.choosenDeco.get(this.choosenDeco.size() - 1));
                } else if (!this.decoListOne.isSelectionEmpty()) {
                    this.showTwoSubnets();
                }
            } else if (selected == 0) {
                this.selectedSubNetindex = -1;
                this.allSubNetsselected = false;
                this.showSubNet(this.choosenDeco.size() - 1);
            } else if (selected == comboBox.getModel().getSize() - 1) {
                this.allSubNetsselected = true;
                this.showCoverageColors(this.choosenDeco.size() - 1);
            } else if (this.dualMode) {
                if (!this.decoListTwo.isSelectionEmpty()) {
                    this.showTwoSubnets();
                }
            } else {
                this.selectedSubNetindex = selected - 1;
                this.allSubNetsselected = false;
                this.showSubNet(this.choosenDeco.size() - 1);
            }
        });
        this.decoListTwo.disable();
        this.decoListTwo.hide();
        this.decoListTwo.setForeground(Color.blue);
        panel.add(this.decoListTwo);
        JPanel listPanel2 = new JPanel();
        JScrollPane jsp2 = new JScrollPane(this.decoListTwo);
        jsp2.setViewportView(this.decoListTwo);
        this.decoListTwo.setLayoutOrientation(0);
        listPanel2.setLayout(new GridBagLayout());
        listPanel2.add((Component)jsp2, c);
        listPanel2.setVisible(true);
        listPanel.setVisible(true);
        this.add(listPanel);
        this.add(listPanel2);
        panel.add(listPanel);
        panel.add(listPanel2);
        panel.setLayout(new GridLayout());
        return panel;
    }

    private void setDual() {
        if (!this.dualMode) {
            this.dualMode = true;
            this.decoListTwo.enable();
            this.decoListTwo.show();
            this.decoListOne.setForeground(Color.RED);
        } else {
            this.dualMode = false;
            this.decoListTwo.disable();
            this.decoListTwo.hide();
            this.decoListOne.setForeground(Color.BLACK);
            this.choosenDeco.clear();
            for (JCheckBox b : this.listOfCheckBoxs) {
                b.setSelected(false);
            }
        }
    }

    private void calculateDeco() {
        SubnetCalculator.cleanSubnets();
        this.getSubnetOfType();
    }

    private void calcWhat1() {
        ArrayList<SubnetCalculator.SubNet> deco = this.getCorrectSubnet(this.choosenDeco.get(0));
        ArrayList<int[][]> subMatrix = new ArrayList<int[][]>();
        for (SubnetCalculator.SubNet subnet : deco) {
            subMatrix.add(DecoComparisonCalculator.subIncMat(subnet).getMatrix());
        }
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter("decoMacierze.txt"));
            for (int i = 0; i < subMatrix.size(); ++i) {
                bw.write("sub: " + i);
                bw.newLine();
                for (int j = 0; j < ((int[][])subMatrix.get(i)).length; ++j) {
                    for (int k = 0; k < ((int[][])subMatrix.get(i))[j].length; ++k) {
                        if (k == ((int[][])subMatrix.get(i))[j].length - 1) {
                            bw.write("" + ((int[][])subMatrix.get(i))[j][k]);
                            continue;
                        }
                        bw.write(((int[][])subMatrix.get(i))[j][k] + " ");
                    }
                    bw.newLine();
                }
                bw.newLine();
            }
            bw.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void calcWhat2() {
        Color cl;
        SubnetCalculator.generateMCT();
        SubnetCalculator.SubNet subnet = SubnetCalculator.mctSubNets.get(11);
        int size = SubnetCalculator.mctSubNets.size();
        ColorPalette cp = new ColorPalette();
        for (int i = 0; i < SubnetCalculator.adtSubNets.size(); ++i) {
            if (!subnet.getSubPlaces().containsAll(SubnetCalculator.adtSubNets.get(i).getSubPlaces())) continue;
            cl = cp.getColor(i);
            System.out.println("dla i r\u00f3wnego : " + i + " - B " + cl.getBlue() + " G " + cl.getGreen() + "R" + cl.getRed());
            for (Place place : SubnetCalculator.adtSubNets.get(i).getSubInternalPlaces()) {
                place.drawGraphBoxP.setColorWithNumber(true, cp.getColor(i), false, 0.0, true, "[Sub net " + (i + 1) + "]");
            }
            for (Place place : SubnetCalculator.adtSubNets.get(i).getSubBorderPlaces()) {
                place.drawGraphBoxP.setColorWithNumber(true, Color.lightGray, false, 0.0, true, "[Sub net " + (i + 1) + "]");
            }
        }
        for (Arc arc : subnet.getSubArcs()) {
            if (this.colorSubNet) continue;
            arc.setGlowedSub(true);
        }
        for (int i = 0; i < SubnetCalculator.adtSubNets.size(); ++i) {
            if (!subnet.getSubTransitions().containsAll(SubnetCalculator.adtSubNets.get(i).getSubTransitions())) continue;
            cl = cp.getColor(i);
            System.out.println("dla i r\u00f3wnego : " + i + " - B " + cl.getBlue() + " G " + cl.getGreen() + "R" + cl.getRed());
            for (Transition transition : SubnetCalculator.adtSubNets.get(i).getSubTransitions()) {
                transition.drawGraphBoxT.setColorWithNumber(true, cl, false, 0.0, true, "[Sub net " + (i + 1) + "]");
            }
        }
        this.overlord.getWorkspace().getProject().getNodes().retainAll(subnet.getSubNode());
        this.overlord.getWorkspace().getProject().getArcs().retainAll(subnet.getSubArcs());
        this.overlord.getWorkspace().getProject().repaintAllGraphPanels();
        if (this.overlord.getWorkspace().getProject().accessSubNetNames() != null) {
            String name = this.overlord.getWorkspace().getProject().accessSubNetNames().get(this.selectedSubNetindex);
            this.elementsOfDecomposedStructure.setText(name);
        }
    }

    private void compareSubnets() {
        GUIManager.getDefaultGUIManager().createComparisonnWindow();
        GUIManager.getDefaultGUIManager().showCompWindow();
    }

    private void getSubnetOfType() {
        if (this.choosenDeco.isEmpty()) {
            JOptionPane.showMessageDialog(null, "Empty list", "WARNING MESSAGE", 2);
        } else {
            this.generateProperSubNet(this.choosenDeco.get(0));
            JList newCB = this.generateButton(this.choosenDeco.get(0));
            this.decoListOne.setModel(newCB.getModel());
            if (this.listOfInvDep.contains(this.choosenDeco.get(0)) && this.getSubnetSize(this.choosenDeco.get(0)) == 0) {
                GUIManager.getDefaultGUIManager().showInvariantsWindow();
            }
            if (this.dualMode) {
                if (this.choosenDeco.size() > 1) {
                    this.generateProperSubNet(this.choosenDeco.get(this.choosenDeco.size() - 1));
                }
                JList secondnewCB = this.generateButton(this.choosenDeco.get(this.choosenDeco.size() - 1));
                this.decoListTwo.setModel(secondnewCB.getModel());
            }
        }
        this.logMainPanel.updateUI();
        this.repaint();
    }

    private void generateProperSubNet(int index) {
        SubnetCalculator.compileElements();
        switch (index) {
            case 0: {
                SubnetCalculator.generateFS();
                break;
            }
            case 1: {
                SubnetCalculator.generateSnets();
                break;
            }
            case 2: {
                SubnetCalculator.generateTnets();
                break;
            }
            case 3: {
                SubnetCalculator.generateADT();
                break;
            }
            case 4: {
                SubnetCalculator.generateTZ();
                break;
            }
            case 5: {
                SubnetCalculator.generateHou();
                break;
            }
            case 6: {
                SubnetCalculator.generateNishi();
                break;
            }
            case 7: {
                SubnetCalculator.generateCycle(false);
                break;
            }
            case 8: {
                SubnetCalculator.generateOotsuki();
                break;
            }
            case 9: {
                SubnetCalculator.generateSMC();
                break;
            }
            case 10: {
                SubnetCalculator.generateMCT();
                break;
            }
            case 11: {
                SubnetCalculator.generateTInv();
                break;
            }
            case 12: {
                SubnetCalculator.generatePInv();
                break;
            }
            case 13: {
                SubnetCalculator.generateBranchesVerticles();
                break;
            }
            case 14: {
                SubnetCalculator.generateBranchesTransitions();
                break;
            }
            case 15: {
                SubnetCalculator.generateBranchesPlaces();
                break;
            }
            case 16: {
                SubnetCalculator.generateNotTzCycles();
            }
        }
    }

    private int getSubnetSize(int index) {
        return switch (index) {
            case 0 -> SubnetCalculator.functionalSubNets.size();
            case 1 -> SubnetCalculator.snetSubNets.size();
            case 2 -> SubnetCalculator.tnetSubNets.size();
            case 3 -> SubnetCalculator.adtSubNets.size();
            case 4 -> SubnetCalculator.tzSubNets.size();
            case 5 -> SubnetCalculator.houSubNets.size();
            case 6 -> SubnetCalculator.nishiSubNets.size();
            case 7 -> SubnetCalculator.cycleSubNets.size();
            case 8 -> SubnetCalculator.ootsukiSubNets.size();
            case 9 -> SubnetCalculator.smcSubNets.size();
            case 10 -> SubnetCalculator.mctSubNets.size();
            case 11 -> SubnetCalculator.tinvSubNets.size();
            case 12 -> SubnetCalculator.pinvSubNets.size();
            case 13 -> SubnetCalculator.bvSubNets.size();
            case 14 -> SubnetCalculator.btSubNets.size();
            case 15 -> SubnetCalculator.bpSubNets.size();
            case 16 -> SubnetCalculator.notTzCyclesiSubNets.size();
            default -> 0;
        };
    }

    private String getProperSubNetName(int index) {
        return switch (index) {
            case 0 -> "Functional ";
            case 1 -> "S-net ";
            case 2 -> "T-net ";
            case 3 -> "connected ADT ";
            case 4 -> "Teng-Zeng subnet ";
            case 5 -> "Path ";
            case 6 -> "Augmented Seqential Path ";
            case 7 -> "Cycle ";
            case 8 -> "Ootsuki ";
            case 9 -> "SMC ";
            case 10 -> "MCT ";
            case 11 -> "T-inv";
            case 12 -> "P-inv";
            case 13 -> "Branch Vertices";
            case 14 -> "Branch Transitions";
            case 15 -> "Branch Places";
            case 16 -> "Not SS cycle";
            default -> "";
        };
    }

    private ArrayList<SubnetCalculator.SubNet> getCorrectSubnet(int type) {
        return switch (type) {
            case 0 -> SubnetCalculator.functionalSubNets;
            case 1 -> SubnetCalculator.snetSubNets;
            case 2 -> SubnetCalculator.tnetSubNets;
            case 3 -> SubnetCalculator.adtSubNets;
            case 4 -> SubnetCalculator.tzSubNets;
            case 5 -> SubnetCalculator.houSubNets;
            case 6 -> SubnetCalculator.nishiSubNets;
            case 7 -> SubnetCalculator.cycleSubNets;
            case 8 -> SubnetCalculator.ootsukiSubNets;
            case 9 -> SubnetCalculator.smcSubNets;
            case 10 -> SubnetCalculator.mctSubNets;
            case 11 -> SubnetCalculator.tinvSubNets;
            case 12 -> SubnetCalculator.pinvSubNets;
            case 13 -> SubnetCalculator.bvSubNets;
            case 14 -> SubnetCalculator.btSubNets;
            case 15 -> SubnetCalculator.bpSubNets;
            case 16 -> SubnetCalculator.notTzCyclesiSubNets;
            default -> SubnetCalculator.functionalSubNets;
        };
    }

    private JList generateButton(int index) {
        return switch (index) {
            case 0, 1, 2, 3, 8, 10 -> this.generateProperDecoButton(index);
            case 4, 5, 6, 7, 9, 11, 12, 13, 14, 15, 16 -> this.generateInProperDecoButton(index);
            default -> this.generateProperDecoButton(index);
        };
    }

    private JList generateProperDecoButton(int index) {
        int size = this.getSubnetSize(index);
        String[] newComoList = new String[size + 3];
        for (int i = 0; i < size; ++i) {
            newComoList[i + 1] = this.getProperSubNetName(index) + i;
            this.listModel.addElement(this.getProperSubNetName(index) + i);
        }
        newComoList[0] = "--";
        newComoList[size + 1] = "All non trivial subnets";
        newComoList[size + 2] = "All subnets";
        JList<String> newCB = new JList<String>(newComoList);
        newCB.setBounds(10, 70, 150, 20);
        newCB.addListSelectionListener(actionEvent -> {
            JComboBox comboBox = (JComboBox)actionEvent.getSource();
            int selected = comboBox.getSelectedIndex();
            if (selected == 0) {
                this.selectedSubNetindex = -1;
                this.allSubNetsselected = false;
                this.showSubNet(index);
                this.elementsOfDecomposedStructure.setText("");
            } else if (selected == comboBox.getItemCount() - 1) {
                this.allSubNetsselected = true;
                this.showAllSubColors(true, index);
            } else if (selected == comboBox.getItemCount() - 2) {
                this.allSubNetsselected = true;
                this.showAllSubColors(false, index);
            } else {
                this.selectedSubNetindex = selected - 1;
                this.allSubNetsselected = false;
                this.showSubNet(index);
            }
        });
        newCB.setVisible(true);
        return newCB;
    }

    private JList generateInProperDecoButton(int index) {
        int size = this.getSubnetSize(index);
        String[] newComoList = new String[size + 2];
        for (int i = 0; i < size; ++i) {
            newComoList[i + 1] = this.getProperSubNetName(index) + i;
        }
        newComoList[0] = "--";
        newComoList[size + 1] = "Net coverage";
        JList<String> newCB = new JList<String>(newComoList);
        newCB.setBounds(10, 70, 150, 20);
        newCB.addListSelectionListener(actionEvent -> {
            JComboBox comboBox = (JComboBox)actionEvent.getSource();
            int selected = comboBox.getSelectedIndex();
            if (selected == 0) {
                this.selectedSubNetindex = -1;
                this.allSubNetsselected = false;
                this.showSubNet(index);
                this.elementsOfDecomposedStructure.setText("");
            } else if (selected == comboBox.getItemCount() - 1) {
                this.allSubNetsselected = true;
                this.showCoverageColors(index);
            } else {
                this.selectedSubNetindex = selected - 1;
                this.allSubNetsselected = false;
                this.showSubNet(index);
            }
        });
        newCB.setVisible(true);
        return newCB;
    }

    private void showSubNet(int typeOfDecomposition) {
        PetriNet pn = this.overlord.getWorkspace().getProject();
        pn.resetNetColors();
        if (this.selectedSubNetindex == -1) {
            return;
        }
        SubnetCalculator.SubNet subnet = null;
        int size = 0;
        switch (typeOfDecomposition) {
            case 0: {
                subnet = SubnetCalculator.functionalSubNets.get(this.selectedSubNetindex);
                size = SubnetCalculator.functionalSubNets.size();
                break;
            }
            case 1: {
                subnet = SubnetCalculator.snetSubNets.get(this.selectedSubNetindex);
                size = SubnetCalculator.snetSubNets.size();
                break;
            }
            case 2: {
                subnet = SubnetCalculator.tnetSubNets.get(this.selectedSubNetindex);
                size = SubnetCalculator.tnetSubNets.size();
                break;
            }
            case 3: {
                subnet = SubnetCalculator.adtSubNets.get(this.selectedSubNetindex);
                size = SubnetCalculator.adtSubNets.size();
                break;
            }
            case 4: {
                subnet = SubnetCalculator.tzSubNets.get(this.selectedSubNetindex);
                size = SubnetCalculator.tzSubNets.size();
                break;
            }
            case 5: {
                subnet = SubnetCalculator.houSubNets.get(this.selectedSubNetindex);
                size = SubnetCalculator.houSubNets.size();
                break;
            }
            case 6: {
                subnet = SubnetCalculator.nishiSubNets.get(this.selectedSubNetindex);
                size = SubnetCalculator.nishiSubNets.size();
                break;
            }
            case 7: {
                subnet = SubnetCalculator.cycleSubNets.get(this.selectedSubNetindex);
                size = SubnetCalculator.cycleSubNets.size();
                break;
            }
            case 8: {
                subnet = SubnetCalculator.ootsukiSubNets.get(this.selectedSubNetindex);
                size = SubnetCalculator.ootsukiSubNets.size();
                break;
            }
            case 9: {
                subnet = SubnetCalculator.smcSubNets.get(this.selectedSubNetindex);
                size = SubnetCalculator.smcSubNets.size();
                break;
            }
            case 10: {
                subnet = SubnetCalculator.mctSubNets.get(this.selectedSubNetindex);
                size = SubnetCalculator.mctSubNets.size();
                break;
            }
            case 11: {
                subnet = SubnetCalculator.tinvSubNets.get(this.selectedSubNetindex);
                size = SubnetCalculator.tinvSubNets.size();
                break;
            }
            case 12: {
                subnet = SubnetCalculator.pinvSubNets.get(this.selectedSubNetindex);
                size = SubnetCalculator.pinvSubNets.size();
                break;
            }
            case 13: {
                subnet = SubnetCalculator.bvSubNets.get(this.selectedSubNetindex);
                size = SubnetCalculator.bvSubNets.size();
                break;
            }
            case 14: {
                subnet = SubnetCalculator.btSubNets.get(this.selectedSubNetindex);
                size = SubnetCalculator.btSubNets.size();
                break;
            }
            case 15: {
                subnet = SubnetCalculator.bpSubNets.get(this.selectedSubNetindex);
                size = SubnetCalculator.bpSubNets.size();
                break;
            }
            case 16: {
                subnet = SubnetCalculator.notTzCyclesiSubNets.get(this.selectedSubNetindex);
                size = SubnetCalculator.notTzCyclesiSubNets.size();
            }
        }
        ColorPalette cp = new ColorPalette();
        ArrayList<SubnetCalculator.SubNet> nety = this.getCorrectSubnet(typeOfDecomposition);
        for (int i = 0; i < size; ++i) {
            SubnetCalculator.SubNet sub = nety.get(i);
            System.out.println("Podsie\u0107 numer : " + i);
            System.out.println("Lista Tranzycji");
            for (Transition t : sub.getSubTransitions()) {
                System.out.println(t.getID() + " & " + t.getName() + "\\\\");
            }
            ArrayList borderPlaces = new ArrayList();
            for (int j = 0; j < size; ++j) {
                if (i == j) continue;
                ArrayList<Place> listaMiejsc = new ArrayList<Place>(sub.getSubPlaces());
                SubnetCalculator.SubNet subT = nety.get(j);
                listaMiejsc.retainAll(subT.getSubPlaces());
                borderPlaces.addAll(listaMiejsc);
            }
            ArrayList<Place> listaMiejsc = new ArrayList<Place>(sub.getSubPlaces());
            listaMiejsc.removeAll(borderPlaces);
            listaMiejsc.stream().distinct().collect(Collectors.toCollection(ArrayList::new));
            System.out.println("Lista miejsc");
            for (Place p : listaMiejsc) {
                System.out.println(p.getID() + " & " + p.getName() + "\\\\");
            }
            borderPlaces = borderPlaces.stream().distinct().collect(Collectors.toCollection(ArrayList::new));
            System.out.println("Lista miejsc granicznych");
            for (Place p : borderPlaces) {
                System.out.println(p.getID() + " & " + p.getName() + "\\\\");
            }
        }
        for (Place place : subnet.getSubPlaces()) {
            if (!this.colorSubNet) {
                place.setGlowedSub(true);
                continue;
            }
            if (this.selectedSubNetindex == size - 1) {
                place.drawGraphBoxP.setColorWithNumber(true, cp.getColor(this.selectedSubNetindex), false, 0.0, true, "[trivial]");
                continue;
            }
            place.drawGraphBoxP.setColorWithNumber(true, cp.getColor(this.selectedSubNetindex), false, 0.0, true, "[Sub net " + (this.selectedSubNetindex + 1) + "]");
        }
        for (Arc arc : subnet.getSubArcs()) {
            if (this.colorSubNet) continue;
            arc.setGlowedSub(true);
        }
        for (Transition transition : subnet.getSubTransitions()) {
            if (!this.colorSubNet) {
                transition.drawGraphBoxT.setGlowed_MTC(true);
                continue;
            }
            if (this.selectedSubNetindex == size - 1) {
                transition.drawGraphBoxT.setColorWithNumber(true, cp.getColor(this.selectedSubNetindex), false, 0.0, true, "[trivial]");
                continue;
            }
            transition.drawGraphBoxT.setColorWithNumber(true, cp.getColor(this.selectedSubNetindex), false, 0.0, true, "[Sub net " + (this.selectedSubNetindex + 1) + "]");
        }
        this.overlord.getWorkspace().getProject().repaintAllGraphPanels();
        if (this.overlord.getWorkspace().getProject().accessSubNetNames() != null) {
            String name = this.overlord.getWorkspace().getProject().accessSubNetNames().get(this.selectedSubNetindex);
            this.elementsOfDecomposedStructure.setText(name);
        }
    }

    private void showTwoSubnets() {
        this.npfn = 0;
        this.npsn = 0;
        this.npcn = 0;
        this.ntfn = 0;
        this.ntsn = 0;
        this.ntcn = 0;
        this.nafn = 0;
        this.nasn = 0;
        this.nacn = 0;
        int firsttype = this.decoListOne.getSelectedIndex();
        int secondtype = this.decoListTwo.getSelectedIndex();
        PetriNet pn = this.overlord.getWorkspace().getProject();
        pn.resetNetColors();
        SubnetCalculator.SubNet firstsubnet = null;
        boolean firstsize = false;
        switch (this.choosenDeco.get(0)) {
            case 0: {
                firstsubnet = SubnetCalculator.functionalSubNets.get(this.decoListOne.getSelectedIndex() - 1);
                break;
            }
            case 1: {
                firstsubnet = SubnetCalculator.snetSubNets.get(this.decoListOne.getSelectedIndex() - 1);
                break;
            }
            case 2: {
                firstsubnet = SubnetCalculator.tnetSubNets.get(this.decoListOne.getSelectedIndex() - 1);
                break;
            }
            case 3: {
                firstsubnet = SubnetCalculator.adtSubNets.get(this.decoListOne.getSelectedIndex() - 1);
                break;
            }
            case 4: {
                firstsubnet = SubnetCalculator.tzSubNets.get(this.decoListOne.getSelectedIndex() - 1);
                break;
            }
            case 5: {
                firstsubnet = SubnetCalculator.houSubNets.get(this.decoListOne.getSelectedIndex() - 1);
                break;
            }
            case 6: {
                firstsubnet = SubnetCalculator.nishiSubNets.get(this.decoListOne.getSelectedIndex() - 1);
                break;
            }
            case 7: {
                firstsubnet = SubnetCalculator.cycleSubNets.get(this.decoListOne.getSelectedIndex() - 1);
                break;
            }
            case 8: {
                firstsubnet = SubnetCalculator.ootsukiSubNets.get(this.decoListOne.getSelectedIndex() - 1);
                break;
            }
            case 9: {
                firstsubnet = SubnetCalculator.smcSubNets.get(this.decoListOne.getSelectedIndex() - 1);
                break;
            }
            case 10: {
                firstsubnet = SubnetCalculator.mctSubNets.get(this.decoListOne.getSelectedIndex() - 1);
                break;
            }
            case 11: {
                firstsubnet = SubnetCalculator.tinvSubNets.get(this.decoListOne.getSelectedIndex() - 1);
                break;
            }
            case 12: {
                firstsubnet = SubnetCalculator.pinvSubNets.get(this.decoListOne.getSelectedIndex() - 1);
                break;
            }
            case 13: {
                firstsubnet = SubnetCalculator.bvSubNets.get(this.decoListOne.getSelectedIndex() - 1);
                break;
            }
            case 14: {
                firstsubnet = SubnetCalculator.btSubNets.get(this.decoListOne.getSelectedIndex() - 1);
                break;
            }
            case 15: {
                firstsubnet = SubnetCalculator.bpSubNets.get(this.decoListOne.getSelectedIndex() - 1);
                break;
            }
            case 16: {
                firstsubnet = SubnetCalculator.notTzCyclesiSubNets.get(this.decoListOne.getSelectedIndex() - 1);
            }
        }
        SubnetCalculator.SubNet secondsubnet = null;
        boolean secondsize = false;
        switch (this.choosenDeco.get(this.choosenDeco.size() - 1)) {
            case 0: {
                secondsubnet = SubnetCalculator.functionalSubNets.get(this.decoListTwo.getSelectedIndex() - 1);
                break;
            }
            case 1: {
                secondsubnet = SubnetCalculator.snetSubNets.get(this.decoListTwo.getSelectedIndex() - 1);
                break;
            }
            case 2: {
                secondsubnet = SubnetCalculator.tnetSubNets.get(this.decoListTwo.getSelectedIndex() - 1);
                break;
            }
            case 3: {
                secondsubnet = SubnetCalculator.adtSubNets.get(this.decoListTwo.getSelectedIndex() - 1);
                break;
            }
            case 4: {
                secondsubnet = SubnetCalculator.tzSubNets.get(this.decoListTwo.getSelectedIndex() - 1);
                break;
            }
            case 5: {
                secondsubnet = SubnetCalculator.houSubNets.get(this.decoListTwo.getSelectedIndex() - 1);
                break;
            }
            case 6: {
                secondsubnet = SubnetCalculator.nishiSubNets.get(this.decoListTwo.getSelectedIndex() - 1);
                break;
            }
            case 7: {
                secondsubnet = SubnetCalculator.cycleSubNets.get(this.decoListTwo.getSelectedIndex() - 1);
                break;
            }
            case 8: {
                secondsubnet = SubnetCalculator.ootsukiSubNets.get(this.decoListTwo.getSelectedIndex() - 1);
                break;
            }
            case 9: {
                secondsubnet = SubnetCalculator.smcSubNets.get(this.decoListTwo.getSelectedIndex() - 1);
                break;
            }
            case 10: {
                secondsubnet = SubnetCalculator.mctSubNets.get(this.decoListTwo.getSelectedIndex() - 1);
                break;
            }
            case 11: {
                secondsubnet = SubnetCalculator.tinvSubNets.get(this.decoListTwo.getSelectedIndex() - 1);
                break;
            }
            case 12: {
                secondsubnet = SubnetCalculator.pinvSubNets.get(this.decoListTwo.getSelectedIndex() - 1);
                break;
            }
            case 13: {
                secondsubnet = SubnetCalculator.bvSubNets.get(this.decoListTwo.getSelectedIndex() - 1);
                break;
            }
            case 14: {
                secondsubnet = SubnetCalculator.btSubNets.get(this.decoListTwo.getSelectedIndex() - 1);
                break;
            }
            case 15: {
                secondsubnet = SubnetCalculator.bpSubNets.get(this.decoListTwo.getSelectedIndex() - 1);
                break;
            }
            case 16: {
                secondsubnet = SubnetCalculator.notTzCyclesiSubNets.get(this.decoListTwo.getSelectedIndex() - 1);
            }
        }
        ColorPalette cp = new ColorPalette();
        for (Place place : secondsubnet.getSubPlaces()) {
            if (firstsubnet.getSubPlaces().contains(place)) {
                place.drawGraphBoxP.setColorWithNumber(true, Color.green, false, 0.0, true, "[Sub net " + (this.selectedSubNetindex + 1) + "]");
                ++this.npcn;
            } else {
                place.drawGraphBoxP.setColorWithNumber(true, Color.blue, false, 0.0, true, "[Sub net " + (this.selectedSubNetindex + 1) + "]");
            }
            ++this.npsn;
        }
        for (Place place : firstsubnet.getSubPlaces()) {
            if (secondsubnet.getSubPlaces().contains(place)) {
                place.drawGraphBoxP.setColorWithNumber(true, Color.red, false, 0.0, true, "[Sub net " + (this.selectedSubNetindex + 1) + "]");
            }
            ++this.npfn;
        }
        for (Transition transition : secondsubnet.getSubTransitions()) {
            if (firstsubnet.getSubTransitions().contains(transition)) {
                transition.drawGraphBoxT.setColorWithNumber(true, Color.green, false, 0.0, true, "[Sub net " + (this.selectedSubNetindex + 1) + "]");
                ++this.ntcn;
            } else {
                transition.drawGraphBoxT.setColorWithNumber(true, Color.blue, false, 0.0, true, "[Sub net " + (this.selectedSubNetindex + 1) + "]");
            }
            ++this.ntsn;
        }
        for (Transition transition : firstsubnet.getSubTransitions()) {
            if (!secondsubnet.getSubTransitions().contains(transition)) {
                transition.drawGraphBoxT.setColorWithNumber(true, Color.red, false, 0.0, true, "[Sub net " + (this.selectedSubNetindex + 1) + "]");
            }
            ++this.ntfn;
        }
        for (Arc arc : secondsubnet.getSubArcs()) {
            if (firstsubnet.getSubArcs().contains(arc)) {
                arc.arcDecoBox.setColor(true, Color.green);
                ++this.nacn;
            } else {
                arc.arcDecoBox.setColor(true, Color.blue);
            }
            ++this.nasn;
        }
        for (Arc arc : firstsubnet.getSubArcs()) {
            if (!secondsubnet.getSubArcs().contains(arc)) {
                arc.arcDecoBox.setColor(true, Color.red);
            }
            ++this.nafn;
        }
        this.calcStatistics();
    }

    private void calcStatistics() {
        this.vafn.setText(String.valueOf(this.nafn));
        this.vafn.updateUI();
        this.vpfn.setText(String.valueOf(this.npfn));
        this.vpfn.updateUI();
        this.vtfn.setText(String.valueOf(this.ntfn));
        this.vtfn.updateUI();
        this.vasn.setText(String.valueOf(this.nasn));
        this.vasn.updateUI();
        this.vpsn.setText(String.valueOf(this.npsn));
        this.vpsn.updateUI();
        this.vtsn.setText(String.valueOf(this.ntsn));
        this.vtsn.updateUI();
        this.vacn.setText(String.valueOf(this.nacn));
        this.vacn.updateUI();
        this.vpcn.setText(String.valueOf(this.npcn));
        this.vpcn.updateUI();
        this.vtcn.setText(String.valueOf(this.ntcn));
        this.vtcn.updateUI();
        this.smc = ((float)this.ntcn + (float)this.npcn + (float)this.nacn) / (float)(this.ntfn + this.ntsn + this.npfn + this.npsn + this.nafn + this.nasn - (this.ntcn + this.npcn + this.nacn));
        this.valueOfSMC.setText(String.valueOf(this.smc));
        this.valueOfSMC.updateUI();
        this.sorenIndex = 2.0f * ((float)this.ntcn + (float)this.npcn + (float)this.nacn) / (float)(this.ntfn + this.ntsn + this.npfn + this.npsn + this.nafn + this.nasn);
        this.valueOfSorensenIndex.setText(String.valueOf(this.sorenIndex));
        this.valueOfSorensenIndex.updateUI();
        this.jackobIndex = ((float)this.ntcn + (float)this.npcn + (float)this.nacn) / (float)(this.ntfn + this.ntsn + this.npfn + this.npsn + this.nafn + this.nasn - (this.ntcn + this.npcn + this.nacn));
        this.valueOfJackobsenIndex.setText(String.valueOf(this.jackobIndex));
        this.valueOfJackobsenIndex.updateUI();
    }

    private void showAllSubColors(boolean trivial, int subnetType) {
        ArrayList<Place> places;
        ArrayList<Transition> transitions;
        SubnetCalculator.SubNet subNet;
        Color currentColor;
        int m;
        ArrayList<SubnetCalculator.SubNet> subnets = this.getCorrectSubnet(subnetType);
        PetriNet pn = this.overlord.getWorkspace().getProject();
        pn.resetNetColors();
        ColorPalette cp = new ColorPalette();
        if (subnetType == 0) {
            for (m = 0; m < subnets.size(); ++m) {
                currentColor = cp.getColor();
                subNet = subnets.get(m);
                transitions = subNet.getSubTransitions();
                if (transitions.size() <= 1 && !trivial) continue;
                for (Transition transition : transitions) {
                    transition.drawGraphBoxT.setColorWithNumber(true, currentColor, false, m, true, "Sub #" + m + " (" + transitions.size() + ")");
                }
                places = subnets.get(m).getSubPlaces();
                for (Place place : places) {
                    if (subNet.getSubBorderPlaces().contains(place)) {
                        place.drawGraphBoxP.setColorWithNumber(true, this.calcMiddleColor(currentColor, place.drawGraphBoxP.getPlaceNewColor()), false, m, true, "");
                        continue;
                    }
                    place.drawGraphBoxP.setColorWithNumber(true, currentColor, false, m, true, "");
                }
                ArrayList<Arc> arrayList = subnets.get(m).getSubArcs();
                for (Arc arc2 : arrayList) {
                    arc2.arcDecoBox.setColor(true, currentColor);
                }
            }
        }
        if (subnetType == 1 || subnetType == 8) {
            for (m = 0; m < subnets.size(); ++m) {
                currentColor = cp.getColor();
                subNet = subnets.get(m);
                ArrayList<Place> places2 = subNet.getSubPlaces();
                if (places2.size() <= 1 && !trivial) continue;
                for (Place place : places2) {
                    place.drawGraphBoxP.setColorWithNumber(true, currentColor, false, m, true, "Sub #" + m + " (" + places2.size() + ")");
                }
                ArrayList<Transition> transitions2 = subnets.get(m).getSubTransitions();
                Iterator iterator = transitions2.iterator();
                while (iterator.hasNext()) {
                    Transition transition = (Transition)iterator.next();
                    if (subNet.getSubBorderTransition().contains(transition)) {
                        transition.drawGraphBoxT.setColorWithNumber(true, this.calcMiddleColor(currentColor, transition.drawGraphBoxT.getTransitionNewColor()), false, m, true, "");
                        transition.setFrame(true);
                        continue;
                    }
                    transition.drawGraphBoxT.setColorWithNumber(true, currentColor, false, m, true, "");
                }
                ArrayList<Arc> arrayList = subnets.get(m).getSubArcs();
                for (Arc arc : arrayList) {
                    arc.arcDecoBox.setColor(true, currentColor);
                }
            }
        }
        if (subnetType == 2 || subnetType == 10) {
            for (m = 0; m < subnets.size(); ++m) {
                currentColor = cp.getColor();
                subNet = subnets.get(m);
                transitions = subNet.getSubTransitions();
                if (transitions.size() <= 1 && !trivial) continue;
                for (Transition transition : transitions) {
                    transition.drawGraphBoxT.setColorWithNumber(true, currentColor, false, m, true, "Sub #" + m + " (" + transitions.size() + ")");
                }
                places = subnets.get(m).getSubPlaces();
                for (Place place : places) {
                    if (subNet.getSubBorderPlaces().contains(place)) {
                        place.drawGraphBoxP.setColorWithNumber(true, this.calcMiddleColor(currentColor, place.drawGraphBoxP.getPlaceNewColor()), false, m, true, "");
                        continue;
                    }
                    place.drawGraphBoxP.setColorWithNumber(true, currentColor, false, m, true, "");
                }
                ArrayList<Arc> arrayList = subnets.get(m).getSubArcs();
                for (Arc arc : arrayList) {
                    arc.arcDecoBox.setColor(true, currentColor);
                }
            }
        }
        if (subnetType == 3) {
            for (m = 0; m < subnets.size(); ++m) {
                currentColor = cp.getColor();
                subNet = subnets.get(m);
                transitions = subNet.getSubTransitions();
                if (transitions.size() <= 1 && !trivial) continue;
                for (Transition transition : transitions) {
                    transition.drawGraphBoxT.setColorWithNumber(true, currentColor, false, m, true, "Sub #" + m + " (" + transitions.size() + ")");
                }
                places = subnets.get(m).getSubPlaces();
                for (Place place : places) {
                    if (subNet.getSubBorderPlaces().contains(place)) {
                        place.drawGraphBoxP.setColorWithNumber(true, this.calcMiddleColor(currentColor, place.drawGraphBoxP.getPlaceNewColor()), false, m, true, "");
                        continue;
                    }
                    place.drawGraphBoxP.setColorWithNumber(true, currentColor, false, m, true, "");
                }
                ArrayList<Arc> arrayList = subnets.get(m).getSubArcs();
                for (Arc arc : arrayList) {
                    arc.arcDecoBox.setColor(true, currentColor);
                }
            }
        }
        this.overlord.getWorkspace().getProject().repaintAllGraphPanels();
    }

    private void showCoverageColors(int subnetType) {
        ArrayList<SubnetCalculator.SubNet> subnets = this.getCorrectSubnet(subnetType);
        PetriNet pn = this.overlord.getWorkspace().getProject();
        pn.resetNetColors();
        for (int m = 0; m < subnets.size(); ++m) {
            SubnetCalculator.SubNet subNet = subnets.get(m);
            ArrayList<Node> transitions = subNet.getSubNode();
            for (Node transition : transitions) {
                if (transition.getType() == PetriNetElement.PetriNetElementType.TRANSITION) {
                    ((Transition)transition).drawGraphBoxT.setColorWithNumber(true, Color.red, false, m, true, "");
                }
                if (transition.getType() != PetriNetElement.PetriNetElementType.PLACE) continue;
                ((Place)transition).drawGraphBoxP.setColorWithNumber(true, Color.red, false, m, true, "");
            }
            ArrayList<Arc> arcs = subnets.get(m).getSubArcs();
            for (Arc arc : arcs) {
                arc.arcDecoBox.setColor(true, Color.red);
            }
        }
        this.overlord.getWorkspace().getProject().repaintAllGraphPanels();
    }

    private Color calcMiddleColor(Color one, Color two) {
        int blue = 0;
        int red = 0;
        int green = 0;
        int absBlue = Math.abs(one.getBlue() - two.getBlue());
        int absRed = Math.abs(one.getRed() - two.getRed());
        int absGreen = Math.abs(one.getGreen() - two.getGreen());
        blue = one.getBlue() > two.getBlue() ? one.getBlue() - absBlue / 2 : two.getBlue() - absBlue / 2;
        red = one.getRed() > two.getRed() ? one.getRed() - absRed / 2 : two.getRed() - absRed / 2;
        green = one.getGreen() > two.getGreen() ? one.getGreen() - absGreen / 2 : two.getGreen() - absGreen / 2;
        return Color.GRAY;
    }

    private void showInfo() {
        JFrame infoWindow = new JFrame();
        infoWindow.setLayout(new FlowLayout());
        JPanel infoPanel = new JPanel();
        infoPanel.setLayout(new BoxLayout(infoPanel, 1));
        JScrollPane scrollPaneIfi = new JScrollPane(infoPanel);
        JTextArea textA = new JTextArea(10, 25);
        textA.setEditable(false);
        textA.append("Functional subnets \n \n");
        textA.append("W swojej pracy z 2004 roku Zaitsev zdefiniowa\u0142 podsieci funkcyjne dla sieci Petriego oraz odpowiedni algorytm dekompozycji.\n W przeciwie\u0144stwie do innych metod opracowanych dla sieci Petriego, dekomponuje ona do struktur niepowi\u0105zanych z inwariantami, \nczy sekwencjami uruchomie\u0144 i jednocze\u015bnie jest niezale\u017cna od ich wyst\u0119powania w sieci.\nPodsieci\u0105 funkcyjn\u0105 nazywamy struktur\u0119 zbudowan\u0105 wok\u00f3\u0142 zbioru tranzycji.Tranzycje wchodz\u0105ce w jej sk\u0142ad posiadaj\u0105 zbiory miejsc \nwej\u015bciowych roz\u0142\u0105czne z miejscami wyj\u015bciowymi innych tranzycji wchodz\u0105cych w sk\u0142ad podsieci.\n\n");
        JScrollPane scrollPane = new JScrollPane(textA);
        infoWindow.setSize(new Dimension(1100, 700));
        JLabel image1 = new JLabel();
        image1.setIcon(new ImageIcon(this.getClass().getResource("/images/Abtss-Zaj2.png")));
        image1.setBounds(new Rectangle(300, 300));
        image1.setText("Functional \n subnets");
        JTextArea textB = new JTextArea(10, 25);
        textB.setEditable(false);
        textB.append("T-net subnets \n \n");
        textB.append("Lorem ipsum dolor sit amet, voluptua placerat maluisset mel at. Sit feugiat liberavisse deterruisset eu,\n tamquam denique pericula qui in. No usu dico laboramus. Vero omnium conclusionemque vis in,\n eu ius augue numquam. Per ex euismod offendit, ea vim errem recusabo. Quo ut hinc lorem consetetur. \nIntegre detraxit ex eam, ut est congue patrioque disputando. Mel ei scripta tacimates, \nad nonumes appareat duo. In alii constituto ius, ut pri dicat intellegam.\n\n");
        JScrollPane scrollPane1 = new JScrollPane(textB);
        JLabel image2 = new JLabel();
        image2.setIcon(new ImageIcon(this.getClass().getResource("/images/Abyss-ADT-1.png")));
        image2.setBounds(new Rectangle(300, 300));
        image2.setText("T-net(ADT) \n subnets");
        JTextArea textC = new JTextArea(10, 25);
        textC.setEditable(false);
        textC.append("S-net subnets \n\n");
        textC.append("Lorem ipsum dolor sit amet, voluptua placerat maluisset mel at. Sit feugiat liberavisse deterruisset eu,\n tamquam denique pericula qui in. No usu dico laboramus. Vero omnium conclusionemque vis in,\n eu ius augue numquam. Per ex euismod offendit, ea vim errem recusabo. Quo ut hinc lorem consetetur. \nIntegre detraxit ex eam, ut est congue patrioque disputando. Mel ei scripta tacimates, \nad nonumes appareat duo. In alii constituto ius, ut pri dicat intellegam.\n\n");
        JScrollPane scrollPane2 = new JScrollPane(textC);
        JLabel image3 = new JLabel();
        image3.setIcon(new ImageIcon(this.getClass().getResource("/images/Abyss-Zeng-0.png")));
        image3.setBounds(new Rectangle(300, 300));
        image3.setText("S-net \n subnets");
        JTextArea textD = new JTextArea(10, 25);
        textD.setEditable(false);
        textD.append("MCT inducted subnets \n\n");
        textD.append("Lorem ipsum dolor sit amet, voluptua placerat maluisset mel at. Sit feugiat liberavisse deterruisset eu,\n tamquam denique pericula qui in. No usu dico laboramus. Vero omnium conclusionemque vis in,\n eu ius augue numquam. Per ex euismod offendit, ea vim errem recusabo. Quo ut hinc lorem consetetur. \nIntegre detraxit ex eam, ut est congue patrioque disputando. Mel ei scripta tacimates, \nad nonumes appareat duo. In alii constituto ius, ut pri dicat intellegam.\n\n");
        JScrollPane scrollPane3 = new JScrollPane(textD);
        JLabel image4 = new JLabel();
        image4.setIcon(new ImageIcon(this.getClass().getResource("/images/MCT1.png")));
        image4.setBounds(new Rectangle(300, 300));
        image4.setText("MCT inducted \n\r subnets");
        JTextArea textE = new JTextArea(10, 25);
        textE.setEditable(false);
        textE.append("P1 subnets \n\n");
        textE.append("Lorem ipsum dolor sit amet, voluptua placerat maluisset mel at. Sit feugiat liberavisse deterruisset eu,\n tamquam denique pericula qui in. No usu dico laboramus. Vero omnium conclusionemque vis in,\n eu ius augue numquam. Per ex euismod offendit, ea vim errem recusabo. Quo ut hinc lorem consetetur. \nIntegre detraxit ex eam, ut est congue patrioque disputando. Mel ei scripta tacimates, \nad nonumes appareat duo. In alii constituto ius, ut pri dicat intellegam.\n\n");
        JScrollPane scrollPane4 = new JScrollPane(textE);
        JLabel image5 = new JLabel();
        image5.setIcon(new ImageIcon(this.getClass().getResource("/images/Abyss-Ootsuki-3-Alternatywa.png")));
        image5.setBounds(new Rectangle(300, 300));
        image5.setText("P1 \n\r subnets");
        infoPanel.add((Component)scrollPane, "Center");
        infoPanel.add(image1);
        infoPanel.add((Component)scrollPane1, "Center");
        infoPanel.add(image2);
        infoPanel.add((Component)scrollPane2, "Center");
        infoPanel.add(image3);
        infoPanel.add((Component)scrollPane3, "Center");
        infoPanel.add(image4);
        infoPanel.add((Component)scrollPane4, "Center");
        infoPanel.add(image5);
        scrollPaneIfi.setBorder(BorderFactory.createLineBorder(Color.red));
        scrollPaneIfi.setPreferredSize(new Dimension(900, 600));
        infoWindow.add((Component)scrollPaneIfi, "Center");
        infoWindow.setVisible(true);
    }

    public void calcSubnetsForSecondNet() {
    }
}

