/*
 * Decompiled with CFR 0.152.
 */
package holmes.windows.clusters;

import holmes.clusters.ClusterDataPackage;
import holmes.clusters.Clustering;
import holmes.clusters.ClusteringExtended;
import holmes.darkgui.GUIManager;
import holmes.darkgui.LanguageManager;
import holmes.files.clusters.ClusterReader;
import holmes.files.clusters.ClusteringExcelWriter;
import holmes.utilities.Tools;
import holmes.windows.clusters.HolmesClusters;
import holmes.windows.clusters.WaitLayerUI;
import holmes.workspace.ExtensionFileFilter;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLayer;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;

public class HolmesClusterSubWindow
extends JFrame {
    private static final long serialVersionUID = 6818230680946396781L;
    private static final GUIManager overlord = GUIManager.getDefaultGUIManager();
    private static final LanguageManager lang = GUIManager.getLanguageManager();
    private JFrame parentFrame;
    private Clustering clusteringMetaData;
    private String nL = "\n";
    private String newline = "\n";
    private StyledDocument doc;
    private JTextPane textPane;
    private JButton buttonExcel;
    private JButton buttonInjectCluster;
    private JButton buttonTexTable;
    private String clusterPath;
    private ClusteringExtended fullData = null;
    final WaitLayerUI layerUI = new WaitLayerUI();

    public HolmesClusterSubWindow() {
    }

    public HolmesClusterSubWindow(HolmesClusters parent, Clustering dataPackage, int mode) {
        this();
        try {
            this.setIconImage(Tools.getImageFromIcon("/icons/holmesicon.png"));
        }
        catch (Exception ex) {
            overlord.log(lang.getText("LOGentry00510exception") + "\n" + ex.getMessage(), "error", true);
        }
        this.clusterPath = parent.getClusterPath();
        this.clusteringMetaData = dataPackage;
        this.parentFrame = parent;
        this.parentFrame.setEnabled(false);
        if (mode == 0) {
            this.initiateSimpleMode(parent, dataPackage);
        } else {
            this.initiateExtendedMode(parent, dataPackage);
        }
    }

    private void initiateSimpleMode(HolmesClusters parent, Clustering dataPackage) {
        JTextArea area = new JTextArea();
        area.setLineWrap(true);
        area.setWrapStyleWord(true);
        area.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        this.add(new JScrollPane(area));
        this.setSize(new Dimension(450, 300));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                HolmesClusterSubWindow.this.parentFrame.setEnabled(true);
            }
        });
        this.setLocationRelativeTo(null);
        this.setVisible(true);
        if (this.clusteringMetaData != null) {
            int i;
            area.append(lang.getText("HCSWwin_entry002") + " " + this.clusteringMetaData.algorithmName + this.nL);
            area.append(lang.getText("HCSWwin_entry003") + " " + this.clusteringMetaData.metricName + this.nL);
            area.append(this.nL);
            area.append(lang.getText("HCSWwin_entry004") + " " + this.clusteringMetaData.invNumber + this.nL);
            area.append(lang.getText("HCSWwin_entry005") + " " + this.clusteringMetaData.clusterNumber + this.nL);
            area.append(lang.getText("HCSWwin_entry006") + " " + this.clusteringMetaData.zeroClusters + this.nL);
            area.append(lang.getText("HCSWwin_entry007") + " " + this.clusteringMetaData.evalMSS + this.nL);
            area.append(lang.getText("HCSWwin_entry008") + " " + this.clusteringMetaData.evalCH + this.nL);
            area.append(this.nL);
            for (i = 0; i < this.clusteringMetaData.clusterNumber; ++i) {
                String value = this.getMSSFormatted(this.clusteringMetaData.clusterMSS.get(i).floatValue());
                String strB = "err.";
                try {
                    strB = String.format(lang.getText("HCSWwin_entry009"), i, this.clusteringMetaData.clusterSize.get(i), value);
                }
                catch (Exception e) {
                    overlord.log(lang.getText("LOGentryLNGexc") + " HCSWwin_entry009", "error", true);
                }
                area.append(strB);
            }
            area.append(this.nL);
            for (i = 0; i < 6; ++i) {
                area.append(String.valueOf(this.clusteringMetaData.vectorMSS.get(i)) + " | ");
            }
        }
    }

    private String getMSSFormatted(double clusterMSS) {
        DecimalFormat df = new DecimalFormat("#.########");
        StringBuilder txt = new StringBuilder();
        txt.append(df.format(clusterMSS));
        txt = new StringBuilder(txt.toString().replace(",", "."));
        if (!txt.toString().contains(".")) {
            txt.append(".");
        }
        int size = txt.length();
        txt.append("0".repeat(Math.max(0, 10 - size)));
        return txt.toString();
    }

    private void initiateExtendedMode(HolmesClusters parent, Clustering dataPackage) {
        String strB = "err.";
        try {
            strB = String.format(lang.getText("HCSWwin_entry001title"), dataPackage.clusterNumber, dataPackage.algorithmName, dataPackage.metricName);
        }
        catch (Exception e) {
            overlord.log(lang.getText("LOGentryLNGexc") + " HCSWwin_entry001title", "error", true);
        }
        this.setTitle(strB);
        this.setDefaultCloseOperation(1);
        this.setMinimumSize(new Dimension(600, 600));
        this.setMaximumSize(new Dimension(600, 600));
        this.setResizable(false);
        JPanel tablePanel = this.createEditor();
        tablePanel.setOpaque(true);
        JLayer<JPanel> jlayer = new JLayer<JPanel>(tablePanel, this.layerUI);
        this.add(jlayer);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                HolmesClusterSubWindow.this.parentFrame.setEnabled(true);
            }
        });
        if (this.clusteringMetaData != null) {
            try {
                this.doc.insertString(this.doc.getLength(), Tools.setToSize(lang.getText("HCSWwin_entry010") + " ", 20, false), this.doc.getStyle("regular"));
                this.doc.insertString(this.doc.getLength(), this.clusteringMetaData.algorithmName + this.nL, this.doc.getStyle("bold"));
                this.doc.insertString(this.doc.getLength(), Tools.setToSize(lang.getText("HCSWwin_entry011") + " ", 20, false), this.doc.getStyle("regular"));
                this.doc.insertString(this.doc.getLength(), this.clusteringMetaData.metricName + this.nL, this.doc.getStyle("bold"));
                this.doc.insertString(this.doc.getLength(), this.nL, this.doc.getStyle("regular"));
                this.doc.insertString(this.doc.getLength(), Tools.setToSize(lang.getText("HCSWwin_entry012") + " ", 20, false), this.doc.getStyle("regular"));
                this.doc.insertString(this.doc.getLength(), this.clusteringMetaData.invNumber + this.nL, this.doc.getStyle("bold"));
                this.doc.insertString(this.doc.getLength(), Tools.setToSize(lang.getText("HCSWwin_entry013") + " ", 20, false), this.doc.getStyle("regular"));
                this.doc.insertString(this.doc.getLength(), this.clusteringMetaData.clusterNumber + this.nL, this.doc.getStyle("bold"));
                this.doc.insertString(this.doc.getLength(), Tools.setToSize(lang.getText("HCSWwin_entry014") + " ", 20, false), this.doc.getStyle("regular"));
                this.doc.insertString(this.doc.getLength(), this.clusteringMetaData.zeroClusters + this.nL, this.doc.getStyle("bold"));
                this.doc.insertString(this.doc.getLength(), Tools.setToSize(lang.getText("HCSWwin_entry015") + " ", 20, false), this.doc.getStyle("regular"));
                String value = this.getMSSFormatted(this.clusteringMetaData.evalMSS);
                this.doc.insertString(this.doc.getLength(), value + this.nL, this.doc.getStyle("bold"));
                this.doc.insertString(this.doc.getLength(), Tools.setToSize(lang.getText("HCSWwin_entry016") + " ", 20, false), this.doc.getStyle("regular"));
                this.doc.insertString(this.doc.getLength(), this.clusteringMetaData.evalCH + this.nL, this.doc.getStyle("bold"));
                this.doc.insertString(this.doc.getLength(), this.nL, this.doc.getStyle("regular"));
                for (int i = 0; i < this.clusteringMetaData.clusterNumber; ++i) {
                    this.doc.insertString(this.doc.getLength(), lang.getText("HCSWwin_entry017a") + " " + Tools.setToSize("" + (i + 1), 3, true) + " " + lang.getText("HCSWwin_entry017b") + " ", this.doc.getStyle("regular"));
                    this.doc.insertString(this.doc.getLength(), Tools.setToSize(String.valueOf(this.clusteringMetaData.clusterSize.get(i)), 4, true), this.doc.getStyle("bold"));
                    this.doc.insertString(this.doc.getLength(), "  " + lang.getText("HCSWwin_entry018") + " ", this.doc.getStyle("regular"));
                    value = this.getMSSFormatted(this.clusteringMetaData.clusterMSS.get(i).floatValue());
                    this.doc.insertString(this.doc.getLength(), value + this.nL, this.doc.getStyle(this.returnStyle(this.clusteringMetaData.clusterMSS.get(i).floatValue())));
                }
                this.doc.insertString(this.doc.getLength(), this.nL, this.doc.getStyle("regular"));
                String sepSpace = "";
                if (this.clusteringMetaData.vectorMSS.get(0).floatValue() < 0.0f) {
                    sepSpace = " ";
                }
                this.doc.insertString(this.doc.getLength(), sepSpace + " " + lang.getText("HCSWwin_entry019") + this.nL, this.doc.getStyle("bold"));
                for (int i = 0; i < 6; ++i) {
                    this.doc.insertString(this.doc.getLength(), Tools.setToSize(String.valueOf(this.clusteringMetaData.vectorMSS.get(i)), 6, false) + " | ", this.doc.getStyle("bold"));
                }
                this.textPane.setCaretPosition(0);
            }
            catch (Exception ex) {
                overlord.log(lang.getText("LOGentry00511exception") + "\n" + ex.getMessage(), "error", true);
            }
        }
        this.setLocationRelativeTo(null);
        this.setVisible(true);
    }

    private String returnStyle(float value) {
        if ((value *= 100.0f) < 30.0f) {
            return "mark1";
        }
        if (value < 40.0f) {
            return "mark2";
        }
        if (value < 50.0f) {
            return "mark3";
        }
        if (value < 60.0f) {
            return "mark4";
        }
        if (value < 75.0f) {
            return "mark5";
        }
        return "mark6";
    }

    private void addStylesToDocument(StyledDocument doc) {
        Style baseStyle = StyleContext.getDefaultStyleContext().getStyle("default");
        Style regular = doc.addStyle("regular", baseStyle);
        StyleConstants.setFontFamily(baseStyle, "monospaced");
        StyleConstants.setFontSize(baseStyle, 16);
        Style mark6 = doc.addStyle("mark6", baseStyle);
        StyleConstants.setForeground(mark6, new Color(1, 153, 19));
        StyleConstants.setBold(mark6, true);
        Style mark5 = doc.addStyle("mark5", baseStyle);
        StyleConstants.setForeground(mark5, new Color(12, 232, 26));
        StyleConstants.setBold(mark5, true);
        Style mark4 = doc.addStyle("mark4", baseStyle);
        StyleConstants.setForeground(mark4, new Color(173, 217, 13));
        StyleConstants.setBold(mark4, true);
        Style mark3 = doc.addStyle("mark3", baseStyle);
        StyleConstants.setForeground(mark3, new Color(240, 171, 12));
        StyleConstants.setBold(mark3, true);
        Style mark2 = doc.addStyle("mark2", baseStyle);
        StyleConstants.setForeground(mark2, new Color(240, 92, 12));
        StyleConstants.setBold(mark2, true);
        Style mark1 = doc.addStyle("mark1", baseStyle);
        StyleConstants.setForeground(mark1, new Color(250, 2, 2));
        StyleConstants.setBold(mark1, true);
        Style bold = doc.addStyle("bold", baseStyle);
        StyleConstants.setBold(bold, true);
        Style s = doc.addStyle("italic2", regular);
        StyleConstants.setItalic(s, true);
        s = doc.addStyle("bold2", regular);
        StyleConstants.setBold(s, true);
        s = doc.addStyle("time", regular);
        StyleConstants.setForeground(s, Color.darkGray);
        StyleConstants.setBold(s, true);
    }

    private JTextPane createTextPane() {
        String initString = lang.getText("HCSWwin_entry020") + this.newline;
        JTextPane txtPane = new JTextPane();
        this.doc = txtPane.getStyledDocument();
        this.addStylesToDocument(this.doc);
        try {
            this.doc.insertString(this.doc.getLength(), initString, this.doc.getStyle("regular"));
        }
        catch (Exception e) {
            overlord.log(lang.getText("LOGentry00512exception") + "\n" + e.getMessage(), "error", true);
        }
        return txtPane;
    }

    private JPanel createEditor() {
        JPanel editPanel = new JPanel();
        editPanel.setLayout(null);
        editPanel.setBounds(0, 0, 500, 500);
        this.textPane = this.createTextPane();
        this.textPane.setEditable(false);
        JScrollPane paneScrollPane = new JScrollPane(this.textPane);
        paneScrollPane.setVerticalScrollBarPolicy(22);
        paneScrollPane.setBounds(5, 5, 585, 500);
        editPanel.add(paneScrollPane);
        this.buttonExcel = new JButton(lang.getText("HCSWwin_entry021"), Tools.getResIcon48("/icons/clustWindow/buttonExportSingleToExcel.png"));
        this.buttonExcel.setBounds(5, 510, 190, 50);
        this.buttonExcel.addActionListener(actionEvent -> {
            this.layerUI.start();
            this.turnOffButtons();
            this.exportDataToExcel();
            this.turnOnButtons();
            this.layerUI.stop();
        });
        editPanel.add(this.buttonExcel);
        this.buttonInjectCluster = new JButton(lang.getText("HCSWwin_entry022"), Tools.getResIcon48("/icons/clustWindow/buttonSendToAbyss.png"));
        this.buttonInjectCluster.setBounds(200, 510, 190, 50);
        this.buttonInjectCluster.addActionListener(actionEvent -> {
            this.layerUI.start();
            this.turnOffButtons();
            this.exportToHolmes();
            this.turnOnButtons();
            this.layerUI.stop();
        });
        editPanel.add(this.buttonInjectCluster);
        this.buttonTexTable = new JButton(lang.getText("HCSWwin_entry023"), Tools.getResIcon48("/icons/menu/menu_exportTex.png"));
        this.buttonTexTable.setBounds(395, 510, 190, 50);
        this.buttonTexTable.addActionListener(actionEvent -> {
            this.layerUI.start();
            this.turnOffButtons();
            this.exportToLatex();
            this.turnOnButtons();
            this.layerUI.stop();
        });
        editPanel.add(this.buttonTexTable);
        editPanel.repaint();
        return editPanel;
    }

    protected void turnOnButtons() {
        this.buttonExcel.setEnabled(true);
        this.buttonInjectCluster.setEnabled(true);
        this.buttonTexTable.setEnabled(true);
    }

    protected void turnOffButtons() {
        this.buttonExcel.setEnabled(false);
        this.buttonInjectCluster.setEnabled(false);
        this.buttonTexTable.setEnabled(false);
    }

    private void deleteTmpFile(String[] resultFiles) {
        try {
            for (int i = 1; i < resultFiles.length; ++i) {
                File del = new File(resultFiles[i]);
                if (!del.exists()) continue;
                del.delete();
            }
            File excelTmp = new File("tmp\\testSheets.xls");
            if (excelTmp.exists()) {
                excelTmp.delete();
            }
        }
        catch (Exception e) {
            overlord.log(lang.getText("LOGentry00513exception") + "\n" + e.getMessage(), "error", true);
        }
    }

    private boolean saveAllFiles(ClusteringExtended fullData, String[] files) {
        String whereExcelIs = this.saveExcelOnly(fullData);
        if (whereExcelIs == null) {
            return false;
        }
        File test = new File(whereExcelIs);
        String excelDestinationFolder = test.getAbsolutePath();
        excelDestinationFolder = excelDestinationFolder.substring(0, excelDestinationFolder.lastIndexOf(File.separator));
        try {
            File mctFile;
            File pdf2;
            File pdf1 = new File(files[3]);
            if (pdf1.exists()) {
                String pdf1Name = pdf1.getName();
                Tools.copyFileByPath(files[3], excelDestinationFolder + "\\" + pdf1Name);
            }
            if ((pdf2 = new File(files[4])).exists()) {
                String pdf2Name = pdf2.getName();
                Tools.copyFileByPath(files[4], excelDestinationFolder + "\\" + pdf2Name);
            }
            if ((mctFile = new File(files[2])).exists()) {
                String mcfFileName = mctFile.getName();
                Tools.copyFileByPath(files[2], excelDestinationFolder + "\\" + mcfFileName);
            }
        }
        catch (Exception e) {
            overlord.log(lang.getText("LOGentry00514exception") + "\n" + e.getMessage(), "error", true);
            return false;
        }
        return true;
    }

    private String saveExcelOnly(ClusteringExtended fullData) {
        ClusteringExcelWriter ew = new ClusteringExcelWriter(0, fullData, "tmp\\testSheets.xls");
        if (!ew.isSuccess()) {
            return null;
        }
        FileFilter[] filters = new FileFilter[]{new ExtensionFileFilter("Microsoft Excel 97/2000/XP/2003 (.xls)", new String[]{"XLS"})};
        String lastPath = overlord.getLastPath();
        Object selectedFile = Tools.selectFileDialog(lastPath, filters, lang.getText("save"), lang.getText("HCSWwin_entry024t"), "");
        if (((String)selectedFile).isEmpty()) {
            return null;
        }
        if (!((String)selectedFile).contains(".xls")) {
            selectedFile = (String)selectedFile + ".xls";
        }
        try {
            Tools.copyFileByPath("tmp//testSheets.xls", (String)selectedFile);
        }
        catch (Exception e) {
            String strB = "err.";
            try {
                strB = String.format(lang.getText("LOGentry00515exception"), selectedFile);
            }
            catch (Exception ex2) {
                overlord.log(lang.getText("LOGentryLNGexc") + " LOGentry00515exception", "error", true);
            }
            overlord.log(strB + "\n" + e.getMessage(), "error", true);
            return null;
        }
        return selectedFile;
    }

    protected void exportDataToExcel() {
        String[] resultFiles;
        String targetDir = this.getInvariantsCSVLocation();
        if (targetDir == null) {
            JOptionPane.showMessageDialog(null, lang.getText("HCSWwin_entry025"), lang.getText("error"), 0);
            return;
        }
        String alg = this.clusteringMetaData.algorithmName;
        if (alg.equals("UPGMA")) {
            alg = "average";
        }
        if ((resultFiles = HolmesClusterSubWindow.overlord.io.generateSingleClustering(targetDir, alg, this.clusteringMetaData.metricName, this.clusteringMetaData.clusterNumber)) != null) {
            ClusterReader reader = new ClusterReader();
            this.fullData = reader.readSingleClustering(resultFiles, this.clusteringMetaData);
            if (this.fullData == null) {
                overlord.log(lang.getText("HCSWwin_entry026"), "error", true);
                return;
            }
        } else {
            overlord.log(lang.getText("HCSWwin_entry027"), "error", true);
            return;
        }
        Object[] options = new Object[]{lang.getText("HCSwin_entry028op1"), lang.getText("HCSwin_entry028op2")};
        int n = JOptionPane.showOptionDialog(null, lang.getText("HCSwin_entry028"), lang.getText("HCSwin_entry028t"), 0, 3, null, options, options[0]);
        if (n == 0) {
            boolean success = this.saveAllFiles(this.fullData, resultFiles);
            if (success) {
                this.deleteTmpFile(resultFiles);
            }
        } else {
            String path = this.saveExcelOnly(this.fullData);
            if (path != null) {
                this.deleteTmpFile(resultFiles);
            }
        }
    }

    protected String getInvariantsCSVLocation() {
        String targetDir;
        Object[] options = new Object[]{lang.getText("HCSwin_entry029op1"), lang.getText("HCSwin_entry029op2")};
        int n = JOptionPane.showOptionDialog(null, lang.getText("HCSwin_entry029"), lang.getText("HCSwin_entry029t"), 0, 3, null, options, options[0]);
        if (n == 0) {
            targetDir = this.selectionOfSource();
            File x = new File(targetDir);
            String name = x.getName();
            String path = Tools.getFilePath(x);
            if (!name.equals("cluster.csv")) {
                try {
                    Tools.copyFileByPath(x.getAbsolutePath(), path + "cluster.csv");
                }
                catch (IOException e) {
                    overlord.log(lang.getText("LOGentry00516exception") + "\n" + e.getMessage(), "error", true);
                }
            }
            targetDir = path;
        } else if (this.clusterPath == null || this.clusterPath.isEmpty()) {
            JOptionPane.showMessageDialog(null, lang.getText("HCSwin_entry030"), lang.getText("HCSwin_entry030t"), 1);
            FileFilter[] filters = new FileFilter[]{new ExtensionFileFilter("Invariants csv file (.csv)", new String[]{"CSV"})};
            String lastPath = overlord.getLastPath();
            String selectedFile = Tools.selectFileDialog(lastPath, filters, lang.getText("select"), "", "");
            if (selectedFile.isEmpty()) {
                return null;
            }
            File x = new File(selectedFile);
            String name = x.getName();
            String path = Tools.getFilePath(x);
            if (!name.equals("cluster.csv")) {
                try {
                    Tools.copyFileByPath(x.getAbsolutePath(), path + "cluster.csv");
                }
                catch (IOException e) {
                    overlord.log(lang.getText("LOGentry00517exception") + "\n" + e.getMessage(), "error", true);
                }
            }
            targetDir = path;
        } else {
            targetDir = this.clusterPath;
        }
        return targetDir;
    }

    private String selectionOfSource() {
        String lastPath = overlord.getLastPath();
        if (overlord.getWorkspace().getProject().getT_InvMatrix() == null) {
            JOptionPane.showMessageDialog(null, lang.getText("HCSwin_entry031"), lang.getText("warning"), 2);
            FileFilter[] filters = new FileFilter[]{new ExtensionFileFilter("CSV invariants file (.csv)", new String[]{"CSV"})};
            String selectedFile = Tools.selectFileDialog(lastPath, filters, lang.getText("HCSwin_entry032"), lang.getText("HCSwin_entry032t"), "");
            if (selectedFile.isEmpty()) {
                return null;
            }
            return selectedFile;
        }
        String CSVfilePath = overlord.getTmpPath() + "cluster.csv";
        int result = overlord.getWorkspace().getProject().saveInvariantsToCSV(CSVfilePath, true, true);
        if (result == -1) {
            JOptionPane.showMessageDialog(null, lang.getText("HCSwin_entry033"), "CSV export error", 0);
            overlord.log(lang.getText("HCSwin_entry033"), "error", true);
            return null;
        }
        return CSVfilePath;
    }

    protected void exportToHolmes() {
        String[] resultFiles;
        boolean proceed = true;
        if (this.fullData != null) {
            Object[] options = new Object[]{lang.getText("HCSwin_entry034op1"), lang.getText("HCSwin_entry034op2")};
            int n = JOptionPane.showOptionDialog(null, lang.getText("HCSwin_entry034"), lang.getText("HCSwin_entry034t"), 0, 3, null, options, options[0]);
            if (n == 0) {
                int transNumber = this.fullData.transNames.length - 1;
                int netTransNumber = overlord.getWorkspace().getProject().getTransitions().size();
                if (transNumber != netTransNumber) {
                    String strB = "err.";
                    try {
                        strB = String.format(lang.getText("HCSwin_entry035"), transNumber, netTransNumber);
                    }
                    catch (Exception e) {
                        overlord.log(lang.getText("LOGentryLNGexc") + " HCSwin_entry035", "error", true);
                    }
                    JOptionPane.showMessageDialog(null, strB, lang.getText("error"), 0);
                    return;
                }
                ClusterDataPackage dataCore = new ClusterDataPackage();
                dataCore.dataMatrix = this.fullData.getClusteringColored();
                dataCore.clustersInvariants = this.fullData.clustersInv;
                dataCore.clMSS = this.fullData.metaData.clusterMSS;
                dataCore.algorithm = this.fullData.metaData.algorithmName;
                dataCore.metric = this.fullData.metaData.metricName;
                dataCore.clNumber = this.fullData.metaData.clusterNumber;
                dataCore.clSize = new ArrayList<Integer>(this.fullData.metaData.clusterSize);
                for (int cl = 0; cl < dataCore.clSize.size(); ++cl) {
                }
                overlord.showClusterSelectionBox(dataCore);
                JOptionPane.showMessageDialog(null, lang.getText("HCSwin_entry036"), lang.getText("status"), 1);
                proceed = false;
            }
        }
        if (!proceed) {
            return;
        }
        String targetDir = this.getInvariantsCSVLocation();
        if (targetDir == null) {
            JOptionPane.showMessageDialog(null, lang.getText("HCSwin_entry037"), lang.getText("error"), 0);
            return;
        }
        String alg = this.clusteringMetaData.algorithmName;
        if (alg.equals("UPGMA")) {
            alg = "average";
        }
        if ((resultFiles = HolmesClusterSubWindow.overlord.io.generateSingleClustering(targetDir, alg, this.clusteringMetaData.metricName, this.clusteringMetaData.clusterNumber)) != null) {
            ClusterReader reader = new ClusterReader();
            this.fullData = reader.readSingleClustering(resultFiles, this.clusteringMetaData);
            if (this.fullData == null) {
                overlord.log(lang.getText("HCSwin_entry038"), "error", true);
                return;
            }
            int transNumber = this.fullData.transNames.length - 1;
            int netTransNumber = overlord.getWorkspace().getProject().getTransitions().size();
            if (transNumber != netTransNumber) {
                String strB = "err.";
                try {
                    strB = String.format(lang.getText("HCSwin_entry035"), transNumber, netTransNumber);
                }
                catch (Exception e) {
                    overlord.log(lang.getText("LOGentryLNGexc") + " HCSwin_entry035", "error", true);
                }
                JOptionPane.showMessageDialog(null, strB, lang.getText("error"), 0);
                return;
            }
            ClusterDataPackage dataCore = new ClusterDataPackage();
            dataCore.dataMatrix = this.fullData.getClusteringColored();
            dataCore.clustersInvariants = this.fullData.clustersInv;
            dataCore.clMSS = this.fullData.metaData.clusterMSS;
            dataCore.algorithm = this.fullData.metaData.algorithmName;
            dataCore.metric = this.fullData.metaData.metricName;
            dataCore.clNumber = this.fullData.metaData.clusterNumber;
            dataCore.clSize = new ArrayList<Integer>(this.fullData.metaData.clusterSize);
            for (int cl = 0; cl < dataCore.clSize.size(); ++cl) {
            }
            overlord.showClusterSelectionBox(dataCore);
            this.deleteTmpFile(resultFiles);
            JOptionPane.showMessageDialog(null, lang.getText("HCSwin_entry039"), "Status", 1);
        } else {
            overlord.log(lang.getText("HCSwin_entry040"), "error", true);
        }
    }

    protected void exportToLatex() {
        String[] resultFiles;
        boolean proceed = true;
        if (this.fullData != null) {
            Object[] options = new Object[]{lang.getText("HCSwin_entry041op1"), lang.getText("HCSwin_entry041op2")};
            int n = JOptionPane.showOptionDialog(null, lang.getText("HCSwin_entry041"), lang.getText("HCSwin_entry041t"), 0, 3, null, options, options[0]);
            if (n == 0) {
                int transNumber = this.fullData.transNames.length - 1;
                int netTransNumber = overlord.getWorkspace().getProject().getTransitions().size();
                if (transNumber != netTransNumber) {
                    String strB = "err.";
                    try {
                        strB = String.format(lang.getText("HCSwin_entry035"), transNumber, netTransNumber);
                    }
                    catch (Exception e) {
                        overlord.log(lang.getText("LOGentryLNGexc") + " HCSwin_entry035", "error", true);
                    }
                    JOptionPane.showMessageDialog(null, strB, lang.getText("error"), 0);
                    return;
                }
                HolmesClusterSubWindow.overlord.tex.writeCluster(this.fullData);
                JOptionPane.showMessageDialog(null, lang.getText("HCSwin_entry042"), "Status", 1);
                proceed = false;
            }
        }
        if (!proceed) {
            return;
        }
        String targetDir = this.getInvariantsCSVLocation();
        if (targetDir == null) {
            JOptionPane.showMessageDialog(null, lang.getText("HCSwin_entry043"), lang.getText("error"), 0);
            return;
        }
        String alg = this.clusteringMetaData.algorithmName;
        if (alg.equals("UPGMA")) {
            alg = "average";
        }
        if ((resultFiles = HolmesClusterSubWindow.overlord.io.generateSingleClustering(targetDir, alg, this.clusteringMetaData.metricName, this.clusteringMetaData.clusterNumber)) != null) {
            ClusterReader reader = new ClusterReader();
            this.fullData = reader.readSingleClustering(resultFiles, this.clusteringMetaData);
            if (this.fullData == null) {
                overlord.log(lang.getText("LOGentry00518"), "error", true);
                return;
            }
            HolmesClusterSubWindow.overlord.tex.writeCluster(this.fullData);
            this.deleteTmpFile(resultFiles);
            JOptionPane.showMessageDialog(null, lang.getText("HCSwin_entry044"), "Status", 1);
        } else {
            overlord.log(lang.getText("HCSwin_entry045"), "error", true);
        }
    }
}

