/*
 * Decompiled with CFR 0.152.
 */
package holmes.windows;

import holmes.darkgui.GUIManager;
import holmes.darkgui.LanguageManager;
import holmes.graphpanel.GraphPanel;
import holmes.petrinet.elements.ElementLocation;
import holmes.petrinet.elements.MetaNode;
import holmes.petrinet.elements.Node;
import holmes.petrinet.elements.PetriNetElement;
import holmes.petrinet.elements.Place;
import holmes.petrinet.elements.Transition;
import holmes.utilities.Tools;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.jfree.ui.tabbedui.VerticalLayout;

public class HolmesSubnetsInfo {
    private final GraphPanel graphPanel;
    private static final GUIManager overlord = GUIManager.getDefaultGUIManager();
    private static final LanguageManager lang = GUIManager.getLanguageManager();

    public HolmesSubnetsInfo(GraphPanel graphPanel) {
        this.graphPanel = graphPanel;
    }

    private JPanel initMainPanel() {
        JPanel mainPanel = new JPanel(null);
        mainPanel.setBounds(0, 0, 600, 480);
        JPanel infoPanel = new JPanel(null);
        mainPanel.add(infoPanel);
        infoPanel.setBounds(5, 5, mainPanel.getWidth() - 25, 130);
        infoPanel.setBorder(BorderFactory.createTitledBorder(lang.getText("HSIwin_entry001")));
        JLabel labelID = new JLabel(lang.getText("HSIwin_entry002"));
        infoPanel.add(labelID);
        labelID.setBounds(10, 20, 20, 20);
        JTextField idTextBox = new JTextField(String.valueOf(this.graphPanel.getSheetId()));
        infoPanel.add(idTextBox);
        idTextBox.setBounds(30, 20, 30, 20);
        idTextBox.setEditable(false);
        JLabel labelName = new JLabel(lang.getText("HSIwin_entry003"));
        infoPanel.add(labelName);
        labelName.setBounds(10, 40, 40, 20);
        JTextField nameField = new JTextField();
        infoPanel.add(nameField);
        nameField.setBounds(100, 40, 465, 20);
        MetaNode metaNode = HolmesSubnetsInfo.overlord.subnetsHQ.getMetanode(this.graphPanel.getSheetId()).orElseThrow();
        nameField.setText(metaNode.getName());
        nameField.getDocument().addDocumentListener(e -> {
            String newValue = nameField.getText();
            metaNode.setName(newValue);
            JFrame frame = (JFrame)SwingUtilities.getWindowAncestor(mainPanel);
            frame.setTitle(newValue);
        });
        JLabel commmentLabel = new JLabel(lang.getText("HSIwin_entry004"));
        infoPanel.add(commmentLabel);
        commmentLabel.setBounds(10, 60, 80, 20);
        JTextArea commentField = new JTextArea(metaNode.getComment());
        infoPanel.add(commentField);
        commentField.setLineWrap(true);
        commentField.getDocument().addDocumentListener(e -> {
            String newValue = commentField.getText();
            metaNode.setComment(newValue);
        });
        JPanel creationPanel = new JPanel();
        infoPanel.add(creationPanel);
        creationPanel.setLayout(new BorderLayout());
        creationPanel.add((Component)new JScrollPane(commentField), "Center");
        creationPanel.setBounds(100, 60, 465, 60);
        JPanel statisticsPanel = new JPanel(null);
        mainPanel.add(statisticsPanel);
        statisticsPanel.setBounds(5, 135, 230, 300);
        statisticsPanel.setBorder(BorderFactory.createTitledBorder(lang.getText("HSIwin_entry005")));
        JLabel nodesCountLabel = new JLabel(lang.getText("HSIwin_entry006"));
        statisticsPanel.add(nodesCountLabel);
        nodesCountLabel.setBounds(10, 25, 200, 20);
        ArrayList<ElementLocation> elements = HolmesSubnetsInfo.overlord.subnetsHQ.getSubnetElementLocations(this.graphPanel.getSheetId());
        JTextField nodesCountField = new JTextField(String.valueOf(elements.size()));
        statisticsPanel.add(nodesCountField);
        nodesCountField.setBounds(190, 25, 30, 20);
        nodesCountField.setEditable(false);
        List<Node> uniqueNodes = elements.stream().map(ElementLocation::getParentNode).sorted(Comparator.comparingInt(PetriNetElement::getID)).distinct().toList();
        JLabel placeCountLabel = new JLabel(lang.getText("HSIwin_entry007"));
        statisticsPanel.add(placeCountLabel);
        placeCountLabel.setBounds(10, 50, 200, 20);
        long placeCount = uniqueNodes.stream().filter(Place.class::isInstance).count();
        JTextField placeCountField = new JTextField(String.valueOf(placeCount));
        statisticsPanel.add(placeCountField);
        placeCountField.setBounds(190, 50, 30, 20);
        placeCountField.setEditable(false);
        JLabel transitionCountLabel = new JLabel(lang.getText("HSIwin_entry008"));
        statisticsPanel.add(transitionCountLabel);
        transitionCountLabel.setBounds(10, 75, 200, 20);
        long transitionCount = uniqueNodes.stream().filter(Transition.class::isInstance).count();
        JTextField transitionCountField = new JTextField(String.valueOf(transitionCount));
        statisticsPanel.add(transitionCountField);
        transitionCountField.setBounds(190, 75, 30, 20);
        transitionCountField.setEditable(false);
        JLabel tokensCountLabel = new JLabel(lang.getText("HSIwin_entry009"));
        statisticsPanel.add(tokensCountLabel);
        tokensCountLabel.setBounds(10, 100, 200, 20);
        int tokenCount = uniqueNodes.stream().filter(Place.class::isInstance).map(node -> ((Place)node).getTokensNumber()).reduce(Integer::sum).orElse(0);
        JTextField tokenCountField = new JTextField(String.valueOf(tokenCount));
        statisticsPanel.add(tokenCountField);
        tokenCountField.setBounds(190, 100, 30, 20);
        tokenCountField.setEditable(false);
        JPanel connectionsPanel = new JPanel(null);
        mainPanel.add(connectionsPanel);
        connectionsPanel.setBounds(240, 135, 340, 300);
        connectionsPanel.setBorder(BorderFactory.createTitledBorder(lang.getText("HSIwin_entry010")));
        JLabel parentIdLabel = new JLabel(lang.getText("HSIwin_entry011"));
        connectionsPanel.add(parentIdLabel);
        parentIdLabel.setBounds(10, 25, 100, 20);
        String parentId = String.valueOf(metaNode.getMySheetID());
        JTextField parentIdField = new JTextField(parentId);
        connectionsPanel.add(parentIdField);
        parentIdField.setBounds(110, 25, 220, 20);
        parentIdField.setEditable(false);
        JLabel parentNameLabel = new JLabel(lang.getText("HSIwin_entry012"));
        connectionsPanel.add(parentNameLabel);
        parentNameLabel.setBounds(10, 50, 100, 20);
        String parentName = HolmesSubnetsInfo.overlord.subnetsHQ.getMetanode(metaNode.getMySheetID()).map(PetriNetElement::getName).orElse("Subnet0");
        JTextField parentNameField = new JTextField(parentName);
        connectionsPanel.add(parentNameField);
        parentNameField.setBounds(110, 50, 220, 20);
        parentNameField.setEditable(false);
        JLabel childrenLabel = new JLabel(lang.getText("HSIwin_entry013"));
        connectionsPanel.add(childrenLabel);
        childrenLabel.setBounds(10, 90, 100, 20);
        JLabel tableHeader = new JLabel(" " + lang.getText("HSIwin_entry014"));
        connectionsPanel.add(tableHeader);
        tableHeader.setBorder(BorderFactory.createLineBorder(Color.GRAY));
        tableHeader.setBounds(10, 115, 220, 25);
        JPanel subnetsList = new JPanel(new VerticalLayout());
        JPanel subnetsWrapper = new JPanel();
        connectionsPanel.add(subnetsWrapper);
        subnetsWrapper.setLayout(new BorderLayout());
        subnetsWrapper.setBounds(10, 138, 220, 155);
        subnetsWrapper.add((Component)new JScrollPane(subnetsList), "Center");
        List<MetaNode> subnets = elements.stream().filter(location -> location.getParentNode() instanceof MetaNode).map(location -> (MetaNode)location.getParentNode()).toList();
        for (MetaNode subnet : subnets) {
            JLabel test = new JLabel(String.format(" %d     %s", subnet.getRepresentedSheetID(), subnet.getName()));
            subnetsList.add(test);
            test.setBorder(BorderFactory.createLineBorder(Color.GRAY));
            test.setPreferredSize(new Dimension(200, 40));
        }
        return mainPanel;
    }

    public void bind(JFrame frame) {
        frame.add(this.initMainPanel());
    }

    public static void open() {
        int subnetID = overlord.getWorkspace().getSelectedSheet().getId();
        HolmesSubnetsInfo.open(subnetID);
    }

    public static void open(int subnetID) {
        GraphPanel graphPanel = HolmesSubnetsInfo.overlord.subnetsHQ.getGraphPanel(subnetID);
        if (graphPanel.getSheetId() == 0) {
            JOptionPane.showMessageDialog(null, lang.getText("HSIwin_entry015"), lang.getText("HSIwin_entry015t"), 1);
            return;
        }
        final JFrame mainFrame = overlord.getFrame();
        JFrame targetFrame = new JFrame();
        try {
            targetFrame.setIconImage(Tools.getImageFromIcon("/icons/holmesicon.png"));
        }
        catch (Exception ex) {
            overlord.log(lang.getText("LOGentry00499exception") + " " + ex.getMessage(), "error", true);
        }
        mainFrame.setEnabled(false);
        targetFrame.setResizable(false);
        targetFrame.setLocation(20, 20);
        targetFrame.setSize(new Dimension(600, 480));
        targetFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                mainFrame.setEnabled(true);
            }
        });
        MetaNode metaNode = HolmesSubnetsInfo.overlord.subnetsHQ.getMetanode(graphPanel.getSheetId()).orElseThrow();
        targetFrame.setTitle(metaNode.getName());
        HolmesSubnetsInfo holmesSubnetsInfo = new HolmesSubnetsInfo(graphPanel);
        holmesSubnetsInfo.bind(targetFrame);
        targetFrame.setVisible(true);
    }
}

