/*
 * Decompiled with CFR 0.152.
 */
package holmes.windows;

import holmes.darkgui.GUIManager;
import holmes.darkgui.LanguageManager;
import holmes.darkgui.settings.SettingsManager;
import holmes.utilities.Tools;
import holmes.workspace.ExtensionFileFilter;
import java.io.File;
import javax.swing.filechooser.FileFilter;

public class HolmesProgramPropertiesActions {
    private static final GUIManager overlord = GUIManager.getDefaultGUIManager();
    private static final LanguageManager lang = GUIManager.getLanguageManager();
    SettingsManager sm;

    public HolmesProgramPropertiesActions(SettingsManager sm) {
        this.sm = sm;
    }

    public void setRPath() {
        FileFilter[] filters = new FileFilter[]{new ExtensionFileFilter("Rscript.exe (.exe)", new String[]{"EXE"})};
        String selectedFile = Tools.selectFileDialog("", filters, lang.getText("HPPAwin_entry001"), lang.getText("HPPAwin_entry001t"), "");
        if (selectedFile.isEmpty()) {
            return;
        }
        if (!selectedFile.contains("x64")) {
            Object dest = selectedFile.substring(0, selectedFile.lastIndexOf(File.separator));
            if (Tools.ifExist((String)(dest = (String)dest + "\\x64\\Rscript.exe"))) {
                this.sm.setValue("r_path64", (String)dest, true);
            } else {
                this.sm.setValue("r_path64", "", true);
            }
        } else {
            this.sm.setValue("r_path64", selectedFile, true);
        }
        if (Tools.ifExist(selectedFile)) {
            this.sm.setValue("r_path", selectedFile, true);
            overlord.setRStatus(true);
            String strB = "err.";
            try {
                strB = String.format(lang.getText("HPPAwin_entry002"), selectedFile);
            }
            catch (Exception e) {
                overlord.log(lang.getText("LOGentryLNGexc") + " HPPAwin_entry002", "error", true);
            }
            overlord.log(strB, "text", true);
        } else {
            this.sm.setValue("r_path", "", true);
            overlord.setRStatus(false);
            overlord.log(lang.getText("HPPAwin_entry003"), "warning", true);
        }
    }
}

