/*
 * Decompiled with CFR 0.152.
 */
package holmes.windows;

import holmes.darkgui.GUIManager;
import holmes.darkgui.LanguageManager;
import holmes.darkgui.settings.SettingsManager;
import holmes.utilities.Tools;
import holmes.windows.HolmesProgramPropertiesActions;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import javax.imageio.ImageIO;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.basic.BasicTabbedPaneUI;

public class HolmesProgramProperties
extends JFrame {
    private static final long serialVersionUID = 2831478312283009975L;
    private JFrame parentFrame;
    private static final GUIManager overlord = GUIManager.getDefaultGUIManager();
    private static final LanguageManager lang = GUIManager.getLanguageManager();
    private SettingsManager sm;
    private HolmesProgramPropertiesActions action;
    private boolean noAction = false;

    public HolmesProgramProperties(JFrame parent) {
        this.parentFrame = parent;
        this.sm = overlord.getSettingsManager();
        this.action = new HolmesProgramPropertiesActions(this.sm);
        try {
            this.setIconImage(Tools.getImageFromIcon("/icons/holmesicon.png"));
        }
        catch (Exception ex) {
            overlord.log(lang.getText("LOGentry00500exception") + "\n" + ex.getMessage(), "error", true);
        }
        try {
            this.initialize_components();
        }
        catch (Exception ex) {
            overlord.log(lang.getText("LOGentry00501exception") + "\n" + ex.getMessage(), "error", true);
        }
    }

    private void initialize_components() {
        Point pPoint = this.parentFrame.getLocation();
        this.setLocation(pPoint.x + 300, pPoint.y + 150);
        this.setTitle(lang.getText("HPPwin_entry001title"));
        this.setLayout(new BorderLayout());
        this.setSize(new Dimension(600, 500));
        this.setResizable(false);
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.setBounds(0, 0, 600, 500);
        tabbedPane.setUI(new BasicTabbedPaneUI(){

            @Override
            protected int calculateTabHeight(int tabPlacement, int tabIndex, int fontHeight) {
                return 32;
            }

            @Override
            protected void paintTab(Graphics g, int tabPlacement, Rectangle[] rects, int tabIndex, Rectangle iconRect, Rectangle textRect) {
                super.paintTab(g, tabPlacement, rects, tabIndex, iconRect, textRect);
            }
        });
        tabbedPane.addTab(lang.getText("HPPwin_entry002"), Tools.getResIcon32("/icons/propertiesWindow/systemIcon.png"), this.makeSysPanel(), lang.getText("HPPwin_entry002t"));
        tabbedPane.setMnemonicAt(0, 49);
        tabbedPane.addTab(lang.getText("HPPwin_entry003"), Tools.getResIcon32("/icons/propertiesWindow/editorIcon.png"), this.makeEditorPanel(), lang.getText("HPPwin_entry003t"));
        tabbedPane.setMnemonicAt(1, 50);
        tabbedPane.addTab(lang.getText("HPPwin_entry004"), Tools.getResIcon32("/icons/propertiesWindow/simulationIcon.png"), this.makeSimulatorPanel(), lang.getText("HPPwin_entry004t"));
        tabbedPane.setMnemonicAt(1, 51);
        tabbedPane.addTab(lang.getText("HPPwin_entry005"), Tools.getResIcon32("/icons/propertiesWindow/analysisIcon.png"), this.makeAnalysisPanel(), lang.getText("HPPwin_entry005t"));
        tabbedPane.setMnemonicAt(2, 52);
        JComponent panel5 = this.makeTextPanel("Other options.");
        tabbedPane.addTab(lang.getText("HPPwin_entry006"), Tools.getResIcon32("/icons/propertiesWindow/otherIcon.png"), panel5, lang.getText("HPPwin_entry006t"));
        tabbedPane.setMnemonicAt(3, 53);
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BorderLayout());
        mainPanel.setBounds(0, 0, 800, 600);
        mainPanel.add(tabbedPane);
        this.add(mainPanel);
        this.repaint();
    }

    private JPanel makeSysPanel() {
        JPanel panel = new JPanel(null);
        panel.setBounds(0, 0, 600, 500);
        panel.add(this.createRoptionsSystemPanel(0, 0, 590, 90));
        panel.add(this.createSnoopyReadSystemPanel(0, 90, 590, 150));
        panel.add(this.createLanguagesSelectionPanel(0, 240, 590, 100));
        panel.add(this.createOtherOptionsPanel(0, 340, 590, 100));
        panel.repaint();
        return panel;
    }

    private JPanel createSnoopyReadSystemPanel(int x, int y, int w, int h) {
        String netExtFactorValue;
        JPanel ioPanel = new JPanel(null);
        ioPanel.setBorder(BorderFactory.createTitledBorder(lang.getText("HPPwinSYS_entry007")));
        ioPanel.setBounds(x, y, w, h);
        int posX = 10;
        int posY = 15;
        this.noAction = true;
        JLabel labelIO1 = new JLabel(lang.getText("HPPwinSYS_entry008"));
        labelIO1.setBounds(posX, posY, 200, 20);
        ioPanel.add(labelIO1);
        ButtonGroup group = new ButtonGroup();
        JRadioButton resize80Button = new JRadioButton("80%");
        resize80Button.setBounds(posX, posY += 20, 60, 20);
        resize80Button.setActionCommand("0");
        resize80Button.addActionListener(actionEvent -> {
            if (this.noAction) {
                return;
            }
            overlord.getSettingsManager().setValue("programSnoopyLoaderNetExtFactor", "80", false);
        });
        group.add(resize80Button);
        ioPanel.add(resize80Button);
        JRadioButton resize100Button = new JRadioButton("100%");
        resize100Button.setBounds(posX + 60, posY, 60, 20);
        resize100Button.setActionCommand("1");
        resize100Button.addActionListener(actionEvent -> {
            if (this.noAction) {
                return;
            }
            overlord.getSettingsManager().setValue("programSnoopyLoaderNetExtFactor", "100", true);
        });
        group.add(resize100Button);
        ioPanel.add(resize100Button);
        JRadioButton resize120Button = new JRadioButton("120%");
        resize120Button.setBounds(posX + 120, posY, 60, 20);
        resize120Button.setActionCommand("2");
        resize120Button.addActionListener(actionEvent -> {
            if (this.noAction) {
                return;
            }
            overlord.getSettingsManager().setValue("programSnoopyLoaderNetExtFactor", "120", false);
        });
        group.add(resize120Button);
        ioPanel.add(resize120Button);
        JRadioButton resize140Button = new JRadioButton("140%");
        resize140Button.setBounds(posX, posY += 20, 60, 20);
        resize140Button.setActionCommand("3");
        resize140Button.addActionListener(actionEvent -> {
            if (this.noAction) {
                return;
            }
            overlord.getSettingsManager().setValue("programSnoopyLoaderNetExtFactor", "140", false);
        });
        group.add(resize140Button);
        ioPanel.add(resize140Button);
        JRadioButton resize160Button = new JRadioButton("160%");
        resize160Button.setBounds(posX + 60, posY, 60, 20);
        resize160Button.setActionCommand("4");
        resize160Button.addActionListener(actionEvent -> {
            if (this.noAction) {
                return;
            }
            overlord.getSettingsManager().setValue("programSnoopyLoaderNetExtFactor", "160", false);
        });
        group.add(resize160Button);
        ioPanel.add(resize160Button);
        JRadioButton resize180Button = new JRadioButton("180%");
        resize180Button.setBounds(posX + 120, posY, 60, 20);
        resize180Button.setActionCommand("5");
        resize180Button.addActionListener(actionEvent -> {
            if (this.noAction) {
                return;
            }
            overlord.getSettingsManager().setValue("programSnoopyLoaderNetExtFactor", "180", false);
        });
        group.add(resize180Button);
        ioPanel.add(resize180Button);
        switch (netExtFactorValue = overlord.getSettingsManager().getValue("programSnoopyLoaderNetExtFactor")) {
            case "80": {
                group.setSelected(resize80Button.getModel(), true);
                break;
            }
            case "120": {
                group.setSelected(resize120Button.getModel(), true);
                break;
            }
            case "140": {
                group.setSelected(resize140Button.getModel(), true);
                break;
            }
            case "160": {
                group.setSelected(resize160Button.getModel(), true);
                break;
            }
            case "180": {
                group.setSelected(resize180Button.getModel(), true);
                break;
            }
            default: {
                group.setSelected(resize100Button.getModel(), true);
            }
        }
        JCheckBox alignGridWhenSavedCheckBox = this.checkboxWizard(lang.getText("HPPwinSYS_entry009"), posX + 220, posY - 20, 350, 20, "editorGridAlignWhenSaved", true);
        ioPanel.add(alignGridWhenSavedCheckBox);
        JCheckBox useOffsetsCheckBox = this.checkboxWizard(lang.getText("HPPwinSYS_entry010"), posX + 220, posY, 350, 20, "editorUseSnoopyOffsets", true);
        ioPanel.add(useOffsetsCheckBox);
        JCheckBox useOldLoaderCheckBox = this.checkboxWizard(lang.getText("HPPwinSYS_entry011"), posX, posY += 20, 560, 20, "programUseOldSnoopyLoaders", true);
        ioPanel.add(useOldLoaderCheckBox);
        JCheckBox checkSaveCheckBox = this.checkboxWizard(lang.getText("HPPwinSYS_entry012"), posX, posY += 20, 500, 20, "editorExportCheckAndWarning", true);
        ioPanel.add(checkSaveCheckBox);
        JCheckBox simpleEditorCheckBox = this.checkboxWizard(lang.getText("HPPwinSYS_entry013"), posX, posY += 20, 500, 20, "programUseSimpleEditor", true);
        ioPanel.add(simpleEditorCheckBox);
        this.noAction = false;
        return ioPanel;
    }

    private JPanel createLanguagesSelectionPanel(int x, int y, int w, int h) {
        String current;
        JPanel langSelectionPanel = new JPanel(null);
        langSelectionPanel.setBorder(BorderFactory.createTitledBorder(lang.getText("HPPwinSYS_entry050")));
        langSelectionPanel.setBounds(x, y, w, h);
        int posX = 10;
        int posY = 20;
        this.noAction = true;
        try {
            BufferedImage image = ImageIO.read(this.getClass().getResource("/icons/propertiesWindow/english.png"));
            JLabel flagLabelEN = new JLabel(new ImageIcon(image));
            flagLabelEN.setBounds(posX, posY, 38, 20);
            langSelectionPanel.add(flagLabelEN);
        }
        catch (Exception ex) {
            overlord.log(ex.getMessage(), "error", true);
        }
        ButtonGroup group = new ButtonGroup();
        JRadioButton englishRadioButton = new JRadioButton(lang.getText("HPPwinSYS_entry051"));
        englishRadioButton.setBounds(posX += 40, posY, 95, 20);
        englishRadioButton.setActionCommand("0");
        englishRadioButton.addActionListener(actionEvent -> {
            if (this.noAction) {
                return;
            }
            String oldLang = this.changeKeyWordIntoLangWord(lang.getSelectedLanguage());
            String strB = "err.";
            try {
                strB = String.format(lang.getText("HPPwinSYS_entry053"), lang.getText("HPPwinSYS_entry051"), oldLang);
            }
            catch (Exception e) {
                overlord.log(lang.getText("LOGentryLNGexc") + " HPPwinSYS_entry053", "error", true);
            }
            lang.setLanguage("English", false);
            JOptionPane.showMessageDialog(null, strB, lang.getText("information"), 1);
        });
        group.add(englishRadioButton);
        langSelectionPanel.add(englishRadioButton);
        try {
            BufferedImage image = ImageIO.read(this.getClass().getResource("/icons/propertiesWindow/poland.png"));
            JLabel flagLabelPL = new JLabel(new ImageIcon(image));
            flagLabelPL.setBounds(posX += 100, posY, 38, 20);
            langSelectionPanel.add(flagLabelPL);
        }
        catch (Exception ex) {
            overlord.log(ex.getMessage(), "error", true);
        }
        JRadioButton polishRadioButton = new JRadioButton(lang.getText("HPPwinSYS_entry052"));
        polishRadioButton.setBounds(posX += 40, posY, 95, 20);
        polishRadioButton.setActionCommand("1");
        polishRadioButton.addActionListener(actionEvent -> {
            if (this.noAction) {
                return;
            }
            String oldLang = this.changeKeyWordIntoLangWord(lang.getSelectedLanguage());
            String strB = "err.";
            try {
                strB = String.format(lang.getText("HPPwinSYS_entry053"), lang.getText("HPPwinSYS_entry052"), oldLang);
            }
            catch (Exception e) {
                overlord.log(lang.getText("LOGentryLNGexc") + " HPPwinSYS_entry053", "error", true);
            }
            lang.setLanguage("Polish", false);
            JOptionPane.showMessageDialog(null, strB, lang.getText("information"), 1);
        });
        group.add(polishRadioButton);
        langSelectionPanel.add(polishRadioButton);
        try {
            BufferedImage image = ImageIO.read(this.getClass().getResource("/icons/propertiesWindow/germany.png"));
            JLabel flagLabelMNT = new JLabel(new ImageIcon(image));
            flagLabelMNT.setBounds(posX += 100, posY, 38, 20);
            langSelectionPanel.add(flagLabelMNT);
        }
        catch (Exception ex) {
            overlord.log(ex.getMessage(), "error", true);
        }
        JRadioButton germanRadioButton = new JRadioButton(lang.getText("HPPwinSYS_entry055"));
        germanRadioButton.setBounds(posX += 40, posY, 95, 20);
        germanRadioButton.setActionCommand("1");
        germanRadioButton.addActionListener(actionEvent -> {
            if (this.noAction) {
                return;
            }
            String oldLang = this.changeKeyWordIntoLangWord(lang.getSelectedLanguage());
            String strB = "err.";
            try {
                strB = String.format(lang.getText("HPPwinSYS_entry053"), lang.getText("HPPwinSYS_entry055"), oldLang);
            }
            catch (Exception e) {
                overlord.log(lang.getText("LOGentryLNGexc") + " HPPwinSYS_entry053", "error", true);
            }
            lang.setLanguage("German", false);
            JOptionPane.showMessageDialog(null, strB, lang.getText("information"), 1);
        });
        group.add(germanRadioButton);
        langSelectionPanel.add(germanRadioButton);
        try {
            BufferedImage image = ImageIO.read(this.getClass().getResource("/icons/propertiesWindow/spain.png"));
            JLabel flagLabelMNT = new JLabel(new ImageIcon(image));
            flagLabelMNT.setBounds(posX += 100, posY, 38, 20);
            langSelectionPanel.add(flagLabelMNT);
        }
        catch (Exception ex) {
            overlord.log(ex.getMessage(), "error", true);
        }
        JRadioButton spainRadioButton = new JRadioButton(lang.getText("HPPwinSYS_entry056"));
        spainRadioButton.setBounds(posX += 40, posY, 95, 20);
        spainRadioButton.setActionCommand("1");
        spainRadioButton.addActionListener(actionEvent -> {
            if (this.noAction) {
                return;
            }
            String oldLang = this.changeKeyWordIntoLangWord(lang.getSelectedLanguage());
            String strB = "err.";
            try {
                strB = String.format(lang.getText("HPPwinSYS_entry053"), lang.getText("HPPwinSYS_entry056"), oldLang);
            }
            catch (Exception e) {
                overlord.log(lang.getText("LOGentryLNGexc") + " HPPwinSYS_entry053", "error", true);
            }
            lang.setLanguage("Spanish", false);
            JOptionPane.showMessageDialog(null, strB, lang.getText("information"), 1);
        });
        group.add(spainRadioButton);
        langSelectionPanel.add(spainRadioButton);
        posX = 10;
        posY += 40;
        try {
            BufferedImage image = ImageIO.read(this.getClass().getResource("/icons/propertiesWindow/ukraine.png"));
            JLabel flagLabelMNT = new JLabel(new ImageIcon(image));
            flagLabelMNT.setBounds(posX, posY, 38, 20);
            langSelectionPanel.add(flagLabelMNT);
        }
        catch (Exception ex) {
            overlord.log(ex.getMessage(), "error", true);
        }
        JRadioButton ukrainianRadioButton = new JRadioButton(lang.getText("HPPwinSYS_entry057"));
        ukrainianRadioButton.setBounds(posX += 40, posY, 95, 20);
        ukrainianRadioButton.setActionCommand("1");
        ukrainianRadioButton.addActionListener(actionEvent -> {
            if (this.noAction) {
                return;
            }
            String oldLang = this.changeKeyWordIntoLangWord(lang.getSelectedLanguage());
            String strB = "err.";
            try {
                strB = String.format(lang.getText("HPPwinSYS_entry053"), lang.getText("HPPwinSYS_entry057"), oldLang);
            }
            catch (Exception e) {
                overlord.log(lang.getText("LOGentryLNGexc") + " HPPwinSYS_entry053", "error", true);
            }
            lang.setLanguage("Ukrainian", false);
            JOptionPane.showMessageDialog(null, strB, lang.getText("information"), 1);
        });
        group.add(ukrainianRadioButton);
        langSelectionPanel.add(ukrainianRadioButton);
        try {
            BufferedImage image = ImageIO.read(this.getClass().getResource("/icons/propertiesWindow/france.png"));
            JLabel flagLabelMNT = new JLabel(new ImageIcon(image));
            flagLabelMNT.setBounds(posX += 100, posY, 38, 20);
            langSelectionPanel.add(flagLabelMNT);
        }
        catch (Exception ex) {
            overlord.log(ex.getMessage(), "error", true);
        }
        JRadioButton frenchRadioButton = new JRadioButton(lang.getText("HPPwinSYS_entry058"));
        frenchRadioButton.setBounds(posX += 40, posY, 95, 20);
        frenchRadioButton.setActionCommand("1");
        frenchRadioButton.addActionListener(actionEvent -> {
            if (this.noAction) {
                return;
            }
            String oldLang = this.changeKeyWordIntoLangWord(lang.getSelectedLanguage());
            String strB = "err.";
            try {
                strB = String.format(lang.getText("HPPwinSYS_entry053"), lang.getText("HPPwinSYS_entry058"), oldLang);
            }
            catch (Exception e) {
                overlord.log(lang.getText("LOGentryLNGexc") + " HPPwinSYS_entry053", "error", true);
            }
            lang.setLanguage("French", false);
            JOptionPane.showMessageDialog(null, strB, lang.getText("information"), 1);
        });
        group.add(frenchRadioButton);
        langSelectionPanel.add(frenchRadioButton);
        try {
            BufferedImage image = ImageIO.read(this.getClass().getResource("/icons/propertiesWindow/italy.png"));
            JLabel flagLabelMNT = new JLabel(new ImageIcon(image));
            flagLabelMNT.setBounds(posX += 100, posY, 38, 20);
            langSelectionPanel.add(flagLabelMNT);
        }
        catch (Exception ex) {
            overlord.log(ex.getMessage(), "error", true);
        }
        JRadioButton italianRadioButton = new JRadioButton(lang.getText("HPPwinSYS_entry059"));
        italianRadioButton.setBounds(posX += 40, posY, 95, 20);
        italianRadioButton.setActionCommand("1");
        italianRadioButton.addActionListener(actionEvent -> {
            if (this.noAction) {
                return;
            }
            String oldLang = this.changeKeyWordIntoLangWord(lang.getSelectedLanguage());
            String strB = "err.";
            try {
                strB = String.format(lang.getText("HPPwinSYS_entry053"), lang.getText("HPPwinSYS_entry059"), oldLang);
            }
            catch (Exception e) {
                overlord.log(lang.getText("LOGentryLNGexc") + " HPPwinSYS_entry053", "error", true);
            }
            lang.setLanguage("Italian", false);
            JOptionPane.showMessageDialog(null, strB, lang.getText("information"), 1);
        });
        group.add(italianRadioButton);
        langSelectionPanel.add(italianRadioButton);
        try {
            BufferedImage image = ImageIO.read(this.getClass().getResource("/icons/propertiesWindow/yourlang.png"));
            JLabel flagLabelMNT = new JLabel(new ImageIcon(image));
            flagLabelMNT.setBounds(posX += 100, posY, 38, 20);
            langSelectionPanel.add(flagLabelMNT);
        }
        catch (Exception ex) {
            overlord.log(ex.getMessage(), "error", true);
        }
        JRadioButton yourLangRadioButton = new JRadioButton(lang.getText("HPPwinSYS_entry054"));
        yourLangRadioButton.setBounds(posX += 40, posY, 95, 20);
        yourLangRadioButton.setActionCommand("1");
        yourLangRadioButton.addActionListener(actionEvent -> {
            if (this.noAction) {
                return;
            }
            String oldLang = this.changeKeyWordIntoLangWord(lang.getSelectedLanguage());
            String strB = "err.";
            try {
                strB = String.format(lang.getText("HPPwinSYS_entry053"), lang.getText("HPPwinSYS_entry054"), oldLang);
            }
            catch (Exception e) {
                overlord.log(lang.getText("LOGentryLNGexc") + " HPPwinSYS_entry053", "error", true);
            }
            lang.setLanguage("YourLang", false);
            JOptionPane.showMessageDialog(null, strB, lang.getText("information"), 1);
        });
        group.add(yourLangRadioButton);
        langSelectionPanel.add(yourLangRadioButton);
        switch (current = lang.getSelectedLanguage()) {
            case "English": {
                group.setSelected(englishRadioButton.getModel(), true);
                break;
            }
            case "Polish": {
                group.setSelected(polishRadioButton.getModel(), true);
                break;
            }
            case "German": {
                group.setSelected(germanRadioButton.getModel(), true);
                break;
            }
            case "Spanish": {
                group.setSelected(spainRadioButton.getModel(), true);
                break;
            }
            case "Ukrainian": {
                group.setSelected(ukrainianRadioButton.getModel(), true);
                break;
            }
            case "French": {
                group.setSelected(frenchRadioButton.getModel(), true);
                break;
            }
            case "Italian": {
                group.setSelected(italianRadioButton.getModel(), true);
                break;
            }
            default: {
                group.setSelected(yourLangRadioButton.getModel(), true);
            }
        }
        this.noAction = false;
        return langSelectionPanel;
    }

    private String changeKeyWordIntoLangWord(String selectedLanguage) {
        return switch (selectedLanguage) {
            case "English" -> lang.getText("HPPwinSYS_entry051");
            case "Polish" -> lang.getText("HPPwinSYS_entry052");
            case "German" -> lang.getText("HPPwinSYS_entry055");
            case "Spanish" -> lang.getText("HPPwinSYS_entry056");
            case "Ukrainian" -> lang.getText("HPPwinSYS_entry057");
            case "France" -> lang.getText("HPPwinSYS_entry058");
            case "Italian" -> lang.getText("HPPwinSYS_entry059");
            default -> lang.getText("HPPwinSYS_entry054");
        };
    }

    private Component createOtherOptionsPanel(int x, int y, int w, int h) {
        String current;
        JPanel otherOptPanel = new JPanel(null);
        otherOptPanel.setBorder(BorderFactory.createTitledBorder(lang.getText("HPPwinSYS_entry049")));
        otherOptPanel.setBounds(x, y, w, h);
        int posX = 10;
        int posY = 20;
        this.noAction = true;
        JCheckBox alignGridWhenSavedCheckBox = this.checkboxWizard(lang.getText("HPPwinSYS_entry014"), posX, posY, 120, 20, "programDebugMode", true);
        otherOptPanel.add(alignGridWhenSavedCheckBox);
        JSeparator sep = new JSeparator();
        sep.setOrientation(1);
        sep.setBounds(posX + 140, posY, 2, 60);
        otherOptPanel.add(sep);
        JLabel testUILabel = new JLabel("HIGHLY experimental UI change");
        testUILabel.setBounds(posX + 150, posY, 200, 20);
        otherOptPanel.add(testUILabel);
        String strWarning = "IMPORTANT! This change will take effect after restart.\n\nEVEN MORE IMPORTANT: if after this Holmes do not start, either delete\nholmes.cfg file and restart OR (more subtle), set systemUI setting in\nholmes.cfg file into 0 (instead of any other number).";
        ButtonGroup group = new ButtonGroup();
        JRadioButton uiButton0 = new JRadioButton("Standard");
        uiButton0.setBounds(posX + 150, posY += 20, 90, 20);
        uiButton0.setActionCommand("0");
        uiButton0.addActionListener(actionEvent -> {
            if (this.noAction) {
                return;
            }
            overlord.getSettingsManager().setValue("systemUI", "0", true);
            JOptionPane.showMessageDialog(null, strWarning, lang.getText("warning"), 2);
        });
        group.add(uiButton0);
        otherOptPanel.add(uiButton0);
        JRadioButton uiButton1 = new JRadioButton("Nimbus");
        uiButton1.setBounds(posX + 245, posY, 90, 20);
        uiButton1.setActionCommand("1");
        uiButton1.addActionListener(actionEvent -> {
            if (this.noAction) {
                return;
            }
            overlord.getSettingsManager().setValue("systemUI", "1", true);
            JOptionPane.showMessageDialog(null, strWarning, lang.getText("warning"), 2);
        });
        group.add(uiButton1);
        otherOptPanel.add(uiButton1);
        JRadioButton uiButton2 = new JRadioButton("CDE/Motif");
        uiButton2.setBounds(posX + 340, posY, 90, 20);
        uiButton2.setActionCommand("2");
        uiButton2.addActionListener(actionEvent -> {
            if (this.noAction) {
                return;
            }
            overlord.getSettingsManager().setValue("systemUI", "2", true);
            JOptionPane.showMessageDialog(null, strWarning, lang.getText("warning"), 2);
        });
        group.add(uiButton2);
        otherOptPanel.add(uiButton2);
        JRadioButton uiButton3 = new JRadioButton("Windows");
        uiButton3.setBounds(posX + 150, posY + 20, 90, 20);
        uiButton3.setActionCommand("3");
        uiButton3.addActionListener(actionEvent -> {
            if (this.noAction) {
                return;
            }
            overlord.getSettingsManager().setValue("systemUI", "3", true);
            JOptionPane.showMessageDialog(null, strWarning, lang.getText("warning"), 2);
        });
        group.add(uiButton3);
        otherOptPanel.add(uiButton3);
        JRadioButton uiButton4 = new JRadioButton("Windows classic");
        uiButton4.setBounds(posX + 245, posY + 20, 140, 20);
        uiButton4.setActionCommand("4");
        uiButton4.addActionListener(actionEvent -> {
            if (this.noAction) {
                return;
            }
            overlord.getSettingsManager().setValue("systemUI", "4", true);
            JOptionPane.showMessageDialog(null, strWarning, lang.getText("warning"), 2);
        });
        group.add(uiButton4);
        otherOptPanel.add(uiButton4);
        switch (current = overlord.getSettingsManager().getValue("systemUI")) {
            case "0": {
                group.setSelected(uiButton0.getModel(), true);
                break;
            }
            case "1": {
                group.setSelected(uiButton1.getModel(), true);
                break;
            }
            case "2": {
                group.setSelected(uiButton2.getModel(), true);
                break;
            }
            case "3": {
                group.setSelected(uiButton3.getModel(), true);
                break;
            }
            default: {
                group.setSelected(uiButton4.getModel(), true);
            }
        }
        this.noAction = false;
        return otherOptPanel;
    }

    private JPanel createRoptionsSystemPanel(int x, int y, int w, int h) {
        JPanel rOptionsPanel = new JPanel(null);
        rOptionsPanel.setBorder(BorderFactory.createTitledBorder(lang.getText("HPPwinSYS_entry015")));
        rOptionsPanel.setBounds(x, y, w, h);
        JLabel labelR_1 = new JLabel(lang.getText("HPPwinSYS_entry016"));
        labelR_1.setBounds(10, 16, 90, 20);
        rOptionsPanel.add(labelR_1);
        JTextArea textR_1 = new JTextArea(this.sm.getValue("r_path"));
        textR_1.setBounds(105, 18, 360, 20);
        textR_1.setOpaque(false);
        textR_1.setEditable(false);
        rOptionsPanel.add(textR_1);
        JLabel labelR_2 = new JLabel(lang.getText("HPPwinSYS_entry017"));
        labelR_2.setBounds(10, 36, 90, 20);
        rOptionsPanel.add(labelR_2);
        JTextArea textR_2 = new JTextArea(this.sm.getValue("r_path64"));
        textR_2.setBounds(105, 38, 360, 20);
        textR_2.setOpaque(false);
        textR_2.setEditable(false);
        rOptionsPanel.add(textR_2);
        JButton rSetPath = new JButton(lang.getText("HPPwinSYS_entry018"));
        rSetPath.setName("setRpath");
        rSetPath.setBounds(10, 60, 140, 20);
        rSetPath.setToolTipText(lang.getText("HPPwinSYS_entry018t"));
        rSetPath.addActionListener(actionEvent -> {
            this.action.setRPath();
            textR_1.setText(this.sm.getValue("r_path"));
            textR_2.setText(this.sm.getValue("r_path64"));
        });
        rOptionsPanel.add(rSetPath);
        JCheckBox forceRcheckBox = this.checkboxWizard(lang.getText("HPPwinSYS_entry019"), 160, 60, 300, 20, "programAskForRonStartup", true);
        rOptionsPanel.add(forceRcheckBox);
        return rOptionsPanel;
    }

    private JPanel makeEditorPanel() {
        JPanel panel = new JPanel(null);
        panel.setBounds(0, 0, 600, 500);
        panel.add(this.createGraphicalEditorPanel(0, 0, 590, 210));
        panel.add(this.createGeneralEditorPanel(0, 210, 590, 90));
        panel.repaint();
        return panel;
    }

    private JPanel createGraphicalEditorPanel(int x, int y, int w, int h) {
        String thickValue;
        JPanel panel = new JPanel(null);
        panel.setBorder(BorderFactory.createTitledBorder(lang.getText("HPPwinEDIT_entry020")));
        panel.setBounds(x, y, w, h);
        int posX = 10;
        int posY = 15;
        this.noAction = true;
        JLabel labelIO1 = new JLabel(lang.getText("HPPwinEDIT_entry021"));
        labelIO1.setBounds(posX, posY, 240, 20);
        panel.add(labelIO1);
        ButtonGroup group = new ButtonGroup();
        JRadioButton size1Button = new JRadioButton("1");
        size1Button.setBounds(posX, posY + 20, 40, 20);
        size1Button.setActionCommand("0");
        size1Button.addActionListener(actionEvent -> {
            if (this.noAction) {
                return;
            }
            overlord.getSettingsManager().setValue("editorGraphArcLineSize", "1", true);
            overlord.getWorkspace().repaintAllGraphPanels();
        });
        group.add(size1Button);
        panel.add(size1Button);
        JRadioButton size2Button = new JRadioButton("2");
        size2Button.setBounds(posX + 40, posY + 20, 40, 20);
        size2Button.setActionCommand("1");
        size2Button.addActionListener(actionEvent -> {
            if (this.noAction) {
                return;
            }
            overlord.getSettingsManager().setValue("editorGraphArcLineSize", "2", true);
            overlord.getWorkspace().repaintAllGraphPanels();
        });
        group.add(size2Button);
        panel.add(size2Button);
        JRadioButton size3Button = new JRadioButton("3");
        size3Button.setBounds(posX + 80, posY + 20, 40, 20);
        size3Button.setActionCommand("2");
        size3Button.addActionListener(actionEvent -> {
            if (this.noAction) {
                return;
            }
            overlord.getSettingsManager().setValue("editorGraphArcLineSize", "3", true);
            overlord.getWorkspace().repaintAllGraphPanels();
        });
        group.add(size3Button);
        panel.add(size3Button);
        switch (thickValue = overlord.getSettingsManager().getValue("editorGraphArcLineSize")) {
            case "1": {
                group.setSelected(size1Button.getModel(), true);
                break;
            }
            case "2": {
                group.setSelected(size2Button.getModel(), true);
                break;
            }
            case "3": {
                group.setSelected(size3Button.getModel(), true);
            }
        }
        JLabel labelFontSize = new JLabel(lang.getText("HPPwinEDIT_entry022"));
        labelFontSize.setBounds(posX + 210, posY, 100, 20);
        panel.add(labelFontSize);
        JCheckBox boldCheckBox = this.checkboxWizard(lang.getText("HPPwinEDIT_entry023"), posX + 320, posY, 110, 20, "editorGraphFontBold", true);
        panel.add(boldCheckBox);
        JCheckBox mctNameCheckBox = this.checkboxWizard(lang.getText("HPPwinEDIT_entry024"), posX + 320, posY + 20, 110, 20, "mctNameShow", true);
        mctNameCheckBox.setToolTipText(lang.getText("HPPwinEDIT_entry024t"));
        panel.add(mctNameCheckBox);
        SpinnerNumberModel fontSizeSpinnerModel = new SpinnerNumberModel(Integer.parseInt(overlord.getSettingsManager().getValue("editorGraphFontSize")), 7, 30, 1);
        JSpinner fontSizeSpinner = new JSpinner(fontSizeSpinnerModel);
        fontSizeSpinner.setBounds(posX + 210, posY += 20, 80, 20);
        fontSizeSpinner.addChangeListener(e -> {
            if (this.noAction) {
                return;
            }
            JSpinner spinner = (JSpinner)e.getSource();
            int val = (Integer)spinner.getValue();
            overlord.getSettingsManager().setValue("editorGraphFontSize", "" + val, true);
            overlord.getWorkspace().repaintAllGraphPanels();
        });
        panel.add(fontSizeSpinner);
        JCheckBox useShortNamesCheckBox = this.checkboxWizard(lang.getText("HPPwinEDIT_entry025"), posX, posY += 20, 420, 20, "editorShowShortNames", true);
        panel.add(useShortNamesCheckBox);
        JCheckBox useShortNamesLowerIndexCheckBox = this.checkboxWizard(lang.getText("HPPwinEDIT_entry026"), posX, posY += 20, 420, 20, "editorShortNameLowerIndex", true);
        panel.add(useShortNamesLowerIndexCheckBox);
        JCheckBox view3dCheckBox = this.checkboxWizard(lang.getText("HPPwinEDIT_entry027"), posX, posY += 20, 420, 20, "editor3Dview", true);
        panel.add(view3dCheckBox);
        JCheckBox snoopyStyleCheckBox = this.checkboxWizard(lang.getText("HPPwinEDIT_entry028"), posX, posY += 20, 420, 20, "editorSnoopyStyleGraphic", true);
        panel.add(snoopyStyleCheckBox);
        JCheckBox portalLinesBox = this.checkboxWizard(lang.getText("HPPwinEDIT_entry030"), posX, posY += 20, 420, 20, "editorPortalLines", true);
        panel.add(portalLinesBox);
        JCheckBox snoopyColorsBox = this.checkboxWizard(lang.getText("HPPwinEDIT_entry029"), posX, posY += 20, 420, 20, "editorSnoopyColors", true);
        panel.add(snoopyColorsBox);
        JCheckBox portalNewVersionBox = this.checkboxWizard(lang.getText("HPPwinEDIT_entry127"), posX, posY += 20, 420, 20, "editorNewPortalPlace", true);
        panel.add(portalNewVersionBox);
        this.noAction = false;
        return panel;
    }

    private JPanel createGeneralEditorPanel(int x, int y, int w, int h) {
        JPanel panel = new JPanel(null);
        panel.setBorder(BorderFactory.createTitledBorder(lang.getText("HPPwinEDIT_entry031")));
        panel.setBounds(x, y, w, h);
        int posX = 10;
        int posY = 15;
        this.noAction = true;
        JCheckBox snoopyCompatibilityCheckBox = new JCheckBox(lang.getText("HPPwinEDIT_entry032"), true);
        snoopyCompatibilityCheckBox.setBounds(posX, posY, 500, 20);
        snoopyCompatibilityCheckBox.addActionListener(actionEvent -> {
            if (this.noAction) {
                return;
            }
            AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
            if (abstractButton.getModel().isSelected()) {
                overlord.getSettingsManager().setValue("editorSnoopyCompatibleMode", "1", true);
            } else {
                overlord.getSettingsManager().setValue("editorSnoopyCompatibleMode", "0", true);
            }
            overlord.getWorkspace().repaintAllGraphPanels();
        });
        snoopyCompatibilityCheckBox.setSelected(overlord.getSettingsManager().getValue("editorSnoopyCompatibleMode").equals("1"));
        panel.add(snoopyCompatibilityCheckBox);
        JCheckBox subnetCompressionCheckBox = this.checkboxWizard(lang.getText("HPPwinEDIT_entry033"), posX, posY += 20, 500, 20, "editorSubnetCompressMode", true);
        panel.add(subnetCompressionCheckBox);
        this.noAction = false;
        return panel;
    }

    public JPanel makeSimulatorPanel() {
        JPanel panel = new JPanel(null);
        panel.setBounds(0, 0, 600, 500);
        panel.add(this.createSimPanel(0, 0, 590, 150));
        panel.add(this.createSimGraphic(0, 150, 590, 100));
        panel.add(this.createSimXTPNPanel(0, 250, 590, 100));
        panel.repaint();
        return panel;
    }

    private JPanel createSimPanel(int x, int y, int w, int h) {
        JPanel panel = new JPanel(null);
        panel.setBorder(BorderFactory.createTitledBorder(lang.getText("HPPwinSIM_entry034")));
        panel.setBounds(x, y, w, h);
        int posX = 10;
        int posY = 15;
        this.noAction = true;
        JCheckBox readArcReservCheckBox = this.checkboxWizard(lang.getText("HPPwinSIM_entry035"), posX, posY, 500, 20, "simTransReadArcTokenReserv", true);
        panel.add(readArcReservCheckBox);
        JCheckBox singleMaxModeCheckBox = this.checkboxWizard(lang.getText("HPPwinSIM_entry036"), posX, posY += 20, 500, 20, "simSingleMode", true);
        panel.add(singleMaxModeCheckBox);
        JCheckBox simTDPNrunTimeCheckBox = this.checkboxWizard(lang.getText("HPPwinSIM_entry037"), posX, posY += 20, 500, 20, "simTDPNrunWhenEft", true);
        panel.add(simTDPNrunTimeCheckBox);
        JCheckBox placesColorsCheckBox = this.checkboxWizard(lang.getText("HPPwinSIM_entry038"), posX, posY += 20, 500, 20, "simPlacesColors", true);
        panel.add(placesColorsCheckBox);
        JCheckBox isSimulatorLoggedCheckBox = this.checkboxWizard(lang.getText("HPPwinSIM_entry044"), posX, posY += 20, 500, 20, "simLogEnabled", true);
        panel.add(isSimulatorLoggedCheckBox);
        this.noAction = false;
        return panel;
    }

    private JPanel createSimXTPNPanel(int x, int y, int w, int h) {
        JPanel panel = new JPanel(null);
        panel.setBorder(BorderFactory.createTitledBorder("XTPN"));
        panel.setBounds(x, y, w, h);
        int posX = 10;
        int posY = 15;
        this.noAction = true;
        JCheckBox XTPNsimMassActionCheckBox = this.checkboxWizard(lang.getText("HPPwinSIM_entry039"), posX, posY, 500, 20, "simXTPNmassAction", true);
        panel.add(XTPNsimMassActionCheckBox);
        JCheckBox XTPNsimReadArcTokenCheckBox = this.checkboxWizard(lang.getText("HPPwinSIM_entry040"), posX, posY += 20, 500, 20, "simXTPNreadArcTokens", true);
        panel.add(XTPNsimReadArcTokenCheckBox);
        JCheckBox XTPNsimReadArcDoNotTakeTokensCheckBox = this.checkboxWizard("(XTPN) Read arcs do not take tokens", posX, posY += 20, 500, 20, "simXTPNreadArcDoNotTakeTokens", true);
        panel.add(XTPNsimReadArcDoNotTakeTokensCheckBox);
        this.noAction = false;
        return panel;
    }

    private JPanel createSimGraphic(int x, int y, int w, int h) {
        JPanel panel = new JPanel(null);
        panel.setBorder(BorderFactory.createTitledBorder(lang.getText("HPPwinSIM_entry041")));
        panel.setBounds(x, y, w, h);
        int io_x = 10;
        int io_y = 15;
        this.noAction = true;
        JLabel transDelayLabel = new JLabel(lang.getText("HPPwinSIM_entry042"));
        transDelayLabel.setBounds(io_x, io_y, 200, 20);
        panel.add(transDelayLabel);
        JLabel arcDelayLabel = new JLabel(lang.getText("HPPwinSIM_entry043"));
        arcDelayLabel.setBounds(io_x + 280, io_y, 200, 20);
        panel.add(arcDelayLabel);
        JSlider arcDelaySlider = new JSlider(0, 5, 85, 25);
        arcDelaySlider.setBounds(io_x + 280, io_y += 20, 250, 50);
        arcDelaySlider.setMinorTickSpacing(2);
        arcDelaySlider.setMajorTickSpacing(10);
        arcDelaySlider.setPaintTicks(true);
        arcDelaySlider.setPaintLabels(true);
        arcDelaySlider.setLabelTable(arcDelaySlider.createStandardLabels(10));
        arcDelaySlider.addChangeListener(e -> {
            int reference;
            JSlider s = (JSlider)e.getSource();
            int val = s.getValue();
            if (val <= (reference = HolmesProgramProperties.overlord.simSettings.getTransitionGraphicDelay())) {
                arcDelaySlider.setValue(val);
                HolmesProgramProperties.overlord.simSettings.setArcGraphicDelay(val);
            } else {
                s.setValue(reference);
            }
        });
        panel.add(arcDelaySlider);
        final JSlider transDelaySlider = new JSlider(0, 5, 85, 25);
        transDelaySlider.setBounds(io_x, io_y, 250, 50);
        transDelaySlider.setMinorTickSpacing(2);
        transDelaySlider.setMajorTickSpacing(10);
        transDelaySlider.setPaintTicks(true);
        transDelaySlider.setPaintLabels(true);
        transDelaySlider.setLabelTable(transDelaySlider.createStandardLabels(10));
        transDelaySlider.addChangeListener(new ChangeListener(){
            private JSlider anotherSlider = null;

            @Override
            public void stateChanged(ChangeEvent e) {
                JSlider s = (JSlider)e.getSource();
                int value = s.getValue();
                transDelaySlider.setValue(value);
                HolmesProgramProperties.overlord.simSettings.setTransitionGraphicDelay(value);
                if (value < HolmesProgramProperties.overlord.simSettings.getArcGraphicDelay()) {
                    this.anotherSlider.setValue(value);
                }
            }

            private ChangeListener yesWeCan(JSlider slider) {
                this.anotherSlider = slider;
                return this;
            }
        }.yesWeCan(arcDelaySlider));
        panel.add(transDelaySlider);
        this.noAction = false;
        return panel;
    }

    public JPanel makeAnalysisPanel() {
        JPanel panel = new JPanel(null);
        panel.setBounds(0, 0, 600, 500);
        panel.add(this.createClustersOptionsPanel(0, 0, 590, 60));
        panel.add(this.createMCSPanel(0, 60, 590, 60));
        panel.repaint();
        return panel;
    }

    private JPanel createClustersOptionsPanel(int x, int y, int w, int h) {
        JPanel panel = new JPanel(null);
        panel.setBorder(BorderFactory.createTitledBorder(lang.getText("HPPwinANAL_entry044")));
        panel.setBounds(x, y, w, h);
        int io_x = 10;
        int io_y = 15;
        this.noAction = true;
        JCheckBox binaryTinvCheckBox = this.checkboxWizard(lang.getText("HPPwinANAL_entry045"), io_x, io_y, 450, 20, "analysisBinaryCSVInvariants", false);
        panel.add(binaryTinvCheckBox);
        JCheckBox feasInvSelfPropCheckBox = this.checkboxWizard(lang.getText("HPPwinANAL_entry046"), io_x, io_y += 20, 450, 20, "analysisFeasibleSelfPropAccepted", true);
        panel.add(feasInvSelfPropCheckBox);
        this.noAction = false;
        return panel;
    }

    private JPanel createClusteringPanel(int x, int y, int w, int h) {
        JPanel panel = new JPanel(null);
        panel.setBorder(BorderFactory.createTitledBorder(lang.getText("HPPwinANAL_entry047")));
        panel.setBounds(x, y, w, h);
        this.noAction = true;
        this.noAction = false;
        return panel;
    }

    private JPanel createMCSPanel(int x, int y, int w, int h) {
        JPanel panel = new JPanel(null);
        panel.setBorder(BorderFactory.createTitledBorder("MCS generator"));
        panel.setBounds(x, y, w, h);
        int io_x = 10;
        int io_y = 15;
        this.noAction = true;
        JCheckBox cleanMCSusingStructureCheckBox = this.checkboxWizard(lang.getText("HPPwinANAL_entry048"), io_x, io_y, 510, 20, "analysisMCSReduction", true);
        panel.add(cleanMCSusingStructureCheckBox);
        this.noAction = false;
        return panel;
    }

    protected JComponent makeTextPanel(String text) {
        JPanel panel = new JPanel(false);
        JLabel filler = new JLabel(text);
        filler.setHorizontalAlignment(0);
        panel.add(filler);
        panel.setBounds(0, 0, 640, 480);
        return panel;
    }

    private JCheckBox checkboxWizard(String checkBName, int xPos, int yPos, int width, int height, String propName, boolean autosave) {
        JCheckBox view3dCheckBox = new JCheckBox(checkBName, true);
        view3dCheckBox.setBounds(xPos, yPos, width, height);
        view3dCheckBox.addActionListener(new ActionListener(){
            private String propName = "";
            private boolean autoSave;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (HolmesProgramProperties.this.noAction) {
                    return;
                }
                AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
                if (abstractButton.getModel().isSelected()) {
                    overlord.getSettingsManager().setValue(this.propName, "1", this.autoSave);
                } else {
                    overlord.getSettingsManager().setValue(this.propName, "0", this.autoSave);
                }
                overlord.getWorkspace().repaintAllGraphPanels();
            }

            private ActionListener yesWeCan(String name, boolean autosave) {
                this.propName = name;
                this.autoSave = autosave;
                return this;
            }
        }.yesWeCan(propName, autosave));
        view3dCheckBox.setSelected(overlord.getSettingsManager().getValue(propName).equals("1"));
        return view3dCheckBox;
    }
}

