/*
 * Decompiled with CFR 0.152.
 */
package holmes.windows;

import holmes.analyse.InvariantsTools;
import holmes.darkgui.GUIManager;
import holmes.darkgui.LanguageManager;
import holmes.graphpanel.GraphPanel;
import holmes.petrinet.elements.Arc;
import holmes.petrinet.elements.Node;
import holmes.petrinet.elements.Place;
import holmes.petrinet.elements.Transition;
import holmes.utilities.Tools;
import holmes.windows.HolmesNetTables;
import holmes.windows.HolmesNotepad;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import javax.swing.JFrame;
import javax.swing.JProgressBar;

public class HolmesNodeInfoActions {
    private JFrame parentFrame;
    private static final GUIManager overlord = GUIManager.getDefaultGUIManager();
    private static final LanguageManager lang = GUIManager.getLanguageManager();

    public HolmesNodeInfoActions(JFrame parent) {
        this.parentFrame = parent;
    }

    public void changeName(Node place, String newName) {
        place.setName(newName);
        this.repaintGraphPanel(place);
    }

    public void changeComment(Node place, String newComment) {
        place.setComment(newComment);
    }

    public void setTokens(Place place, int tokens) {
        place.setTokensNumber(tokens);
        this.repaintGraphPanel(place);
    }

    private void repaintGraphPanel(Node node) {
        int sheetIndex = overlord.IDtoIndex(node.getElementLocations().get(0).getSheetID());
        GraphPanel graphPanel = overlord.getWorkspace().getSheets().get(sheetIndex).getGraphPanel();
        graphPanel.repaint();
    }

    public void parentTableUpdate(JFrame parentFrame, String name) {
        if (parentFrame instanceof HolmesNetTables) {
            ((HolmesNetTables)parentFrame).updateRow(name, 1);
        }
    }

    public void showTinvForPlace(Place place, JProgressBar progressBar) {
        ArrayList<ArrayList<Integer>> invariantsMatrix = overlord.getWorkspace().getProject().getT_InvMatrix();
        if (invariantsMatrix == null || invariantsMatrix.isEmpty()) {
            return;
        }
        HolmesNotepad notepad = new HolmesNotepad(800, 600, true);
        ArrayList<Transition> transitions = overlord.getWorkspace().getProject().getTransitions();
        ArrayList<ArrayList<Integer>> invariantsSubMatrix = new ArrayList<ArrayList<Integer>>();
        for (ArrayList<Integer> invariant : invariantsMatrix) {
            int position = -1;
            boolean bl = false;
            for (int t : invariant) {
                ++position;
                if (t == 0) continue;
                for (Arc arc : transitions.get(position).getInputArcs()) {
                    if (!arc.getStartNode().equals(place)) continue;
                    bl = true;
                    break;
                }
                if (!bl) continue;
                break;
            }
            if (!bl) continue;
            position = -1;
            boolean targetPlaceFound = false;
            for (int t : invariant) {
                ++position;
                if (t == 0) continue;
                for (Arc arc : transitions.get(position).getOutputArcs()) {
                    if (!arc.getEndNode().equals(place)) continue;
                    targetPlaceFound = true;
                    break;
                }
                if (!targetPlaceFound) continue;
                break;
            }
            if (!targetPlaceFound) continue;
            invariantsSubMatrix.add(invariant);
        }
        ArrayList<ArrayList<Transition>> mctSets = overlord.getWorkspace().getProject().getMCTMatrix();
        progressBar.setMaximum(invariantsSubMatrix.size());
        progressBar.setMinimum(0);
        progressBar.setValue(0);
        int counter = 0;
        for (ArrayList arrayList : invariantsSubMatrix) {
            int index = invariantsMatrix.indexOf(arrayList);
            this.showInvariantNotepadSimple(counter, index, notepad, arrayList, transitions, mctSets);
            notepad.addTextLineNL("", "text");
            notepad.addTextLineNL("=====================================================================================", "text");
            notepad.addTextLineNL("", "text");
            progressBar.setValue(counter++);
            if (counter % 20 != 0) continue;
            progressBar.update(progressBar.getGraphics());
        }
        notepad.addTextLineNL("", "text");
        notepad.addTextLineNL("=====================================================================================", "text");
        notepad.addTextLineNL("=====================================================================================", "text");
        notepad.addTextLineNL("=====================================================================================", "text");
        notepad.addTextLineNL("", "text");
        counter = 0;
        for (ArrayList arrayList : invariantsSubMatrix) {
            StringBuilder vector = new StringBuilder();
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                int fireValue = (Integer)iterator.next();
                vector.append(fireValue).append(";");
                if (fireValue != 0) continue;
            }
            vector = new StringBuilder(vector.substring(0, vector.length() - 1));
            notepad.addTextLineNL(counter + ";" + String.valueOf(vector), "text");
            ++counter;
        }
        notepad.setVisible(true);
    }

    public void showTinvForTransition(Transition transition, JProgressBar progressBar) {
        ArrayList<ArrayList<Integer>> invariantsMatrix = overlord.getWorkspace().getProject().getT_InvMatrix();
        if (invariantsMatrix == null || invariantsMatrix.isEmpty()) {
            return;
        }
        HolmesNotepad notepad = new HolmesNotepad(800, 600, true);
        ArrayList<Transition> transitions = overlord.getWorkspace().getProject().getTransitions();
        ArrayList<ArrayList<Integer>> invariantsSubMatrix = InvariantsTools.returnT_invWithTransition(invariantsMatrix, transitions.indexOf(transition));
        ArrayList<ArrayList<Transition>> mctSets = overlord.getWorkspace().getProject().getMCTMatrix();
        progressBar.setMaximum(invariantsSubMatrix.size());
        progressBar.setMinimum(0);
        progressBar.setValue(0);
        int counter = 0;
        for (ArrayList<Integer> invariant : invariantsSubMatrix) {
            int index = invariantsMatrix.indexOf(invariant);
            this.showInvariantNotepadSimple(counter, index, notepad, invariant, transitions, mctSets);
            notepad.addTextLineNL("", "text");
            notepad.addTextLineNL("=====================================================================================", "text");
            notepad.addTextLineNL("", "text");
            progressBar.setValue(counter++);
            if (counter % 20 != 0) continue;
            progressBar.update(progressBar.getGraphics());
        }
        notepad.addTextLineNL("", "text");
        notepad.addTextLineNL("=====================================================================================", "text");
        notepad.addTextLineNL("=====================================================================================", "text");
        notepad.addTextLineNL("=====================================================================================", "text");
        notepad.addTextLineNL("", "text");
        counter = 0;
        for (ArrayList<Integer> invariant : invariantsSubMatrix) {
            StringBuilder vector = new StringBuilder();
            for (int fireValue : invariant) {
                vector.append(fireValue).append(";");
                if (fireValue != 0) continue;
            }
            vector = new StringBuilder(vector.substring(0, vector.length() - 1));
            notepad.addTextLineNL(counter + ";" + String.valueOf(vector), "text");
            ++counter;
        }
        notepad.setVisible(true);
    }

    /*
     * WARNING - void declaration
     */
    protected void showInvariantNotepad(int invNo, HolmesNotepad notepad, ArrayList<Integer> invariant, ArrayList<Transition> transitions) {
        void var11_17;
        ArrayList<Integer> mcts = new ArrayList<Integer>();
        ArrayList<CallSite> singleT = new ArrayList<CallSite>();
        ArrayList<Integer> transMCTvector = overlord.getWorkspace().getProject().getMCTtransIndicesVector();
        int transNumber = 0;
        for (int t = 0; t < invariant.size(); ++t) {
            int fireValue = invariant.get(t);
            if (fireValue == 0) continue;
            ++transNumber;
            int n = transMCTvector.get(t);
            if (n == -1) {
                singleT.add((CallSite)((Object)("T" + t + "_" + transitions.get(t).getName())));
                continue;
            }
            if (mcts.contains(n)) continue;
            mcts.add(n);
        }
        String description = overlord.getWorkspace().getProject().accessT_InvDescriptions().get(invNo);
        notepad.addTextLineNL(lang.getText("HNIAwin_entry001") + " " + (invNo + 1), "text");
        notepad.addTextLineNL(lang.getText("HNIAwin_entry002") + " " + description, "text");
        notepad.addTextLineNL(lang.getText("HNIAwin_entry003") + " " + transNumber, "text");
        notepad.addTextLineNL(lang.getText("HNIAwin_entry004"), "text");
        Iterator fireValue = mcts.iterator();
        while (fireValue.hasNext()) {
            int n = (Integer)fireValue.next();
            String MCTname = overlord.getWorkspace().getProject().getMCTname(n);
            notepad.addTextLineNL("  [MCT: " + (n + 1) + "]: " + MCTname, "text");
        }
        for (String string : singleT) {
            notepad.addTextLineNL(string, "text");
        }
        notepad.addTextLineNL("", "text");
        notepad.addTextLineNL(lang.getText("HNIAwin_entry005") + (invNo + 1) + ":", "text");
        if (transitions.size() != invariant.size() && ((transitions = overlord.getWorkspace().getProject().getTransitions()) == null || transitions.size() != invariant.size())) {
            overlord.log(lang.getText("LOGentry00484critErr"), "error", true);
            return;
        }
        StringBuilder vector = new StringBuilder();
        boolean bl = false;
        while (var11_17 < invariant.size()) {
            int fireValue2 = invariant.get((int)var11_17);
            vector.append(fireValue2).append(";");
            if (fireValue2 != 0) {
                Transition realT = transitions.get((int)var11_17);
                String t1 = Tools.setToSize("t" + (int)var11_17, 5, false);
                String t2 = Tools.setToSize("Fired: " + fireValue2, 12, false);
                notepad.addTextLineNL(t1 + t2 + " ; " + realT.getName(), "text");
            }
            ++var11_17;
        }
        vector = new StringBuilder(vector.substring(0, vector.length() - 1));
        notepad.addTextLineNL("", "text");
        notepad.addTextLineNL(lang.getText("HNIAwin_entry006"), "text");
        notepad.addTextLineNL(vector.toString(), "text");
    }

    protected void showInvariantNotepadSimple(int invNo, int index, HolmesNotepad notepad, ArrayList<Integer> invariant, ArrayList<Transition> transitions, ArrayList<ArrayList<Transition>> mctSets) {
        ArrayList<Integer> mcts = new ArrayList<Integer>();
        ArrayList<CallSite> singleT = new ArrayList<CallSite>();
        ArrayList<Integer> transMCTvector = overlord.getWorkspace().getProject().getMCTtransIndicesVector();
        for (int t = 0; t < invariant.size(); ++t) {
            int fireValue = invariant.get(t);
            if (fireValue == 0) continue;
            int n = transMCTvector.get(t);
            if (n == -1) {
                singleT.add((CallSite)((Object)("t" + t + "_" + transitions.get(t).getName())));
                continue;
            }
            if (mcts.contains(n)) continue;
            mcts.add(n);
        }
        Collections.sort(mcts);
        String strB = "err.";
        try {
            strB = String.format(lang.getText("HNIAwin_entry007"), invNo, index + 1);
        }
        catch (Exception e) {
            overlord.log(lang.getText("LOGentryLNGexc") + " HNIAwin_entry007", "error", true);
        }
        notepad.addTextLineNL(strB, "text");
        Iterator e = mcts.iterator();
        while (e.hasNext()) {
            int n = (Integer)e.next();
            StringBuilder transInMCT = new StringBuilder();
            for (Transition trans : mctSets.get(n)) {
                transInMCT.append("t").append(transitions.indexOf(trans)).append("_").append(trans.getName()).append(",  ");
            }
            transInMCT = new StringBuilder(transInMCT.substring(0, transInMCT.length() - 3));
            notepad.addTextLineNL("  [MCT_" + (n + 1) + ": " + String.valueOf(transInMCT) + "]", "text");
        }
        for (String string : singleT) {
            notepad.addTextLineNL(string, "text");
        }
        StringBuilder vector = new StringBuilder();
        for (int fireValue : invariant) {
            vector.append(fireValue).append(";");
            if (fireValue != 0) continue;
        }
        vector = new StringBuilder(vector.substring(0, vector.length() - 1));
        notepad.addTextLineNL("", "text");
        notepad.addTextLineNL(lang.getText("HNIAwin_entry008"), "text");
        notepad.addTextLineNL(vector.toString(), "text");
    }
}

