/*
 * Decompiled with CFR 0.152.
 */
package holmes.windows;

import holmes.darkgui.GUIManager;
import holmes.darkgui.LanguageManager;
import holmes.graphpanel.GraphPanel;
import holmes.petrinet.elements.ElementLocation;
import holmes.petrinet.elements.MetaNode;
import holmes.petrinet.elements.Node;
import holmes.petrinet.elements.Place;
import holmes.petrinet.elements.Transition;
import holmes.petrinet.simulators.GraphicalSimulator;
import holmes.petrinet.simulators.SimulatorGlobals;
import holmes.petrinet.simulators.StateSimulator;
import holmes.utilities.Tools;
import holmes.windows.HolmesNodeInfoActions;
import holmes.windows.HolmesSubnetsInfo;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.ParseException;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.TitledBorder;
import javax.swing.plaf.basic.BasicTabbedPaneUI;
import javax.swing.text.DefaultFormatter;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.title.TextTitle;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class HolmesNodeInfo
extends JFrame {
    private static final long serialVersionUID = 1476738825515760744L;
    private static final GUIManager overlord = GUIManager.getDefaultGUIManager();
    private static final LanguageManager lang = GUIManager.getLanguageManager();
    private Place place;
    private Transition transition;
    private JPanel mainInfoPanel;
    private JFrame parentFrame;
    private HolmesNodeInfoActions action = new HolmesNodeInfoActions(this);
    public boolean mainSimulatorActive = false;
    private XYSeriesCollection dynamicsSeriesDataSet = null;
    private JFreeChart dynamicsChart;
    private int simSteps = 1000;
    private int repeated = 1;
    private JSpinner transIntervalSpinner;
    private boolean maximumMode = false;
    private boolean singleMode = false;
    private int transInterval = 10;
    private JFormattedTextField avgFiredTextBox;
    private SimulatorGlobals.SimNetType choosenNetType = SimulatorGlobals.SimNetType.BASIC;
    JTextArea placeSecondPanelResults;

    public HolmesNodeInfo(Place place, JFrame papa) {
        this.parentFrame = papa;
        this.place = place;
        this.setTitle(lang.getText("HNIwin_entry001title") + " " + place.getName());
        this.initializeCommon();
        JPanel main = new JPanel(new BorderLayout());
        this.add(main);
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.setUI(new BasicTabbedPaneUI(){

            @Override
            protected int calculateTabHeight(int tabPlacement, int tabIndex, int fontHeight) {
                return 32;
            }

            @Override
            protected void paintTab(Graphics g, int tabPlacement, Rectangle[] rects, int tabIndex, Rectangle iconRect, Rectangle textRect) {
                super.paintTab(g, tabPlacement, rects, tabIndex, iconRect, textRect);
            }
        });
        tabbedPane.addTab(lang.getText("HNIwin_entryP002"), Tools.getResIcon16("/icons/nodeViewer/tab1.png"), this.initializePlaceInfo(), lang.getText("HNIwin_entryP002t"));
        tabbedPane.setMnemonicAt(0, 49);
        tabbedPane.addTab(lang.getText("HNIwin_entryP003"), Tools.getResIcon16("/icons/nodeViewer/tab1.png"), this.initializePlaceSecondPanel(), lang.getText("HNIwin_entryP003t"));
        tabbedPane.setMnemonicAt(1, 50);
        main.add(tabbedPane);
    }

    public HolmesNodeInfo(Transition transition, JFrame papa) {
        this.parentFrame = papa;
        this.transition = transition;
        this.setTitle(lang.getText("HNIwin_entry001title") + " " + transition.getName());
        if (transition.timeExtension.isDPN() || transition.timeExtension.isTPN()) {
            this.choosenNetType = SimulatorGlobals.SimNetType.TIME;
        }
        this.initializeCommon();
        JPanel main = new JPanel(new BorderLayout());
        this.add(main);
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.setUI(new BasicTabbedPaneUI(){

            @Override
            protected int calculateTabHeight(int tabPlacement, int tabIndex, int fontHeight) {
                return 32;
            }

            @Override
            protected void paintTab(Graphics g, int tabPlacement, Rectangle[] rects, int tabIndex, Rectangle iconRect, Rectangle textRect) {
                super.paintTab(g, tabPlacement, rects, tabIndex, iconRect, textRect);
            }
        });
        tabbedPane.addTab(lang.getText("HNIwin_entryT004"), Tools.getResIcon16("/icons/nodeViewer/tab1.png"), this.initializeTransitionInfo(), lang.getText("HNIwin_entryT004t"));
        tabbedPane.setMnemonicAt(0, 49);
        tabbedPane.addTab(lang.getText("HNIwin_entryT005"), Tools.getResIcon16("/icons/nodeViewer/tab1.png"), this.initializeTransSecondPanel(), lang.getText("HNIwin_entryT005t"));
        tabbedPane.setMnemonicAt(1, 50);
        main.add(tabbedPane);
    }

    public HolmesNodeInfo(MetaNode metanode, JFrame papa) {
        this.parentFrame = papa;
        this.setTitle(lang.getText("HNIwin_entryM006title") + " " + metanode.getName());
        GraphPanel graphPanel = overlord.getWorkspace().getProject().getGraphPanel(metanode.getRepresentedSheetID());
        this.initializeCommon();
        HolmesSubnetsInfo subnetsInfo = new HolmesSubnetsInfo(graphPanel);
        subnetsInfo.bind(this);
    }

    private void initializeCommon() {
        try {
            this.setIconImage(Tools.getImageFromIcon("/icons/holmesicon.png"));
        }
        catch (Exception ex) {
            overlord.log(lang.getText("LOGentry00478exception") + "\n" + ex.getMessage(), "error", true);
        }
        if (overlord.getSimulatorBox().getCurrentDockWindow().getSimulator().getSimulatorStatus() != GraphicalSimulator.SimulatorMode.STOPPED) {
            this.mainSimulatorActive = true;
        }
        if (overlord.getWorkspace().getProject().isSimulationActive()) {
            this.mainSimulatorActive = true;
        }
        this.parentFrame.setEnabled(false);
        this.setResizable(false);
        this.setLocation(20, 20);
        this.setSize(new Dimension(600, 500));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                HolmesNodeInfo.this.parentFrame.setEnabled(true);
            }
        });
        this.setVisible(true);
    }

    private JPanel initializePlaceInfo() {
        this.mainInfoPanel = new JPanel(null);
        this.mainInfoPanel.setBounds(0, 0, 600, 480);
        int mPanelX = 0;
        int mPanelY = 0;
        JPanel infoPanel = new JPanel(null);
        infoPanel.setBounds(mPanelX, mPanelY, this.mainInfoPanel.getWidth() - 10, 130);
        infoPanel.setBorder(BorderFactory.createTitledBorder(lang.getText("HNIwin_entryP007")));
        int infPanelX = 10;
        int infPanelY = 20;
        JLabel labelID = new JLabel(lang.getText("HNIwin_entryP008"));
        labelID.setBounds(infPanelX, infPanelY, 20, 20);
        infoPanel.add(labelID);
        int id = overlord.getWorkspace().getProject().getPlaces().indexOf(this.place);
        JFormattedTextField idTextBox = new JFormattedTextField((Object)id);
        idTextBox.setBounds(infPanelX + 20, infPanelY, 30, 20);
        idTextBox.setEditable(false);
        infoPanel.add(idTextBox);
        JLabel portalLabel = new JLabel(lang.getText("HNIwin_entryP009"));
        portalLabel.setBounds(infPanelX + 60, infPanelY, 50, 20);
        infoPanel.add(portalLabel);
        String port = lang.getText("no");
        if (this.place.isPortal()) {
            port = lang.getText("yes");
        }
        JLabel portalLabel2 = new JLabel(port);
        portalLabel2.setBounds(infPanelX + 110, infPanelY, 40, 20);
        infoPanel.add(portalLabel2);
        JLabel tokenLabel = new JLabel(lang.getText("HNIwin_entryP010"), 2);
        tokenLabel.setBounds(infPanelX + 160, infPanelY, 50, 20);
        infoPanel.add(tokenLabel);
        int tok = this.place.getTokensNumber();
        boolean problem = false;
        if (tok < 0) {
            overlord.log(lang.getText("LOGentry00479") + " " + this.place.getName(), "error", true);
            tok = 0;
            problem = true;
        }
        SpinnerNumberModel tokenSpinnerModel = new SpinnerNumberModel(tok, 0, Integer.MAX_VALUE, 1);
        JSpinner tokenSpinner = new JSpinner(tokenSpinnerModel);
        tokenSpinner.setLocation(infPanelX + 215, infPanelY);
        tokenSpinner.setSize(45, 20);
        tokenSpinner.setMaximumSize(new Dimension(60, 20));
        tokenSpinner.setMinimumSize(new Dimension(60, 20));
        if (this.mainSimulatorActive || problem) {
            tokenSpinner.setEnabled(false);
        }
        tokenSpinner.addChangeListener(e -> {
            JSpinner spinner = (JSpinner)e.getSource();
            int tokens = (Integer)spinner.getValue();
            this.action.setTokens(this.place, tokens);
            if (HolmesNodeInfo.overlord.getWorkspace().getProject().accessStatesManager().selectedStatePN == 0) {
                ArrayList<Place> places = overlord.getWorkspace().getProject().getPlaces();
                overlord.getWorkspace().getProject().accessStatesManager().getStatePN(0).setTokens(places.indexOf(this.place), tokens);
            }
        });
        infoPanel.add(tokenSpinner);
        int inTrans = 0;
        int outTrans = 0;
        for (ElementLocation el : this.place.getElementLocations()) {
            inTrans += el.getInArcs().size();
            outTrans += el.getOutArcs().size();
        }
        JLabel inTransLabel = new JLabel(lang.getText("HNIwin_entryP011"));
        inTransLabel.setBounds(infPanelX + 270, infPanelY, 75, 20);
        infoPanel.add(inTransLabel);
        JFormattedTextField inTransTextBox = new JFormattedTextField((Object)inTrans);
        inTransTextBox.setBounds(infPanelX + 345, infPanelY, 30, 20);
        inTransTextBox.setEditable(false);
        infoPanel.add(inTransTextBox);
        JLabel outTransLabel = new JLabel(lang.getText("HNIwin_entryP012"));
        outTransLabel.setBounds(infPanelX + 380, infPanelY, 75, 20);
        infoPanel.add(outTransLabel);
        JFormattedTextField outTransTextBox = new JFormattedTextField((Object)outTrans);
        outTransTextBox.setBounds(infPanelX + 465, infPanelY, 30, 20);
        outTransTextBox.setEditable(false);
        infoPanel.add(outTransTextBox);
        JLabel labelName = new JLabel(lang.getText("HNIwin_entryP013"));
        labelName.setBounds(infPanelX, infPanelY += 20, 40, 20);
        infoPanel.add(labelName);
        DefaultFormatter format = new DefaultFormatter();
        format.setOverwriteMode(false);
        JFormattedTextField nameField = new JFormattedTextField(format);
        nameField.setLocation(infPanelX + 60, infPanelY);
        nameField.setSize(460, 20);
        nameField.setValue(this.place.getName());
        nameField.addPropertyChangeListener("value", e -> {
            JFormattedTextField field = (JFormattedTextField)e.getSource();
            try {
                field.commitEdit();
            }
            catch (ParseException ex) {
                overlord.log(lang.getText("LOGentry00480exception") + "\n" + ex.getMessage(), "error", true);
            }
            String newName = field.getText();
            this.action.changeName(this.place, newName);
            this.action.parentTableUpdate(this.parentFrame, newName);
        });
        infoPanel.add(nameField);
        JLabel commmentLabel = new JLabel(lang.getText("HNIwin_entryP014"), 2);
        commmentLabel.setBounds(infPanelX, infPanelY += 20, 50, 20);
        infoPanel.add(commmentLabel);
        JTextArea commentField = new JTextArea(this.place.getComment());
        commentField.setLineWrap(true);
        commentField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                JTextArea field = (JTextArea)e.getSource();
                String newComment = "";
                if (field != null) {
                    newComment = field.getText();
                }
                HolmesNodeInfo.this.action.changeComment(HolmesNodeInfo.this.place, newComment);
            }
        });
        JPanel creationPanel = new JPanel();
        creationPanel.setLayout(new BorderLayout());
        creationPanel.add((Component)new JScrollPane(commentField), "Center");
        creationPanel.setBounds(infPanelX + 60, infPanelY, 460, 60);
        infoPanel.add(creationPanel);
        this.mainInfoPanel.add(infoPanel);
        JPanel chartMainPanel = new JPanel(new BorderLayout());
        chartMainPanel.setBorder(BorderFactory.createTitledBorder(lang.getText("HNIwin_entryP015")));
        chartMainPanel.setBounds(0, infoPanel.getHeight(), this.mainInfoPanel.getWidth() - 10, 245);
        chartMainPanel.add((Component)this.createChartPanel(this.place), "Center");
        this.mainInfoPanel.add(chartMainPanel);
        JPanel chartButtonPanel = this.panelButtonsPlace(infoPanel, chartMainPanel);
        this.mainInfoPanel.add(chartButtonPanel);
        this.fillPlaceDynamicData(chartMainPanel);
        return this.mainInfoPanel;
    }

    private JPanel initializePlaceSecondPanel() {
        JPanel secondaryTabMainPanel = new JPanel(null);
        secondaryTabMainPanel.setBounds(0, 0, 600, 480);
        int mPanelX = 0;
        int mPanelY = 0;
        JPanel analP_firstPanel = new JPanel(null);
        analP_firstPanel.setBounds(mPanelX, mPanelY, secondaryTabMainPanel.getWidth() - 20, 200);
        analP_firstPanel.setBorder(BorderFactory.createTitledBorder("Analysis:"));
        int subPanelX = 10;
        int subPanelY = 20;
        JLabel labelID = new JLabel("ID:");
        labelID.setBounds(subPanelX, subPanelY, 20, 20);
        analP_firstPanel.add(labelID);
        int id = overlord.getWorkspace().getProject().getPlaces().indexOf(this.place);
        JFormattedTextField idTextBox = new JFormattedTextField((Object)id);
        idTextBox.setBounds(subPanelX + 20, subPanelY, 30, 20);
        idTextBox.setEditable(false);
        analP_firstPanel.add(idTextBox);
        JButton button1 = new JButton("Test");
        button1.setBounds(subPanelX, subPanelY += 30, 100, 32);
        button1.setMargin(new Insets(0, 0, 0, 0));
        button1.setIcon(Tools.getResIcon32("/icons/nodeViewer/iconInv.png"));
        button1.setToolTipText("Show information about t-invariants going through place");
        button1.addActionListener(actionEvent -> {});
        analP_firstPanel.add(button1);
        subPanelY += 40;
        this.placeSecondPanelResults = new JTextArea();
        this.placeSecondPanelResults.setLineWrap(true);
        JPanel CreationPanel = new JPanel();
        CreationPanel.setLayout(new BorderLayout());
        CreationPanel.add((Component)new JScrollPane(this.placeSecondPanelResults), "Center");
        CreationPanel.setBounds(subPanelX, subPanelY, 400, 40);
        analP_firstPanel.add(CreationPanel);
        secondaryTabMainPanel.add(analP_firstPanel);
        JPanel analP_secondPanel = new JPanel(null);
        analP_secondPanel.setBounds(mPanelX, analP_firstPanel.getHeight(), this.mainInfoPanel.getWidth() - 20, 130);
        analP_secondPanel.setBorder(BorderFactory.createTitledBorder("Analysis"));
        subPanelX = 10;
        subPanelY = 20;
        JProgressBar progressBar = new JProgressBar();
        JButton tInvButton = new JButton("t-inv list");
        tInvButton.setBounds(subPanelX, subPanelY, 120, 26);
        tInvButton.setMargin(new Insets(0, 0, 0, 0));
        tInvButton.setIcon(Tools.getResIcon32("/icons/nodeViewer/iconInv.png"));
        tInvButton.setToolTipText("Show information about t-invariants going through place");
        tInvButton.addActionListener(actionEvent -> this.action.showTinvForPlace(this.place, progressBar));
        analP_secondPanel.add(tInvButton);
        progressBar.setBounds(subPanelX + 130, subPanelY, 400, 30);
        progressBar.setMaximum(100);
        progressBar.setMinimum(0);
        progressBar.setValue(0);
        progressBar.setStringPainted(true);
        TitledBorder border = BorderFactory.createTitledBorder("Progress");
        progressBar.setBorder(border);
        analP_secondPanel.add(progressBar);
        secondaryTabMainPanel.add(analP_secondPanel);
        return secondaryTabMainPanel;
    }

    private JPanel panelButtonsPlace(JPanel infoPanel, JPanel chartMainPanel) {
        JPanel chartButtonPanel = new JPanel(null);
        chartButtonPanel.setBounds(0, infoPanel.getHeight() + chartMainPanel.getHeight(), this.mainInfoPanel.getWidth() - 10, 50);
        int chartX = 5;
        int chartY_1st = 0;
        int chartY_2nd = 15;
        JButton acqDataButton = new JButton(lang.getText("HNIwin_entryP016"));
        acqDataButton.setBounds(chartX, chartY_2nd, 110, 25);
        acqDataButton.setMargin(new Insets(0, 0, 0, 0));
        acqDataButton.setIcon(Tools.getResIcon32("/icons/stateSim/computeData.png"));
        acqDataButton.setToolTipText(lang.getText("HNIwin_entryP016t"));
        acqDataButton.addActionListener(actionEvent -> this.acquireNewPlaceData());
        chartButtonPanel.add(acqDataButton);
        JLabel labelSteps = new JLabel(lang.getText("HNIwin_entryP017"));
        labelSteps.setBounds(chartX + 120, chartY_1st, 70, 15);
        chartButtonPanel.add(labelSteps);
        SpinnerNumberModel simStepsSpinnerModel = new SpinnerNumberModel(this.simSteps, 0, 50000, 100);
        JSpinner simStepsSpinner = new JSpinner(simStepsSpinnerModel);
        simStepsSpinner.setBounds(chartX + 120, chartY_2nd, 80, 25);
        simStepsSpinner.addChangeListener(e -> {
            JSpinner spinner = (JSpinner)e.getSource();
            this.simSteps = (Integer)spinner.getValue();
        });
        chartButtonPanel.add(simStepsSpinner);
        JLabel labelRep = new JLabel(lang.getText("HNIwin_entryP018"));
        labelRep.setBounds(chartX + 210, chartY_1st, 70, 15);
        chartButtonPanel.add(labelRep);
        SpinnerNumberModel simStepsRepeatedSpinnerModel = new SpinnerNumberModel(this.repeated, 1, 50, 1);
        JSpinner simStepsRepeatedSpinner = new JSpinner(simStepsRepeatedSpinnerModel);
        simStepsRepeatedSpinner.setBounds(chartX + 210, chartY_2nd, 60, 25);
        simStepsRepeatedSpinner.addChangeListener(e -> {
            JSpinner spinner = (JSpinner)e.getSource();
            this.repeated = (Integer)spinner.getValue();
        });
        chartButtonPanel.add(simStepsRepeatedSpinner);
        JLabel label1 = new JLabel("Mode:");
        label1.setBounds(chartX + 280, chartY_1st, 50, 15);
        chartButtonPanel.add(label1);
        JComboBox<String> simMode = new JComboBox<String>(new String[]{lang.getText("HNIwin_entryP019op1"), lang.getText("HNIwin_entryP019op2"), lang.getText("HNIwin_entryP019op3")});
        simMode.setToolTipText(lang.getText("HNIwin_entryP019t"));
        simMode.setBounds(chartX + 280, chartY_2nd, 120, 25);
        simMode.setSelectedIndex(0);
        simMode.setMaximumRowCount(6);
        simMode.addActionListener(actionEvent -> {
            int selected = simMode.getSelectedIndex();
            if (selected == 0) {
                this.maximumMode = false;
                this.singleMode = false;
            } else if (selected == 1) {
                this.maximumMode = true;
                this.singleMode = false;
            } else {
                this.singleMode = true;
            }
        });
        chartButtonPanel.add(simMode);
        String[] simModeName = new String[]{lang.getText("HNIwin_entryP020op1"), lang.getText("HNIwin_entryP020op2"), lang.getText("HNIwin_entryP020op3")};
        JComboBox<String> simNetMode = new JComboBox<String>(simModeName);
        simNetMode.setBounds(chartX + 400, chartY_2nd, 120, 25);
        simNetMode.setSelectedIndex(0);
        simNetMode.addActionListener(actionEvent -> {
            int selectedModeIndex = simNetMode.getSelectedIndex();
            switch (selectedModeIndex) {
                case 0: {
                    this.choosenNetType = SimulatorGlobals.SimNetType.BASIC;
                    break;
                }
                case 1: {
                    this.choosenNetType = SimulatorGlobals.SimNetType.TIME;
                    break;
                }
                case 2: {
                    this.choosenNetType = SimulatorGlobals.SimNetType.HYBRID;
                }
            }
        });
        chartButtonPanel.add(simNetMode);
        return chartButtonPanel;
    }

    private JPanel initializeTransitionInfo() {
        this.mainInfoPanel = new JPanel(null);
        this.mainInfoPanel.setBounds(0, 0, 600, 450);
        int mPanelX = 0;
        int mPanelY = 0;
        JPanel infoPanel = new JPanel(null);
        infoPanel.setBounds(mPanelX, mPanelY, 580, 130);
        infoPanel.setBorder(BorderFactory.createTitledBorder(lang.getText("HNIwin_entryT036")));
        int infPanelX = 10;
        int infPanelY = 20;
        JLabel labelID = new JLabel(lang.getText("HNIwin_entryT021"));
        labelID.setBounds(infPanelX, infPanelY, 20, 20);
        infoPanel.add(labelID);
        int id = overlord.getWorkspace().getProject().getTransitions().indexOf(this.transition);
        JFormattedTextField idTextBox = new JFormattedTextField((Object)id);
        idTextBox.setBounds(infPanelX + 20, infPanelY, 30, 20);
        idTextBox.setEditable(false);
        infoPanel.add(idTextBox);
        JLabel portalLabel = new JLabel(lang.getText("HNIwin_entryT022"));
        portalLabel.setBounds(infPanelX + 60, infPanelY, 50, 20);
        infoPanel.add(portalLabel);
        String port = lang.getText("no");
        if (this.transition.isPortal()) {
            port = lang.getText("yes");
        }
        JLabel portalLabel2 = new JLabel(port);
        portalLabel2.setBounds(infPanelX + 110, infPanelY, 40, 20);
        infoPanel.add(portalLabel2);
        JLabel avgFiredLabel = new JLabel(lang.getText("HNIwin_entryT023"), 2);
        avgFiredLabel.setBounds(infPanelX + 160, infPanelY, 50, 20);
        infoPanel.add(avgFiredLabel);
        this.avgFiredTextBox = new JFormattedTextField((Object)id);
        this.avgFiredTextBox.setBounds(infPanelX + 215, infPanelY, 50, 20);
        this.avgFiredTextBox.setEditable(false);
        infoPanel.add(this.avgFiredTextBox);
        int preP = 0;
        int postP = 0;
        for (ElementLocation el : this.transition.getElementLocations()) {
            preP += el.getInArcs().size();
            postP += el.getOutArcs().size();
        }
        JLabel prePlaceLabel = new JLabel(lang.getText("HNIwin_entryT024"));
        prePlaceLabel.setBounds(infPanelX + 270, infPanelY, 75, 20);
        infoPanel.add(prePlaceLabel);
        JFormattedTextField prePlaceTextBox = new JFormattedTextField((Object)preP);
        prePlaceTextBox.setBounds(infPanelX + 345, infPanelY, 30, 20);
        prePlaceTextBox.setEditable(false);
        infoPanel.add(prePlaceTextBox);
        JLabel postPlaceLabel = new JLabel(lang.getText("HNIwin_entryT025"));
        postPlaceLabel.setBounds(infPanelX + 380, infPanelY, 75, 20);
        infoPanel.add(postPlaceLabel);
        JFormattedTextField postPlaceTextBox = new JFormattedTextField((Object)postP);
        postPlaceTextBox.setBounds(infPanelX + 465, infPanelY, 30, 20);
        postPlaceTextBox.setEditable(false);
        infoPanel.add(postPlaceTextBox);
        JLabel labelName = new JLabel(lang.getText("HNIwin_entryT026"));
        labelName.setBounds(infPanelX, infPanelY += 20, 40, 20);
        infoPanel.add(labelName);
        DefaultFormatter format = new DefaultFormatter();
        format.setOverwriteMode(false);
        JFormattedTextField nameField = new JFormattedTextField(format);
        nameField.setLocation(infPanelX + 60, infPanelY);
        nameField.setSize(460, 20);
        nameField.setValue(this.transition.getName());
        nameField.addPropertyChangeListener("value", e -> {
            JFormattedTextField field = (JFormattedTextField)e.getSource();
            try {
                field.commitEdit();
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            String newName = field.getText();
            this.action.changeName(this.transition, newName);
            this.action.parentTableUpdate(this.parentFrame, newName);
        });
        infoPanel.add(nameField);
        JLabel commmentLabel = new JLabel(lang.getText("HNIwin_entryT027"), 2);
        commmentLabel.setBounds(infPanelX, infPanelY += 20, 50, 20);
        infoPanel.add(commmentLabel);
        JTextArea commentField = new JTextArea(this.transition.getComment());
        commentField.setLineWrap(true);
        commentField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                JTextArea field = (JTextArea)e.getSource();
                String newComment = "";
                if (field != null) {
                    newComment = field.getText();
                }
                HolmesNodeInfo.this.action.changeComment(HolmesNodeInfo.this.transition, newComment);
            }
        });
        JPanel creationPanel = new JPanel();
        creationPanel.setLayout(new BorderLayout());
        creationPanel.add((Component)new JScrollPane(commentField), "Center");
        creationPanel.setBounds(infPanelX + 60, infPanelY, 460, 60);
        infoPanel.add(creationPanel);
        infPanelY += 60;
        this.mainInfoPanel.add(infoPanel);
        JPanel chartMainPanel = new JPanel(new BorderLayout());
        chartMainPanel.setBorder(BorderFactory.createTitledBorder(lang.getText("HNIwin_entryT028")));
        chartMainPanel.setBounds(0, infoPanel.getHeight(), this.mainInfoPanel.getWidth() - 10, 245);
        chartMainPanel.add((Component)this.createChartPanel(this.transition), "Center");
        this.mainInfoPanel.add(chartMainPanel);
        JPanel chartButtonPanel = this.panelButtonsTransition(infoPanel, chartMainPanel);
        this.mainInfoPanel.add(chartButtonPanel);
        try {
            if (!this.transition.getOutputPlaces().isEmpty() || !this.transition.getInputPlaces().isEmpty()) {
                this.fillTransitionDynamicData(this.avgFiredTextBox, chartMainPanel, chartButtonPanel);
            }
        }
        catch (Exception e2) {
            overlord.log(lang.getText("LOGentry00481exception") + "\n" + e2.getMessage(), "error", true);
        }
        return this.mainInfoPanel;
    }

    private JPanel initializeTransSecondPanel() {
        JPanel secondaryTabMainPanel = new JPanel(null);
        secondaryTabMainPanel.setBounds(0, 0, 600, 480);
        int mPanelX = 0;
        int mPanelY = 0;
        JPanel analT_firstPanel = new JPanel(null);
        analT_firstPanel.setBounds(mPanelX, mPanelY, secondaryTabMainPanel.getWidth() - 20, 130);
        analT_firstPanel.setBorder(BorderFactory.createTitledBorder("Analysis:"));
        int subPanelX = 10;
        int subPanelY = 20;
        JLabel labelID = new JLabel("ID:");
        labelID.setBounds(subPanelX, subPanelY, 20, 20);
        analT_firstPanel.add(labelID);
        int id = overlord.getWorkspace().getProject().getPlaces().indexOf(this.transition);
        JFormattedTextField idTextBox = new JFormattedTextField((Object)id);
        idTextBox.setBounds(subPanelX + 20, subPanelY, 30, 20);
        idTextBox.setEditable(false);
        analT_firstPanel.add(idTextBox);
        secondaryTabMainPanel.add(analT_firstPanel);
        JPanel analT_secondPanel = new JPanel(null);
        analT_secondPanel.setBounds(mPanelX, analT_firstPanel.getHeight(), secondaryTabMainPanel.getWidth() - 20, 130);
        analT_secondPanel.setBorder(BorderFactory.createTitledBorder("Analysis:"));
        subPanelX = 10;
        subPanelY = 20;
        JProgressBar progressBar = new JProgressBar();
        JButton tInvButton = new JButton("t-inv list");
        tInvButton.setBounds(subPanelX, subPanelY, 120, 26);
        tInvButton.setMargin(new Insets(0, 0, 0, 0));
        tInvButton.setIcon(Tools.getResIcon32("/icons/nodeViewer/iconInv.png"));
        tInvButton.setToolTipText("Show information about t-invariants going through transition");
        tInvButton.addActionListener(actionEvent -> this.action.showTinvForTransition(this.transition, progressBar));
        analT_secondPanel.add(tInvButton);
        progressBar.setBounds(subPanelX + 130, subPanelY, 400, 30);
        progressBar.setMaximum(100);
        progressBar.setMinimum(0);
        progressBar.setValue(0);
        progressBar.setStringPainted(true);
        TitledBorder border = BorderFactory.createTitledBorder("Progress");
        progressBar.setBorder(border);
        analT_secondPanel.add(progressBar);
        secondaryTabMainPanel.add(analT_secondPanel);
        return secondaryTabMainPanel;
    }

    private JPanel panelButtonsTransition(JPanel infoPanel, JPanel chartMainPanel) {
        JPanel chartButtonPanel = new JPanel(null);
        chartButtonPanel.setBounds(0, infoPanel.getHeight() + chartMainPanel.getHeight(), this.mainInfoPanel.getWidth() - 10, 50);
        int chartX = 5;
        int chartY_1st = 0;
        int chartY_2nd = 15;
        JButton acqDataButton = new JButton(lang.getText("HNIwin_entryT029"));
        acqDataButton.setBounds(chartX, chartY_2nd, 110, 25);
        acqDataButton.setMargin(new Insets(0, 0, 0, 0));
        acqDataButton.setIcon(Tools.getResIcon32("/icons/stateSim/computeData.png"));
        acqDataButton.setToolTipText(lang.getText("HNIwin_entryT029t"));
        acqDataButton.addActionListener(actionEvent -> this.acquireNewTransitionData());
        chartButtonPanel.add(acqDataButton);
        JLabel labelSteps = new JLabel(lang.getText("HNIwin_entryT030"));
        labelSteps.setBounds(chartX + 120, chartY_1st, 70, 15);
        chartButtonPanel.add(labelSteps);
        SpinnerNumberModel simStepsSpinnerModel = new SpinnerNumberModel(this.simSteps, 0, 50000, 100);
        JSpinner simStepsSpinner = new JSpinner(simStepsSpinnerModel);
        simStepsSpinner.setBounds(chartX + 120, chartY_2nd, 80, 25);
        simStepsSpinner.addChangeListener(e -> {
            JSpinner spinner = (JSpinner)e.getSource();
            this.simSteps = (Integer)spinner.getValue();
            int cVal = this.simSteps / 100;
            int mVal = this.simSteps / 5;
            if (cVal < 1) {
                cVal = 1;
            }
            if (cVal > mVal) {
                cVal = 1;
                mVal = 20;
            }
            try {
                SpinnerNumberModel spinnerClustersModel = new SpinnerNumberModel(cVal, 1, mVal, 1);
                this.transIntervalSpinner.setModel(spinnerClustersModel);
                this.transInterval = cVal;
            }
            catch (Exception ex) {
                overlord.log(lang.getText("LOGentry00482exception") + "\n" + ex.getMessage(), "warning", true);
            }
        });
        chartButtonPanel.add(simStepsSpinner);
        JLabel labelInterval = new JLabel(lang.getText("HNIwin_entryT031"));
        labelInterval.setBounds(chartX + 210, chartY_1st, 80, 15);
        chartButtonPanel.add(labelInterval);
        int maxVal = this.simSteps / 10;
        SpinnerNumberModel intervSpinnerModel = new SpinnerNumberModel(this.transInterval, 1, maxVal, 1);
        this.transIntervalSpinner = new JSpinner(intervSpinnerModel);
        this.transIntervalSpinner.setBounds(chartX + 210, chartY_2nd, 60, 25);
        this.transIntervalSpinner.addChangeListener(e -> {
            JSpinner spinner = (JSpinner)e.getSource();
            this.transInterval = (Integer)spinner.getValue();
        });
        chartButtonPanel.add(this.transIntervalSpinner);
        JLabel labelMode = new JLabel(lang.getText("HNIwin_entryT032"));
        labelMode.setBounds(chartX + 280, chartY_1st, 110, 15);
        chartButtonPanel.add(labelMode);
        JComboBox<String> simMode = new JComboBox<String>(new String[]{lang.getText("HNIwin_entryT033op1"), lang.getText("HNIwin_entryT033op2"), lang.getText("HNIwin_entryT033op3")});
        simMode.setToolTipText(lang.getText("HNIwin_entryT033t"));
        simMode.setBounds(chartX + 280, chartY_2nd, 120, 25);
        simMode.setSelectedIndex(0);
        simMode.setMaximumRowCount(6);
        simMode.addActionListener(actionEvent -> {
            int selected = simMode.getSelectedIndex();
            if (selected == 0) {
                this.maximumMode = false;
                this.singleMode = false;
            } else if (selected == 1) {
                this.maximumMode = true;
                this.singleMode = false;
            } else {
                this.singleMode = true;
            }
        });
        chartButtonPanel.add(simMode);
        String[] simModeName = new String[]{lang.getText("HNIwin_entryT034op1"), lang.getText("HNIwin_entryT034op2"), lang.getText("HNIwin_entryT034op3")};
        JComboBox<String> simNetMode = new JComboBox<String>(simModeName);
        simNetMode.setBounds(chartX + 400, chartY_2nd, 120, 25);
        if (this.choosenNetType == SimulatorGlobals.SimNetType.TIME) {
            simNetMode.setSelectedIndex(1);
        } else {
            simNetMode.setSelectedIndex(0);
        }
        simNetMode.addActionListener(actionEvent -> {
            int selectedModeIndex = simNetMode.getSelectedIndex();
            switch (selectedModeIndex) {
                case 0: {
                    this.choosenNetType = SimulatorGlobals.SimNetType.BASIC;
                    break;
                }
                case 1: {
                    this.choosenNetType = SimulatorGlobals.SimNetType.TIME;
                    break;
                }
                case 2: {
                    this.choosenNetType = SimulatorGlobals.SimNetType.HYBRID;
                }
            }
        });
        chartButtonPanel.add(simNetMode);
        return chartButtonPanel;
    }

    private void fillPlaceDynamicData(JPanel chartMainPanel) {
        if (!this.mainSimulatorActive) {
            this.acquireNewPlaceData();
        } else {
            chartMainPanel.setEnabled(false);
            TextTitle title = this.dynamicsChart.getTitle();
            title.setBorder(2.0, 2.0, 2.0, 2.0);
            title.setFont(new Font("Dialog", 0, 20));
            title.setExpandToFitSpace(true);
            title.setPaint(Color.red);
            title.setText(lang.getText("HNIwin_entryT035"));
        }
    }

    private void fillTransitionDynamicData(JFormattedTextField avgFiredTextBox, JPanel chartMainPanel, JPanel chartButtonPanel) {
        if (!this.mainSimulatorActive) {
            ArrayList<Integer> dataVector = this.acquireNewTransitionData();
            if (!dataVector.isEmpty()) {
                int sum = dataVector.get(dataVector.size() - 2);
                int steps = dataVector.get(dataVector.size() - 1);
                double avgFired = sum;
                avgFired /= (double)steps;
                avgFiredTextBox.setText(Tools.cutValue(avgFired *= 100.0) + "%");
            }
        } else {
            avgFiredTextBox.setEnabled(false);
            avgFiredTextBox.setText("n/a");
            chartMainPanel.setEnabled(false);
            chartButtonPanel.setEnabled(false);
            TextTitle title = this.dynamicsChart.getTitle();
            title.setBorder(2.0, 2.0, 2.0, 2.0);
            title.setFont(new Font("Dialog", 0, 20));
            title.setExpandToFitSpace(true);
            title.setPaint(Color.red);
            title.setText(lang.getText("HNIwin_entryT035"));
        }
    }

    private void acquireNewPlaceData() {
        StateSimulator ss = new StateSimulator();
        SimulatorGlobals ownSettings = new SimulatorGlobals();
        ownSettings.setNetType(this.choosenNetType, false);
        ownSettings.setMaxMode(this.maximumMode);
        ownSettings.setSingleMode(this.singleMode);
        ss.initiateSim(false, ownSettings);
        ArrayList<Integer> dataVector = ss.simulateNetSinglePlace(this.simSteps, this.place, false);
        ArrayList<ArrayList<Integer>> dataMatrix = new ArrayList<ArrayList<Integer>>();
        dataMatrix.add(dataVector);
        int problemCounter = 0;
        int rep_succeed = 1;
        for (int i = 1; i < this.repeated; ++i) {
            ss.clearData();
            ArrayList<Integer> newData = ss.simulateNetSinglePlace(this.simSteps, this.place, false);
            if (newData.size() < dataVector.size()) {
                --i;
                if (++problemCounter != 10) continue;
                String strB = "err.";
                try {
                    strB = String.format(lang.getText("LOGentry00483"), this.repeated, this.simSteps, dataVector.size());
                }
                catch (Exception e) {
                    overlord.log(lang.getText("LOGentryLNGexc") + " LOGentry00483", "error", true);
                }
                overlord.log(strB, "error", true);
                break;
            }
            ++rep_succeed;
            dataMatrix.add(newData);
        }
        this.dynamicsSeriesDataSet.removeAllSeries();
        XYSeries series = new XYSeries((Comparable)((Object)"Number of tokens"));
        if (this.repeated != 1) {
            ArrayList<Double> dataDVector = new ArrayList<Double>();
            for (int i = 0; i < this.repeated; ++i) {
                int j;
                if (i == 0) {
                    for (j = 0; j < ((ArrayList)dataMatrix.get(0)).size(); ++j) {
                        dataDVector.add(Double.valueOf(((Integer)((ArrayList)dataMatrix.get(0)).get(j)).intValue()));
                    }
                    continue;
                }
                for (j = 0; j < ((ArrayList)dataMatrix.get(i)).size(); ++j) {
                    double oldval = (Double)dataDVector.get(j);
                    dataDVector.set(j, oldval += (double)((Integer)((ArrayList)dataMatrix.get(i)).get(j)).intValue());
                }
            }
            for (int step = 0; step < dataDVector.size(); ++step) {
                double value = (Double)dataDVector.get(step);
                series.add((double)step, value /= (double)rep_succeed);
            }
        } else if (dataVector != null) {
            for (int step = 0; step < dataVector.size(); ++step) {
                int value = dataVector.get(step);
                series.add((double)step, value);
            }
        }
        this.dynamicsSeriesDataSet.addSeries(series);
        dataMatrix.clear();
    }

    private ArrayList<Integer> acquireNewTransitionData() {
        StateSimulator ss = new StateSimulator();
        SimulatorGlobals ownSettings = new SimulatorGlobals();
        ownSettings.setNetType(this.choosenNetType, false);
        ownSettings.setMaxMode(this.maximumMode);
        ownSettings.setSingleMode(this.singleMode);
        ss.initiateSim(false, ownSettings);
        ArrayList<Integer> dataVector = ss.simulateNetSingleTransition(this.simSteps, this.transition, false);
        this.dynamicsSeriesDataSet.removeAllSeries();
        XYSeries series = new XYSeries((Comparable)((Object)"Average firing"));
        if (dataVector != null) {
            for (int step = 0; step < dataVector.size() - 2; ++step) {
                double value = 0.0;
                int interval = this.transInterval;
                if (step + interval >= dataVector.size() - 2) {
                    interval = dataVector.size() - 2 - step;
                }
                for (int i = 0; i < interval; ++i) {
                    try {
                        value += (double)dataVector.get(step + i).intValue();
                        continue;
                    }
                    catch (Exception e) {
                        overlord.log("Error Ex: " + e.getMessage(), "error", true);
                    }
                }
                value /= (double)interval;
                series.add((double)step, value *= 100.0);
                step += interval - 1;
            }
        }
        this.dynamicsSeriesDataSet.addSeries(series);
        assert (dataVector != null);
        int sum = dataVector.get(dataVector.size() - 2);
        int steps = dataVector.get(dataVector.size() - 1);
        double avgFired = sum;
        avgFired /= (double)steps;
        this.avgFiredTextBox.setText(Tools.cutValue(avgFired *= 100.0) + "%");
        return dataVector;
    }

    JPanel createChartPanel(Node node) {
        String chartTitle = node.getName() + " dynamics";
        String xAxisLabel = "Simulation steps";
        String yAxisLabel = "Tokens";
        if (node instanceof Transition) {
            yAxisLabel = "Firings chance %";
        }
        boolean showLegend = false;
        boolean createTooltip = true;
        boolean createURL = false;
        this.dynamicsSeriesDataSet = new XYSeriesCollection();
        this.dynamicsChart = ChartFactory.createXYLineChart(chartTitle, xAxisLabel, yAxisLabel, this.dynamicsSeriesDataSet, PlotOrientation.VERTICAL, showLegend, createTooltip, createURL);
        this.dynamicsChart.getTitle().setFont(new Font("Dialog", 0, 14));
        return new ChartPanel(this.dynamicsChart);
    }
}

