/*
 * Decompiled with CFR 0.152.
 */
package holmes.windows;

import holmes.analyse.InvariantsCalculator;
import holmes.analyse.InvariantsTools;
import holmes.analyse.NetPropertiesAnalyzer;
import holmes.darkgui.GUIManager;
import holmes.darkgui.LanguageManager;
import holmes.petrinet.elements.Arc;
import holmes.petrinet.elements.Node;
import holmes.petrinet.elements.Place;
import holmes.petrinet.elements.Transition;
import holmes.utilities.Tools;
import holmes.varia.Check;
import holmes.workspace.ExtensionFileFilter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.filechooser.FileFilter;

public class HolmesNetProperties
extends JFrame {
    private static final long serialVersionUID = -4382182770445745847L;
    private static final GUIManager overlord = GUIManager.getDefaultGUIManager();
    private static final LanguageManager lang = GUIManager.getLanguageManager();
    private JFrame ego;
    private ArrayList<Arc> arcs = new ArrayList();
    private ArrayList<Place> places = new ArrayList();
    private ArrayList<Transition> transitions = new ArrayList();
    private ArrayList<Node> nodes = new ArrayList();
    private ArrayList<ArrayList<Integer>> invariantsMatrix;
    private ArrayList<ArrayList<Object>> properties = new ArrayList();
    private JFormattedTextField nameField;
    private JLabel label_nodesNumber;
    private JLabel label_transitionsNumber;
    private JLabel label_placesNumber;
    private JLabel label_arcNumber;
    private JLabel label_invNumber;
    private JLabel label_arcNormal;
    private JLabel label_arcReadarc;
    private JLabel label_arcInhibitor;
    private JLabel label_arcReset;
    private JLabel label_arcEqual;
    JPanel staticPropertiesPanel;
    JTextArea textField;

    public HolmesNetProperties() {
        this.ego = this;
        try {
            this.setIconImage(Tools.getImageFromIcon("/icons/holmesicon.png"));
        }
        catch (Exception ex) {
            overlord.log(lang.getText("LOGentry00470exception") + "\n" + ex.getMessage(), "error", true);
        }
        this.setTitle(lang.getText("HNPwin_entry001title"));
        this.setLayout(new BorderLayout());
        this.setSize(new Dimension(650, 550));
        this.setLocation(50, 50);
        this.setDefaultCloseOperation(1);
        this.setResizable(false);
        JPanel main = this.createMainPanel();
        this.add((Component)main, "Center");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
            }
        });
        this.setVisible(false);
        this.initiateListeners();
    }

    private void fillData() {
        this.places = overlord.getWorkspace().getProject().getPlaces();
        this.transitions = overlord.getWorkspace().getProject().getTransitions();
        this.arcs = overlord.getWorkspace().getProject().getArcs();
        this.nodes = overlord.getWorkspace().getProject().getNodes();
        this.invariantsMatrix = overlord.getWorkspace().getProject().getT_InvMatrix();
        ArrayList<Integer> arcClasses = Check.getArcClassCount();
        this.nameField.setText(overlord.getWorkspace().getProject().getName());
        this.label_nodesNumber.setText("" + this.nodes.size());
        this.label_transitionsNumber.setText("" + this.transitions.size());
        this.label_placesNumber.setText("" + this.places.size());
        int readArcs = arcClasses.get(1) / 2;
        this.label_arcNumber.setText("" + (this.arcs.size() - readArcs));
        int inv_number = this.invariantsMatrix == null ? 0 : this.invariantsMatrix.size();
        this.label_invNumber.setText("" + inv_number);
        this.label_arcNormal.setText(String.valueOf(arcClasses.get(0)));
        this.label_arcReadarc.setText("" + arcClasses.get(1) / 2);
        this.label_arcInhibitor.setText(String.valueOf(arcClasses.get(2)));
        this.label_arcReset.setText(String.valueOf(arcClasses.get(3)));
        this.label_arcEqual.setText(String.valueOf(arcClasses.get(4)));
        this.fillStaticProperties();
        ArrayList<Integer> idTransNoInv = new ArrayList<Integer>();
        ArrayList<Integer> transInInv = new ArrayList<Integer>();
        ArrayList<Integer> transFiresInInv = new ArrayList<Integer>();
        for (int trans = 0; trans < this.transitions.size(); ++trans) {
            transInInv.add(0);
            transFiresInInv.add(0);
        }
        int sur = 0;
        int sub = 0;
        int none = 0;
        int normal = 0;
        if (this.invariantsMatrix != null) {
            if (!overlord.getWorkspace().getProject().getT_invTypesComputed()) {
                this.textField.append(lang.getText("HNPwin_entry002"));
                InvariantsCalculator ic = new InvariantsCalculator(true);
                InvariantsTools.analyseInvariantTypes(ic.getCMatrix(), this.invariantsMatrix, true);
            }
            ArrayList<Integer> invTypes = overlord.getWorkspace().getProject().accessT_InvTypesVector();
            for (Integer invType : invTypes) {
                if (invType == 0) {
                    ++normal;
                    continue;
                }
                if (invType == -1) {
                    ++sub;
                    continue;
                }
                if (invType == 1) {
                    ++sur;
                    continue;
                }
                ++none;
            }
        }
        this.textField.setText("");
        int transInNoInvariant = 0;
        if (inv_number > 0) {
            ArrayList<Integer> invTypes = overlord.getWorkspace().getProject().accessT_InvTypesVector();
            for (int inv = 0; inv < this.invariantsMatrix.size(); ++inv) {
                if (invTypes.get(inv) != 0) continue;
                for (int t = 0; t < this.invariantsMatrix.get(0).size(); ++t) {
                    if (this.invariantsMatrix.get(inv).get(t) <= 0) continue;
                    int oldVal = (Integer)transInInv.get(t);
                    transInInv.set(t, ++oldVal);
                    oldVal = (Integer)transFiresInInv.get(t);
                    transFiresInInv.set(t, oldVal += this.invariantsMatrix.get(inv).get(t).intValue());
                }
            }
            for (int trans = 0; trans < this.transitions.size(); ++trans) {
                if ((Integer)transInInv.get(trans) != 0) continue;
                idTransNoInv.add(trans);
                ++transInNoInvariant;
            }
            this.textField.append(lang.getText("HNPwin_entry003") + " " + normal + "\n");
            this.textField.append(lang.getText("HNPwin_entry004") + " " + sur + "\n");
            this.textField.append(lang.getText("HNPwin_entry005") + " " + sub + "\n");
            this.textField.append(lang.getText("HNPwin_entry006") + " " + none + "\n");
            if (transInNoInvariant == 0) {
                this.textField.append("\n");
                this.textField.append(lang.getText("HNPwin_entry007"));
                this.textField.append("\n");
            } else {
                this.textField.append("\n");
                this.textField.append(lang.getText("HNPwin_entry008"));
                String strB = "err.";
                try {
                    strB = String.format(lang.getText("HNPwin_entry008"), normal);
                }
                catch (Exception e) {
                    overlord.log(lang.getText("LOGentryLNGexc") + " HNPwin_entry008", "error", true);
                }
                this.textField.append(strB);
                this.textField.append("\n");
                Iterator e = idTransNoInv.iterator();
                while (e.hasNext()) {
                    int tNumber = (Integer)e.next();
                    String txt1 = Tools.setToSize("t" + tNumber, 5, false);
                    this.textField.append(txt1 + " " + tNumber + this.transitions.get(tNumber).getName() + "\n");
                }
                this.textField.append("\n");
            }
            String strB = "err.";
            try {
                strB = String.format(lang.getText("HNPwin_entry009"), normal);
            }
            catch (Exception e) {
                overlord.log(lang.getText("LOGentryLNGexc") + " HNPwin_entry009", "error", true);
            }
            this.textField.append(strB);
            for (int i = 0; i < this.transitions.size(); ++i) {
                if ((Integer)transInInv.get(i) <= 0) continue;
                int transInv = (Integer)transInInv.get(i);
                int transFire = (Integer)transFiresInInv.get(i);
                String transName = this.transitions.get(i).getName();
                String txt1 = Tools.setToSize("t" + i, 5, false);
                String txt2 = Tools.setToSize("Inv:" + transInv, 10, false);
                String txt3 = Tools.setToSize("Fired:" + transFire, 12, false);
                this.textField.append(txt1 + txt2 + txt3 + "  t" + i + "_" + transName + "\n");
            }
            this.textField.setCaretPosition(0);
        }
    }

    private JPanel createMainPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(null);
        panel.setBorder(BorderFactory.createTitledBorder("General Petri net informations:"));
        int xPos = 10;
        int yPosA = 15;
        int yPosB = 15;
        int spacing = 20;
        int numberLabelWidth = 70;
        JLabel label1 = new JLabel("Project name:");
        label1.setBounds(xPos, yPosA, 100, 20);
        panel.add(label1);
        this.nameField = new JFormattedTextField();
        this.nameField.setBounds(xPos + 110, yPosA + 2, 500, 20);
        this.nameField.addPropertyChangeListener("value", e -> {
            JFormattedTextField field = (JFormattedTextField)e.getSource();
            try {
                field.commitEdit();
            }
            catch (ParseException ex) {
                overlord.log(lang.getText("LOGentry00471exception") + "\n" + ex.getMessage(), "error", true);
            }
            String newName = field.getText();
            overlord.getWorkspace().getProject().setName(newName);
        });
        panel.add(this.nameField);
        JLabel label2 = new JLabel(lang.getText("HNPwin_entry010"));
        label2.setBounds(xPos, yPosA += spacing, 100, 20);
        panel.add(label2);
        this.label_nodesNumber = new JLabel(lang.getText("HNPwin_entry011"));
        this.label_nodesNumber.setBounds(xPos + label2.getWidth() + 10, label2.getLocation().y, numberLabelWidth, 20);
        panel.add(this.label_nodesNumber);
        JLabel label3 = new JLabel(lang.getText("HNPwin_entry012"));
        label3.setBounds(xPos, yPosA += spacing, 100, 20);
        panel.add(label3);
        this.label_transitionsNumber = new JLabel(lang.getText("HNPwin_entry011"));
        this.label_transitionsNumber.setBounds(xPos + label3.getWidth() + 10, label3.getLocation().y, numberLabelWidth, 20);
        panel.add(this.label_transitionsNumber);
        JLabel label4 = new JLabel(lang.getText("HNPwin_entry013"));
        label4.setBounds(xPos, yPosA += spacing, 100, 20);
        panel.add(label4);
        this.label_placesNumber = new JLabel(lang.getText("HNPwin_entry011"));
        this.label_placesNumber.setBounds(xPos + label4.getWidth() + 10, label4.getLocation().y, numberLabelWidth, 20);
        panel.add(this.label_placesNumber);
        JLabel label5 = new JLabel(lang.getText("HNPwin_entry014"));
        label5.setBounds(xPos, yPosA += spacing, 100, 20);
        panel.add(label5);
        this.label_arcNumber = new JLabel(lang.getText("HNPwin_entry011"));
        this.label_arcNumber.setBounds(xPos + label5.getWidth() + 10, label5.getLocation().y, numberLabelWidth, 20);
        panel.add(this.label_arcNumber);
        JLabel label6 = new JLabel(lang.getText("HNPwin_entry015"));
        label6.setBounds(xPos, yPosA += spacing, 100, 20);
        panel.add(label6);
        this.label_invNumber = new JLabel("N/A");
        this.label_invNumber.setBounds(xPos + label6.getWidth() + 10, label6.getLocation().y, numberLabelWidth, 20);
        panel.add(this.label_invNumber);
        JLabel label11 = new JLabel(lang.getText("HNPwin_entry016"));
        label11.setBounds(xPos + 150, yPosB += spacing, 110, 20);
        panel.add(label11);
        this.label_arcNormal = new JLabel("0");
        this.label_arcNormal.setBounds(xPos + 265, yPosB, 60, 20);
        panel.add(this.label_arcNormal);
        JLabel label12 = new JLabel(lang.getText("HNPwin_entry017"));
        label12.setBounds(xPos + 150, yPosB += spacing, 110, 20);
        panel.add(label12);
        this.label_arcReadarc = new JLabel("0");
        this.label_arcReadarc.setBounds(xPos + 265, yPosB, 60, 20);
        panel.add(this.label_arcReadarc);
        JLabel label13 = new JLabel(lang.getText("HNPwin_entry018"));
        label13.setBounds(xPos + 150, yPosB += spacing, 110, 20);
        panel.add(label13);
        this.label_arcInhibitor = new JLabel("0");
        this.label_arcInhibitor.setBounds(xPos + 265, yPosB, 60, 20);
        panel.add(this.label_arcInhibitor);
        JLabel label14 = new JLabel(lang.getText("HNPwin_entry019"));
        label14.setBounds(xPos + 150, yPosB += spacing, 110, 20);
        panel.add(label14);
        this.label_arcReset = new JLabel("0");
        this.label_arcReset.setBounds(xPos + 265, yPosB, 60, 20);
        panel.add(this.label_arcReset);
        JLabel label15 = new JLabel(lang.getText("HNPwin_entry020"));
        label15.setBounds(xPos + 150, yPosB += spacing, 110, 20);
        panel.add(label15);
        this.label_arcEqual = new JLabel("0");
        this.label_arcEqual.setBounds(xPos + 265, yPosB, 60, 20);
        panel.add(this.label_arcEqual);
        this.staticPropertiesPanel = new JPanel(new FlowLayout());
        this.staticPropertiesPanel.setBorder(BorderFactory.createTitledBorder(lang.getText("HNPwin_entry021")));
        this.staticPropertiesPanel.setBounds(330, 35, 300, 100);
        panel.add(this.staticPropertiesPanel);
        JButton saveButton = new JButton(lang.getText("HNPwin_entry022"));
        saveButton.setMargin(new Insets(0, 0, 0, 0));
        saveButton.setIcon(Tools.getResIcon22("/icons/quickSave.png"));
        saveButton.setBounds(xPos, yPosA += 25, 150, 30);
        saveButton.addActionListener(actionEvent -> this.saveToFile());
        panel.add(saveButton);
        yPosA += 10;
        JPanel invInfoPanel = new JPanel(new BorderLayout());
        invInfoPanel.setBorder(BorderFactory.createTitledBorder(lang.getText("HNPwin_entry023")));
        invInfoPanel.setBounds(xPos - 5, yPosA += spacing, 635, 345);
        this.textField = new JTextArea();
        this.textField.setEditable(false);
        this.textField.setFont(new Font("Monospaced", 0, 12));
        JScrollPane areaScrollPane = new JScrollPane(this.textField);
        areaScrollPane.setVerticalScrollBarPolicy(22);
        invInfoPanel.add(areaScrollPane);
        panel.add(invInfoPanel);
        panel.repaint();
        return panel;
    }

    private void fillStaticProperties() {
        this.staticPropertiesPanel.removeAll();
        this.staticPropertiesPanel.revalidate();
        NetPropertiesAnalyzer analyzer = new NetPropertiesAnalyzer();
        this.properties = analyzer.propAnalyze();
        for (ArrayList<Object> pr : this.properties) {
            JButton pButton = new JButton();
            pButton.setPreferredSize(new Dimension(66, 20));
            if (pr.size() < 2) {
                pButton.setBackground(Color.GRAY);
            } else {
                if (((Boolean)pr.get(1)).booleanValue()) {
                    pButton.setBackground(Color.green);
                    pButton.setForeground(Color.WHITE);
                } else {
                    pButton.setBackground(Color.red);
                }
                String[] dataTxt = (String[])pr.get(2);
                pButton.setToolTipText(dataTxt[0]);
                pButton.addActionListener(new ActionListener(){
                    private String[] yesWeCan;

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        JOptionPane.showMessageDialog(HolmesNetProperties.this.ego, lang.getText("HNPwin_entry024a") + this.yesWeCan[1] + lang.getText("HNPwin_entry024b") + this.yesWeCan[2], this.yesWeCan[0], 1);
                    }

                    private ActionListener goForthMyMinion(String[] codeInjection) {
                        this.yesWeCan = codeInjection;
                        return this;
                    }
                }.goForthMyMinion(dataTxt));
            }
            pButton.setText(pr.get(0).toString());
            pButton.setVisible(true);
            this.staticPropertiesPanel.add(pButton);
        }
    }

    private void saveToFile() {
        FileFilter[] filters = new FileFilter[1];
        String lastPath = overlord.getLastPath();
        filters[0] = new ExtensionFileFilter("Normal text file (.txt)", new String[]{"TXT"});
        Object selectedFile = Tools.selectFileDialog(lastPath, filters, "Save", "", "");
        if (!((String)selectedFile).isEmpty()) {
            String fileName = ((String)selectedFile).substring(((String)selectedFile).lastIndexOf(File.separator) + 1);
            if (!fileName.contains(".txt")) {
                selectedFile = (String)selectedFile + ".txt";
            }
            try {
                BufferedWriter bw = new BufferedWriter(new FileWriter((String)selectedFile));
                bw.write(lang.getText("HNPwin_entry025") + " " + this.nameField.getText() + "\n");
                bw.write(lang.getText("HNPwin_entry026") + " " + this.label_nodesNumber.getText() + "\n");
                bw.write(lang.getText("HNPwin_entry027") + " " + this.label_transitionsNumber.getText() + "\n");
                bw.write(lang.getText("HNPwin_entry028") + " " + this.label_placesNumber.getText() + "\n");
                bw.write(lang.getText("HNPwin_entry029") + " " + this.label_arcNumber.getText() + "\n");
                bw.write("\n");
                bw.write(lang.getText("HNPwin_entry030"));
                int count = 1;
                for (ArrayList<Object> property : this.properties) {
                    boolean isNet = (Boolean)property.get(1);
                    if (!isNet) continue;
                    String[] data = (String[])property.get(2);
                    bw.write(lang.getText("HNPwin_entry031") + " " + count + ": " + data[0] + "\n");
                    String txt = data[1];
                    txt = txt.replace("\n", "");
                    bw.write(lang.getText("HNPwin_entry032") + " " + txt + "\n");
                    txt = data[2];
                    txt = txt.replace("\n", "");
                    bw.write(lang.getText("HNPwin_entry033") + " " + data[2] + "\n\n");
                    ++count;
                }
                bw.write("\n");
                if (this.invariantsMatrix != null) {
                    int inv_number = this.invariantsMatrix.size();
                    bw.write(lang.getText("HNPwin_entry034") + " " + inv_number + "\n");
                    bw.write(this.textField.getText());
                }
                bw.close();
            }
            catch (Exception ex) {
                overlord.log(lang.getText("LOGentry00472exception") + "\n" + ex.getMessage(), "error", true);
            }
        }
    }

    private void initiateListeners() {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent e) {
                HolmesNetProperties.this.fillData();
            }
        });
    }
}

