/*
 * Decompiled with CFR 0.152.
 */
package holmes.windows;

import holmes.analyse.InvariantsTools;
import holmes.darkgui.GUIManager;
import holmes.darkgui.LanguageManager;
import holmes.petrinet.data.MCSDataMatrix;
import holmes.petrinet.elements.Place;
import holmes.petrinet.elements.Transition;
import holmes.utilities.Tools;
import holmes.windows.HolmesNotepad;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.plaf.basic.BasicTabbedPaneUI;
import javax.swing.text.DefaultCaret;

public class HolmesMCSanalysis
extends JFrame {
    private static final GUIManager overlord = GUIManager.getDefaultGUIManager();
    private static final LanguageManager lang = GUIManager.getLanguageManager();
    private JFrame ego;
    private JTextArea logField1stTab;
    private JTextArea logField2ndTab;
    int windowWidth = 1070;
    int windowHeight = 810;
    JComboBox<String> TorP;
    JCheckBox description;
    JCheckBox ID;
    JSpinner distanceSpinner;
    private int distanceVar = 3;
    JComboBox<String> transBox;
    JComboBox<String> mcsBox;
    JTextField importantTrans;
    ArrayList<Transition> transitions = null;
    ArrayList<Place> places = null;
    ArrayList<ArrayList<Integer>> invariantsMatrix = null;
    MCSDataMatrix mcsd = null;
    private static final HashMap<Character, Character> SUBSCRIPT_MAP = new HashMap<Character, Character>(){
        {
            this.put(Character.valueOf('0'), Character.valueOf('\u2080'));
            this.put(Character.valueOf('1'), Character.valueOf('\u2081'));
            this.put(Character.valueOf('2'), Character.valueOf('\u2082'));
            this.put(Character.valueOf('3'), Character.valueOf('\u2083'));
            this.put(Character.valueOf('4'), Character.valueOf('\u2084'));
            this.put(Character.valueOf('5'), Character.valueOf('\u2085'));
            this.put(Character.valueOf('6'), Character.valueOf('\u2086'));
            this.put(Character.valueOf('7'), Character.valueOf('\u2087'));
            this.put(Character.valueOf('8'), Character.valueOf('\u2088'));
            this.put(Character.valueOf('9'), Character.valueOf('\u2089'));
        }
    };

    public HolmesMCSanalysis() {
        try {
            this.setIconImage(Tools.getImageFromIcon("/icons/holmesicon.png"));
        }
        catch (Exception ex) {
            overlord.log("Error (691193817) | Exception:  " + ex.getMessage(), "error", true);
        }
        this.ego = this;
        this.setVisible(false);
        this.setTitle("MCS detailed analysis");
        this.setLayout(new BorderLayout());
        this.setSize(new Dimension(this.windowWidth, this.windowHeight));
        this.setLocation(50, 50);
        this.setResizable(false);
        this.setDefaultCloseOperation(1);
        JPanel mainPanel = this.createMainPanel();
        this.initiateListeners();
        this.fillTComboBox();
        this.add((Component)mainPanel, "Center");
    }

    private String toSubscript(String input) {
        StringBuilder output = new StringBuilder();
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (SUBSCRIPT_MAP.containsKey(Character.valueOf(c))) {
                output.append(SUBSCRIPT_MAP.get(Character.valueOf(c)));
                continue;
            }
            output.append(c);
        }
        return output.toString();
    }

    public void fillTComboBox() {
        this.transitions = overlord.getWorkspace().getProject().getTransitions();
        this.mcsd = overlord.getWorkspace().getProject().getMCSdataCore();
        this.mcsBox.removeAllItems();
        this.mcsBox.addItem("---");
        this.mcsBox.setSelectedIndex(0);
        this.transBox.removeAllItems();
        this.transBox.addItem("---");
        this.transBox.setSelectedIndex(0);
        if (this.mcsd.getSize() == 0) {
            return;
        }
        this.transitions = overlord.getWorkspace().getProject().getTransitions();
        if (this.transitions != null && !this.transitions.isEmpty()) {
            for (int t = 0; t < this.transitions.size(); ++t) {
                this.transBox.addItem("t" + t + "." + this.transitions.get(t).getName());
            }
        }
    }

    private void showMCS(Integer transitionIndex, Integer mcsIndex) {
        String[] parseImportantTrans;
        this.places = overlord.getWorkspace().getProject().getPlaces();
        this.transitions = overlord.getWorkspace().getProject().getTransitions();
        this.mcsd = overlord.getWorkspace().getProject().getMCSdataCore();
        ArrayList<ArrayList<Integer>> dataVector = this.mcsd.getMCSlist(transitionIndex);
        ArrayList<Integer> MCS = dataVector.get(mcsIndex);
        HolmesNotepad notePad = new HolmesNotepad(800, 500);
        notePad.setVisible(true);
        ArrayList<Integer> ImportantTrans = new ArrayList<Integer>();
        if (!this.importantTrans.getText().isEmpty()) {
            if (this.importantTrans.getText().contains(",")) {
                for (String elem : parseImportantTrans = this.importantTrans.getText().split(",")) {
                    ImportantTrans.add(Integer.parseInt(elem));
                }
            } else {
                ImportantTrans.add(Integer.parseInt(this.importantTrans.getText()));
            }
        }
        notePad.addTextLine("MCS#" + mcsIndex + "[\n", "text");
        parseImportantTrans = MCS.iterator();
        while (parseImportantTrans.hasNext()) {
            int el = (Integer)parseImportantTrans.next();
            if (ImportantTrans.contains(el)) {
                notePad.addTextLine("\t(DENIED)_", "warning");
            } else {
                notePad.addTextLine("\t", "text");
            }
            notePad.addTextLine("t" + this.toSubscript(Integer.toString(el)) + "_" + this.transitions.get(el).getName() + ";\n", "text");
        }
        notePad.addTextLine("]\n", "text");
        HashSet<Place> Px = new HashSet<Place>();
        for (Integer MCStransition : MCS) {
            Transition transition = this.transitions.get(MCStransition);
            Px.addAll(transition.getOutputPlaces());
        }
        HashSet<Place> Poff = new HashSet<Place>();
        for (Place place : Px) {
            boolean flag = true;
            for (Transition transition : place.getInputTransitions()) {
                if (MCS.contains(transition.getID() - this.places.size())) continue;
                flag = false;
                break;
            }
            if (!flag) continue;
            Poff.add(place);
        }
        HashSet<Transition> Toff = new HashSet<Transition>();
        for (Place place : Poff) {
            Toff.addAll(place.getOutputTransitions());
        }
        notePad.addTextLine("(T_off: [\n", "text");
        for (Transition transition : Toff) {
            if (ImportantTrans.contains(transition.getID() - this.places.size())) {
                notePad.addTextLine("\t(DENIED)_", "error");
            } else {
                notePad.addTextLine("\t", "text");
            }
            notePad.addTextLine("t" + this.toSubscript(Integer.toString(transition.getID() - this.places.size())) + "_" + transition.getName() + ";\n", "text");
        }
        notePad.addTextLine("], Poff: [\n", "text");
        for (Place place : Poff) {
            notePad.addTextLine("\tp" + this.toSubscript(Integer.toString(place.getID())) + "_" + place.getName() + ";\n", "text");
        }
        notePad.addTextLine("])", "text");
        Px.clear();
        Poff.clear();
        Toff.clear();
    }

    private JPanel createMainPanel() {
        JPanel main = new JPanel(new BorderLayout());
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.setUI(new BasicTabbedPaneUI(){

            @Override
            protected int calculateTabHeight(int tabPlacement, int tabIndex, int fontHeight) {
                return 32;
            }

            @Override
            protected void paintTab(Graphics g, int tabPlacement, Rectangle[] rects, int tabIndex, Rectangle iconRect, Rectangle textRect) {
                super.paintTab(g, tabPlacement, rects, tabIndex, iconRect, textRect);
            }
        });
        JPanel mainPanel1stTab = new JPanel();
        mainPanel1stTab.setLayout(null);
        JPanel buttonPanelT = this.createUpperButtonPanel1stTab(0, 0, this.windowWidth - 20, 125);
        JPanel logMainPanelT = this.createLogMainPanel1stTab(0, 125, this.windowWidth, this.windowHeight - 120);
        mainPanel1stTab.add(buttonPanelT);
        mainPanel1stTab.add(logMainPanelT);
        mainPanel1stTab.repaint();
        tabbedPane.addTab("MCS", Tools.getResIcon22("/icons/invWindow/tInvIcon.png"), mainPanel1stTab, "T-invariants");
        tabbedPane.setMnemonicAt(0, 49);
        main.add((Component)tabbedPane, "Center");
        return main;
    }

    private JPanel createUpperButtonPanel1stTab(int x, int y, int width, int height) {
        JPanel panel = new JPanel();
        panel.setLayout(null);
        panel.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        panel.setBounds(x, y, width, height);
        int posX = 10;
        int posY = 10;
        JButton button1 = new JButton("TokensRanking");
        button1.setText("<html>Tokens<br />ranking</html>");
        button1.setBounds(posX, posY, 150, 45);
        button1.setMargin(new Insets(0, 0, 0, 0));
        button1.setIcon(Tools.getResIcon32("/icons/stateSim/simpleSimTab.png"));
        button1.addActionListener(actionEvent -> {
            this.places = overlord.getWorkspace().getProject().getPlaces();
            this.transitions = overlord.getWorkspace().getProject().getTransitions();
            this.mcsd = overlord.getWorkspace().getProject().getMCSdataCore();
            if (this.mcsd.getSize() == 0) {
                this.logField1stTab.append(" *** No MCS data! \n");
                return;
            }
            if (this.transBox.getSelectedIndex() == 0) {
                Object[] options = new Object[]{"All", "Cancel"};
                int n = JOptionPane.showOptionDialog(null, "You have not selected a transition (in Transition selector list)\nfor which you want to generate a ranking (an objective reaction).\n\nDo you want to generate rankings for all transitions?", "Warning", 0, 3, null, options, options[0]);
                if (n == 0) {
                    this.checkStarvedTransitions();
                }
            } else {
                this.checkStarvedTransitions();
            }
        });
        button1.setFocusPainted(false);
        panel.add(button1);
        JButton button1Info = new JButton("TKInfo");
        button1Info.setText("<html>Explanations</html>");
        button1Info.setBounds(posX, posY + 46, 150, 15);
        button1Info.setMargin(new Insets(0, 0, 0, 0));
        button1Info.setIcon(Tools.getResIcon32(""));
        button1Info.addActionListener(actionEvent -> JOptionPane.showMessageDialog(null, "When you press the button \"Tokens ranking\", make sure that you have selected the transition for which\nyou want to create a ranking of its MCS sets in the list to the right of the \"Clear Window\" button.\nIf \"---\" is selected, the rankings will be created (independently) for the MCS sets of each single\ntransition for which they were generated in the previous window.\n\nThe \"Tokens ranking\" button creates a ranking of MCS sets based on how many transitions will potentially\nbe starved if we consider MCS transitions to be permanently excluded in the simulation. Note: the algo-\nrithm is more complicated than the following description, but this one gives an idea of how it works. Let's\nassume that the transitions in MCS are a set of M. The set X is all the output places of the transitions \nfrom M. The set Y, is all the output transitions of the places from X. The algorithm checks whether in the\nset Y (the set of potentially starved transitions) there are some for which *all* input places have *at \nleast one* transition that will provide tokens. Such a transition, in order to sustain token production at\nthe input places of those in Y, must meet the conditions: not be in the M set (obviously), not be in the Y\nset. In addition, the distance variable (2 or 3) periodizes how far in the net structure the above relation-\nships are sought. If any transition initially being in the set Y, has all its input places such that they\nin turn will have tokens produced by other transitions independent of M (by distance), it is removed from Y.\nThe final ranking is based on the number of transitions remaining in Y.\n\n", "Info", 1));
        button1Info.setFocusPainted(false);
        panel.add(button1Info);
        this.description = new JCheckBox("Full trans/places names");
        this.description.setBounds(posX - 5, posY + 65, 170, 20);
        panel.add(this.description);
        this.ID = new JCheckBox("ID of transitions/places");
        this.ID.setBounds(posX - 5, posY + 90, 160, 15);
        panel.add(this.ID);
        JLabel comboDesc = new JLabel("Sort by:");
        comboDesc.setBounds(posX + 180, posY - 10, 150, 20);
        comboDesc.setEnabled(false);
        panel.add(comboDesc);
        this.TorP = new JComboBox();
        this.TorP.addItem("T_off");
        this.TorP.addItem("P_off");
        this.TorP.setBounds(posX + 180, posY + 10, 70, 20);
        this.TorP.setSelectedIndex(0);
        this.TorP.setEnabled(false);
        panel.add(this.TorP);
        JLabel transDesc = new JLabel("Important trans.:");
        transDesc.setBounds(posX + 180, posY + 30, 120, 20);
        transDesc.setEnabled(false);
        panel.add(transDesc);
        this.importantTrans = new JTextField();
        this.importantTrans.setBounds(posX + 180, posY + 50, 100, 20);
        this.importantTrans.setEnabled(false);
        panel.add(this.importantTrans);
        JLabel distLabel = new JLabel("Distance");
        distLabel.setBounds(posX + 180, posY + 70, 80, 20);
        panel.add(distLabel);
        SpinnerNumberModel distSpinnerModel = new SpinnerNumberModel(3, 2, 3, 1);
        this.distanceSpinner = new JSpinner(distSpinnerModel);
        this.distanceSpinner.setBounds(posX + 180, posY + 90, 60, 20);
        this.distanceSpinner.addChangeListener(e -> {
            JSpinner spinner = (JSpinner)e.getSource();
            this.distanceVar = (Integer)spinner.getValue();
        });
        panel.add(this.distanceSpinner);
        JSeparator separator101 = new JSeparator();
        separator101.setOrientation(1);
        separator101.setBounds(posX + 295, posY, 2, 110);
        panel.add(separator101);
        JButton transRank = new JButton("T-inv rank");
        transRank.setText("<html><center>Invariants<br />ranking</center></html>");
        transRank.setBounds(posX + 310, posY, 135, 45);
        transRank.setMargin(new Insets(0, 0, 0, 0));
        transRank.setIcon(Tools.getResIcon22("/icons/menu/menu_analysis_invariants.png"));
        transRank.addActionListener(actionEvent -> {
            if (this.transBox.getSelectedIndex() == 0) {
                Object[] options = new Object[]{"All", "Cancel"};
                int n = JOptionPane.showOptionDialog(null, "You have not selected a transition (in Transition selector list)\nfor which you want to generate a ranking (an objective reaction).\n\nDo you want to generate rankings for all transitions?", "Warning", 0, 3, null, options, options[0]);
                if (n == 0) {
                    this.rankingByInvariantsThenTransitions();
                }
            } else {
                this.rankingByInvariantsThenTransitions();
            }
        });
        transRank.setFocusPainted(false);
        panel.add(transRank);
        JButton transRankInfo = new JButton("Jenson");
        transRankInfo.setText("<html>Explanations</html>");
        transRankInfo.setBounds(posX + 310, posY + 46, 135, 15);
        transRankInfo.setMargin(new Insets(0, 0, 0, 0));
        transRankInfo.setIcon(Tools.getResIcon32(""));
        transRankInfo.addActionListener(actionEvent -> JOptionPane.showMessageDialog(null, "When you press the button \"Invariants ranking\", make sure that you have selected the transition for \nwhich you want to create a ranking of its MCS sets in the dropdown list to the right of the \n\"Clear Window\" button. If \"---\" is selected, the rankings will be created (independently) for the MCS\nsets of each single transition for which they were generated in the previous window.\n\nThe \"Invariants ranking\" button creates a ranking of MCS sets according to two criteria. The most \nimportant on is the number of t-invariants disabled by a given MCS (i.e., t-invariant is considered\ndisabled, if it contains in its support at least one transition from an MCS). If the same number of \nt-invariants is disabled for several different MCS sets, then the order is further determined by the \nnumber of transitions found in the supports of all excluded t-invariants. The fewer, the higher the MCS\nis ranked because the more subtle its effects are on the net.\nAdditionally: please leave Distance setting to 3, and be aware that other controls have currently no\ninfluence on this ranking. [To be adjusted soon]\n\n", "Info", 1));
        transRankInfo.setFocusPainted(false);
        panel.add(transRankInfo);
        JButton buttonData = new JButton("ButtonClearAll");
        buttonData.setText("<html><center>Clear<br>log</center></html>");
        buttonData.setBounds(posX + 320, posY + 70, 110, 38);
        buttonData.setMargin(new Insets(0, 0, 0, 0));
        buttonData.setIcon(Tools.getResIcon22("/icons/toolbar/cleanGraphColors.png"));
        buttonData.addActionListener(actionEvent -> this.logField1stTab.setText(""));
        buttonData.setFocusPainted(false);
        panel.add(buttonData);
        JSeparator separator201 = new JSeparator();
        separator201.setOrientation(1);
        separator201.setBounds(posX + 460, posY, 2, 110);
        panel.add(separator201);
        JLabel transLabel = new JLabel("Transitions selector (objective reactions with MCSs:");
        transLabel.setBounds(posX + 475, posY - 10, 300, 20);
        panel.add(transLabel);
        String[] dataT = new String[]{"---"};
        this.transBox = new JComboBox<String>(dataT);
        this.transBox.setBounds(posX + 475, posY + 10, 330, 20);
        this.transBox.setSelectedIndex(0);
        this.transBox.setMaximumRowCount(6);
        this.transBox.removeAllItems();
        this.transBox.addItem("---");
        this.transBox.addActionListener(actionEvent -> {
            this.mcsBox.removeAllItems();
            this.mcsBox.addItem("---");
            this.mcsd = overlord.getWorkspace().getProject().getMCSdataCore();
            if (this.mcsd.getSize() == 0) {
                return;
            }
            int selected = this.transBox.getSelectedIndex();
            if (selected <= 0) {
                return;
            }
            ArrayList<ArrayList<Integer>> dataVector = this.mcsd.getMCSlist(--selected);
            int counter = 0;
            for (ArrayList<Integer> MCS : dataVector) {
                StringBuilder msg = new StringBuilder("MCS#");
                msg.append(counter).append(" ").append("[");
                for (int el : MCS) {
                    msg.append(el).append(", ");
                }
                msg.append("]");
                msg = new StringBuilder(msg.toString().replace(", ]", "]"));
                this.mcsBox.addItem(msg.toString());
                ++counter;
            }
        });
        panel.add(this.transBox);
        JLabel showMCSLabel = new JLabel("Show MCS:");
        showMCSLabel.setBounds(posX + 475, posY + 30, 100, 20);
        panel.add(showMCSLabel);
        this.mcsBox = new JComboBox<String>(dataT);
        this.mcsBox.setBounds(posX + 475, posY + 50, 200, 20);
        this.mcsBox.setSelectedIndex(0);
        this.mcsBox.setMaximumRowCount(6);
        this.mcsBox.removeAllItems();
        this.mcsBox.addItem("---");
        this.mcsBox.addActionListener(actionEvent -> {});
        panel.add(this.mcsBox);
        JButton showMCS = new JButton("Button 888");
        showMCS.setText("Show MCS");
        showMCS.setBounds(posX + 475, posY + 74, 130, 36);
        showMCS.setMargin(new Insets(0, 0, 0, 0));
        showMCS.setIcon(Tools.getResIcon22("/icons/invWindow/showInvariants.png"));
        showMCS.addActionListener(actionEvent -> {
            int selectedTrans = this.transBox.getSelectedIndex();
            if (selectedTrans == 0) {
                return;
            }
            --selectedTrans;
            int selectedMCS = this.mcsBox.getSelectedIndex();
            if (selectedMCS == 0) {
                return;
            }
            this.showMCS(selectedTrans, --selectedMCS);
        });
        showMCS.setFocusPainted(false);
        panel.add(showMCS);
        JSeparator separator301 = new JSeparator();
        separator301.setOrientation(1);
        separator301.setBounds(posX + 815, posY, 2, 110);
        panel.add(separator301);
        JButton mcsOffRank = new JButton("Off Rank");
        mcsOffRank.setText("<html><center>Minimum offline<br />P/T ranking</center></html>");
        mcsOffRank.setBounds(posX + 825, posY, 160, 50);
        mcsOffRank.setMargin(new Insets(0, 0, 0, 0));
        mcsOffRank.setIcon(Tools.getResIcon22("/icons/toolbar/simLog.png"));
        mcsOffRank.addActionListener(actionEvent -> this.trzy());
        mcsOffRank.setFocusPainted(false);
        panel.add(mcsOffRank);
        JButton mcsOffRankInfo = new JButton("Jenson");
        mcsOffRankInfo.setText("<html>Explanation</html>");
        mcsOffRankInfo.setBounds(posX + 825, posY + 51, 160, 15);
        mcsOffRankInfo.setMargin(new Insets(0, 0, 0, 0));
        mcsOffRankInfo.setIcon(Tools.getResIcon32(""));
        mcsOffRankInfo.addActionListener(actionEvent -> JOptionPane.showMessageDialog(null, "The task is to select the best MCS set for each transition of the analyzed model.\nThis algorithm is essentially an extension of the first algorithm, as it also creates\nthe P_off and T_off sets, but instead of creating a ranking of minimal cut sets, it\nselects the theoretically best set for a given transition. According to the algorithm's\ncriteria, the best set is the one whose transitions directly disable the fewest places\nand transitions in the network, meaning the P_off and T_off sets are the smallest.\nAdditionally, if one or more sets have the same result, the number of transitions in\neach MCS set is checked. The smaller the MCS set, the better. Of course, this algorithm\nalso allows for marking important transitions that should remain enabled. If the\npotentially best MCS set disables such a transition, another best set that does not\ndisable such a transition will appear next to it. Furthermore, where possible, the\nalgorithm tries not to select a trivial case as the best set, where the MCS is a\nsingle-element set consisting of the transition for which the best set is being sought.", "Info", 1));
        mcsOffRankInfo.setFocusPainted(false);
        panel.add(mcsOffRankInfo);
        return panel;
    }

    private JPanel createLogMainPanel1stTab(int x, int y, int width, int height) {
        JPanel panel = new JPanel();
        panel.setLayout(null);
        panel.setBorder(BorderFactory.createTitledBorder("Log window"));
        panel.setBounds(x, y, width - 20, height - 50);
        this.logField1stTab = new JTextArea();
        this.logField1stTab.setLineWrap(true);
        this.logField1stTab.setEditable(true);
        this.logField1stTab.setFont(new Font("Monospaced", 0, 12));
        DefaultCaret caret = (DefaultCaret)this.logField1stTab.getCaret();
        caret.setUpdatePolicy(2);
        JPanel logFieldPanel = new JPanel();
        logFieldPanel.setLayout(new BorderLayout());
        logFieldPanel.add((Component)new JScrollPane(this.logField1stTab), "Center");
        logFieldPanel.setBounds(10, 20, width - 35, height - 110);
        panel.add(logFieldPanel);
        return panel;
    }

    private void initiateListeners() {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent e) {
                HolmesMCSanalysis.this.fillTComboBox();
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private void checkStarvedTransitions() {
        this.mcsd = overlord.getWorkspace().getProject().getMCSdataCore();
        this.transitions = overlord.getWorkspace().getProject().getTransitions();
        this.invariantsMatrix = overlord.getWorkspace().getProject().getT_InvMatrix();
        int selectedTrans = this.transBox.getSelectedIndex();
        int Distance = this.distanceVar;
        if (this.invariantsMatrix == null || this.invariantsMatrix.isEmpty()) {
            this.logField1stTab.append(" *** t-invariants set empty! ***\n");
            return;
        }
        this.logField1stTab.append(" *******************************************************************\n");
        this.logField1stTab.append("                TRANSITION STARVATION MCS RANKING\n");
        this.logField1stTab.append(" *******************************************************************\n\n");
        for (int objReaction = 0; objReaction < this.mcsd.getSize(); ++objReaction) {
            if (selectedTrans > 0 && selectedTrans - 1 != objReaction) continue;
            ArrayList<ArrayList<Integer>> MCSsForObjReaction = this.mcsd.getMCSlist(objReaction);
            if (MCSsForObjReaction == null || MCSsForObjReaction.isEmpty()) {
                this.logField1stTab.append("\n XXXXXXXXX no MCSs for trans. ID: " + objReaction + " XXXXXXXXX\n\n");
                continue;
            }
            this.logField1stTab.append("\n ********* MCS sets ranking for trans. ID: " + objReaction + " *********\n\n");
            HashMap<String, tokensRankDatabox> MCSrank = new HashMap<String, tokensRankDatabox>();
            int counter = -1;
            for (ArrayList<Integer> MCS : MCSsForObjReaction) {
                boolean bl;
                ++counter;
                HashSet<Transition> hashSetMCS = new HashSet<Transition>();
                for (Integer MCStransitionID : MCS) {
                    hashSetMCS.add(this.transitions.get(MCStransitionID));
                }
                hashSetMCS = this.redefineMCS(hashSetMCS);
                HashSet<Place> outputPlacesOfMCS = this.createOutputPlacesOfMCS(hashSetMCS);
                HashSet<Place> safeOutputPlacesOfMCS = new HashSet<Place>();
                for (Integer n : MCS) {
                    Transition transition = this.transitions.get(n);
                }
                HashSet<Transition> T_dng = new HashSet<Transition>();
                for (Place place : outputPlacesOfMCS) {
                    T_dng.addAll(place.getOutputTransitions());
                }
                boolean bl2 = false;
                ArrayList<Transition> transDeadDirectlyBecauseOfMCS = new ArrayList<Transition>();
                boolean triggerFoundReallyDeadTransitionInTdng = false;
                while (!bl) {
                    Transition transToRemove = null;
                    for (Transition currentTrans : T_dng) {
                        bl = true;
                        boolean removeTransitionFromEndangeredSet = false;
                        boolean potentiallyRemoveTransAsStarved = false;
                        HashSet<Place> inputPlacesForTransFormT_dng = new HashSet<Place>(currentTrans.getInputPlaces());
                        for (Place place : inputPlacesForTransFormT_dng) {
                            triggerFoundReallyDeadTransitionInTdng = false;
                            HashSet<Transition> inputTransToInputPlacesForT_dng = new HashSet<Transition>(place.getInputTransitions());
                            inputTransToInputPlacesForT_dng.removeIf(hashSetMCS::contains);
                            if (inputTransToInputPlacesForT_dng.isEmpty()) {
                                for (Transition t_tmp : place.getOutputTransitions()) {
                                    if (!T_dng.contains(t_tmp)) continue;
                                    transDeadDirectlyBecauseOfMCS.add(t_tmp);
                                }
                                bl = false;
                                triggerFoundReallyDeadTransitionInTdng = true;
                                break;
                            }
                            inputTransToInputPlacesForT_dng.removeIf(T_dng::contains);
                            if (inputTransToInputPlacesForT_dng.isEmpty()) break;
                            boolean unstarvedPlaceFound = false;
                            for (Transition toCheckTrans : inputTransToInputPlacesForT_dng) {
                                boolean canTransitionFire = this.canFire(toCheckTrans, T_dng, Distance);
                                if (!canTransitionFire) continue;
                                unstarvedPlaceFound = true;
                                break;
                            }
                            if (unstarvedPlaceFound) {
                                if (outputPlacesOfMCS.contains(place)) {
                                    safeOutputPlacesOfMCS.add(place);
                                }
                                potentiallyRemoveTransAsStarved = true;
                                continue;
                            }
                            potentiallyRemoveTransAsStarved = false;
                            break;
                        }
                        if (triggerFoundReallyDeadTransitionInTdng) break;
                        if (!potentiallyRemoveTransAsStarved) continue;
                        bl = false;
                        transToRemove = currentTrans;
                        break;
                    }
                    if (triggerFoundReallyDeadTransitionInTdng) {
                        T_dng.removeIf(transDeadDirectlyBecauseOfMCS::contains);
                        break;
                    }
                    if (!bl) {
                        T_dng.remove(transToRemove);
                    }
                    if (!T_dng.isEmpty()) continue;
                    bl = true;
                }
                outputPlacesOfMCS.removeAll(safeOutputPlacesOfMCS);
                T_dng.addAll(transDeadDirectlyBecauseOfMCS);
                StringBuilder rankmsg = new StringBuilder("MCS#");
                rankmsg.append(counter).append(" ").append("[");
                Iterator<Object> iterator = MCS.iterator();
                while (iterator.hasNext()) {
                    int el = (Integer)iterator.next();
                    rankmsg.append("t").append(el).append(", ");
                }
                rankmsg.append("]");
                rankmsg = new StringBuilder(rankmsg.toString().replace(", ]", "]"));
                tokensRankDatabox obj = new tokensRankDatabox();
                obj.starvedTransitions = T_dng.size();
                obj.outputPlacesOfMCS = outputPlacesOfMCS;
                MCSrank.put(rankmsg.toString(), obj);
            }
            LinkedHashMap<String, tokensRankDatabox> lhm = new LinkedHashMap<String, tokensRankDatabox>();
            int lim = MCSrank.size();
            for (int i = 0; i < lim; ++i) {
                int min = this.transitions.size() + 1;
                String rem = "";
                tokensRankDatabox newObject = new tokensRankDatabox();
                for (Map.Entry entry : MCSrank.entrySet()) {
                    if (((tokensRankDatabox)entry.getValue()).starvedTransitions >= min) continue;
                    newObject = (tokensRankDatabox)entry.getValue();
                    rem = (String)entry.getKey();
                    min = ((tokensRankDatabox)entry.getValue()).starvedTransitions;
                }
                lhm.put(rem, newObject);
                MCSrank.remove(rem);
            }
            ArrayList<Integer> ImportantTrans = new ArrayList<Integer>();
            if (!this.importantTrans.getText().isEmpty()) {
                if (this.importantTrans.getText().contains(",")) {
                    void var13_26;
                    String[] parseImportantTrans;
                    String[] stringArray = parseImportantTrans = this.importantTrans.getText().split(",");
                    int newObject = stringArray.length;
                    boolean bl = false;
                    while (var13_26 < newObject) {
                        String elem = stringArray[var13_26];
                        ImportantTrans.add(Integer.parseInt(elem));
                        ++var13_26;
                    }
                } else {
                    ImportantTrans.add(Integer.parseInt(this.importantTrans.getText()));
                }
            }
            int liczba_wynikow = 20;
            for (Map.Entry mapElement : lhm.entrySet()) {
                String[] stringArray = ((String)mapElement.getKey()).split("\\[");
                float percStarvedTransitions = (float)(((tokensRankDatabox)mapElement.getValue()).starvedTransitions * 100) / (float)this.transitions.size();
                float percStarvedPlaces = (float)(((tokensRankDatabox)mapElement.getValue()).outputPlacesOfMCS.size() * 100) / (float)this.places.size();
                String pSign = "%";
                this.logField1stTab.append(String.format("%-8s %-30s%s%d, %.2f%s, %s%d, %.2f%s)", stringArray[0], "[" + stringArray[1], "( Tx:", ((tokensRankDatabox)mapElement.getValue()).starvedTransitions, Float.valueOf(percStarvedTransitions), pSign, "Px: ", ((tokensRankDatabox)mapElement.getValue()).outputPlacesOfMCS.size(), Float.valueOf(percStarvedPlaces), pSign));
                this.logField1stTab.append("\n");
                --liczba_wynikow;
            }
            lhm.clear();
            MCSrank.clear();
        }
    }

    private void rankingByInvariantsThenTransitions() {
        this.mcsd = overlord.getWorkspace().getProject().getMCSdataCore();
        this.transitions = overlord.getWorkspace().getProject().getTransitions();
        this.invariantsMatrix = overlord.getWorkspace().getProject().getT_InvMatrix();
        int selectedTrans = this.transBox.getSelectedIndex();
        if (this.invariantsMatrix == null || this.invariantsMatrix.isEmpty()) {
            this.logField1stTab.append(" *** t-invariants set empty! ***\n");
            return;
        }
        this.logField1stTab.append(" *******************************************************************\n");
        this.logField1stTab.append("                T-INVARIANTS IMPACT MCS RANKING\n");
        this.logField1stTab.append(" *******************************************************************\n\n");
        for (int transitionIndex = 0; transitionIndex < this.mcsd.getSize(); ++transitionIndex) {
            if (selectedTrans > 0 && selectedTrans - 1 != transitionIndex) continue;
            ArrayList<ArrayList<Integer>> dataVector = this.mcsd.getMCSlist(transitionIndex);
            if (dataVector == null || dataVector.isEmpty()) {
                this.logField1stTab.append("\n XXXXXXXXX no MCSs for trans. ID: " + transitionIndex + " XXXXXXXXX\n\n");
                continue;
            }
            this.logField1stTab.append("\n ********* MCS sets ranking for trans. ID: " + transitionIndex + " *********\n\n");
            HashMap<Integer, ArrayList<Integer>> B = new HashMap<Integer, ArrayList<Integer>>();
            HashMap<Integer, ArrayList<Integer>> A = new HashMap<Integer, ArrayList<Integer>>();
            HashSet<Integer> Tb = new HashSet<Integer>();
            HashSet<Integer> Tx = new HashSet<Integer>();
            HashMap<String, Long> MCSrank = new HashMap<String, Long>();
            HashMap MCSsets = new HashMap();
            int MCScounter = 0;
            for (ArrayList<Integer> MCSset : dataVector) {
                StringBuilder rankmsg = new StringBuilder("MCS#");
                rankmsg.append(MCScounter).append(" ").append("[");
                for (int el : MCSset) {
                    rankmsg.append("t").append(el).append(", ");
                }
                rankmsg.append("]");
                rankmsg = new StringBuilder(rankmsg.toString().replace(", ]", "]"));
                int counter = 0;
                for (ArrayList<Integer> tInv : this.invariantsMatrix) {
                    ArrayList<Integer> tInvSupp = InvariantsTools.getSupport(tInv);
                    boolean flag = true;
                    for (Integer MCStrans : MCSset) {
                        if (!tInvSupp.contains(MCStrans)) continue;
                        flag = false;
                        A.put(counter, tInvSupp);
                        Tx.addAll(tInvSupp);
                        break;
                    }
                    if (flag) {
                        B.put(counter, tInvSupp);
                        Tb.addAll(tInvSupp);
                    }
                    ++counter;
                }
                rankmsg.append(" dis-inv: ").append(A.size());
                MCSrank.put(rankmsg.toString(), (long)A.size() * 100000L + (long)Tx.size());
                MCSsets.put(rankmsg.toString(), new HashSet(Tx));
                A.clear();
                B.clear();
                Tx.clear();
                Tb.clear();
                ++MCScounter;
            }
            LinkedHashMap<String, Long> lhm = new LinkedHashMap<String, Long>();
            int lim = MCSrank.size();
            for (int i = 0; i < lim; ++i) {
                int min = Integer.MAX_VALUE;
                long originalEntryValue = 0L;
                String remembered = "";
                for (Map.Entry entry : MCSrank.entrySet()) {
                    int invNumber = (int)((Long)entry.getValue() / 100000L);
                    if (invNumber >= min) continue;
                    remembered = (String)entry.getKey();
                    min = invNumber;
                    originalEntryValue = (Long)entry.getValue();
                }
                lhm.put(remembered, originalEntryValue);
                MCSrank.remove(remembered);
            }
            ArrayList<Integer> ImportantTrans = new ArrayList<Integer>();
            if (!this.importantTrans.getText().isEmpty()) {
                if (this.importantTrans.getText().contains(",")) {
                    String[] parseImportantTrans;
                    for (String elem : parseImportantTrans = this.importantTrans.getText().split(",")) {
                        ImportantTrans.add(Integer.parseInt(elem));
                    }
                } else {
                    ImportantTrans.add(Integer.parseInt(this.importantTrans.getText()));
                }
            }
            int liczba_wynikow = 20;
            for (Map.Entry mapElement : lhm.entrySet()) {
                String[] mcs = ((String)mapElement.getKey()).split("\\[");
                int inv = -1;
                try {
                    int num;
                    int tmp1 = mcs[1].indexOf(":");
                    String check = mcs[1].substring(tmp1 + 1);
                    check = check.replace(" ", "");
                    inv = num = Integer.parseInt(check);
                    tmp1 = mcs[1].indexOf("]");
                    mcs[1] = mcs[1].substring(0, tmp1 + 1);
                }
                catch (Exception tmp1) {
                    // empty catch block
                }
                int transNumberValue = (int)((Long)mapElement.getValue() % 100000L);
                float disabledTransitions = (float)(transNumberValue * 100) / (float)this.transitions.size();
                String pSing = "%";
                for (Integer trans : ImportantTrans) {
                    if (!((Set)MCSsets.get(mapElement.getKey())).contains(trans)) continue;
                    this.logField1stTab.append("(DENIED)_");
                    break;
                }
                this.logField1stTab.append(String.format("%-8s %-30s %s%d%s%d (%.2f%s) )", mcs[0], "[" + mcs[1], "(Dis. inv: ", inv, " | Dis. trans: ", transNumberValue, Float.valueOf(disabledTransitions), pSing));
                this.logField1stTab.append("\n");
                --liczba_wynikow;
            }
            lhm.clear();
            MCSrank.clear();
            MCSsets.clear();
        }
    }

    private HashSet<Place> createOutputPlacesOfMCS(HashSet<Transition> hashSetMCS) {
        HashSet<Place> outputPlacesOfMCS = new HashSet<Place>();
        for (Transition t : hashSetMCS) {
            outputPlacesOfMCS.addAll(t.getOutputPlaces());
        }
        return outputPlacesOfMCS;
    }

    private HashSet<Transition> redefineMCS(HashSet<Transition> hashSetMCS) {
        HashSet<Transition> newMCS = new HashSet<Transition>();
        block0: for (Transition t : hashSetMCS) {
            ArrayList<Place> outPlaces = t.getOutputPlaces();
            for (Place p : outPlaces) {
                HashSet<Transition> inTrans = new HashSet<Transition>(p.getInputTransitions());
                inTrans.removeIf(hashSetMCS::contains);
                if (!inTrans.isEmpty()) continue;
                newMCS.addAll(p.getOutputTransitions());
                continue block0;
            }
        }
        newMCS.addAll(hashSetMCS);
        return newMCS;
    }

    private boolean canFire(Transition t_x, HashSet<Transition> T_dng, int distance) {
        for (Place p : t_x.getInputPlaces()) {
            if (this.AllInputTransitionsInDngSet(p, T_dng)) {
                return false;
            }
            if (distance <= 1) continue;
            for (Transition t : p.getInputTransitions()) {
                if (!this.CheckHigherLevels(t, T_dng, distance - 1)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean AllInputTransitionsInDngSet(Place p, HashSet<Transition> T_dng) {
        for (Transition t : p.getInputTransitions()) {
            if (T_dng.contains(t)) continue;
            return false;
        }
        return true;
    }

    private boolean CheckHigherLevels(Transition t, HashSet<Transition> T_dng, int distance) {
        if (distance == 1) {
            for (Place p : t.getInputPlaces()) {
                if (this.AllInputTransitionsInDngSet(p, T_dng)) continue;
                return false;
            }
        } else {
            for (Place p : t.getInputPlaces()) {
                if (this.AllInputTransitionsInDngSet(p, T_dng)) {
                    return true;
                }
                if (distance <= 2) continue;
                for (Transition t_prime : p.getInputTransitions()) {
                    if (!this.CheckHigherLevels(t_prime, T_dng, distance - 1)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    /*
     * Could not resolve type clashes
     */
    private void jeden() {
        this.places = overlord.getWorkspace().getProject().getPlaces();
        this.transitions = overlord.getWorkspace().getProject().getTransitions();
        this.mcsd = overlord.getWorkspace().getProject().getMCSdataCore();
        boolean deniedTransParseFailed = false;
        int selectedTrans = this.transBox.getSelectedIndex();
        for (int transitionIndex = 0; transitionIndex < this.mcsd.getSize(); ++transitionIndex) {
            ArrayList<ArrayList<Integer>> dataVector;
            if (selectedTrans > 0 && selectedTrans - 1 != transitionIndex || (dataVector = this.mcsd.getMCSlist(transitionIndex)) == null || dataVector.isEmpty()) continue;
            this.logField1stTab.append(" *** MCS sets for transition ID: " + transitionIndex + ": ***\n");
            HashMap<String, ArrayList<Integer>> MCSsets = new HashMap<String, ArrayList<Integer>>();
            HashMap MCSsetsindexes = new HashMap();
            HashMap<String, ArrayList<Integer>> MCStrans = new HashMap<String, ArrayList<Integer>>();
            int counter = 0;
            for (ArrayList<Integer> MCS : dataVector) {
                Object MCStransition2;
                StringBuilder rankmsg = new StringBuilder("MCS#");
                rankmsg.append(counter).append(" ").append("[");
                StringBuilder msg = new StringBuilder("[");
                for (int el : MCS) {
                    msg.append("t").append(el).append(", ");
                    rankmsg.append("t").append(el).append(", ");
                }
                msg.append("] : ");
                rankmsg.append("] ");
                msg = new StringBuilder(msg.toString().replace(", ]", "]"));
                rankmsg = new StringBuilder(rankmsg.toString().replace(", ]", "]"));
                HashSet<Place> Px = new HashSet<Place>();
                for (Object MCStransition2 : MCS) {
                    Transition transition = this.transitions.get((Integer)MCStransition2);
                    Px.addAll(transition.getOutputPlaces());
                }
                HashSet<Object> Poff = new HashSet<Object>();
                MCStransition2 = Px.iterator();
                while (MCStransition2.hasNext()) {
                    Place place = (Place)MCStransition2.next();
                    boolean flag = true;
                    for (Transition transition : place.getInputTransitions()) {
                        if (MCS.contains(transition.getID() - this.places.size())) continue;
                        flag = false;
                        break;
                    }
                    if (!flag) continue;
                    Poff.add(place);
                }
                HashSet<Transition> Toff = new HashSet<Transition>();
                for (Place place : Poff) {
                    Toff.addAll(place.getOutputTransitions());
                }
                ArrayList<Integer> indexes = new ArrayList<Integer>();
                for (Transition transition : Toff) {
                    indexes.add(transition.getID() - this.places.size());
                }
                for (Place place : Poff) {
                    indexes.add(place.getID());
                }
                MCSsetsindexes.put(rankmsg.toString(), indexes);
                MCSsets.put(rankmsg.toString(), new ArrayList<Integer>(Arrays.asList(Toff.size(), Poff.size())));
                MCStrans.put(rankmsg.toString(), MCS);
                ++counter;
                Px.clear();
                Poff.clear();
                Toff.clear();
            }
            LinkedHashMap<String, Integer> lhm = new LinkedHashMap<String, Integer>();
            HashMap MCSsetscp = new HashMap(MCSsets);
            int lim = MCSsets.size();
            for (int i = 0; i < lim; ++i) {
                int min = this.transitions.size();
                int min_alt = this.transitions.size();
                String rem = null;
                for (Map.Entry entry : MCSsetscp.entrySet()) {
                    int other = 0;
                    if (this.TorP.getSelectedIndex() != 1) {
                        other = 1;
                    }
                    if ((Integer)((ArrayList)entry.getValue()).get(this.TorP.getSelectedIndex()) < min) {
                        rem = (String)entry.getKey();
                        min = (Integer)((ArrayList)entry.getValue()).get(this.TorP.getSelectedIndex());
                        min_alt = (Integer)((ArrayList)entry.getValue()).get(other);
                        continue;
                    }
                    if ((Integer)((ArrayList)entry.getValue()).get(this.TorP.getSelectedIndex()) != min || (Integer)((ArrayList)entry.getValue()).get(other) >= min_alt) continue;
                    rem = (String)entry.getKey();
                    min = (Integer)((ArrayList)entry.getValue()).get(this.TorP.getSelectedIndex());
                    min_alt = (Integer)((ArrayList)entry.getValue()).get(other);
                }
                lhm.put(rem, min);
                MCSsetscp.remove(rem);
            }
            ArrayList<Integer> ImportantTrans = new ArrayList<Integer>();
            if (!this.importantTrans.getText().isEmpty()) {
                try {
                    if (this.importantTrans.getText().contains(",")) {
                        String[] parseImportantTrans;
                        for (String elem : parseImportantTrans = this.importantTrans.getText().split(",")) {
                            ImportantTrans.add(Integer.parseInt(elem));
                        }
                    } else {
                        ImportantTrans.add(Integer.parseInt(this.importantTrans.getText()));
                    }
                }
                catch (Exception ex) {
                    if (!deniedTransParseFailed) {
                        JOptionPane.showMessageDialog(null, "Error while parsing text field, proper syntax is: 1,2,3,4,5\n\n Important transitions will be ignored for this analysis.", "Important transitions field error", 0);
                    }
                    deniedTransParseFailed = true;
                }
            }
            if (!this.description.isSelected() && !this.ID.isSelected()) {
                for (Map.Entry mapElement : lhm.entrySet()) {
                    Object trans2;
                    String[] mcs = ((String)mapElement.getKey()).split("\\[");
                    for (Object trans2 : ((ArrayList)MCSsetsindexes.get(mapElement.getKey())).subList(0, (Integer)((ArrayList)MCSsets.get(mapElement.getKey())).get(0))) {
                        if (!ImportantTrans.contains(trans2)) continue;
                        this.logField1stTab.append("(DENIED)_");
                    }
                    String deniedMCStrans = mcs[1];
                    trans2 = ImportantTrans.iterator();
                    while (trans2.hasNext()) {
                        int impTrans = (Integer)trans2.next();
                        if (!mcs[1].contains(Integer.toString(impTrans))) continue;
                        deniedMCStrans = deniedMCStrans.replace("t" + Integer.toString(impTrans), "(DENIED)_t" + Integer.toString(impTrans));
                    }
                    this.logField1stTab.append(String.format("%-8s %-20s (T_off: %d, P_off %d)", mcs[0], "[" + deniedMCStrans, ((ArrayList)MCSsets.get(mapElement.getKey())).get(0), ((ArrayList)MCSsets.get(mapElement.getKey())).get(1)));
                    this.logField1stTab.append("\n");
                }
            } else if (!this.description.isSelected() && this.ID.isSelected()) {
                int liczba_wynikow = 20;
                for (Map.Entry mapElement : lhm.entrySet()) {
                    String[] mcs = ((String)mapElement.getKey()).split("\\[");
                    String deniedMCStrans = mcs[1];
                    Iterator impTrans = ImportantTrans.iterator();
                    while (impTrans.hasNext()) {
                        int impTrans2 = (Integer)impTrans.next();
                        if (!mcs[1].contains(Integer.toString(impTrans2))) continue;
                        deniedMCStrans = deniedMCStrans.replace("t" + Integer.toString(impTrans2), "(DENIED)_t" + Integer.toString(impTrans2));
                    }
                    this.logField1stTab.append(String.format("%-8s %-20s (T_off: [", mcs[0], "[" + deniedMCStrans));
                    if ((Integer)((ArrayList)MCSsets.get(mapElement.getKey())).get(0) > 0) {
                        for (int i = 0; i < (Integer)((ArrayList)MCSsets.get(mapElement.getKey())).get(0); ++i) {
                            if (ImportantTrans.contains(((ArrayList)MCSsetsindexes.get(mapElement.getKey())).get(i))) {
                                this.logField1stTab.append("(DENIED)_");
                            }
                            this.logField1stTab.append("t" + this.toSubscript(Integer.toString((Integer)((ArrayList)MCSsetsindexes.get(mapElement.getKey())).get(i))));
                            if (i != (Integer)((ArrayList)MCSsets.get(mapElement.getKey())).get(0) - 1) {
                                this.logField1stTab.append(", ");
                                continue;
                            }
                            this.logField1stTab.append("], P_off: [");
                        }
                    } else {
                        this.logField1stTab.append("], P_off: [");
                    }
                    if ((Integer)((ArrayList)MCSsets.get(mapElement.getKey())).get(1) > 0) {
                        for (int i = ((Integer)((ArrayList)MCSsets.get(mapElement.getKey())).get(0)).intValue(); i < (Integer)((ArrayList)MCSsets.get(mapElement.getKey())).get(0) + (Integer)((ArrayList)MCSsets.get(mapElement.getKey())).get(1); ++i) {
                            this.logField1stTab.append("p" + this.toSubscript(Integer.toString((Integer)((ArrayList)MCSsetsindexes.get(mapElement.getKey())).get(i))));
                            if (i != (Integer)((ArrayList)MCSsets.get(mapElement.getKey())).get(0) + (Integer)((ArrayList)MCSsets.get(mapElement.getKey())).get(1) - 1) {
                                this.logField1stTab.append(", ");
                                continue;
                            }
                            this.logField1stTab.append("])");
                        }
                    } else {
                        this.logField1stTab.append("])");
                    }
                    this.logField1stTab.append("\n");
                    --liczba_wynikow;
                }
                this.logField1stTab.append("\n");
            } else if (this.description.isSelected() && !this.ID.isSelected()) {
                for (Map.Entry mapElement : lhm.entrySet()) {
                    String MCSname = ((String)mapElement.getKey()).split(" \\[")[0];
                    this.logField1stTab.append(MCSname + "[ \n");
                    for (Object trans2 : (ArrayList)MCStrans.get(mapElement.getKey())) {
                        if (ImportantTrans.contains(trans2)) {
                            this.logField1stTab.append("\t(DENIED)_" + this.transitions.get((Integer)trans2).getName() + ";\n");
                            continue;
                        }
                        this.logField1stTab.append("\t" + this.transitions.get((Integer)trans2).getName() + ";\n");
                    }
                    this.logField1stTab.append("]\n");
                    this.logField1stTab.append("(T_off: [\n");
                    if ((Integer)((ArrayList)MCSsets.get(mapElement.getKey())).get(0) > 0) {
                        for (int i = 0; i < (Integer)((ArrayList)MCSsets.get(mapElement.getKey())).get(0); ++i) {
                            if (ImportantTrans.contains(((ArrayList)MCSsetsindexes.get(mapElement.getKey())).get(i))) {
                                this.logField1stTab.append("\t(DENIED)_");
                            } else {
                                this.logField1stTab.append("\t");
                            }
                            this.logField1stTab.append(this.transitions.get((Integer)((ArrayList)MCSsetsindexes.get(mapElement.getKey())).get(i)).getName() + ";");
                            this.logField1stTab.append("\n");
                            if (i != (Integer)((ArrayList)MCSsets.get(mapElement.getKey())).get(0) - 1) continue;
                            this.logField1stTab.append("], P_off: [\n");
                        }
                    } else {
                        this.logField1stTab.append("], P_off: [\n");
                    }
                    if ((Integer)((ArrayList)MCSsets.get(mapElement.getKey())).get(1) > 0) {
                        for (int i = ((Integer)((ArrayList)MCSsets.get(mapElement.getKey())).get(0)).intValue(); i < (Integer)((ArrayList)MCSsets.get(mapElement.getKey())).get(0) + (Integer)((ArrayList)MCSsets.get(mapElement.getKey())).get(1); ++i) {
                            this.logField1stTab.append("\t" + this.places.get((Integer)((ArrayList)MCSsetsindexes.get(mapElement.getKey())).get(i)).getName() + ";\n");
                            if (i != (Integer)((ArrayList)MCSsets.get(mapElement.getKey())).get(0) + (Integer)((ArrayList)MCSsets.get(mapElement.getKey())).get(1) - 1) continue;
                            this.logField1stTab.append("])");
                        }
                    } else {
                        this.logField1stTab.append("])");
                    }
                    this.logField1stTab.append("\n\n");
                }
            } else if (this.description.isSelected() && this.ID.isSelected()) {
                for (Map.Entry mapElement : lhm.entrySet()) {
                    String MCSname = ((String)mapElement.getKey()).split(" \\[")[0];
                    this.logField1stTab.append(MCSname + "[ \n");
                    for (Object trans2 : (ArrayList)MCStrans.get(mapElement.getKey())) {
                        if (ImportantTrans.contains(trans2)) {
                            this.logField1stTab.append("\t(DENIED)_t" + this.toSubscript(((Integer)trans2).toString()) + "_" + this.transitions.get((Integer)trans2).getName() + ";\n");
                            continue;
                        }
                        this.logField1stTab.append("\tt" + this.toSubscript(((Integer)trans2).toString()) + "_" + this.transitions.get((Integer)trans2).getName() + ";\n");
                    }
                    this.logField1stTab.append("]\n");
                    this.logField1stTab.append("(T_off: [\n");
                    if ((Integer)((ArrayList)MCSsets.get(mapElement.getKey())).get(0) > 0) {
                        for (int i = 0; i < (Integer)((ArrayList)MCSsets.get(mapElement.getKey())).get(0); ++i) {
                            if (ImportantTrans.contains(((ArrayList)MCSsetsindexes.get(mapElement.getKey())).get(i))) {
                                this.logField1stTab.append("\t(DENIED)_");
                            } else {
                                this.logField1stTab.append("\t");
                            }
                            this.logField1stTab.append("t" + this.toSubscript(((Integer)((ArrayList)MCSsetsindexes.get(mapElement.getKey())).get(i)).toString()) + "_" + this.transitions.get((Integer)((ArrayList)MCSsetsindexes.get(mapElement.getKey())).get(i)).getName() + ";");
                            this.logField1stTab.append("\n");
                            if (i != (Integer)((ArrayList)MCSsets.get(mapElement.getKey())).get(0) - 1) continue;
                            this.logField1stTab.append("], P_off: [\n");
                        }
                    } else {
                        this.logField1stTab.append("], P_off: [\n");
                    }
                    if ((Integer)((ArrayList)MCSsets.get(mapElement.getKey())).get(1) > 0) {
                        for (int i = ((Integer)((ArrayList)MCSsets.get(mapElement.getKey())).get(0)).intValue(); i < (Integer)((ArrayList)MCSsets.get(mapElement.getKey())).get(0) + (Integer)((ArrayList)MCSsets.get(mapElement.getKey())).get(1); ++i) {
                            this.logField1stTab.append("\tp" + this.toSubscript(((Integer)((ArrayList)MCSsetsindexes.get(mapElement.getKey())).get(i)).toString()) + "_" + this.places.get((Integer)((ArrayList)MCSsetsindexes.get(mapElement.getKey())).get(i)).getName() + ";\n");
                            if (i != (Integer)((ArrayList)MCSsets.get(mapElement.getKey())).get(0) + (Integer)((ArrayList)MCSsets.get(mapElement.getKey())).get(1) - 1) continue;
                            this.logField1stTab.append("])");
                        }
                    } else {
                        this.logField1stTab.append("])");
                    }
                    this.logField1stTab.append("\n\n");
                }
            }
            MCSsets.clear();
            MCSsetscp.clear();
            MCSsetsindexes.clear();
            lhm.clear();
        }
    }

    /*
     * Could not resolve type clashes
     */
    private void orgInvTransRankingAlg() {
        this.mcsd = overlord.getWorkspace().getProject().getMCSdataCore();
        this.transitions = overlord.getWorkspace().getProject().getTransitions();
        this.invariantsMatrix = overlord.getWorkspace().getProject().getT_InvMatrix();
        int selectedTrans = this.transBox.getSelectedIndex();
        for (int transitionIndex = 0; transitionIndex < this.mcsd.getSize(); ++transitionIndex) {
            ArrayList<ArrayList<Integer>> dataVector;
            if (selectedTrans > 0 && selectedTrans - 1 != transitionIndex || (dataVector = this.mcsd.getMCSlist(transitionIndex)) == null || dataVector.isEmpty()) continue;
            if (this.invariantsMatrix == null || this.invariantsMatrix.isEmpty()) {
                this.logField1stTab.append(" *** t-invariants set empty! ***\n");
            }
            this.logField1stTab.append(" *** MCS sets for transition ID: " + transitionIndex + " ***\n");
            HashMap<Integer, ArrayList<Integer>> B = new HashMap<Integer, ArrayList<Integer>>();
            HashMap<Integer, ArrayList<Integer>> A = new HashMap<Integer, ArrayList<Integer>>();
            HashSet<Integer> Tb = new HashSet<Integer>();
            HashSet<Integer> Tx = new HashSet<Integer>();
            HashMap<String, Integer> MCSrank = new HashMap<String, Integer>();
            HashMap MCSsets = new HashMap();
            int MCScounter = 0;
            for (ArrayList<Integer> MCSset : dataVector) {
                StringBuilder rankmsg = new StringBuilder("MCS#");
                rankmsg.append(MCScounter).append(" ").append("[");
                for (int el : MCSset) {
                    rankmsg.append("t").append(el).append(", ");
                }
                rankmsg.append("]");
                rankmsg = new StringBuilder(rankmsg.toString().replace(", ]", "]"));
                int counter = 0;
                for (Object tInv : this.invariantsMatrix) {
                    ArrayList<Integer> tInvSupp = InvariantsTools.getSupport((ArrayList<Integer>)tInv);
                    boolean flag = true;
                    for (Integer MCStrans : MCSset) {
                        if (!tInvSupp.contains(MCStrans)) continue;
                        flag = false;
                        A.put(counter, tInvSupp);
                        Tx.addAll(tInvSupp);
                        break;
                    }
                    if (flag) {
                        B.put(counter, tInvSupp);
                        Tb.addAll(tInvSupp);
                    }
                    ++counter;
                }
                rankmsg.append(" dis-inv: ").append(A.size());
                MCSrank.put(rankmsg.toString(), Tx.size());
                MCSsets.put(rankmsg.toString(), new HashSet(Tx));
                A.clear();
                B.clear();
                Tx.clear();
                Tb.clear();
                ++MCScounter;
            }
            LinkedHashMap<String, Integer> lhm = new LinkedHashMap<String, Integer>();
            int lim = MCSrank.size();
            for (int i = 0; i < lim; ++i) {
                Object tInv;
                Integer min = this.transitions.size() + 1;
                String rem = "";
                tInv = MCSrank.entrySet().iterator();
                while (tInv.hasNext()) {
                    Map.Entry entry = tInv.next();
                    if ((Integer)entry.getValue() >= min) continue;
                    rem = (String)entry.getKey();
                    min = (Integer)entry.getValue();
                }
                lhm.put(rem, min);
                MCSrank.remove(rem);
            }
            ArrayList<Integer> ImportantTrans = new ArrayList<Integer>();
            if (this.importantTrans.getText().length() > 0) {
                if (this.importantTrans.getText().contains(",")) {
                    String[] parseImportantTrans;
                    for (String elem : parseImportantTrans = this.importantTrans.getText().split(",")) {
                        ImportantTrans.add(Integer.parseInt(elem));
                    }
                } else {
                    ImportantTrans.add(Integer.parseInt(this.importantTrans.getText()));
                }
            }
            int liczba_wynikow = 20;
            for (Map.Entry mapElement : lhm.entrySet()) {
                String[] mcs = ((String)mapElement.getKey()).split("\\[");
                int inv = -1;
                try {
                    int num;
                    int tmp1 = mcs[1].indexOf(":");
                    String check = mcs[1].substring(tmp1 + 1);
                    check = check.replace(" ", "");
                    inv = num = Integer.parseInt(check);
                    tmp1 = mcs[1].indexOf("]");
                    mcs[1] = mcs[1].substring(0, tmp1 + 1);
                }
                catch (Exception tmp1) {
                    // empty catch block
                }
                float percentage = (float)((Integer)mapElement.getValue() * 100) / (float)this.transitions.size();
                String pSign = "%";
                for (Integer trans : ImportantTrans) {
                    if (!((Set)MCSsets.get(mapElement.getKey())).contains(trans)) continue;
                    this.logField1stTab.append("(DENIED)_");
                    break;
                }
                this.logField1stTab.append(String.format("%-8s %-30s %s%d (%.2f%s) %s%d)", mcs[0], "[" + mcs[1], "(Dis. trans.: ", mapElement.getValue(), Float.valueOf(percentage), pSign, " | Dis. inv.: ", inv));
                this.logField1stTab.append("\n");
                --liczba_wynikow;
            }
            lhm.clear();
            MCSrank.clear();
            MCSsets.clear();
        }
    }

    /*
     * Could not resolve type clashes
     */
    void trzy() {
        this.places = overlord.getWorkspace().getProject().getPlaces();
        this.transitions = overlord.getWorkspace().getProject().getTransitions();
        this.mcsd = overlord.getWorkspace().getProject().getMCSdataCore();
        for (int transitionIndex = 0; transitionIndex < this.mcsd.getSize(); ++transitionIndex) {
            ArrayList<ArrayList<Integer>> dataVector = this.mcsd.getMCSlist(transitionIndex);
            if (dataVector == null || dataVector.isEmpty()) continue;
            this.logField1stTab.append(" *** Best MCS for the transition ID: " + transitionIndex + " ***\n");
            HashMap<String, Integer> MCSsets = new HashMap<String, Integer>();
            HashMap indexes = new HashMap();
            int counter = 0;
            for (ArrayList<Integer> MCS : dataVector) {
                Object MCStransition2;
                Object rankmsg = new StringBuilder("MCS#");
                ((StringBuilder)rankmsg).append(counter).append(" ").append("[");
                StringBuilder msg = new StringBuilder("[");
                for (int el : MCS) {
                    msg.append("t").append(el).append(", ");
                    ((StringBuilder)rankmsg).append("t").append(el).append(", ");
                }
                msg.append("] : ");
                ((StringBuilder)rankmsg).append("] ");
                msg = new StringBuilder(msg.toString().replace(", ]", "]"));
                rankmsg = new StringBuilder(((StringBuilder)rankmsg).toString().replace(", ]", "]"));
                HashSet<Place> Px = new HashSet<Place>();
                for (Object MCStransition2 : MCS) {
                    Transition transition = this.transitions.get((Integer)MCStransition2);
                    Px.addAll(transition.getOutputPlaces());
                }
                HashSet<Object> Poff = new HashSet<Object>();
                MCStransition2 = Px.iterator();
                while (MCStransition2.hasNext()) {
                    Place place = (Place)MCStransition2.next();
                    boolean flag = true;
                    for (Transition transition : place.getInputTransitions()) {
                        if (MCS.contains(transition.getID() - this.places.size())) continue;
                        flag = false;
                        break;
                    }
                    if (!flag) continue;
                    Poff.add(place);
                }
                HashSet<Transition> Toff = new HashSet<Transition>();
                for (Place place : Poff) {
                    Toff.addAll(place.getOutputTransitions());
                }
                ArrayList<Integer> ids = new ArrayList<Integer>();
                for (Transition trans : Toff) {
                    ids.add(trans.getID() - this.places.size());
                }
                if (!MCS.contains(transitionIndex)) {
                    indexes.put(((StringBuilder)rankmsg).toString(), new ArrayList(ids));
                    MCSsets.put(((StringBuilder)rankmsg).toString(), Poff.size() + Toff.size());
                } else if (dataVector.size() == 1) {
                    indexes.put(((StringBuilder)rankmsg).toString(), new ArrayList(ids));
                    MCSsets.put(((StringBuilder)rankmsg).toString(), Poff.size() + Toff.size());
                }
                ++counter;
                ids.clear();
                Px.clear();
                Poff.clear();
                Toff.clear();
            }
            ArrayList<Integer> ImportantTrans = new ArrayList<Integer>();
            if (this.importantTrans.getText().length() > 0) {
                if (this.importantTrans.getText().contains(",")) {
                    String[] parseImportantTrans = this.importantTrans.getText().split(",");
                    for (String elem : parseImportantTrans) {
                        ImportantTrans.add(Integer.parseInt(elem));
                    }
                } else {
                    ImportantTrans.add(Integer.parseInt(this.importantTrans.getText()));
                }
            }
            int lim = MCSsets.size();
            int min = this.transitions.size();
            int min_allowed = this.transitions.size();
            String rem_allowed = null;
            String rem = null;
            int num_of_mcs_trans = 4;
            int num_of_mcs_trans_allowed = 4;
            for (Map.Entry entry : MCSsets.entrySet()) {
                int mcsSetSize = Arrays.asList(((String)entry.getKey()).split("#")[1].split(",")).size();
                if ((Integer)entry.getValue() < min) {
                    rem = (String)entry.getKey();
                    min = (Integer)entry.getValue();
                    num_of_mcs_trans = mcsSetSize;
                } else if (((Integer)entry.getValue()).equals(min) && num_of_mcs_trans > mcsSetSize) {
                    rem = (String)entry.getKey();
                    min = (Integer)entry.getValue();
                    num_of_mcs_trans = mcsSetSize;
                }
                boolean contains_denied = false;
                for (Integer trans : (ArrayList)indexes.get(entry.getKey())) {
                    if (!ImportantTrans.contains(trans)) continue;
                    contains_denied = true;
                    break;
                }
                if (!contains_denied && (Integer)entry.getValue() < min_allowed) {
                    rem_allowed = (String)entry.getKey();
                    min_allowed = (Integer)entry.getValue();
                    num_of_mcs_trans_allowed = mcsSetSize;
                    continue;
                }
                if (contains_denied || (Integer)entry.getValue() >= min_allowed || num_of_mcs_trans_allowed <= mcsSetSize) continue;
                rem_allowed = (String)entry.getKey();
                min_allowed = (Integer)entry.getValue();
                num_of_mcs_trans = mcsSetSize;
            }
            double percentage = (double)min / (double)(this.transitions.size() + this.places.size()) * 100.0;
            String result = String.format("%.2f", percentage);
            double percentage_allowed = (double)min_allowed / (double)(this.transitions.size() + this.places.size()) * 100.0;
            String result_allowed = String.format("%.2f", percentage_allowed);
            boolean flag = true;
            for (Integer trans : (ArrayList)indexes.get(rem)) {
                if (!ImportantTrans.contains(trans)) continue;
                if (Objects.equals(rem_allowed, null)) {
                    this.logField1stTab.append("Wa\u017cne tranzycje uniemo\u017cliwiaj\u0105 pokazanie najlepszego MCS\n");
                    continue;
                }
                this.logField1stTab.append("(DENIED)_" + rem + ": " + min + "/" + (this.transitions.size() + this.places.size()) + ", " + result + "% || " + rem_allowed + ": " + min_allowed + "/" + (this.transitions.size() + this.places.size()) + ", " + result_allowed + "%\n");
                flag = false;
                break;
            }
            if (flag && !Objects.equals(rem_allowed, null)) {
                this.logField1stTab.append(rem + ": " + min + "/" + (this.transitions.size() + this.places.size()) + ", " + result + "%\n");
            }
            this.logField1stTab.append("\n");
            MCSsets.clear();
            indexes.clear();
        }
    }

    private class tokensRankDatabox {
        public HashSet<Place> outputPlacesOfMCS = null;
        public HashSet<Transition> disabledTransitionsSet = null;
        public int starvedTransitions = 0;

        private tokensRankDatabox() {
        }
    }
}

