/*
 * Decompiled with CFR 0.152.
 */
package holmes.windows;

import holmes.analyse.MCSCalculator;
import holmes.darkgui.GUIManager;
import holmes.darkgui.LanguageManager;
import holmes.files.io.MCSoperations;
import holmes.petrinet.data.MCSDataMatrix;
import holmes.petrinet.elements.Transition;
import holmes.utilities.Tools;
import holmes.windows.HolmesMCSanalysis;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.SpinnerNumberModel;
import javax.swing.text.DefaultCaret;

public class HolmesMCS
extends JFrame {
    private static final long serialVersionUID = -5765964470006303431L;
    private static final GUIManager overlord = GUIManager.getDefaultGUIManager();
    private static final LanguageManager lang = GUIManager.getLanguageManager();
    private MCSCalculator mcsGenerator = null;
    private ArrayList<Transition> transitions;
    private int maxCutSize = 3;
    private int maximumMCS = 10;
    private int maxSetsNumber = 300;
    private boolean generateAll = true;
    private boolean isMCSGeneratorWorking = false;
    private boolean showFullInfo = true;
    private boolean listenerAllowed = true;
    private JComboBox<String> transitionsCombo;
    private JComboBox<String> transitionsResultsCombo;
    private JSpinner mcsSpinner;
    private JTextArea logField;
    private JTextArea reactionSetsTextField;
    private HolmesMCSanalysis newWindow;

    public HolmesMCS() {
        try {
            this.setIconImage(Tools.getImageFromIcon("/icons/holmesicon.png"));
            this.transitions = overlord.getWorkspace().getProject().getTransitions();
        }
        catch (Exception ex) {
            overlord.log(lang.getText("LOGentry00468exception") + "\n" + ex.getMessage(), "error", true);
        }
        this.setVisible(false);
        this.setTitle(lang.getText("HMCSwin_entry001title"));
        this.setLayout(new BorderLayout());
        this.setSize(new Dimension(860, 754));
        this.setLocation(50, 50);
        this.setDefaultCloseOperation(1);
        this.setResizable(false);
        JPanel mainPanel = this.createMainPanel();
        this.add((Component)mainPanel, "Center");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent e) {
                HolmesMCS.this.fillComboBoxData();
            }
        });
        this.newWindow = new HolmesMCSanalysis();
    }

    private JPanel createMainPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(null);
        JPanel buttonPanel = this.createUpperButtonPanel(0, 0, 844, 110);
        JPanel logMainPanel = this.createMainPanel(0, 110, 844, 610);
        panel.add(buttonPanel);
        panel.add(logMainPanel);
        panel.repaint();
        return panel;
    }

    private JPanel createUpperButtonPanel(int x, int y, int width, int height) {
        JPanel panel = new JPanel();
        panel.setLayout(null);
        panel.setBorder(BorderFactory.createLineBorder(Color.black));
        panel.setBounds(x, y, width, height);
        int posX = 10;
        int posY = 10;
        JLabel mcsLabel1 = new JLabel(lang.getText("HMCSwin_entry002"));
        mcsLabel1.setBounds(posX, posY, 80, 20);
        panel.add(mcsLabel1);
        String[] dataT = new String[]{"---"};
        this.transitionsCombo = new JComboBox<String>(dataT);
        this.transitionsCombo.setBounds(posX + 90, posY, 370, 20);
        this.transitionsCombo.setSelectedIndex(0);
        this.transitionsCombo.setMaximumRowCount(6);
        this.transitionsCombo.removeAllItems();
        this.transitionsCombo.addItem("---");
        if (this.transitions != null && !this.transitions.isEmpty()) {
            for (int t = 0; t < this.transitions.size(); ++t) {
                this.transitionsCombo.addItem("t" + t + "." + this.transitions.get(t).getName());
            }
        }
        panel.add(this.transitionsCombo);
        JLabel mcsLabel2 = new JLabel(lang.getText("HMCSwin_entry003"));
        mcsLabel2.setBounds(posX, posY + 25, 80, 20);
        panel.add(mcsLabel2);
        SpinnerNumberModel mcsSpinnerModel = new SpinnerNumberModel(this.maxCutSize, 1, this.maximumMCS, 1);
        this.mcsSpinner = new JSpinner(mcsSpinnerModel);
        this.mcsSpinner.setBounds(posX + 90, posY + 25, 60, 20);
        this.mcsSpinner.addChangeListener(e -> {
            JSpinner spinner = (JSpinner)e.getSource();
            this.maxCutSize = (Integer)spinner.getValue();
        });
        panel.add(this.mcsSpinner);
        JLabel mcsLabel3 = new JLabel(lang.getText("HMCSwin_entry004"));
        mcsLabel3.setBounds(posX + 160, posY + 25, 120, 20);
        panel.add(mcsLabel3);
        SpinnerNumberModel maxSizeSpinnerModel = new SpinnerNumberModel(300, 50, 5000, 100);
        JSpinner maxSizeStepsSpinner = new JSpinner(maxSizeSpinnerModel);
        maxSizeStepsSpinner.setBounds(posX + 270, posY + 25, 60, 20);
        maxSizeStepsSpinner.addChangeListener(e -> {
            JSpinner spinner = (JSpinner)e.getSource();
            this.maxSetsNumber = (Integer)spinner.getValue();
        });
        panel.add(maxSizeStepsSpinner);
        JCheckBox cleanMCSusingStructureCheckBox = new JCheckBox(lang.getText("HMCSwin_entry005"), true);
        cleanMCSusingStructureCheckBox.setBounds(posX + 340, posY + 25, 140, 20);
        cleanMCSusingStructureCheckBox.addActionListener(actionEvent -> {
            AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
            if (abstractButton.getModel().isSelected()) {
                overlord.getSettingsManager().setValue("analysisMCSReduction", "1", true);
            } else {
                overlord.getSettingsManager().setValue("analysisMCSReduction", "0", true);
            }
        });
        cleanMCSusingStructureCheckBox.setSelected(overlord.getSettingsManager().getValue("analysisMCSReduction").equals("1"));
        panel.add(cleanMCSusingStructureCheckBox);
        JButton generateButton = new JButton();
        generateButton.setText(lang.getText("HMCSwin_entry006"));
        generateButton.setBounds(posX, posY + 50, 110, 40);
        generateButton.setMargin(new Insets(0, 0, 0, 0));
        generateButton.setIcon(Tools.getResIcon32("/icons/mcsWindow/computeData.png"));
        generateButton.addActionListener(actionEvent -> {
            this.launchMCSanalysis();
            overlord.showMCS();
        });
        generateButton.setFocusPainted(false);
        panel.add(generateButton);
        JButton cancelButton = new JButton();
        cancelButton.setText(lang.getText("HMCSwin_entry007"));
        cancelButton.setBounds(posX + 110, posY + 50, 50, 40);
        cancelButton.setMargin(new Insets(0, 0, 0, 0));
        cancelButton.addActionListener(actionEvent -> {
            if (this.mcsGenerator != null) {
                this.mcsGenerator.emergencyStop();
            }
        });
        cancelButton.setFocusPainted(false);
        panel.add(cancelButton);
        JButton loadButton = new JButton();
        loadButton.setText(lang.getText("HMCSwin_entry008"));
        loadButton.setBounds(posX + 170, posY + 50, 120, 40);
        loadButton.setMargin(new Insets(0, 0, 0, 0));
        loadButton.setIcon(Tools.getResIcon22("/icons/mcsWindow/loadMCS.png"));
        loadButton.addActionListener(actionEvent -> {
            MCSoperations.loadSingleMCS();
            overlord.showMCS();
        });
        loadButton.setFocusPainted(false);
        panel.add(loadButton);
        JButton loadAllButton = new JButton();
        loadAllButton.setText(lang.getText("HMCSwin_entry009"));
        loadAllButton.setBounds(posX + 295, posY + 50, 120, 40);
        loadAllButton.setMargin(new Insets(0, 0, 0, 0));
        loadAllButton.setIcon(Tools.getResIcon22("/icons/mcsWindow/loadAllMCS.png"));
        loadAllButton.addActionListener(actionEvent -> {
            MCSoperations.loadAllMCS();
            overlord.showMCS();
        });
        loadAllButton.setFocusPainted(false);
        panel.add(loadAllButton);
        JButton saveAllButton = new JButton();
        saveAllButton.setText(lang.getText("HMCSwin_entry010"));
        saveAllButton.setBounds(posX + 420, posY + 50, 120, 40);
        saveAllButton.setMargin(new Insets(0, 0, 0, 0));
        saveAllButton.setIcon(Tools.getResIcon22("/icons/mcsWindow/saveAllMCS.png"));
        saveAllButton.addActionListener(actionEvent -> MCSoperations.saveAllMCS(overlord.getWorkspace().getProject().getMCSdataCore()));
        saveAllButton.setFocusPainted(false);
        panel.add(saveAllButton);
        JButton addToButton = new JButton();
        addToButton.setText(lang.getText("add"));
        addToButton.setBounds(posX + 470, posY, 80, 20);
        addToButton.setMargin(new Insets(0, 0, 0, 0));
        addToButton.setIcon(Tools.getResIcon16("/icons/mcsWindow/add.png"));
        addToButton.addActionListener(actionEvent -> {
            int selected = this.transitionsCombo.getSelectedIndex();
            if (selected == 0) {
                return;
            }
            String msg = "t" + --selected + ",";
            if (!this.reactionSetsTextField.getText().contains(msg)) {
                this.reactionSetsTextField.append(msg);
            }
        });
        addToButton.setFocusPainted(false);
        panel.add(addToButton);
        JButton removeButton = new JButton();
        removeButton.setText(lang.getText("HMCSwin_entry011"));
        removeButton.setBounds(posX + 555, posY, 80, 20);
        removeButton.setMargin(new Insets(0, 0, 0, 0));
        removeButton.setIcon(Tools.getResIcon16("/icons/mcsWindow/remove.png"));
        removeButton.addActionListener(actionEvent -> {
            int selected = this.transitionsCombo.getSelectedIndex();
            if (selected == 0) {
                return;
            }
            String msg = "t" + --selected + ",";
            String text = this.reactionSetsTextField.getText();
            text = text.replace(msg, "");
            this.reactionSetsTextField.setText(text);
        });
        removeButton.setFocusPainted(false);
        panel.add(removeButton);
        JButton clearButton = new JButton();
        clearButton.setText(lang.getText("clear"));
        clearButton.setBounds(posX + 640, posY, 80, 20);
        clearButton.setMargin(new Insets(0, 0, 0, 0));
        clearButton.setIcon(Tools.getResIcon16("/icons/mcsWindow/clear.png"));
        clearButton.addActionListener(actionEvent -> this.reactionSetsTextField.setText(""));
        clearButton.setFocusPainted(false);
        panel.add(clearButton);
        this.reactionSetsTextField = new JTextArea();
        this.reactionSetsTextField.setLineWrap(true);
        this.reactionSetsTextField.setEditable(false);
        JPanel logFieldPanel = new JPanel();
        logFieldPanel.setLayout(new BorderLayout());
        logFieldPanel.add((Component)new JScrollPane(this.reactionSetsTextField), "Center");
        logFieldPanel.setBounds(posX + 485, posY + 22, 235, 26);
        panel.add(logFieldPanel);
        JCheckBox allCheckBox = new JCheckBox(lang.getText("HMCSwin_entry012"), true);
        allCheckBox.setBounds(posX + 690, posY + 55, 140, 20);
        allCheckBox.addActionListener(actionEvent -> {
            AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
            this.generateAll = abstractButton.getModel().isSelected();
        });
        panel.add(allCheckBox);
        JButton calcAllButton = new JButton();
        calcAllButton.setText(lang.getText("HMCSwin_entry013"));
        calcAllButton.setBounds(posX + 725, posY, 100, 50);
        calcAllButton.setMargin(new Insets(0, 0, 0, 0));
        calcAllButton.setIcon(Tools.getResIcon22("/icons/mcsWindow/computeSet.png"));
        calcAllButton.addActionListener(actionEvent -> this.calculateAllAction());
        calcAllButton.setFocusPainted(false);
        panel.add(calcAllButton);
        return panel;
    }

    private JPanel createMainPanel(int x, int y, int width, int height) {
        JPanel panel = new JPanel();
        panel.setLayout(null);
        panel.setBorder(BorderFactory.createLineBorder(Color.black));
        panel.setBounds(x, y, width, height - 5);
        JPanel upperButtons = this.createSubButtonPanel(2, 2, 840, 90);
        panel.add(upperButtons);
        this.logField = new JTextArea();
        this.logField.setLineWrap(true);
        this.logField.setEditable(false);
        DefaultCaret caret = (DefaultCaret)this.logField.getCaret();
        caret.setUpdatePolicy(2);
        JPanel logFieldPanel = new JPanel();
        logFieldPanel.setBorder(BorderFactory.createTitledBorder(lang.getText("HMCSwin_entry014")));
        logFieldPanel.setLayout(new BorderLayout());
        logFieldPanel.add((Component)new JScrollPane(this.logField), "Center");
        logFieldPanel.setBounds(2, 90, 840, height - 98);
        panel.add(logFieldPanel);
        return panel;
    }

    private JPanel createSubButtonPanel(int x, int y, int width, int height) {
        JPanel panel = new JPanel();
        panel.setLayout(null);
        panel.setBorder(BorderFactory.createTitledBorder(lang.getText("HMCSwin_entry015")));
        panel.setBounds(x, y, width, height);
        int posX = 10;
        int posY = 20;
        JLabel mcsLabel1 = new JLabel(lang.getText("HMCSwin_entry016"));
        mcsLabel1.setBounds(posX, posY, 80, 20);
        panel.add(mcsLabel1);
        String[] dataT = new String[]{"---"};
        this.transitionsResultsCombo = new JComboBox<String>(dataT);
        this.transitionsResultsCombo.setBounds(posX + 90, posY, 370, 20);
        this.transitionsResultsCombo.setSelectedIndex(0);
        this.transitionsResultsCombo.setMaximumRowCount(6);
        this.transitionsResultsCombo.removeAllItems();
        this.transitionsResultsCombo.addItem("---");
        if (this.transitions != null && !this.transitions.isEmpty()) {
            for (int t = 0; t < this.transitions.size(); ++t) {
                this.transitionsResultsCombo.addItem("t" + t + "." + this.transitions.get(t).getName());
            }
        }
        this.transitionsResultsCombo.addActionListener(actionEvent -> {});
        panel.add(this.transitionsResultsCombo);
        JCheckBox showAllCheckBox = new JCheckBox(lang.getText("HMCSwin_entry017"), true);
        showAllCheckBox.setBounds(posX + 460, posY, 145, 20);
        showAllCheckBox.addActionListener(actionEvent -> {
            AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
            this.showFullInfo = abstractButton.getModel().isSelected();
        });
        panel.add(showAllCheckBox);
        JButton saveButton = new JButton();
        saveButton.setText(lang.getText("HMCSwin_entry018"));
        saveButton.setBounds(posX, posY + 25, 110, 40);
        saveButton.setMargin(new Insets(0, 0, 0, 0));
        saveButton.setIcon(Tools.getResIcon22("/icons/mcsWindow/saveMCS.png"));
        saveButton.addActionListener(actionEvent -> {
            int selected = this.transitionsResultsCombo.getSelectedIndex();
            if (selected == 0) {
                return;
            }
            String name = (String)this.transitionsResultsCombo.getSelectedItem();
            MCSoperations.saveSingleMCS(overlord.getWorkspace().getProject().getMCSdataCore(), --selected, name);
        });
        saveButton.setFocusPainted(false);
        panel.add(saveButton);
        JButton showMCSButton = new JButton();
        showMCSButton.setText(lang.getText("HMCSwin_entry019"));
        showMCSButton.setBounds(posX + 120, posY + 25, 110, 40);
        showMCSButton.setMargin(new Insets(0, 0, 0, 0));
        showMCSButton.setIcon(Tools.getResIcon22("/icons/mcsWindow/showData.png"));
        showMCSButton.addActionListener(actionEvent -> {
            int selected = this.transitionsResultsCombo.getSelectedIndex();
            if (selected > 0) {
                this.showMCSData(selected - 1);
            }
        });
        showMCSButton.setFocusPainted(false);
        panel.add(showMCSButton);
        JButton calculateFragilityButton = new JButton();
        calculateFragilityButton.setText(lang.getText("HMCSwin_entry020"));
        calculateFragilityButton.setBounds(posX + 240, posY + 25, 110, 40);
        calculateFragilityButton.setMargin(new Insets(0, 0, 0, 0));
        calculateFragilityButton.setIcon(Tools.getResIcon22("/icons/mcsWindow/fragility.png"));
        calculateFragilityButton.addActionListener(actionEvent -> {
            int selected = this.transitionsResultsCombo.getSelectedIndex();
            if (selected > 0) {
                this.calculateFragility(selected - 1);
            }
        });
        calculateFragilityButton.setFocusPainted(false);
        panel.add(calculateFragilityButton);
        JButton cleanButton = new JButton("", Tools.getResIcon48("/icons/mcsWindow/cleanLogArea.png"));
        cleanButton.setText(lang.getText("clean"));
        cleanButton.setBounds(posX + 360, posY + 25, 110, 40);
        cleanButton.setMargin(new Insets(0, 0, 0, 0));
        cleanButton.addActionListener(actionEvent -> this.logField.setText(""));
        cleanButton.setFocusPainted(false);
        panel.add(cleanButton);
        JButton doSmthButtonMk1 = new JButton();
        doSmthButtonMk1.setText(lang.getText("HMCSwin_entry021"));
        doSmthButtonMk1.setBounds(posX + 650, posY, 130, 60);
        doSmthButtonMk1.setMargin(new Insets(0, 0, 0, 0));
        doSmthButtonMk1.setIcon(Tools.getResIcon22("/icons/mcsWindow/computeData.png"));
        doSmthButtonMk1.addActionListener(actionEvent -> this.newWindow.setVisible(true));
        doSmthButtonMk1.setFocusPainted(false);
        panel.add(doSmthButtonMk1);
        return panel;
    }

    protected void launchMCSanalysis() {
        if (this.isMCSGeneratorWorking) {
            JOptionPane.showMessageDialog(null, lang.getText("HMCSwin_entry022"), lang.getText("HMCSwin_entry022t"), 2);
        } else {
            ArrayList<Transition> transitions = overlord.getWorkspace().getProject().getTransitions();
            if (transitions == null || transitions.size() < 2) {
                JOptionPane.showMessageDialog(null, lang.getText("HMCSwin_entry023"), lang.getText("warning"), 1);
                return;
            }
            ArrayList<ArrayList<Integer>> invariants = overlord.getWorkspace().getProject().getT_InvMatrix();
            if (invariants == null || invariants.isEmpty()) {
                JOptionPane.showMessageDialog(null, lang.getText("HMCSwin_entry024"), lang.getText("warning"), 1);
                return;
            }
            int selectionObjR = this.transitionsCombo.getSelectedIndex();
            if (selectionObjR == 0) {
                JOptionPane.showMessageDialog(null, lang.getText("HMCSwin_entry025"), lang.getText("information"), 1);
                return;
            }
            --selectionObjR;
            int minCutSize = (Integer)this.mcsSpinner.getValue();
            if (minCutSize == 0) {
                JOptionPane.showMessageDialog(null, lang.getText("HMCSwin_entry026"), lang.getText("warning"), 1);
                return;
            }
            int MCSdatacoreSize = overlord.getWorkspace().getProject().getMCSdataCore().getSize();
            if (transitions.size() != MCSdatacoreSize) {
                if (MCSdatacoreSize == 0) {
                    overlord.getWorkspace().getProject().getMCSdataCore().initiateMCS();
                } else {
                    Object[] options = new Object[]{lang.getText("yes"), lang.getText("no")};
                    int decision = JOptionPane.showOptionDialog(null, lang.getText("HMCSwin_entry027"), lang.getText("HMCSwin_entry027t"), 0, 2, null, options, options[1]);
                    if (decision == 1) {
                        return;
                    }
                    overlord.getWorkspace().getProject().getMCSdataCore().initiateMCS();
                }
            }
            this.mcsGenerator = new MCSCalculator(selectionObjR, invariants, transitions, minCutSize, this.maxSetsNumber, this, true);
            Thread myThread = new Thread(this.mcsGenerator);
            this.setGeneratorStatus(true);
            myThread.start();
        }
    }

    protected void calculateAllAction() {
        ArrayList<Integer> objReactions = new ArrayList<Integer>();
        if (this.generateAll) {
            int transSize = overlord.getWorkspace().getProject().getTransitions().size();
            for (int t = 0; t < transSize; ++t) {
                objReactions.add(t);
            }
        } else {
            String[] splittedSets;
            String all = this.reactionSetsTextField.getText();
            if (!all.isEmpty() && (splittedSets = (all = all.trim()).split(",")).length > 0) {
                for (String s : splittedSets) {
                    try {
                        s = s.replace("t", "");
                        int next = Integer.parseInt(s);
                        objReactions.add(next);
                    }
                    catch (Exception ex) {
                        overlord.log(lang.getText("LOGentry00469exception") + "\n" + ex.getMessage(), "error", true);
                    }
                }
            }
        }
        this.launchMCSanalysis(objReactions);
    }

    protected void launchMCSanalysis(ArrayList<Integer> objReactions) {
        if (objReactions.isEmpty()) {
            return;
        }
        if (this.isMCSGeneratorWorking) {
            JOptionPane.showMessageDialog(null, lang.getText("HMCSwin_entry022"), lang.getText("HMCSwin_entry022t"), 2);
        } else {
            ArrayList<Transition> transitions = overlord.getWorkspace().getProject().getTransitions();
            if (transitions == null || transitions.size() < 2) {
                JOptionPane.showMessageDialog(null, lang.getText("HMCSwin_entry023"), lang.getText("warning"), 1);
                return;
            }
            ArrayList<ArrayList<Integer>> invariants = overlord.getWorkspace().getProject().getT_InvMatrix();
            if (invariants == null || invariants.isEmpty()) {
                JOptionPane.showMessageDialog(null, lang.getText("HMCSwin_entry024"), "warning", 1);
                return;
            }
            int minCutSize = (Integer)this.mcsSpinner.getValue();
            if (minCutSize == 0) {
                JOptionPane.showMessageDialog(null, lang.getText("HMCSwin_entry026"), lang.getText("warning"), 1);
                return;
            }
            int MCSdatacoreSize = overlord.getWorkspace().getProject().getMCSdataCore().getSize();
            if (transitions.size() != MCSdatacoreSize) {
                if (MCSdatacoreSize == 0) {
                    overlord.getWorkspace().getProject().getMCSdataCore().initiateMCS();
                } else {
                    Object[] options = new Object[]{lang.getText("yes"), lang.getText("no")};
                    int decision = JOptionPane.showOptionDialog(null, lang.getText("HMCSwin_entry027"), lang.getText("HMCSwin_entry027t"), 0, 2, null, options, options[1]);
                    if (decision == 1) {
                        return;
                    }
                    overlord.getWorkspace().getProject().getMCSdataCore().initiateMCS();
                }
            }
            for (int el : objReactions) {
                while (this.getGeneratorStatus()) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                this.logField.append(lang.getText("HMCSwin_entry028") + "\n" + el + "\n");
                this.mcsGenerator = new MCSCalculator(el, invariants, transitions, minCutSize, this.maxSetsNumber, this, false);
                Thread myThread = new Thread(this.mcsGenerator);
                this.setGeneratorStatus(true);
                myThread.start();
            }
        }
    }

    protected void showMCSData(int selected) {
        MCSDataMatrix mcsd = overlord.getWorkspace().getProject().getMCSdataCore();
        if (mcsd.getSize() == 0) {
            return;
        }
        ArrayList<ArrayList<Integer>> dataVector = mcsd.getMCSlist(selected);
        if (dataVector == null) {
            return;
        }
        Transition objR = this.transitions.get(selected);
        this.logField.append("==========================================================\n");
        this.logField.append(lang.getText("HMCSwin_entry029") + " " + objR.getName() + "\n");
        this.logField.append(lang.getText("HMCSwin_entry030") + " " + dataVector.size() + "\n");
        int counter = 0;
        for (ArrayList<Integer> set : dataVector) {
            this.logField.append("MSC#" + counter + " ");
            StringBuilder msg = new StringBuilder("[");
            for (int el : set) {
                msg.append(el).append(", ");
            }
            msg.append("]   : ");
            msg = new StringBuilder(msg.toString().replace(", ]", "]"));
            if (this.showFullInfo) {
                int transSize = this.transitions.size();
                StringBuilder names = new StringBuilder();
                for (int el : set) {
                    if (el >= transSize) continue;
                    names.append("t").append(el).append("_").append(this.transitions.get(el).getName()).append("; ");
                }
                msg.append((CharSequence)names);
            }
            this.logField.append(String.valueOf(msg) + "\n");
            ++counter;
        }
        this.logField.append("==========================================================\n");
        this.logField.append("\n");
    }

    protected void calculateFragility(int selected) {
        Iterator<Object> iterator;
        MCSDataMatrix mcsd = overlord.getWorkspace().getProject().getMCSdataCore();
        if (mcsd.getSize() == 0) {
            return;
        }
        ArrayList<ArrayList<Integer>> dataVector = mcsd.getMCSlist(selected);
        if (dataVector == null) {
            return;
        }
        ArrayList<Integer> reactions = new ArrayList<Integer>();
        ArrayList<Float> fi = new ArrayList<Float>();
        for (ArrayList<Integer> set : dataVector) {
            iterator = set.iterator();
            while (iterator.hasNext()) {
                int el = (Integer)iterator.next();
                if (reactions.contains(el)) continue;
                reactions.add(el);
            }
        }
        Collections.sort(reactions);
        iterator = reactions.iterator();
        while (iterator.hasNext()) {
            int reaction = (Integer)iterator.next();
            float reactSum = 0.0f;
            float setSizeSum = 0.0f;
            for (ArrayList<Integer> set : dataVector) {
                if (!set.contains(reaction)) continue;
                reactSum += 1.0f;
                setSizeSum += (float)set.size();
            }
            fi.add(Float.valueOf(reactSum / setSizeSum));
        }
        for (int i = 0; i < fi.size(); ++i) {
            Object msg = "";
            msg = (String)msg + "t" + String.valueOf(reactions.get(i)) + "_";
            msg = (String)msg + this.transitions.get((Integer)reactions.get(i)).getName() + "    ";
            msg = (String)msg + "fragility = " + String.valueOf(fi.get(i));
            this.logField.append((String)msg + "\n");
        }
    }

    public void setGeneratorStatus(boolean status) {
        this.isMCSGeneratorWorking = status;
    }

    public boolean getGeneratorStatus() {
        return this.isMCSGeneratorWorking;
    }

    protected void fillComboBoxData() {
        this.transitions = overlord.getWorkspace().getProject().getTransitions();
        int selection = this.transitionsCombo.getSelectedIndex();
        this.transitionsCombo.removeAllItems();
        this.transitionsCombo.addItem("---");
        for (int t = 0; t < this.transitions.size(); ++t) {
            this.transitionsCombo.addItem("t" + t + "." + this.transitions.get(t).getName());
        }
        this.listenerAllowed = false;
        int oldSize = this.transitionsResultsCombo.getItemCount();
        int oldSelected = this.transitionsResultsCombo.getSelectedIndex();
        this.transitionsResultsCombo.removeAllItems();
        this.transitionsResultsCombo.addItem("---");
        for (int t = 0; t < this.transitions.size(); ++t) {
            this.transitionsResultsCombo.addItem("t" + t + "." + this.transitions.get(t).getName());
        }
        if (oldSize == this.transitionsResultsCombo.getItemCount()) {
            this.transitionsResultsCombo.setSelectedIndex(oldSelected);
        }
        this.listenerAllowed = true;
        if (selection < this.transitions.size() + 1) {
            this.transitionsCombo.setSelectedIndex(selection);
        }
        if (this.transitions != null && this.transitions.size() > 1) {
            this.maximumMCS = this.transitions.size();
            if (this.maxCutSize >= this.transitions.size() || this.maxCutSize == 0) {
                this.maxCutSize = 3;
            }
        } else {
            this.maxCutSize = 0;
            this.maximumMCS = 0;
        }
        SpinnerNumberModel mcsSpinnerModel = new SpinnerNumberModel(this.maxCutSize, 0, this.maximumMCS, 1);
        this.mcsSpinner.setModel(mcsSpinnerModel);
    }

    public JTextArea accessLogField() {
        return this.logField;
    }

    public void resetMCSGenerator() {
        this.mcsGenerator = null;
        this.setGeneratorStatus(false);
    }
}

