/*
 * Decompiled with CFR 0.152.
 */
package holmes.windows;

import holmes.darkgui.GUIManager;
import holmes.darkgui.LanguageManager;
import holmes.graphpanel.MauritiusMapPanel;
import holmes.petrinet.data.PetriNet;
import holmes.petrinet.elements.Transition;
import holmes.tables.InvariantsSimpleTableModel;
import holmes.utilities.Tools;
import holmes.windows.HolmesInvariantsViewer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;

public class HolmesKnockoutViewer
extends JFrame {
    private static final long serialVersionUID = -6944527110471274930L;
    private static final GUIManager overlord = GUIManager.getDefaultGUIManager();
    private static final LanguageManager lang = GUIManager.getLanguageManager();
    private PetriNet pn = overlord.getWorkspace().getProject();
    private MauritiusMapPanel.MapElement data;
    private ArrayList<Transition> transitions;
    private JTable table;

    public HolmesKnockoutViewer(MauritiusMapPanel.MapElement data) {
        this.data = data;
        this.transitions = this.pn.getTransitions();
        this.initalizeComponents();
        this.initiateListeners();
        this.setVisible(true);
    }

    private void initalizeComponents() {
        try {
            this.setIconImage(Tools.getImageFromIcon("/icons/holmesicon.png"));
        }
        catch (Exception ex) {
            overlord.log(lang.getText("LOGentry00466exception") + "\n" + ex.getMessage(), "error", true);
        }
        this.setLayout(new BorderLayout());
        this.setSize(new Dimension(640, 400));
        this.setLocation(50, 50);
        this.setResizable(false);
        this.setTitle(lang.getText("HKVwin_entry001title"));
        this.setLayout(new BorderLayout());
        JPanel main = new JPanel(new BorderLayout());
        main.add((Component)this.getUpperPanel(), "North");
        main.add((Component)this.getBottomPanel(), "Center");
        this.add((Component)main, "Center");
    }

    public JPanel getUpperPanel() {
        JPanel result = new JPanel(null);
        result.setBorder(BorderFactory.createTitledBorder(lang.getText("HKVwin_entry003")));
        result.setPreferredSize(new Dimension(640, 130));
        int posXda = 10;
        int posYda = 20;
        JLabel label0 = new JLabel(lang.getText("HKVwin_entry002"));
        label0.setBounds(posXda, posYda, 70, 20);
        result.add(label0);
        int t_index = this.data.node.transLocation;
        ArrayList<Integer> mctSet = this.checkMCT(t_index);
        JLabel labelElement = new JLabel("");
        labelElement.setBounds(posXda + 100, posYda, 400, 20);
        result.add(labelElement);
        if (mctSet.size() > 1) {
            labelElement.setText(lang.getText("HKVwin_entry004") + String.valueOf(mctSet.get(0)));
            JLabel label2 = new JLabel(lang.getText("HKVwin_entry005"));
            label2.setBounds(posXda + 210, posYda, 80, 20);
            result.add(label2);
            JComboBox<CallSite> mctTransCombo = new JComboBox<CallSite>();
            for (int i = 1; i < mctSet.size(); ++i) {
                String transName = "t" + String.valueOf(mctSet.get(i)) + "_" + this.transitions.get(mctSet.get(i)).getName();
                mctTransCombo.addItem((CallSite)((Object)transName));
            }
            mctTransCombo.setBounds(posXda + 270, posYda, 340, 20);
            result.add(mctTransCombo);
        } else {
            labelElement.setText("t" + t_index + "_" + this.transitions.get(t_index).getName());
        }
        JLabel label3 = new JLabel(lang.getText("HKVwin_entry006"));
        label3.setBounds(posXda, posYda += 20, 150, 20);
        result.add(label3);
        JLabel label4 = new JLabel("" + this.data.node.transFrequency);
        label4.setBounds(posXda + 160, posYda, 30, 20);
        result.add(label4);
        JLabel label5 = new JLabel(lang.getText("HKVwin_entry007"));
        label5.setBounds(posXda + 190, posYda, 150, 20);
        result.add(label5);
        JLabel label6 = new JLabel("" + this.data.node.othersFrequency);
        label6.setBounds(posXda + 350, posYda, 150, 20);
        result.add(label6);
        JLabel label7 = new JLabel(lang.getText("HKVwin_entry008"));
        label7.setBounds(posXda, posYda += 20, 150, 20);
        result.add(label7);
        JTextArea descriptionTextArea = new JTextArea();
        descriptionTextArea.setLineWrap(true);
        descriptionTextArea.setEditable(false);
        JPanel descPanel = new JPanel();
        descPanel.setLayout(new BorderLayout());
        descPanel.add((Component)new JScrollPane(descriptionTextArea), "Center");
        descPanel.setBounds(posXda, posYda += 20, 600, 40);
        result.add(descPanel);
        this.computePath(descriptionTextArea);
        return result;
    }

    public JPanel getBottomPanel() {
        JPanel result = new JPanel(new BorderLayout());
        result.setBorder(BorderFactory.createTitledBorder(lang.getText("HKVwin_entry009")));
        result.setPreferredSize(new Dimension(640, 320));
        InvariantsSimpleTableModel tableModel = new InvariantsSimpleTableModel();
        this.table = new JTable(tableModel);
        this.table.setName("Invariant description");
        this.table.getColumnModel().getColumn(0).setHeaderValue("ID");
        this.table.getColumnModel().getColumn(0).setPreferredWidth(60);
        this.table.getColumnModel().getColumn(0).setMinWidth(60);
        this.table.getColumnModel().getColumn(0).setMaxWidth(60);
        this.table.getColumnModel().getColumn(1).setHeaderValue("Invariant description");
        this.table.getColumnModel().getColumn(1).setPreferredWidth(800);
        this.table.getColumnModel().getColumn(1).setMinWidth(100);
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 1 && !e.isControlDown()) {
                    HolmesKnockoutViewer.this.cellClickAction();
                }
            }
        });
        this.table.setAutoResizeMode(4);
        JScrollPane tableScrollPane = new JScrollPane(this.table, 20, 30);
        result.add((Component)tableScrollPane, "Center");
        ArrayList<Integer> invariants = this.data.node.myInvariantsIDs;
        for (Integer invIndex : invariants) {
            tableModel.addNew(invIndex + 1, this.pn.getT_InvDescription(invIndex));
        }
        return result;
    }

    protected void cellClickAction() {
        try {
            int row = this.table.getSelectedRow();
            if (this.table.getName().equals("Invariant description")) {
                String id = this.table.getValueAt(row, 0).toString();
                int invID = Integer.parseInt(id);
                new HolmesInvariantsViewer(invID);
            }
        }
        catch (Exception ex) {
            overlord.log(lang.getText("LOGentry00467exception") + "\n" + ex.getMessage(), "error", true);
        }
    }

    private void computePath(JTextArea descriptionTextArea) {
        ArrayList<Integer> path = this.data.disabledHistory;
        ArrayList<Integer> processed = new ArrayList<Integer>();
        StringBuilder resultPath = new StringBuilder();
        for (Integer trans : path) {
            if (processed.contains(trans)) continue;
            ArrayList<Integer> mct = this.checkMCT(trans);
            if (mct.size() > 1) {
                resultPath.append("MCT#").append(mct.get(0)).append(" ==> ");
                for (int i = 1; i < mct.size(); ++i) {
                    processed.add(mct.get(i));
                }
                continue;
            }
            resultPath.append("t").append(trans).append(" ==> ");
            processed.add(trans);
        }
        if (resultPath.length() > 5) {
            resultPath = new StringBuilder(resultPath.substring(0, resultPath.length() - 4));
        }
        descriptionTextArea.setText(resultPath.toString());
    }

    private ArrayList<Integer> checkMCT(int t_index) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        boolean found = false;
        ArrayList<ArrayList<Transition>> mcts = this.pn.getMCTMatrix();
        int mctNumber = mcts.size() - 1;
        Transition target = this.transitions.get(t_index);
        for (int m = 0; m < mctNumber; ++m) {
            if (!mcts.get(m).contains(target)) continue;
            ArrayList<Transition> mct = mcts.get(m);
            result.add(m + 1);
            for (Transition trans : mct) {
                result.add(this.transitions.indexOf(trans));
            }
            found = true;
            break;
        }
        if (!found) {
            result.add(-1);
        }
        return result;
    }

    private void initiateListeners() {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
            }
        });
    }
}

