/*
 * Decompiled with CFR 0.152.
 */
package holmes.windows;

import holmes.analyse.InvariantsCalculator;
import holmes.analyse.InvariantsTools;
import holmes.analyse.TimeComputations;
import holmes.darkgui.GUIManager;
import holmes.darkgui.LanguageManager;
import holmes.petrinet.data.PetriNet;
import holmes.petrinet.elements.Transition;
import holmes.petrinet.simulators.GraphicalSimulator;
import holmes.petrinet.simulators.SimulatorGlobals;
import holmes.petrinet.simulators.StateSimulator;
import holmes.tables.InvariantsTableRenderer;
import holmes.tables.InvariantsViewerTableModel;
import holmes.utilities.Tools;
import holmes.windows.HolmesNodeInfo;
import holmes.windows.HolmesNotepad;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.invoke.CallSite;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;

public class HolmesInvariantsViewer
extends JFrame {
    private static final long serialVersionUID = 7735367902562553555L;
    private static final GUIManager overlord = GUIManager.getDefaultGUIManager();
    private static final LanguageManager lang = GUIManager.getLanguageManager();
    private PetriNet pn = overlord.getWorkspace().getProject();
    private static final DecimalFormat formatter = new DecimalFormat("#.##");
    private JComboBox<String> invCombo = null;
    private JLabel labelMinimal;
    private JLabel labelFeasible;
    private JLabel labelSub;
    private JLabel labelSur;
    private JLabel labelCanon;
    private JLabel labelPureInT;
    private JLabel labelInT;
    private JLabel labelOutT;
    private JLabel labelReadArcs;
    private JLabel labelInhibitors;
    private JTextArea descriptionTextArea;
    private JLabel labelEFT;
    private JLabel labelAVG;
    private JLabel labelLFT;
    private JLabel labelTPNtrans;
    private JLabel labelDPNtrans;
    private JLabel labelTDPNtrans;
    private JLabel labelPNtrans;
    private JTable table;
    private InvariantsTableRenderer tableRenderer;
    private JScrollPane tableScrollPane;
    private int currentSelected = 0;
    private ArrayList<ArrayList<Integer>> invariantsMatrix = this.pn.getT_InvMatrix();
    private ArrayList<Transition> transitions;
    private ArrayList<Integer> readArcTransLocations;
    private ArrayList<ArrayList<Integer>> incidenceMatrix;
    private ArrayList<ArrayList<Integer>> supportMatrix;
    private ArrayList<ArrayList<Double>> transStats;
    private boolean problem = false;
    private boolean showTransTable = true;

    public HolmesInvariantsViewer() {
        boolean problem = false;
        if (this.invariantsMatrix == null || this.invariantsMatrix.isEmpty()) {
            JOptionPane.showMessageDialog(null, lang.getText("HIVwin_entry001"), lang.getText("error"), 0);
            this.dispatchEvent(new WindowEvent(this, 201));
            problem = true;
        }
        if (!problem) {
            this.currentSelected = 0;
            this.initiateVariables();
            this.initalizeComponents();
            this.initiateListeners();
            this.fillData(this.currentSelected);
            this.setVisible(true);
        }
    }

    public HolmesInvariantsViewer(int invNumber) {
        this.currentSelected = invNumber + 1;
        boolean problem = false;
        if (this.invariantsMatrix == null || this.invariantsMatrix.isEmpty()) {
            JOptionPane.showMessageDialog(null, lang.getText("HIVwin_entry001"), lang.getText("error"), 0);
            this.dispatchEvent(new WindowEvent(this, 201));
            problem = true;
        }
        if (!problem) {
            this.initiateVariables();
            this.initalizeComponents();
            this.initiateListeners();
            this.fillData(this.currentSelected);
            this.setVisible(true);
        }
    }

    private void initiateVariables() {
        try {
            this.transitions = this.pn.getTransitions();
            this.readArcTransLocations = InvariantsTools.getReadArcTransitionsStatic();
            InvariantsCalculator ic = new InvariantsCalculator(true);
            this.incidenceMatrix = ic.getCMatrix();
            this.supportMatrix = new ArrayList();
            for (ArrayList<Integer> matrix : this.invariantsMatrix) {
                this.supportMatrix.add(InvariantsTools.getSupport(matrix));
            }
            if (overlord.getSimulatorBox().getCurrentDockWindow().getSimulator().getSimulatorStatus() != GraphicalSimulator.SimulatorMode.STOPPED) {
                JOptionPane.showMessageDialog(null, lang.getText("HIVwin_entry002"), lang.getText("HIVwin_entry002t"), 0);
                this.transStats = null;
                this.problem = true;
            } else {
                StateSimulator ss = new StateSimulator();
                SimulatorGlobals ownSettings = new SimulatorGlobals();
                ownSettings.setNetType(SimulatorGlobals.SimNetType.BASIC, false);
                ownSettings.setMaxMode(false);
                ownSettings.setSingleMode(false);
                ss.initiateSim(false, ownSettings);
                this.transStats = ss.simulateForInvariantTrans(1000, 20, false);
                this.problem = this.transStats == null;
            }
        }
        catch (Exception e) {
            overlord.log(lang.getText("LOGentry00449exception") + "\n" + e.getMessage(), "error", true);
        }
    }

    private void initalizeComponents() {
        try {
            this.setIconImage(Tools.getImageFromIcon("/icons/holmesicon.png"));
        }
        catch (Exception e) {
            overlord.log(lang.getText("LOGentry00449exception") + "\n" + e.getMessage(), "error", true);
        }
        this.setLayout(new BorderLayout());
        this.setSize(new Dimension(800, 650));
        this.setLocation(50, 50);
        this.setResizable(true);
        this.setTitle(lang.getText("HIVwin_entry003title"));
        this.setLayout(new BorderLayout());
        JPanel main = new JPanel(new BorderLayout());
        main.add((Component)this.getUpperPanel(), "North");
        main.add((Component)this.getBottomPanel(), "Center");
        this.add((Component)main, "Center");
    }

    public JPanel getUpperPanel() {
        JPanel result = new JPanel(null);
        result.setBorder(BorderFactory.createTitledBorder(lang.getText("HIVwin_entry05")));
        result.setPreferredSize(new Dimension(800, 200));
        int posXda = 10;
        int posYda = 25;
        JLabel label0 = new JLabel(lang.getText("HIVwin_entry06"));
        label0.setBounds(posXda, posYda, 70, 20);
        result.add(label0);
        this.invCombo = new JComboBox();
        this.invCombo.addItem(" ---------- ");
        for (int i = 0; i < this.invariantsMatrix.size(); ++i) {
            this.invCombo.addItem(lang.getText("HIVwin_entry07") + " " + (i + 1) + " (ID:" + i + ")");
        }
        this.invCombo.setBounds(posXda + 75, posYda, 160, 20);
        this.invCombo.setSelectedIndex(this.currentSelected);
        this.invCombo.setMaximumRowCount(6);
        this.invCombo.addActionListener(actionEvent -> {
            this.currentSelected = this.invCombo.getSelectedIndex();
            if (this.currentSelected > 0) {
                this.fillData(this.currentSelected);
            } else {
                this.clearSelection();
            }
        });
        result.add(this.invCombo);
        JButton prevButton = new JButton(lang.getText("previous"));
        prevButton.setBounds(posXda + 245, posYda, 80, 20);
        prevButton.setMargin(new Insets(0, 0, 0, 0));
        prevButton.setIcon(Tools.getResIcon16("/icons/invViewer/prevIcon.png"));
        prevButton.setToolTipText(lang.getText("HIVwin_entry08"));
        prevButton.addActionListener(actionEvent -> {
            --this.currentSelected;
            if (this.currentSelected <= 0) {
                this.currentSelected = this.invariantsMatrix.size();
            }
            this.invCombo.setSelectedIndex(this.currentSelected);
        });
        result.add(prevButton);
        JButton nextButton = new JButton(lang.getText("HIVwin_entry09"));
        nextButton.setBounds(posXda + 335, posYda, 80, 20);
        nextButton.setMargin(new Insets(0, 0, 0, 0));
        nextButton.setIcon(Tools.getResIcon16("/icons/invViewer/nextIcon.png"));
        nextButton.setToolTipText(lang.getText("HIVwin_entry09t"));
        nextButton.addActionListener(actionEvent -> {
            ++this.currentSelected;
            if (this.currentSelected > this.invariantsMatrix.size()) {
                this.currentSelected = 1;
            }
            this.invCombo.setSelectedIndex(this.currentSelected);
        });
        result.add(nextButton);
        JLabel label1 = new JLabel(lang.getText("HIVwin_entry10"));
        label1.setBounds(posXda, posYda += 20, 70, 20);
        result.add(label1);
        this.labelMinimal = new JLabel("---");
        this.labelMinimal.setBounds(posXda + 75, posYda, 40, 20);
        result.add(this.labelMinimal);
        JLabel label2 = new JLabel(lang.getText("HIVwin_entry11"));
        label2.setBounds(posXda + 110, posYda, 70, 20);
        result.add(label2);
        this.labelFeasible = new JLabel("---");
        this.labelFeasible.setBounds(posXda + 180, posYda, 40, 20);
        result.add(this.labelFeasible);
        JLabel label3 = new JLabel(lang.getText("HIVwin_entry12"));
        label3.setBounds(posXda + 220, posYda, 70, 20);
        result.add(label3);
        this.labelSub = new JLabel("---");
        this.labelSub.setBounds(posXda + 290, posYda, 40, 20);
        result.add(this.labelSub);
        JLabel label4 = new JLabel(lang.getText("HIVwin_entry13"));
        label4.setBounds(posXda + 330, posYda, 70, 20);
        result.add(label4);
        this.labelSur = new JLabel("---");
        this.labelSur.setBounds(posXda + 400, posYda, 40, 20);
        result.add(this.labelSur);
        JLabel label5 = new JLabel(lang.getText("HIVwin_entry14"));
        label5.setBounds(posXda + 440, posYda, 70, 20);
        result.add(label5);
        this.labelCanon = new JLabel("---");
        this.labelCanon.setBounds(posXda + 510, posYda, 40, 20);
        result.add(this.labelCanon);
        JLabel label6 = new JLabel(lang.getText("HIVwin_entry15"));
        label6.setBounds(posXda, posYda += 20, 70, 20);
        result.add(label6);
        this.labelPureInT = new JLabel("---");
        this.labelPureInT.setBounds(posXda + 75, posYda, 40, 20);
        result.add(this.labelPureInT);
        JLabel label7 = new JLabel(lang.getText("HIVwin_entry16"));
        label7.setBounds(posXda + 110, posYda, 70, 20);
        result.add(label7);
        this.labelInT = new JLabel("---");
        this.labelInT.setBounds(posXda + 180, posYda, 40, 20);
        result.add(this.labelInT);
        JLabel label8 = new JLabel(lang.getText("HIVwin_entry17"));
        label8.setBounds(posXda + 220, posYda, 70, 20);
        result.add(label8);
        this.labelOutT = new JLabel("---");
        this.labelOutT.setBounds(posXda + 290, posYda, 40, 20);
        result.add(this.labelOutT);
        JLabel label9 = new JLabel(lang.getText("HIVwin_entry18"));
        label9.setBounds(posXda + 330, posYda, 70, 20);
        result.add(label9);
        this.labelReadArcs = new JLabel("---");
        this.labelReadArcs.setBounds(posXda + 400, posYda, 40, 20);
        result.add(this.labelReadArcs);
        JLabel label10 = new JLabel(lang.getText("HIVwin_entry19"));
        label10.setBounds(posXda + 440, posYda, 70, 20);
        result.add(label10);
        this.labelInhibitors = new JLabel("---");
        this.labelInhibitors.setBounds(posXda + 510, posYda, 40, 20);
        result.add(this.labelInhibitors);
        JLabel label11 = new JLabel(lang.getText("HIVwin_entry20"));
        label11.setBounds(posXda, posYda += 20, 70, 20);
        result.add(label11);
        this.labelEFT = new JLabel("---");
        this.labelEFT.setBounds(posXda + 75, posYda, 40, 20);
        result.add(this.labelEFT);
        JLabel label12 = new JLabel(lang.getText("HIVwin_entry21"));
        label12.setBounds(posXda + 140, posYda, 70, 20);
        result.add(label12);
        this.labelAVG = new JLabel("---");
        this.labelAVG.setBounds(posXda + 210, posYda, 40, 20);
        result.add(this.labelAVG);
        JLabel label13 = new JLabel(lang.getText("HIVwin_entry22"));
        label13.setBounds(posXda + 280, posYda, 70, 20);
        result.add(label13);
        this.labelLFT = new JLabel("---");
        this.labelLFT.setBounds(posXda + 350, posYda, 40, 20);
        result.add(this.labelLFT);
        JLabel label16 = new JLabel(lang.getText("HIVwin_entry23"));
        label16.setBounds(posXda, posYda += 20, 70, 20);
        result.add(label16);
        this.labelTPNtrans = new JLabel("---");
        this.labelTPNtrans.setBounds(posXda + 75, posYda, 40, 20);
        result.add(this.labelTPNtrans);
        JLabel label17 = new JLabel(lang.getText("HIVwin_entry24"));
        label17.setBounds(posXda + 110, posYda, 70, 20);
        result.add(label17);
        this.labelDPNtrans = new JLabel("---");
        this.labelDPNtrans.setBounds(posXda + 180, posYda, 40, 20);
        result.add(this.labelDPNtrans);
        JLabel label18 = new JLabel(lang.getText("HIVwin_entry25"));
        label18.setBounds(posXda + 220, posYda, 70, 20);
        result.add(label18);
        this.labelTDPNtrans = new JLabel("---");
        this.labelTDPNtrans.setBounds(posXda + 290, posYda, 40, 20);
        result.add(this.labelTDPNtrans);
        JLabel label19 = new JLabel(lang.getText("HIVwin_entry26"));
        label19.setBounds(posXda + 330, posYda, 70, 20);
        result.add(label19);
        this.labelPNtrans = new JLabel("---");
        this.labelPNtrans.setBounds(posXda + 400, posYda, 40, 20);
        result.add(this.labelPNtrans);
        JLabel comLabel = new JLabel(lang.getText("HIVwin_entry27"));
        comLabel.setBounds(posXda, posYda += 20, 70, 20);
        result.add(comLabel);
        this.descriptionTextArea = new JTextArea();
        this.descriptionTextArea.setLineWrap(true);
        this.descriptionTextArea.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                JTextArea field = (JTextArea)e.getSource();
                String newComment = "";
                if (field != null) {
                    newComment = field.getText();
                }
                HolmesInvariantsViewer.this.changeInvDescr(newComment);
                overlord.markNetChange();
            }
        });
        JPanel descPanel = new JPanel();
        descPanel.setLayout(new BorderLayout());
        descPanel.add((Component)new JScrollPane(this.descriptionTextArea), "Center");
        descPanel.setBounds(posXda, posYda += 20, 550, 50);
        result.add(descPanel);
        JButton calcButton = new JButton(lang.getText("HIVwin_entry28"));
        calcButton.setBounds(570, 20, 200, 35);
        calcButton.setMargin(new Insets(0, 0, 0, 0));
        calcButton.setIcon(Tools.getResIcon16("/icons/invViewer/recalculateInvStats.png"));
        calcButton.setToolTipText(lang.getText("HIVwin_entry28t"));
        calcButton.addActionListener(actionEvent -> {
            if (overlord.getSimulatorBox().getCurrentDockWindow().getSimulator().getSimulatorStatus() != GraphicalSimulator.SimulatorMode.STOPPED) {
                JOptionPane.showMessageDialog(null, lang.getText("HIVwin_entry002"), lang.getText("HIVwin_entry002t"), 0);
                this.transStats = null;
                this.problem = true;
            } else {
                StateSimulator ss = new StateSimulator();
                SimulatorGlobals ownSettings = new SimulatorGlobals();
                ownSettings.setNetType(SimulatorGlobals.SimNetType.BASIC, false);
                ownSettings.setMaxMode(false);
                ownSettings.setSingleMode(false);
                ss.initiateSim(false, ownSettings);
                this.transStats = ss.simulateForInvariantTrans(1000, 20, false);
                this.problem = this.transStats == null;
            }
        });
        result.add(calcButton);
        JButton showNotepadButton = new JButton(lang.getText("HIVwin_entry29"));
        showNotepadButton.setBounds(570, 60, 200, 35);
        showNotepadButton.setMargin(new Insets(0, 0, 0, 0));
        showNotepadButton.setIcon(Tools.getResIcon32("/icons/invViewer/showInNotepad.png"));
        showNotepadButton.setToolTipText(lang.getText("HIVwin_entry29t"));
        showNotepadButton.addActionListener(actionEvent -> {
            if (this.currentSelected > 0) {
                this.showInvariantNotepad(this.currentSelected);
            }
        });
        result.add(showNotepadButton);
        JCheckBox maximumModeCheckBox = new JCheckBox(lang.getText("HIVwin_entry30"));
        maximumModeCheckBox.setBounds(570, 130, 150, 20);
        maximumModeCheckBox.addActionListener(actionEvent -> {
            AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
            boolean bl = this.showTransTable = !abstractButton.getModel().isSelected();
            if (this.currentSelected > 0) {
                this.fillData(this.currentSelected);
            } else {
                this.clearSelection();
            }
        });
        result.add(maximumModeCheckBox);
        return result;
    }

    protected void showTransitionTable(int invNo) {
        if (--invNo == -1) {
            return;
        }
        InvariantsViewerTableModel modelTransition = new InvariantsViewerTableModel(false);
        this.table.setModel(modelTransition);
        this.table.getColumnModel().getColumn(0).setHeaderValue("ID");
        this.table.getColumnModel().getColumn(0).setPreferredWidth(30);
        this.table.getColumnModel().getColumn(0).setMinWidth(30);
        this.table.getColumnModel().getColumn(0).setMaxWidth(30);
        this.table.getColumnModel().getColumn(1).setHeaderValue("Transition");
        this.table.getColumnModel().getColumn(1).setPreferredWidth(800);
        this.table.getColumnModel().getColumn(1).setMinWidth(100);
        this.table.getColumnModel().getColumn(2).setHeaderValue("Supp.");
        this.table.getColumnModel().getColumn(2).setPreferredWidth(50);
        this.table.getColumnModel().getColumn(2).setMinWidth(50);
        this.table.getColumnModel().getColumn(2).setMaxWidth(50);
        this.table.getColumnModel().getColumn(3).setHeaderValue("Firing%");
        this.table.getColumnModel().getColumn(3).setPreferredWidth(80);
        this.table.getColumnModel().getColumn(3).setMinWidth(80);
        this.table.getColumnModel().getColumn(4).setMaxWidth(80);
        this.table.getColumnModel().getColumn(4).setHeaderValue("stdDev");
        this.table.getColumnModel().getColumn(4).setPreferredWidth(80);
        this.table.getColumnModel().getColumn(4).setMinWidth(80);
        this.table.getColumnModel().getColumn(4).setMaxWidth(80);
        TableRowSorter<TableModel> sorter = new TableRowSorter<TableModel>(this.table.getModel());
        this.table.setRowSorter(sorter);
        this.table.setName("InvTransTable");
        this.table.setFillsViewportHeight(true);
        this.table.setDefaultRenderer(Object.class, this.tableRenderer);
        ArrayList<Integer> invariant = this.invariantsMatrix.get(invNo);
        for (int t = 0; t < this.transitions.size(); ++t) {
            if (invariant.get(t) == 0) continue;
            ArrayList<String> row = new ArrayList<String>();
            row.add("" + t);
            row.add(this.transitions.get(t).getName());
            row.add(String.valueOf(invariant.get(t)));
            if (this.problem) {
                row.add("n/a");
                row.add("n/a");
            } else {
                Object value = formatter.format((Object)(this.transStats.get(0).get(t) * 100.0));
                int index = ((String)value).indexOf(",");
                if (index == 1) {
                    value = "0" + (String)value;
                }
                row.add((String)value + "%");
                value = formatter.format((Object)(this.transStats.get(1).get(t) * 100.0));
                row.add((String)value + "%");
            }
            modelTransition.addNew(row);
        }
        this.table.setAutoResizeMode(4);
        this.table.validate();
    }

    protected void showMCTTransTable(int invNo) {
        if (--invNo == -1) {
            return;
        }
        InvariantsViewerTableModel modelMCTandTrans = new InvariantsViewerTableModel(true);
        this.table.setModel(modelMCTandTrans);
        this.table.getColumnModel().getColumn(0).setHeaderValue("ID");
        this.table.getColumnModel().getColumn(0).setPreferredWidth(60);
        this.table.getColumnModel().getColumn(0).setMinWidth(60);
        this.table.getColumnModel().getColumn(0).setMaxWidth(60);
        this.table.getColumnModel().getColumn(1).setHeaderValue("Element");
        this.table.getColumnModel().getColumn(1).setPreferredWidth(800);
        this.table.getColumnModel().getColumn(1).setMinWidth(100);
        TableRowSorter<TableModel> sorter = new TableRowSorter<TableModel>(this.table.getModel());
        this.table.setRowSorter(sorter);
        this.table.setName("TransitionMCTInvTable");
        this.table.setFillsViewportHeight(true);
        this.table.setDefaultRenderer(Object.class, this.tableRenderer);
        ArrayList<ArrayList<Transition>> mcts = this.pn.getMCTMatrix();
        ArrayList<Integer> invariant = new ArrayList<Integer>((Collection)this.invariantsMatrix.get(invNo));
        for (int mctIndex = 0; mctIndex < mcts.size() - 1; ++mctIndex) {
            ArrayList<Transition> mctSet = mcts.get(mctIndex);
            int firstTindex = this.transitions.indexOf(mctSet.get(0));
            if ((Integer)invariant.get(firstTindex) == 0) continue;
            ArrayList<String> row = new ArrayList<String>();
            row.add("MCT" + (mctIndex + 1));
            row.add(this.pn.getMCTname(mctIndex));
            modelMCTandTrans.addNew(row);
            for (Transition trans : mctSet) {
                int tIndex = this.transitions.indexOf(trans);
                invariant.set(tIndex, 0);
            }
        }
        for (int t = 0; t < this.transitions.size(); ++t) {
            if ((Integer)invariant.get(t) == 0) continue;
            ArrayList<String> row = new ArrayList<String>();
            row.add("t" + t);
            row.add(this.transitions.get(t).getName());
            modelMCTandTrans.addNew(row);
        }
        this.table.setAutoResizeMode(4);
        this.table.validate();
    }

    private void changeInvDescr(String newComment) {
        if (this.currentSelected > 0) {
            this.pn.accessT_InvDescriptions().set(this.currentSelected - 1, newComment);
        }
    }

    private void fillData(int invNo) {
        ArrayList<Integer> data;
        if (invNo == 0) {
            return;
        }
        if ((data = InvariantsTools.singleT_invAnalysis(this.invariantsMatrix, --invNo, this.transitions, this.readArcTransLocations, this.incidenceMatrix, this.supportMatrix)).get(0) == 0) {
            this.labelMinimal.setText(lang.getText("yes"));
        } else {
            this.labelMinimal.setText(lang.getText("no"));
        }
        if (data.get(1) == 1) {
            this.labelFeasible.setText(lang.getText("yes"));
        } else {
            this.labelFeasible.setText(lang.getText("no"));
        }
        if (data.get(2) == 0) {
            this.labelSub.setText(lang.getText("no"));
            this.labelSur.setText(lang.getText("no"));
        } else if (data.get(2) == -1) {
            this.labelSub.setText(lang.getText("yes"));
            this.labelSur.setText(lang.getText("no"));
        } else if (data.get(2) == 1) {
            this.labelSub.setText(lang.getText("no"));
            this.labelSur.setText(lang.getText("yes"));
        } else {
            this.labelSub.setText("n-Inv");
            this.labelSur.setText("n-Inv");
        }
        if (data.get(3) == 1) {
            this.labelCanon.setText(lang.getText("yes"));
        } else {
            this.labelCanon.setText(lang.getText("no"));
        }
        this.labelInT.setText(String.valueOf(data.get(4)));
        this.labelPureInT.setText(String.valueOf(data.get(5)));
        this.labelOutT.setText(String.valueOf(data.get(6)));
        this.labelReadArcs.setText(String.valueOf(data.get(7)));
        this.labelInhibitors.setText(String.valueOf(data.get(8)));
        if (this.showTransTable) {
            this.showTransitionTable(this.currentSelected);
        } else {
            this.showMCTTransTable(this.currentSelected);
        }
        this.tableScrollPane.setViewportView(this.table);
        this.tableScrollPane.repaint();
        this.descriptionTextArea.setText(overlord.getWorkspace().getProject().getT_InvDescription(invNo));
        ArrayList<Double> timeVector = TimeComputations.getT_InvTimeValues(this.invariantsMatrix.get(invNo), this.transitions);
        try {
            assert (timeVector != null);
            this.labelEFT.setText(String.format("%.2f", timeVector.get(0) + timeVector.get(3)));
            this.labelAVG.setText(String.format("%.2f", timeVector.get(2) + timeVector.get(3)));
            this.labelLFT.setText(String.format("%.2f", timeVector.get(1) + timeVector.get(3)));
            this.labelTPNtrans.setText("" + timeVector.get(5).intValue());
            this.labelDPNtrans.setText("" + timeVector.get(6).intValue());
            this.labelTDPNtrans.setText("" + timeVector.get(7).intValue());
            this.labelPNtrans.setText("" + timeVector.get(4).intValue());
        }
        catch (Exception e) {
            overlord.log(lang.getText("LOGentry00451exception") + "\n" + e.getMessage(), "error", true);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void showInvariantNotepad(int invNo) {
        void var12_19;
        if (invNo == 0) {
            return;
        }
        HolmesNotepad note = new HolmesNotepad(800, 600);
        ArrayList<Integer> invariant = this.invariantsMatrix.get(--invNo);
        ArrayList<Integer> mcts = new ArrayList<Integer>();
        ArrayList<CallSite> singleT = new ArrayList<CallSite>();
        ArrayList<Integer> transMCTvector = overlord.getWorkspace().getProject().getMCTtransIndicesVector();
        int transNumber = 0;
        for (int t = 0; t < invariant.size(); ++t) {
            int fireValue = invariant.get(t);
            if (fireValue == 0) continue;
            ++transNumber;
            int mctNo = transMCTvector.get(t);
            if (mctNo == -1) {
                singleT.add((CallSite)((Object)("T" + t + "_" + this.transitions.get(t).getName())));
                continue;
            }
            if (mcts.contains(mctNo)) continue;
            mcts.add(mctNo);
        }
        Collections.sort(mcts);
        String description = overlord.getWorkspace().getProject().accessT_InvDescriptions().get(invNo);
        note.addTextLineNL(lang.getText("HIVwin_entry32") + " " + (invNo + 1), "text");
        note.addTextLineNL(lang.getText("HIVwin_entry33") + " " + description, "text");
        note.addTextLineNL(lang.getText("HIVwin_entry34") + " " + transNumber, "text");
        ArrayList<Double> timeVector = TimeComputations.getT_InvTimeValues(invariant, this.transitions);
        assert (timeVector != null);
        note.addTextLineNL(lang.getText("HIVwin_entry35") + " " + String.format("%.2f", timeVector.get(0) + timeVector.get(3)), "text");
        note.addTextLineNL(lang.getText("HIVwin_entry36") + " " + String.format("%.2f", timeVector.get(1) + timeVector.get(3)), "text");
        note.addTextLineNL(lang.getText("HIVwin_entry37") + " " + String.format("%.2f", timeVector.get(2) + timeVector.get(3)), "text");
        String strB = "err.";
        try {
            strB = String.format(lang.getText("HIVwin_entry38"), timeVector.get(5).intValue(), timeVector.get(6).intValue(), timeVector.get(7).intValue(), timeVector.get(4).intValue());
        }
        catch (Exception e) {
            overlord.log(lang.getText("LOGentryLNGexc") + " HIVwin_entry38", "error", true);
        }
        note.addTextLineNL(strB, "text");
        note.addTextLineNL(" ", "text");
        note.addTextLineNL(lang.getText("HIVwin_entry39"), "text");
        Iterator e = mcts.iterator();
        while (e.hasNext()) {
            int n = (Integer)e.next();
            String MCTname = overlord.getWorkspace().getProject().getMCTname(n);
            note.addTextLineNL("  [MCT: " + (n + 1) + "]: " + MCTname, "text");
        }
        for (String string : singleT) {
            note.addTextLineNL(string, "text");
        }
        note.addTextLineNL("", "text");
        note.addTextLineNL(lang.getText("HIVwin_entry40") + (invNo + 1) + ":", "text");
        if (this.transitions.size() != invariant.size()) {
            this.transitions = overlord.getWorkspace().getProject().getTransitions();
            if (this.transitions == null || this.transitions.size() != invariant.size()) {
                overlord.log(lang.getText("HIVwin_entry41"), "error", true);
                return;
            }
        }
        StringBuilder vector = new StringBuilder();
        boolean bl = false;
        while (var12_19 < invariant.size()) {
            int fireValue = invariant.get((int)var12_19);
            vector.append(fireValue).append(";");
            if (fireValue != 0) {
                Transition realT = this.transitions.get((int)var12_19);
                String t1 = Tools.setToSize("t" + (int)var12_19, 5, false);
                String t2 = Tools.setToSize(lang.getText("HIVwin_entry42") + " " + fireValue, 12, false);
                note.addTextLineNL(t1 + t2 + " ; " + realT.getName(), "text");
            }
            ++var12_19;
        }
        vector = new StringBuilder(vector.substring(0, vector.length() - 1));
        note.addTextLineNL("", "text");
        note.addTextLineNL(lang.getText("HIVwin_entry43"), "text");
        note.addTextLineNL(vector.toString(), "text");
        note.setCaretFirstLine();
        note.setVisible(true);
    }

    private void clearSelection() {
        this.labelMinimal.setText("---");
        this.labelFeasible.setText("---");
        this.labelSub.setText("---");
        this.labelSur.setText("---");
        this.labelCanon.setText("---");
        this.labelPureInT.setText("---");
        this.labelInT.setText("---");
        this.labelOutT.setText("---");
        this.labelReadArcs.setText("---");
        this.labelInhibitors.setText("---");
        this.labelEFT.setText("---");
        this.labelAVG.setText("---");
        this.labelLFT.setText("---");
        this.labelTPNtrans.setText("---");
        this.labelDPNtrans.setText("---");
        this.labelTDPNtrans.setText("---");
        this.labelPNtrans.setText("---");
        this.table.setModel(new DefaultTableModel());
    }

    public JPanel getBottomPanel() {
        JPanel result = new JPanel(new BorderLayout());
        result.setBorder(BorderFactory.createTitledBorder("Tables"));
        result.setPreferredSize(new Dimension(150, 500));
        DefaultTableModel tableModel = new DefaultTableModel();
        this.table = new JTable(tableModel);
        this.tableRenderer = new InvariantsTableRenderer(this.table);
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 1 && !e.isControlDown()) {
                    HolmesInvariantsViewer.this.cellClickAction();
                }
            }
        });
        this.table.setAutoResizeMode(0);
        this.tableScrollPane = new JScrollPane(this.table, 20, 30);
        result.add((Component)this.tableScrollPane, "Center");
        return result;
    }

    protected void cellClickAction() {
        try {
            int row = this.table.getSelectedRow();
            if (this.table.getName().equals("InvTransTable")) {
                String id = this.table.getValueAt(row, 0).toString();
                int transId = Integer.parseInt(id);
                new HolmesNodeInfo(this.transitions.get(transId), (JFrame)this);
            }
        }
        catch (Exception ex) {
            overlord.log(lang.getText("LOGentry00452exception") + "\n" + ex.getMessage(), "error", true);
        }
    }

    private void initiateListeners() {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
            }
        });
    }
}

