/*
 * Decompiled with CFR 0.152.
 */
package holmes.windows;

import holmes.analyse.InvariantsCalculator;
import holmes.analyse.InvariantsCalculatorFeasible;
import holmes.analyse.InvariantsTools;
import holmes.darkgui.GUIManager;
import holmes.darkgui.LanguageManager;
import holmes.files.io.IOprotocols;
import holmes.petrinet.data.PetriNet;
import holmes.petrinet.elements.Arc;
import holmes.petrinet.elements.PetriNetElement;
import holmes.petrinet.elements.Place;
import holmes.petrinet.elements.Transition;
import holmes.utilities.Tools;
import holmes.varia.Check;
import holmes.windows.HolmesNotepad;
import holmes.workspace.ExtensionFileFilter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.filechooser.FileFilter;
import javax.swing.plaf.basic.BasicTabbedPaneUI;
import javax.swing.text.DefaultCaret;

public class HolmesInvariantsGenerator
extends JFrame {
    private static final long serialVersionUID = 5805567123988000425L;
    private static final GUIManager overlord = GUIManager.getDefaultGUIManager();
    private static final LanguageManager lang = GUIManager.getLanguageManager();
    private JFrame ego;
    private JTextArea logFieldTinv;
    private JTextArea logFieldPinv;
    private InvariantsCalculator invGenerator = null;
    public boolean isGeneratorWorking = false;
    public boolean noAction = false;
    private boolean detailsTinv = true;
    private boolean detailsPinv = true;
    private int feasibleCalcMode = 1;
    private boolean showInvDiff = false;

    public HolmesInvariantsGenerator() {
        try {
            this.setIconImage(Tools.getImageFromIcon("/icons/holmesicon.png"));
        }
        catch (Exception ex) {
            overlord.log(lang.getText("LOGentry00440exception") + "\n" + ex.getMessage(), "error", true);
        }
        this.ego = this;
        this.setVisible(false);
        this.setTitle("Invariants generator and tools");
        this.setLayout(new BorderLayout());
        this.setSize(new Dimension(682, 570));
        this.setLocation(50, 50);
        this.setResizable(false);
        this.setDefaultCloseOperation(1);
        JPanel mainPanel = this.createMainPanel();
        this.add((Component)mainPanel, "Center");
    }

    private JPanel createMainPanel() {
        JPanel main = new JPanel(new BorderLayout());
        JPanel panelTinv = new JPanel();
        panelTinv.setLayout(null);
        JPanel buttonPanelT = this.createUpperButtonPanelTinv(0, 0, 660, 90);
        JPanel logMainPanelT = this.createLogMainPanelTinv(0, 90, 530, 400);
        JPanel sideButtonPanelT = this.createRightButtonPanelTinv(530, 90, 130, 400);
        panelTinv.add(buttonPanelT);
        panelTinv.add(logMainPanelT);
        panelTinv.add(sideButtonPanelT);
        panelTinv.repaint();
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.setUI(new BasicTabbedPaneUI(){

            @Override
            protected int calculateTabHeight(int tabPlacement, int tabIndex, int fontHeight) {
                return 32;
            }

            @Override
            protected void paintTab(Graphics g, int tabPlacement, Rectangle[] rects, int tabIndex, Rectangle iconRect, Rectangle textRect) {
                super.paintTab(g, tabPlacement, rects, tabIndex, iconRect, textRect);
            }
        });
        tabbedPane.addTab(lang.getText("HIGwin_entry002"), Tools.getResIcon22("/icons/invWindow/tInvIcon.png"), panelTinv, lang.getText("HIGwin_entry002t"));
        tabbedPane.setMnemonicAt(0, 49);
        JPanel panelPinv = new JPanel();
        panelPinv.setLayout(null);
        JPanel buttonPanelP = this.createUpperButtonPanelPinv(0, 0, 660, 90);
        JPanel logMainPanelP = this.createLogMainPanelPinv(0, 90, 530, 400);
        JPanel sideButtonPanelP = this.createRightButtonPanelPinv(530, 90, 130, 400);
        panelPinv.add(buttonPanelP);
        panelPinv.add(logMainPanelP);
        panelPinv.add(sideButtonPanelP);
        panelPinv.repaint();
        tabbedPane.addTab(lang.getText("HIGwin_entry003"), Tools.getResIcon22("/icons/invWindow/pInvIcon.png"), panelPinv, lang.getText("HIGwin_entry003t"));
        tabbedPane.setMnemonicAt(1, 50);
        main.add((Component)tabbedPane, "Center");
        return main;
    }

    private JPanel createUpperButtonPanelTinv(int x, int y, int width, int height) {
        JPanel panel = new JPanel();
        panel.setLayout(null);
        panel.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        panel.setBounds(x, y, width, height);
        int posX = 10;
        int posY = 10;
        JButton generateButton = new JButton(lang.getText("HIGwin_entry004"));
        generateButton.setBounds(posX, posY, 110, 60);
        generateButton.setMargin(new Insets(0, 0, 0, 0));
        generateButton.setIcon(Tools.getResIcon32("/icons/stateSim/computeData.png"));
        generateButton.addActionListener(actionEvent -> {
            if (this.isGeneratorWorking) {
                JOptionPane.showMessageDialog(null, lang.getText("HIGwin_entry005"), lang.getText("HIGwin_entry005t"), 2);
            } else {
                this.setGeneratorStatus(true);
                this.invGenerator = new InvariantsCalculator(true);
                this.invGenerator.setShowInvDiff(this.showInvDiff);
                Thread myThread = new Thread(this.invGenerator);
                myThread.start();
            }
        });
        generateButton.setFocusPainted(false);
        panel.add(generateButton);
        JButton INAgenerateButton = new JButton();
        INAgenerateButton.setText(lang.getText("HIGwin_entry006"));
        INAgenerateButton.setBounds(posX + 130, posY, 120, 36);
        INAgenerateButton.setMargin(new Insets(0, 0, 0, 0));
        INAgenerateButton.setIcon(Tools.getResIcon22("/icons/invWindow/inaGenerator.png"));
        INAgenerateButton.addActionListener(actionEvent -> {
            if (overlord.getINAStatus()) {
                this.setGeneratorStatus(true);
                HolmesInvariantsGenerator.overlord.io.generateINAinvariants(true);
                HolmesInvariantsGenerator.overlord.reset.setT_invariantsStatus(true);
                overlord.accessNetTablesWindow().resetT_invData();
                overlord.markNetChange();
            } else {
                JOptionPane.showMessageDialog(null, lang.getText("HIGwin_entry007"), lang.getText("HIGwin_entry007t"), 0);
            }
        });
        INAgenerateButton.setFocusPainted(false);
        INAgenerateButton.setEnabled(false);
        panel.add(INAgenerateButton);
        JButton loadInvariantsButton = new JButton();
        loadInvariantsButton.setText(lang.getText("HIGwin_entry008"));
        loadInvariantsButton.setBounds(posX + 255, posY, 120, 36);
        loadInvariantsButton.setMargin(new Insets(0, 0, 0, 0));
        loadInvariantsButton.setIcon(Tools.getResIcon22("/icons/invWindow/loadInvariants.png"));
        loadInvariantsButton.setToolTipText(lang.getText("HIGwin_entry008info"));
        loadInvariantsButton.addActionListener(actionEvent -> {
            overlord.accessNetTablesWindow().resetT_invData();
            boolean status = HolmesInvariantsGenerator.overlord.io.loadExternalAnalysis(true);
            if (status) {
                this.logFieldTinv.append("\n");
                this.logFieldTinv.append("=====================================================================\n");
                this.logFieldTinv.append(lang.getText("LOGentry00441") + " " + overlord.getWorkspace().getProject().getT_InvMatrix().size() + "\n");
                this.logFieldTinv.append("=====================================================================\n");
                overlord.markNetChange();
            } else {
                this.logFieldTinv.append("\n");
                this.logFieldTinv.append(lang.getText("LOGentry00442"));
            }
        });
        loadInvariantsButton.setFocusPainted(false);
        panel.add(loadInvariantsButton);
        JButton saveInvariantsButton = new JButton();
        saveInvariantsButton.setText(lang.getText("HIGwin_entry009"));
        saveInvariantsButton.setBounds(posX + 380, posY, 120, 36);
        saveInvariantsButton.setMargin(new Insets(0, 0, 0, 0));
        saveInvariantsButton.setIcon(Tools.getResIcon22("/icons/invWindow/saveInvariants.png"));
        saveInvariantsButton.setToolTipText(lang.getText("HIGwin_entry009info"));
        saveInvariantsButton.addActionListener(actionEvent -> {
            boolean status = HolmesInvariantsGenerator.overlord.io.exportGeneratedInvariants(true);
            if (status) {
                this.logFieldTinv.append("\n");
                this.logFieldTinv.append("=====================================================================\n");
                this.logFieldTinv.append(lang.getText("LOGentry00443") + " " + overlord.getWorkspace().getProject().getT_InvMatrix().size() + "\n");
                this.logFieldTinv.append("=====================================================================\n");
            } else {
                this.logFieldTinv.append("\n");
                this.logFieldTinv.append(lang.getText("LOGentry00444"));
            }
        });
        saveInvariantsButton.setFocusPainted(false);
        panel.add(saveInvariantsButton);
        JButton showInvariantsButton = new JButton();
        showInvariantsButton.setText(lang.getText("HIGwin_entry010"));
        showInvariantsButton.setBounds(posX + 505, posY, 120, 36);
        showInvariantsButton.setMargin(new Insets(0, 0, 0, 0));
        showInvariantsButton.setIcon(Tools.getResIcon22("/icons/invWindow/showInvariants.png"));
        showInvariantsButton.addActionListener(actionEvent -> this.showNotepadInvariants(true));
        showInvariantsButton.setToolTipText(lang.getText("HIGwin_entry010info"));
        showInvariantsButton.setFocusPainted(false);
        panel.add(showInvariantsButton);
        JButton saveInvButton = new JButton();
        saveInvButton.setText(lang.getText("HIGwin_entry011"));
        saveInvButton.setBounds(posX + 130, posY + 40, 120, 36);
        saveInvButton.setMargin(new Insets(0, 0, 0, 0));
        saveInvButton.setIcon(Tools.getResIcon22("/icons/invWindow/showInvariants.png"));
        saveInvButton.addActionListener(actionEvent -> this.saveInvKajaType(true));
        saveInvButton.setToolTipText(lang.getText("HIGwin_entry011info"));
        saveInvButton.setFocusPainted(false);
        panel.add(saveInvButton);
        JButton makeFeasibleButton = new JButton();
        makeFeasibleButton.setText(lang.getText("HIGwin_entry012"));
        makeFeasibleButton.setBounds(posX + 255, posY + 40, 120, 36);
        makeFeasibleButton.setMargin(new Insets(0, 0, 0, 0));
        makeFeasibleButton.setIcon(Tools.getResIcon22("/icons/invWindow/makeFeasible.png"));
        makeFeasibleButton.addActionListener(actionEvent -> this.checkAndMakeFeasible());
        makeFeasibleButton.setFocusPainted(false);
        makeFeasibleButton.setToolTipText(lang.getText("HIGwin_entry012info"));
        panel.add(makeFeasibleButton);
        JCheckBox feasModeCheckBox = new JCheckBox(lang.getText("HIGwin_entry013"));
        feasModeCheckBox.setBounds(posX + 380, posY + 36, 240, 20);
        feasModeCheckBox.setToolTipText(lang.getText("HIGwin_entry013info"));
        feasModeCheckBox.addActionListener(actionEvent -> {
            AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
            this.feasibleCalcMode = abstractButton.getModel().isSelected() ? 1 : 0;
        });
        feasModeCheckBox.setSelected(true);
        panel.add(feasModeCheckBox);
        JCheckBox invPurityCheckBox = new JCheckBox(lang.getText("HIGwin_entry014"));
        invPurityCheckBox.setBounds(posX + 380, posY + 56, 120, 20);
        invPurityCheckBox.setToolTipText(lang.getText("HIGwin_entry014info"));
        invPurityCheckBox.addActionListener(actionEvent -> {
            AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
            if (abstractButton.getModel().isSelected()) {
                overlord.getSettingsManager().setValue("analysisRemoveNonInv", "1", true);
            } else {
                overlord.getSettingsManager().setValue("analysisRemoveNonInv", "0", true);
            }
        });
        invPurityCheckBox.setSelected(overlord.getSettingsManager().getValue("analysisRemoveNonInv").equals("1"));
        panel.add(invPurityCheckBox);
        JCheckBox removeSingleInvCheckBox = new JCheckBox(lang.getText("HIGwin_entry015"));
        removeSingleInvCheckBox.setBounds(posX + 510, posY + 56, 120, 20);
        removeSingleInvCheckBox.setToolTipText(lang.getText("HIGwin_entry015info"));
        removeSingleInvCheckBox.addActionListener(actionEvent -> {
            AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
            if (abstractButton.getModel().isSelected()) {
                overlord.getSettingsManager().setValue("analysisRemoveSingleElementInv", "1", true);
            } else {
                overlord.getSettingsManager().setValue("analysisRemoveSingleElementInv", "0", true);
            }
        });
        removeSingleInvCheckBox.setSelected(overlord.getSettingsManager().getValue("analysisRemoveSingleElementInv").equals("1"));
        panel.add(removeSingleInvCheckBox);
        return panel;
    }

    private void saveInvKajaType(boolean t_inv) {
        block6: {
            block5: {
                if (!t_inv) break block5;
                ArrayList<ArrayList<Integer>> t_invariants = overlord.getWorkspace().getProject().getT_InvMatrix();
                if (t_invariants == null) break block6;
                ArrayList<Transition> transitions = overlord.getWorkspace().getProject().getTransitions();
                HolmesNotepad notePad = new HolmesNotepad(900, 600);
                notePad.setVisible(true);
                notePad.addTextLineNL(lang.getText("HIGwin_entry016"), "text");
                for (int i = 0; i < t_invariants.size(); ++i) {
                    ArrayList<Integer> inv = t_invariants.get(i);
                    StringBuilder vector = new StringBuilder("x" + i + ";");
                    for (int j = 0; j < inv.size(); ++j) {
                        int value = inv.get(j);
                        if (value == 0) continue;
                        vector.append("t").append(overlord.getWorkspace().getProject().getTransitions().lastIndexOf(transitions.get(j))).append(";");
                    }
                    notePad.addTextLineNL(vector.toString(), "text");
                }
                break block6;
            }
            ArrayList<ArrayList<Integer>> p_invariants = overlord.getWorkspace().getProject().getT_InvMatrix();
            if (p_invariants != null) {
                ArrayList<Place> places = overlord.getWorkspace().getProject().getPlaces();
                HolmesNotepad notePad = new HolmesNotepad(900, 600);
                notePad.setVisible(true);
                notePad.addTextLineNL(lang.getText("HIGwin_entry017"), "text");
                for (int i = 0; i < p_invariants.size(); ++i) {
                    ArrayList<Integer> inv = p_invariants.get(i);
                    StringBuilder vector = new StringBuilder("x" + i + ";");
                    for (int j = 0; j < inv.size(); ++j) {
                        int value = inv.get(j);
                        if (value == 0) continue;
                        vector.append("p").append(overlord.getWorkspace().getProject().getPlaces().lastIndexOf(places.get(j))).append(";");
                    }
                    notePad.addTextLineNL(vector.toString(), "text");
                }
            }
        }
    }

    private JPanel createLogMainPanelTinv(int x, int y, int width, int height) {
        JPanel panel = new JPanel();
        panel.setLayout(null);
        panel.setBorder(BorderFactory.createTitledBorder(lang.getText("HIGwin_entry018")));
        panel.setBounds(x, y, width, height);
        this.logFieldTinv = new JTextArea();
        this.logFieldTinv.setLineWrap(true);
        this.logFieldTinv.setEditable(false);
        DefaultCaret caret = (DefaultCaret)this.logFieldTinv.getCaret();
        caret.setUpdatePolicy(2);
        JPanel logFieldPanel = new JPanel();
        logFieldPanel.setLayout(new BorderLayout());
        logFieldPanel.add((Component)new JScrollPane(this.logFieldTinv), "Center");
        logFieldPanel.setBounds(10, 20, width - 20, height - 25);
        panel.add(logFieldPanel);
        return panel;
    }

    private JPanel createRightButtonPanelTinv(int x, int y, int width, int height) {
        JPanel panel = new JPanel();
        panel.setLayout(null);
        panel.setBorder(BorderFactory.createTitledBorder(lang.getText("HIGwin_entry019")));
        panel.setBounds(x, y, width, height);
        int posX = 10;
        int posY = 18;
        JButton cardinalityButton = new JButton();
        cardinalityButton.setText(lang.getText("HIGwin_entry020"));
        cardinalityButton.setBounds(posX, posY, 110, 48);
        cardinalityButton.setMargin(new Insets(0, 0, 0, 0));
        cardinalityButton.setIcon(Tools.getResIcon22("/icons/invWindow/test_canon.png"));
        cardinalityButton.setToolTipText(lang.getText("HIGwin_entry020info"));
        cardinalityButton.addActionListener(actionEvent -> {
            ArrayList<ArrayList<Integer>> invariants = overlord.getWorkspace().getProject().getT_InvMatrix();
            if (invariants == null || invariants.isEmpty()) {
                JOptionPane.showMessageDialog(this.ego, lang.getText("HIGwin_entry021"), lang.getText("HIGwin_entry021t"), 1);
            } else {
                this.logFieldTinv.append("\n");
                this.logFieldTinv.append("=====================================================================\n");
                String strB = "err.";
                try {
                    strB = String.format(lang.getText("HIGwin_entry022"), invariants.size());
                }
                catch (Exception e) {
                    overlord.log(lang.getText("LOGentryLNGexc") + " HIGwin_entry022", "error", true);
                }
                this.logFieldTinv.append(strB);
                int card = InvariantsTools.checkCanonity(invariants);
                this.logFieldTinv.append(lang.getText("HIGwin_entry023") + " " + card + "\n");
                this.logFieldTinv.append("=====================================================================\n");
            }
        });
        cardinalityButton.setFocusPainted(false);
        panel.add(cardinalityButton);
        JButton minSuppButton = new JButton();
        minSuppButton.setText(lang.getText("HIGwin_entry024"));
        minSuppButton.setBounds(posX, posY + 54, 110, 48);
        minSuppButton.setMargin(new Insets(0, 0, 0, 0));
        minSuppButton.setIcon(Tools.getResIcon22("/icons/invWindow/test_minsup.png"));
        minSuppButton.setToolTipText(lang.getText("HIGwin_entry024info"));
        minSuppButton.addActionListener(actionEvent -> {
            ArrayList<ArrayList<Integer>> invariants = overlord.getWorkspace().getProject().getT_InvMatrix();
            if (invariants == null || invariants.isEmpty()) {
                JOptionPane.showMessageDialog(this.ego, lang.getText("HIGwin_entry021"), lang.getText("HIGwin_entry021t"), 1);
            } else {
                this.logFieldTinv.append("\n");
                this.logFieldTinv.append("=====================================================================\n");
                String strB = "err.";
                try {
                    strB = String.format(lang.getText("HIGwin_entry025"), invariants.size());
                }
                catch (Exception e) {
                    overlord.log(lang.getText("LOGentryLNGexc") + " HIGwin_entry025", "error", true);
                }
                this.logFieldTinv.append(strB);
                int value = InvariantsTools.checkSupportMinimality(invariants);
                this.logFieldTinv.append(lang.getText("HIGwin_entry026") + " " + value + "\n");
                this.logFieldTinv.append("=====================================================================\n");
            }
        });
        minSuppButton.setFocusPainted(false);
        panel.add(minSuppButton);
        JButton checkMatrixZeroButton = new JButton();
        checkMatrixZeroButton.setText(lang.getText("HIGwin_entry027"));
        checkMatrixZeroButton.setBounds(posX, posY + 108, 110, 48);
        checkMatrixZeroButton.setMargin(new Insets(0, 0, 0, 0));
        checkMatrixZeroButton.setIcon(Tools.getResIcon22("/icons/invWindow/test_invC.png"));
        checkMatrixZeroButton.setToolTipText(lang.getText("HIGwin_entry027info"));
        checkMatrixZeroButton.addActionListener(actionEvent -> {
            ArrayList<ArrayList<Integer>> invariants = overlord.getWorkspace().getProject().getT_InvMatrix();
            if (invariants == null || invariants.isEmpty()) {
                JOptionPane.showMessageDialog(this.ego, lang.getText("HIGwin_entry021"), lang.getText("HIGwin_entry021t"), 1);
            } else {
                this.logFieldTinv.append("\n");
                this.logFieldTinv.append("=====================================================================\n");
                String strB = "err.";
                try {
                    strB = String.format(lang.getText("HIGwin_entry028"), invariants.size());
                }
                catch (Exception e) {
                    overlord.log(lang.getText("LOGentryLNGexc") + " HIGwin_entry028", "error", true);
                }
                this.logFieldTinv.append(strB);
                InvariantsCalculator ic = new InvariantsCalculator(true);
                ArrayList<ArrayList<Integer>> results = InvariantsTools.analyseInvariantDetails(ic.getCMatrix(), invariants, true);
                this.logFieldTinv.append(lang.getText("HIGwin_entry029") + " " + String.valueOf(results.get(0).get(0)) + "\n");
                this.logFieldTinv.append(lang.getText("HIGwin_entry030") + " " + String.valueOf(results.get(0).get(1)) + "\n");
                this.logFieldTinv.append(lang.getText("HIGwin_entry031") + " " + String.valueOf(results.get(0).get(2)) + "\n");
                this.logFieldTinv.append(lang.getText("HIGwin_entry032") + " " + String.valueOf(results.get(0).get(3)) + "\n");
                this.logFieldTinv.append("=====================================================================\n");
                if (this.detailsTinv) {
                    this.showSubSurT_invInfo(results, invariants.size());
                }
            }
        });
        checkMatrixZeroButton.setFocusPainted(false);
        panel.add(checkMatrixZeroButton);
        JCheckBox detailsCheckBox = new JCheckBox(lang.getText("HIGwin_entry035"));
        detailsCheckBox.setBounds(posX, posY + 160, 110, 20);
        detailsCheckBox.setToolTipText(lang.getText("HIGwin_entry035info"));
        detailsCheckBox.addActionListener(actionEvent -> {
            AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
            this.detailsTinv = abstractButton.getModel().isSelected();
        });
        detailsCheckBox.setSelected(true);
        panel.add(detailsCheckBox);
        JButton loadRefButton = new JButton();
        loadRefButton.setText(lang.getText("HIGwin_entry033"));
        loadRefButton.setBounds(posX, posY + 192, 110, 48);
        loadRefButton.setMargin(new Insets(0, 0, 0, 0));
        loadRefButton.setIcon(Tools.getResIcon22("/icons/invWindow/test_ref.png"));
        loadRefButton.setToolTipText(lang.getText("HIGwin_entry033info"));
        loadRefButton.addActionListener(actionEvent -> this.testReference(true));
        loadRefButton.setFocusPainted(false);
        panel.add(loadRefButton);
        JButton testRefButton = new JButton();
        testRefButton.setText(lang.getText("HIGwin_entry034"));
        testRefButton.setBounds(posX, posY + 246, 110, 48);
        testRefButton.setMargin(new Insets(0, 0, 0, 0));
        testRefButton.setIcon(Tools.getResIcon22("/icons/invWindow/test_ref.png"));
        testRefButton.setToolTipText(lang.getText("HIGwin_entry034info"));
        testRefButton.addActionListener(actionEvent -> this.getIncMatrix(true));
        testRefButton.setFocusPainted(false);
        panel.add(testRefButton);
        JCheckBox showDiffCheckBox = new JCheckBox(lang.getText("HIGwin_entry036"));
        showDiffCheckBox.setBounds(posX, posY + 300, 130, 20);
        showDiffCheckBox.setToolTipText(lang.getText("HIGwin_entry036info"));
        showDiffCheckBox.addActionListener(actionEvent -> {
            AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
            this.showInvDiff = abstractButton.getModel().isSelected();
        });
        showDiffCheckBox.setSelected(false);
        panel.add(showDiffCheckBox);
        return panel;
    }

    private JPanel createUpperButtonPanelPinv(int x, int y, int width, int height) {
        JPanel panel = new JPanel();
        panel.setLayout(null);
        panel.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        panel.setBounds(x, y, width, height);
        int posX = 10;
        int posY = 10;
        JButton generateButton = new JButton(lang.getText("HIGwin_entry037"));
        generateButton.setBounds(posX, posY, 110, 60);
        generateButton.setMargin(new Insets(0, 0, 0, 0));
        generateButton.setIcon(Tools.getResIcon32("/icons/stateSim/computeData.png"));
        generateButton.addActionListener(actionEvent -> {
            if (this.isGeneratorWorking) {
                JOptionPane.showMessageDialog(null, lang.getText("HIGwin_entry038"), lang.getText("HIGwin_entry038t"), 2);
            } else {
                this.setGeneratorStatus(true);
                this.invGenerator = new InvariantsCalculator(false);
                Thread myThread = new Thread(this.invGenerator);
                myThread.start();
            }
        });
        generateButton.setFocusPainted(false);
        panel.add(generateButton);
        JButton INAgenerateButton = new JButton();
        INAgenerateButton.setText(lang.getText("HIGwin_entry039"));
        INAgenerateButton.setBounds(posX + 130, posY, 120, 36);
        INAgenerateButton.setMargin(new Insets(0, 0, 0, 0));
        INAgenerateButton.setIcon(Tools.getResIcon22("/icons/invWindow/inaGenerator.png"));
        INAgenerateButton.addActionListener(actionEvent -> {
            if (overlord.getINAStatus()) {
                this.setGeneratorStatus(true);
                HolmesInvariantsGenerator.overlord.io.generateINAinvariants(false);
                HolmesInvariantsGenerator.overlord.reset.setP_invariantsStatus(true);
                ArrayList<ArrayList<Integer>> pInv = overlord.getWorkspace().getProject().getP_InvMatrix();
                overlord.markNetChange();
            } else {
                JOptionPane.showMessageDialog(null, lang.getText("HIGwin_entry040"), lang.getText("HIGwin_entry040t"), 0);
            }
        });
        INAgenerateButton.setFocusPainted(false);
        INAgenerateButton.setEnabled(false);
        panel.add(INAgenerateButton);
        JButton loadInvariantsButton = new JButton();
        loadInvariantsButton.setText(lang.getText("HIGwin_entry041"));
        loadInvariantsButton.setBounds(posX + 255, posY, 120, 36);
        loadInvariantsButton.setMargin(new Insets(0, 0, 0, 0));
        loadInvariantsButton.setIcon(Tools.getResIcon22("/icons/invWindow/loadInvariants.png"));
        loadInvariantsButton.setToolTipText(lang.getText("HIGwin_entry041info"));
        loadInvariantsButton.addActionListener(actionEvent -> {
            boolean status = HolmesInvariantsGenerator.overlord.io.loadExternalAnalysis(false);
            if (status) {
                this.logFieldPinv.append("\n");
                this.logFieldPinv.append("=====================================================================\n");
                this.logFieldPinv.append(lang.getText("LOGentry00445") + " " + overlord.getWorkspace().getProject().getP_InvMatrix().size() + "\n");
                this.logFieldPinv.append("=====================================================================\n");
                overlord.markNetChange();
            } else {
                this.logFieldPinv.append("\n");
                this.logFieldPinv.append(lang.getText("LOGentry00446"));
            }
        });
        loadInvariantsButton.setFocusPainted(false);
        panel.add(loadInvariantsButton);
        JButton saveInvariantsButton = new JButton();
        saveInvariantsButton.setText(lang.getText("HIGwin_entry042"));
        saveInvariantsButton.setBounds(posX + 380, posY, 120, 36);
        saveInvariantsButton.setMargin(new Insets(0, 0, 0, 0));
        saveInvariantsButton.setIcon(Tools.getResIcon22("/icons/invWindow/saveInvariants.png"));
        saveInvariantsButton.setToolTipText(lang.getText("HIGwin_entry042info"));
        saveInvariantsButton.addActionListener(actionEvent -> {
            boolean status = HolmesInvariantsGenerator.overlord.io.exportGeneratedInvariants(false);
            if (status) {
                this.logFieldPinv.append("\n");
                this.logFieldPinv.append("=====================================================================\n");
                this.logFieldPinv.append(lang.getText("LOGentry00447") + " " + overlord.getWorkspace().getProject().getP_InvMatrix().size() + "\n");
                this.logFieldPinv.append("=====================================================================\n");
            } else {
                this.logFieldPinv.append("\n");
                this.logFieldPinv.append(lang.getText("LOGentry00448"));
            }
        });
        saveInvariantsButton.setFocusPainted(false);
        panel.add(saveInvariantsButton);
        JButton showInvariantsButton = new JButton();
        showInvariantsButton.setText(lang.getText("HIGwin_entry043"));
        showInvariantsButton.setBounds(posX + 505, posY, 120, 36);
        showInvariantsButton.setMargin(new Insets(0, 0, 0, 0));
        showInvariantsButton.setIcon(Tools.getResIcon22("/icons/invWindow/showInvariants.png"));
        showInvariantsButton.addActionListener(actionEvent -> this.showNotepadInvariants(false));
        showInvariantsButton.setToolTipText(lang.getText("HIGwin_entry043info"));
        showInvariantsButton.setFocusPainted(false);
        panel.add(showInvariantsButton);
        JCheckBox invPurityCheckBox = new JCheckBox(lang.getText("HIGwin_entry044"));
        invPurityCheckBox.setBounds(posX + 380, posY + 56, 120, 20);
        invPurityCheckBox.setToolTipText(lang.getText("HIGwin_entry044info"));
        invPurityCheckBox.addActionListener(actionEvent -> {
            AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
            if (abstractButton.getModel().isSelected()) {
                overlord.getSettingsManager().setValue("analysisRemoveNonInv", "1", true);
            } else {
                overlord.getSettingsManager().setValue("analysisRemoveNonInv", "0", true);
            }
        });
        invPurityCheckBox.setSelected(overlord.getSettingsManager().getValue("analysisRemoveNonInv").equals("1"));
        panel.add(invPurityCheckBox);
        JCheckBox removeSingleInvCheckBox = new JCheckBox(lang.getText("HIGwin_entry045"));
        removeSingleInvCheckBox.setBounds(posX + 510, posY + 56, 120, 20);
        removeSingleInvCheckBox.setToolTipText(lang.getText("HIGwin_entry045info"));
        removeSingleInvCheckBox.setToolTipText(lang.getText("HIGwin_entry045info"));
        removeSingleInvCheckBox.addActionListener(actionEvent -> {
            AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
            if (abstractButton.getModel().isSelected()) {
                overlord.getSettingsManager().setValue("analysisRemoveSingleElementInv", "1", true);
            } else {
                overlord.getSettingsManager().setValue("analysisRemoveSingleElementInv", "0", true);
            }
        });
        removeSingleInvCheckBox.setSelected(overlord.getSettingsManager().getValue("analysisRemoveSingleElementInv").equals("1"));
        panel.add(removeSingleInvCheckBox);
        return panel;
    }

    private JPanel createLogMainPanelPinv(int x, int y, int width, int height) {
        JPanel panel = new JPanel();
        panel.setLayout(null);
        panel.setBorder(BorderFactory.createTitledBorder(lang.getText("HIGwin_entry046")));
        panel.setBounds(x, y, width, height);
        this.logFieldPinv = new JTextArea();
        this.logFieldPinv.setLineWrap(true);
        this.logFieldPinv.setEditable(false);
        DefaultCaret caret = (DefaultCaret)this.logFieldPinv.getCaret();
        caret.setUpdatePolicy(2);
        JPanel logFieldPanel = new JPanel();
        logFieldPanel.setLayout(new BorderLayout());
        logFieldPanel.add((Component)new JScrollPane(this.logFieldPinv), "Center");
        logFieldPanel.setBounds(10, 20, width - 20, height - 25);
        panel.add(logFieldPanel);
        return panel;
    }

    private JPanel createRightButtonPanelPinv(int x, int y, int width, int height) {
        JPanel panel = new JPanel();
        panel.setLayout(null);
        panel.setBorder(BorderFactory.createTitledBorder(lang.getText("HIGwin_entry019")));
        panel.setBounds(x, y, width, height);
        int posX = 10;
        int posY = 18;
        JButton cardinalityButton = new JButton();
        cardinalityButton.setText(lang.getText("HIGwin_entry047"));
        cardinalityButton.setBounds(posX, posY, 110, 48);
        cardinalityButton.setMargin(new Insets(0, 0, 0, 0));
        cardinalityButton.setIcon(Tools.getResIcon22("/icons/invWindow/test_canon.png"));
        cardinalityButton.setToolTipText(lang.getText("HIGwin_entry047info"));
        cardinalityButton.addActionListener(actionEvent -> {
            ArrayList<ArrayList<Integer>> p_invariants = overlord.getWorkspace().getProject().getP_InvMatrix();
            if (p_invariants == null || p_invariants.isEmpty()) {
                JOptionPane.showMessageDialog(this.ego, lang.getText("HIGwin_entry048"), lang.getText("HIGwin_entry048t"), 1);
            } else {
                this.logFieldPinv.append("\n");
                this.logFieldPinv.append("=====================================================================\n");
                String strB = "err.";
                try {
                    strB = String.format(lang.getText("HIGwin_entry049"), p_invariants.size());
                }
                catch (Exception e) {
                    overlord.log(lang.getText("LOGentryLNGexc") + " HIGwin_entry049", "error", true);
                }
                this.logFieldPinv.append(strB);
                int card = InvariantsTools.checkCanonity(p_invariants);
                this.logFieldPinv.append(lang.getText("HIGwin_entry050") + " " + card + "\n");
                this.logFieldPinv.append("=====================================================================\n");
            }
        });
        cardinalityButton.setFocusPainted(false);
        panel.add(cardinalityButton);
        JButton minSuppButton = new JButton();
        minSuppButton.setText(lang.getText("HIGwin_entry051"));
        minSuppButton.setBounds(posX, posY + 54, 110, 48);
        minSuppButton.setMargin(new Insets(0, 0, 0, 0));
        minSuppButton.setIcon(Tools.getResIcon22("/icons/invWindow/test_minsup.png"));
        minSuppButton.setToolTipText(lang.getText("HIGwin_entry051info"));
        minSuppButton.addActionListener(actionEvent -> {
            ArrayList<ArrayList<Integer>> p_invariants = overlord.getWorkspace().getProject().getP_InvMatrix();
            if (p_invariants == null || p_invariants.isEmpty()) {
                JOptionPane.showMessageDialog(null, lang.getText("HIGwin_entry048"), lang.getText("HIGwin_entry048t"), 1);
            } else {
                this.logFieldPinv.append("\n");
                this.logFieldPinv.append("=====================================================================\n");
                String strB = "err.";
                try {
                    strB = String.format(lang.getText("HIGwin_entry052"), p_invariants.size());
                }
                catch (Exception e) {
                    overlord.log(lang.getText("LOGentryLNGexc") + " HIGwin_entry052", "error", true);
                }
                this.logFieldPinv.append(strB);
                int value = InvariantsTools.checkSupportMinimality(p_invariants);
                this.logFieldPinv.append(lang.getText("HIGwin_entry053") + " " + value + "\n");
                this.logFieldPinv.append("=====================================================================\n");
            }
        });
        minSuppButton.setFocusPainted(false);
        panel.add(minSuppButton);
        JButton checkMatrixZeroButton = new JButton();
        checkMatrixZeroButton.setText(lang.getText("HIGwin_entry054"));
        checkMatrixZeroButton.setBounds(posX, posY + 108, 110, 48);
        checkMatrixZeroButton.setMargin(new Insets(0, 0, 0, 0));
        checkMatrixZeroButton.setIcon(Tools.getResIcon22("/icons/invWindow/test_invC.png"));
        checkMatrixZeroButton.setToolTipText(lang.getText("HIGwin_entry054info"));
        checkMatrixZeroButton.addActionListener(actionEvent -> {
            ArrayList<ArrayList<Integer>> p_invariants = overlord.getWorkspace().getProject().getP_InvMatrix();
            if (p_invariants == null || p_invariants.isEmpty()) {
                JOptionPane.showMessageDialog(null, lang.getText("HIGwin_entry048"), lang.getText("HIGwin_entry048t"), 1);
            } else {
                this.logFieldPinv.append("\n");
                this.logFieldPinv.append("=====================================================================\n");
                String strB = "err.";
                try {
                    strB = String.format(lang.getText("HIGwin_entry055"), p_invariants.size());
                }
                catch (Exception e) {
                    overlord.log(lang.getText("LOGentryLNGexc") + " HIGwin_entry055", "error", true);
                }
                this.logFieldPinv.append(strB);
                InvariantsCalculator ic = new InvariantsCalculator(true);
                ArrayList<ArrayList<Integer>> results = InvariantsTools.analyseInvariantDetails(ic.getCMatrix(), p_invariants, false);
                this.logFieldPinv.append(lang.getText("HIGwin_entry056") + " " + String.valueOf(results.get(0).get(0)) + "\n");
                this.logFieldPinv.append(lang.getText("HIGwin_entry057") + " " + String.valueOf(results.get(0).get(1)) + "\n");
                this.logFieldPinv.append(lang.getText("HIGwin_entry058") + " " + String.valueOf(results.get(0).get(2)) + "\n");
                this.logFieldPinv.append(lang.getText("HIGwin_entry059") + " " + String.valueOf(results.get(0).get(3)) + "\n");
                this.logFieldPinv.append("=====================================================================\n");
                if (this.detailsPinv) {
                    this.showSubSurP_invInfo(results, p_invariants.size());
                }
            }
        });
        checkMatrixZeroButton.setFocusPainted(false);
        panel.add(checkMatrixZeroButton);
        JCheckBox detailsCheckBox = new JCheckBox(lang.getText("HIGwin_entry062"));
        detailsCheckBox.setBounds(posX, posY + 160, 110, 20);
        detailsCheckBox.setToolTipText(lang.getText("HIGwin_entry062info"));
        detailsCheckBox.addActionListener(actionEvent -> {
            AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
            this.detailsPinv = abstractButton.getModel().isSelected();
        });
        detailsCheckBox.setSelected(true);
        panel.add(detailsCheckBox);
        JButton loadRefButton = new JButton();
        loadRefButton.setText(lang.getText("HIGwin_entry060"));
        loadRefButton.setBounds(posX, posY + 192, 110, 48);
        loadRefButton.setMargin(new Insets(0, 0, 0, 0));
        loadRefButton.setIcon(Tools.getResIcon22("/icons/invWindow/test_ref.png"));
        loadRefButton.setToolTipText(lang.getText("HIGwin_entry060info"));
        loadRefButton.addActionListener(actionEvent -> this.testReference(false));
        loadRefButton.setFocusPainted(false);
        panel.add(loadRefButton);
        JButton testRefButton = new JButton();
        testRefButton.setText(lang.getText("HIGwin_entry061"));
        testRefButton.setBounds(posX, posY + 246, 110, 48);
        testRefButton.setMargin(new Insets(0, 0, 0, 0));
        testRefButton.setIcon(Tools.getResIcon22("/icons/invWindow/test_ref.png"));
        testRefButton.setToolTipText(lang.getText("HIGwin_entry061info"));
        testRefButton.addActionListener(actionEvent -> this.getIncMatrix(false));
        testRefButton.setFocusPainted(false);
        panel.add(testRefButton);
        return panel;
    }

    protected void getIncMatrix(boolean Tinv) {
        int i;
        HashMap<Place, Integer> placesMap = new HashMap<Place, Integer>();
        HashMap<Transition, Integer> transitionsMap = new HashMap<Transition, Integer>();
        ArrayList<Place> places = overlord.getWorkspace().getProject().getPlaces();
        ArrayList<Transition> transitions = overlord.getWorkspace().getProject().getTransitions();
        ArrayList<Arc> arcs = overlord.getWorkspace().getProject().getArcs();
        for (i = 0; i < places.size(); ++i) {
            placesMap.put(places.get(i), i);
        }
        for (i = 0; i < transitions.size(); ++i) {
            transitionsMap.put(transitions.get(i), i);
        }
        ArrayList<ArrayList<Integer>> globalIncidenceMatrix = new ArrayList<ArrayList<Integer>>();
        for (int trans = 0; trans < transitions.size(); ++trans) {
            ArrayList<Integer> transRow = new ArrayList<Integer>();
            for (int place = 0; place < places.size(); ++place) {
                transRow.add(0);
            }
            globalIncidenceMatrix.add(transRow);
        }
        for (Arc oneArc : arcs) {
            int incidenceValue;
            int pPosition;
            int tPosition;
            if (oneArc.getArcType() != Arc.TypeOfArc.NORMAL) continue;
            if (oneArc.getStartNode().getType() == PetriNetElement.PetriNetElementType.TRANSITION) {
                tPosition = (Integer)transitionsMap.get(oneArc.getStartNode());
                pPosition = (Integer)placesMap.get(oneArc.getEndNode());
                incidenceValue = oneArc.getWeight();
            } else {
                tPosition = (Integer)transitionsMap.get(oneArc.getEndNode());
                pPosition = (Integer)placesMap.get(oneArc.getStartNode());
                incidenceValue = -1 * oneArc.getWeight();
            }
            int oldValue = globalIncidenceMatrix.get(tPosition).get(pPosition);
            if (oldValue != 0) {
                ArrayList<Integer> hiddenReadArc = new ArrayList<Integer>();
                hiddenReadArc.add(pPosition);
                hiddenReadArc.add(tPosition);
            }
            globalIncidenceMatrix.get(tPosition).set(pPosition, oldValue + incidenceValue);
        }
        if (Tinv) {
            notePad = new HolmesNotepad(900, 600);
            notePad.setVisible(true);
            notePad.addTextLineNL("", "text");
            for (int t = 0; t < globalIncidenceMatrix.size(); ++t) {
                ArrayList<Integer> transRow = globalIncidenceMatrix.get(t);
                StringBuilder text = new StringBuilder("t" + t + " ");
                for (Integer integer : transRow) {
                    text.append(" ").append(integer);
                }
                notePad.addTextLineNL(text.toString(), "text");
            }
        } else {
            globalIncidenceMatrix = InvariantsTools.transposeMatrix(globalIncidenceMatrix);
            notePad = new HolmesNotepad(900, 600);
            notePad.setVisible(true);
            notePad.addTextLineNL("", "text");
            for (int p = 0; p < globalIncidenceMatrix.size(); ++p) {
                ArrayList<Integer> placeRow = globalIncidenceMatrix.get(p);
                StringBuilder text = new StringBuilder("p" + p + " ");
                for (Integer integer : placeRow) {
                    text.append(" ").append(integer);
                }
                notePad.addTextLineNL(text.toString(), "text");
            }
        }
    }

    protected void testReference(boolean t_inv) {
        ArrayList<ArrayList<Integer>> invariants = Check.invExistsWithWarning(t_inv);
        if (invariants == null) {
            return;
        }
        String lastPath = overlord.getLastPath();
        FileFilter[] filters = new FileFilter[]{t_inv ? new ExtensionFileFilter("INA t-nvariants file (.inv)", new String[]{"INV"}) : new ExtensionFileFilter("INA p-invariants file (.inv)", new String[]{"INV"})};
        String selectedFile = Tools.selectFileDialog(lastPath, filters, lang.getText("HIGwin_entry063"), lang.getText("HIGwin_entry063t"), "");
        if (selectedFile.isEmpty()) {
            return;
        }
        File file = new File(selectedFile);
        if (!file.exists()) {
            return;
        }
        IOprotocols io = new IOprotocols();
        boolean status = t_inv ? io.readT_invariants(file.getPath()) : io.readP_invariants(file.getPath());
        if (!status) {
            return;
        }
        this.refTest(invariants, io.getInvariantsList(), t_inv);
    }

    private void refTest(ArrayList<ArrayList<Integer>> invRefMatrix, ArrayList<ArrayList<Integer>> invLoadedMatrix, boolean t_inv) {
        if (invRefMatrix != null) {
            String symbol = "t-";
            if (!t_inv) {
                symbol = "p-";
            }
            ArrayList<ArrayList<Integer>> res = InvariantsTools.compareTwoInvariantsSets(invRefMatrix, invLoadedMatrix);
            this.accessLogField(t_inv).append("\n");
            this.accessLogField(t_inv).append("=====================================================================\n");
            this.accessLogField(t_inv).append(lang.getText("HIGwin_entry064") + "   " + invRefMatrix.size() + "\n");
            this.accessLogField(t_inv).append(lang.getText("HIGwin_entry065") + "    " + invLoadedMatrix.size() + "\n");
            this.accessLogField(t_inv).append(lang.getText("HIGwin_entry066") + " " + res.get(0).size() + "\n");
            this.accessLogField(t_inv).append(lang.getText("HIGwin_entry068") + " " + symbol + lang.getText("HIGwin_entry068_1") + " " + res.get(1).size() + "\n");
            this.accessLogField(t_inv).append(lang.getText("HIGwin_entry069") + " " + symbol + lang.getText("HIGwin_entry069_1") + " " + res.get(2).size() + "\n");
            this.accessLogField(t_inv).append(lang.getText("HIGwin_entry070") + " " + String.valueOf(res.get(3).get(0)) + "\n");
            this.accessLogField(t_inv).append(lang.getText("HIGwin_entry071") + String.valueOf(res.get(3).get(1)) + "\n");
            this.accessLogField(t_inv).append("\n");
            this.accessLogField(t_inv).append(lang.getText("HIGwin_entry072") + " " + invLoadedMatrix.size() + " " + symbol + lang.getText("HIGwin_entry072_1"));
            int card = InvariantsTools.checkCanonity(invLoadedMatrix);
            this.accessLogField(t_inv).append(lang.getText("HIGwin_entry073") + " " + symbol + lang.getText("HIGwin_entry073_1") + " " + card + "\n");
            int value = InvariantsTools.checkSupportMinimality(invLoadedMatrix);
            this.accessLogField(t_inv).append(lang.getText("HIGwin_entry074") + " " + symbol + lang.getText("HIGwin_entry074_1") + " " + value + "\n");
            InvariantsCalculator ic = new InvariantsCalculator(true);
            ArrayList<ArrayList<Integer>> results = InvariantsTools.analyseInvariantDetails(ic.getCMatrix(), invLoadedMatrix, t_inv);
            this.accessLogField(t_inv).append(" " + symbol + lang.getText("HIGwin_entry075") + " " + String.valueOf(results.get(0).get(0)) + "\n");
            this.accessLogField(t_inv).append("Sur-" + symbol + lang.getText("HIGwin_entry076") + " " + String.valueOf(results.get(0).get(1)) + "\n");
            this.accessLogField(t_inv).append("Sub-" + symbol + lang.getText("HIGwin_entry077") + " " + String.valueOf(results.get(0).get(2)) + "\n");
            this.accessLogField(t_inv).append("Non-" + symbol + lang.getText("HIGwin_entry078") + " " + String.valueOf(results.get(0).get(3)) + "\n");
            this.accessLogField(t_inv).append("=====================================================================\n");
            this.accessLogField(t_inv).append("\n");
            if (this.detailsPinv) {
                this.showSubSurT_invInfo(results, invLoadedMatrix.size());
            }
        }
    }

    private void showSubSurT_invInfo(ArrayList<ArrayList<Integer>> results, int invMatrixSize) {
        int value;
        int p;
        int surPlaceMaxName = 0;
        int subPlaceMaxName = 0;
        ArrayList<Integer> surInvVector = results.get(1);
        ArrayList<Integer> subInvVector = results.get(2);
        ArrayList<Integer> noInvVector = results.get(3);
        HolmesNotepad notePad = new HolmesNotepad(900, 600);
        notePad.setVisible(true);
        notePad.addTextLineNL("", "text");
        notePad.addTextLineNL(lang.getText("HIGwin_entry079") + " " + invMatrixSize, "text");
        notePad.addTextLineNL(lang.getText("HIGwin_entry080") + " " + String.valueOf(results.get(0).get(0)), "text");
        notePad.addTextLineNL(lang.getText("HIGwin_entry081") + " " + String.valueOf(results.get(0).get(1)), "text");
        notePad.addTextLineNL(lang.getText("HIGwin_entry082") + " " + String.valueOf(results.get(0).get(2)), "text");
        notePad.addTextLineNL(lang.getText("HIGwin_entry083") + " " + String.valueOf(results.get(0).get(3)), "text");
        notePad.addTextLineNL("", "text");
        ArrayList<Place> places = overlord.getWorkspace().getProject().getPlaces();
        int size = places.size();
        if (results.get(0).get(1) > 0 || results.get(0).get(2) > 0) {
            for (p = 0; p < size; ++p) {
                int nameSize;
                value = surInvVector.get(p);
                if (value != 0 && (nameSize = places.get(p).getName().length()) > surPlaceMaxName) {
                    surPlaceMaxName = nameSize;
                }
                if ((value = subInvVector.get(p).intValue()) == 0 || (nameSize = places.get(p).getName().length()) <= subPlaceMaxName) continue;
                subPlaceMaxName = nameSize;
            }
        }
        if (results.get(0).get(1) > 0) {
            notePad.addTextLineNL(lang.getText("HIGwin_entry084"), "text");
            notePad.addTextLineNL(lang.getText("HIGwin_entry085"), "text");
            for (p = 0; p < size; ++p) {
                value = surInvVector.get(p);
                if (value == 0) continue;
                String line = "p_" + p + Tools.setToSize(places.get(p).getName(), surPlaceMaxName + 3, false) + ": " + value;
                notePad.addTextLineNL(line, "text");
            }
        }
        notePad.addTextLineNL("", "text");
        if (results.get(0).get(2) > 0) {
            notePad.addTextLineNL(lang.getText("HIGwin_entry086"), "text");
            notePad.addTextLineNL(lang.getText("HIGwin_entry087"), "text");
            for (p = 0; p < size; ++p) {
                value = subInvVector.get(p);
                if (value == 0) continue;
                String line = "p_" + p + Tools.setToSize(places.get(p).getName(), subPlaceMaxName + 2, false) + ": " + value;
                notePad.addTextLineNL(line, "text");
            }
        }
        if (results.get(0).get(3) > 0) {
            notePad.addTextLineNL(lang.getText("HIGwin_entry088"), "text");
            notePad.addTextLineNL(lang.getText("HIGwin_entry089"), "text");
            for (p = 0; p < size; ++p) {
                value = noInvVector.get(p);
                if (value == 0) continue;
                String line = "p_" + p + Tools.setToSize(places.get(p).getName(), subPlaceMaxName + 2, false) + ": " + value;
                notePad.addTextLineNL(line, "text");
            }
        }
    }

    private void showSubSurP_invInfo(ArrayList<ArrayList<Integer>> results, int invMatrixSize) {
        int value;
        int t;
        int surTransMaxName = 0;
        int subTransMaxName = 0;
        ArrayList<Integer> surInvVector = results.get(1);
        ArrayList<Integer> subInvVector = results.get(2);
        ArrayList<Integer> noInvVector = results.get(3);
        HolmesNotepad notePad = new HolmesNotepad(900, 600);
        notePad.setVisible(true);
        notePad.addTextLineNL("", "text");
        notePad.addTextLineNL(lang.getText("HIGwin_entry090") + " " + invMatrixSize, "text");
        notePad.addTextLineNL(lang.getText("HIGwin_entry091") + " " + String.valueOf(results.get(0).get(0)), "text");
        notePad.addTextLineNL(lang.getText("HIGwin_entry092") + " " + String.valueOf(results.get(0).get(1)), "text");
        notePad.addTextLineNL(lang.getText("HIGwin_entry093") + " " + String.valueOf(results.get(0).get(2)), "text");
        notePad.addTextLineNL(lang.getText("HIGwin_entry094") + " " + String.valueOf(results.get(0).get(3)), "text");
        notePad.addTextLineNL("", "text");
        ArrayList<Transition> transitions = overlord.getWorkspace().getProject().getTransitions();
        int size = transitions.size();
        if (results.get(0).get(1) > 0 || results.get(0).get(2) > 0) {
            for (t = 0; t < size; ++t) {
                int nameSize;
                value = surInvVector.get(t);
                if (value != 0 && (nameSize = transitions.get(t).getName().length()) > surTransMaxName) {
                    surTransMaxName = nameSize;
                }
                if ((value = subInvVector.get(t).intValue()) == 0 || (nameSize = transitions.get(t).getName().length()) <= subTransMaxName) continue;
                subTransMaxName = nameSize;
            }
        }
        if (results.get(0).get(1) > 0) {
            notePad.addTextLineNL(lang.getText("HIGwin_entry095"), "text");
            notePad.addTextLineNL(lang.getText("HIGwin_entry096"), "text");
            for (t = 0; t < size; ++t) {
                value = surInvVector.get(t);
                if (value == 0) continue;
                String line = "t_" + t + Tools.setToSize(transitions.get(t).getName(), surTransMaxName + 3, false) + ": " + value;
                notePad.addTextLineNL(line, "text");
            }
        }
        notePad.addTextLineNL("", "text");
        if (results.get(0).get(2) > 0) {
            notePad.addTextLineNL(lang.getText("HIGwin_entry097"), "text");
            notePad.addTextLineNL(lang.getText("HIGwin_entry098"), "text");
            for (t = 0; t < size; ++t) {
                value = subInvVector.get(t);
                if (value == 0) continue;
                String line = "t_" + t + Tools.setToSize(transitions.get(t).getName(), subTransMaxName + 2, false) + ": " + value;
                notePad.addTextLineNL(line, "text");
            }
        }
        if (results.get(0).get(3) > 0) {
            notePad.addTextLineNL(lang.getText("HIGwin_entry099"), "text");
            notePad.addTextLineNL(lang.getText("HIGwin_entry100"), "text");
            for (t = 0; t < size; ++t) {
                value = noInvVector.get(t);
                if (value == 0) continue;
                String line = "t_" + t + Tools.setToSize(transitions.get(t).getName(), subTransMaxName + 2, false) + ": " + value;
                notePad.addTextLineNL(line, "text");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkAndMakeFeasible() {
        ArrayList<ArrayList<Integer>> invariants = Check.invExistsWithWarning(true);
        if (invariants == null) {
            return;
        }
        InvariantsCalculatorFeasible invF = new InvariantsCalculatorFeasible(invariants, true);
        invariants = invF.getMinFeasible(this.feasibleCalcMode);
        Object[] options = new Object[]{lang.getText("saveAndReplace"), lang.getText("saveOnly"), lang.getText("replaceOnly"), lang.getText("cancel")};
        int n = JOptionPane.showOptionDialog(null, lang.getText("HIGwin_entry101"), lang.getText("question"), 0, 3, null, options, options[3]);
        if (n == 0) {
            PetriNet project = overlord.getWorkspace().getProject();
            project.setT_InvMatrix(invariants, false);
            HolmesInvariantsGenerator.overlord.io.exportGeneratedInvariants(true);
            overlord.getT_invBox().showT_invBoxWindow(project.getT_InvMatrix());
            overlord.markNetChange();
        } else if (n == 1) {
            ArrayList<ArrayList<Integer>> invBackup = overlord.getWorkspace().getProject().getT_InvMatrix();
            try {
                overlord.getWorkspace().getProject().setT_InvMatrix(invariants, false);
                HolmesInvariantsGenerator.overlord.io.exportGeneratedInvariants(true);
            }
            catch (Exception ex) {
                overlord.log(lang.getText("HIGwin_entry102exception") + "\n" + ex.getMessage(), "error", true);
            }
            finally {
                overlord.getWorkspace().getProject().setT_InvMatrix(invBackup, false);
            }
        } else if (n == 2) {
            PetriNet project = overlord.getWorkspace().getProject();
            project.setT_InvMatrix(invariants, false);
            overlord.getT_invBox().showT_invBoxWindow(project.getT_InvMatrix());
            overlord.markNetChange();
        }
    }

    protected void showNotepadInvariants(boolean t_inv) {
        block6: {
            block5: {
                if (!t_inv) break block5;
                ArrayList<ArrayList<Integer>> t_invariants = overlord.getWorkspace().getProject().getT_InvMatrix();
                if (t_invariants == null) break block6;
                HolmesNotepad notePad = new HolmesNotepad(900, 600);
                notePad.setVisible(true);
                notePad.addTextLineNL(lang.getText("HIGwin_entry103"), "text");
                for (ArrayList<Integer> inv : t_invariants) {
                    StringBuilder vector = new StringBuilder();
                    for (int value : inv) {
                        vector.append(value).append(";");
                    }
                    vector = new StringBuilder(vector.substring(0, vector.length() - 1));
                    notePad.addTextLineNL(vector.toString(), "text");
                }
                break block6;
            }
            ArrayList<ArrayList<Integer>> p_invariants = overlord.getWorkspace().getProject().getP_InvMatrix();
            if (p_invariants != null) {
                HolmesNotepad notePad = new HolmesNotepad(900, 600);
                notePad.setVisible(true);
                notePad.addTextLineNL(lang.getText("HIGwin_entry104"), "text");
                for (ArrayList<Integer> inv : p_invariants) {
                    StringBuilder vector = new StringBuilder();
                    for (int value : inv) {
                        vector.append(value).append(";");
                    }
                    vector = new StringBuilder(vector.substring(0, vector.length() - 1));
                    notePad.addTextLineNL(vector.toString(), "text");
                }
            }
        }
    }

    public JTextArea accessLogField(boolean t_inv) {
        if (t_inv) {
            return this.accessLogFieldTinv();
        }
        return this.accessLogFieldPinv();
    }

    public JTextArea accessLogFieldTinv() {
        return this.logFieldTinv;
    }

    public JTextArea accessLogFieldPinv() {
        return this.logFieldPinv;
    }

    public void resetInvariantGenerator() {
        this.invGenerator = null;
        this.setGeneratorStatus(false);
    }

    public void setGeneratorStatus(boolean status) {
        this.isGeneratorWorking = status;
    }
}

