/*
 * Decompiled with CFR 0.152.
 */
package holmes.windows;

import holmes.darkgui.GUIManager;
import holmes.utilities.HolmesFileView;
import holmes.utilities.Tools;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.Document;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;

public class HolmesConsole
extends JFrame {
    private static final long serialVersionUID = -2286636544180010192L;
    private static final GUIManager overlord = GUIManager.getDefaultGUIManager();
    private String newline = "\n";
    private StyledDocument doc;
    private JTextPane textPane;
    private String[] initStyles = new String[]{"regular", "italic", "bold", "small", "large", "warning", "error"};
    private boolean noWarnings = false;
    private boolean noErrors = false;

    public HolmesConsole() {
        this.setTitle("Holmes Status Console");
        try {
            this.setIconImage(Tools.getImageFromIcon("/icons/holmesicon.png"));
        }
        catch (Exception ex) {
            overlord.log("Error (316619924) | Exception:  " + ex.getMessage(), "error", true);
        }
        this.setVisible(false);
        this.setDefaultCloseOperation(1);
        this.setMinimumSize(new Dimension(1000, 400));
        this.setMaximumSize(new Dimension(1000, 400));
        this.setResizable(false);
        JPanel tablePanel = this.createEditor();
        tablePanel.setOpaque(true);
        this.setContentPane(tablePanel);
        this.pack();
    }

    private JPanel createEditor() {
        JPanel editPanel = new JPanel();
        editPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 23;
        gbc.fill = 1;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.1;
        gbc.weighty = 1.0;
        this.textPane = this.createTextPane();
        this.textPane.setEditable(false);
        JScrollPane paneScrollPane = new JScrollPane(this.textPane);
        paneScrollPane.setVerticalScrollBarPolicy(22);
        editPanel.add((Component)paneScrollPane, gbc);
        gbc.insets = new Insets(5, 10, 5, 10);
        gbc.gridy = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.fill = 15;
        JButton button = new JButton("Save log...");
        button.addActionListener(actionEvent -> this.saveDialog());
        editPanel.add((Component)button, gbc);
        return editPanel;
    }

    private JTextPane createTextPane() {
        String initString = "Console initiated" + this.newline;
        JTextPane txtPane = new JTextPane();
        this.doc = txtPane.getStyledDocument();
        this.addStylesToDocument(this.doc);
        try {
            this.doc.insertString(this.doc.getLength(), initString, this.doc.getStyle("regular"));
        }
        catch (BadLocationException ble) {
            System.err.println("Couldn't initialize the console.");
        }
        return txtPane;
    }

    public void addText(String text, String mode, boolean time, boolean enter) {
        int style;
        Style def = StyleContext.getDefaultStyleContext().getStyle("default");
        StyleConstants.setFontFamily(def, "SansSerif");
        StyleConstants.setFontSize(def, 12);
        String newLn = "";
        if (enter) {
            newLn = this.newline;
        }
        switch (mode) {
            case "warning": {
                if (this.noWarnings) {
                    return;
                }
                style = 5;
                break;
            }
            case "error": {
                if (this.noErrors) {
                    return;
                }
                style = 6;
                break;
            }
            case "text": {
                style = 0;
                break;
            }
            case "italic": {
                style = 1;
                break;
            }
            case "bold": {
                style = 2;
                break;
            }
            default: {
                style = 0;
            }
        }
        try {
            if (time) {
                String timeStamp = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(Calendar.getInstance().getTime());
                this.doc.insertString(this.doc.getLength(), "[" + timeStamp + "]   ", this.doc.getStyle("time"));
            }
            this.doc.insertString(this.doc.getLength(), text + newLn, this.doc.getStyle(this.initStyles[style]));
        }
        catch (BadLocationException ble) {
            System.err.println("Couldn't insert text into console.");
        }
        int len = this.textPane.getDocument().getLength();
        this.textPane.setCaretPosition(len);
    }

    private void addStylesToDocument(StyledDocument doc) {
        Style def = StyleContext.getDefaultStyleContext().getStyle("default");
        Style regular = doc.addStyle("regular", def);
        StyleConstants.setFontFamily(def, "SansSerif");
        Style s = doc.addStyle("italic", regular);
        StyleConstants.setItalic(s, true);
        s = doc.addStyle("bold", regular);
        StyleConstants.setBold(s, true);
        s = doc.addStyle("small", regular);
        StyleConstants.setFontSize(s, 10);
        s = doc.addStyle("large", regular);
        StyleConstants.setFontSize(s, 16);
        s = doc.addStyle("warning", regular);
        StyleConstants.setForeground(s, Color.magenta);
        s = doc.addStyle("error", regular);
        StyleConstants.setForeground(s, Color.red);
        s = doc.addStyle("time", regular);
        StyleConstants.setForeground(s, Color.darkGray);
        StyleConstants.setBold(s, true);
    }

    public void silenceWarnings(boolean value) {
        this.noWarnings = value;
    }

    public void silenceErrors(boolean value) {
        this.noErrors = value;
    }

    private void saveDialog() {
        JFileChooser chooserSaveAs = new JFileChooser();
        chooserSaveAs.setFileView(new HolmesFileView());
        chooserSaveAs.setDialogTitle("Save as...");
        if (chooserSaveAs.showSaveDialog(this) == 0) {
            File file = chooserSaveAs.getSelectedFile();
            this.saveLogToFile(file);
        }
    }

    public void saveLogToFile(File file) {
        File saveFile = file == null ? new File("log/log.txt") : file;
        try {
            PrintStream p = new PrintStream(new BufferedOutputStream(new FileOutputStream(saveFile, true)));
            p.println("*********************************************************************");
            p.close();
            DefaultEditorKit kit = new DefaultEditorKit();
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(saveFile, true));
            kit.write(out, (Document)this.doc, this.doc.getStartPosition().getOffset(), this.doc.getLength());
            out.close();
        }
        catch (IOException | BadLocationException exception) {
            // empty catch block
        }
    }
}

