/*
 * Decompiled with CFR 0.152.
 */
package holmes.utilities;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Random;

public class ColorPalette {
    private int currentColor = 0;
    private ArrayList<Color> colors = new ArrayList();
    private Random generator = new Random(777L);

    public ColorPalette() {
        this.initializeColor();
    }

    public Color getColor() {
        if (this.currentColor < this.colors.size()) {
            ++this.currentColor;
            return this.colors.get(this.currentColor - 1);
        }
        return this.generateRandomColor(null);
    }

    public Color getColor(int value) {
        int size = this.colors.size();
        if (value >= size - 1) {
            return Color.BLACK;
        }
        return this.colors.get(value);
    }

    public int getCurrentIndex() {
        return this.currentColor;
    }

    private void initializeColor() {
        this.colors.add(new Color(255, 0, 0));
        this.colors.add(new Color(255, 255, 0));
        this.colors.add(new Color(0, 255, 0));
        this.colors.add(new Color(0, 0, 255));
        this.colors.add(new Color(102, 0, 204));
        this.colors.add(new Color(255, 128, 0));
        this.colors.add(new Color(102, 0, 0));
        this.colors.add(new Color(51, 51, 0));
        this.colors.add(new Color(255, 102, 178));
        this.colors.add(new Color(0, 102, 0));
        this.colors.add(new Color(102, 102, 255));
        this.colors.add(new Color(153, 204, 255));
        this.colors.add(new Color(102, 255, 255));
        this.colors.add(new Color(102, 102, 0));
        this.colors.add(new Color(0, 0, 102));
        this.colors.add(new Color(204, 153, 255));
        this.colors.add(new Color(229, 255, 204));
        this.colors.add(new Color(255, 204, 153));
        for (int i = 0; i < 100; ++i) {
            this.colors.add(this.generateRandomColor(null));
        }
    }

    private Color generateRandomColor(Color mix) {
        int red = this.generator.nextInt(256);
        int green = this.generator.nextInt(256);
        int blue = this.generator.nextInt(256);
        if (mix != null) {
            red = (red + mix.getRed()) / 2;
            green = (green + mix.getGreen()) / 2;
            blue = (blue + mix.getBlue()) / 2;
        }
        return new Color(red, green, blue);
    }
}

