/*
 * Decompiled with CFR 0.152.
 */
package holmes.tables.managers;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.text.DecimalFormat;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;

public class StatesPlacesTableRendererXTPN
implements TableCellRenderer {
    public DefaultTableCellRenderer DEFAULT_RENDERER = new DefaultTableCellRenderer();
    private static final DecimalFormat formatter = new DecimalFormat("#");
    private final JTable table;
    private static final Font fontNormal = new Font("Verdana", 0, 9);
    private static final Font fontBold = new Font("Verdana", 1, 9);

    public StatesPlacesTableRendererXTPN(JTable table) {
        this.table = table;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        return this.paintCellsInvariants(value, isSelected, hasFocus, row, column);
    }

    private Component paintCellsInvariants(Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        JLabel oLabel = (JLabel)this.DEFAULT_RENDERER.getTableCellRendererComponent(this.table, value, isSelected, hasFocus, row, column);
        oLabel.setBackground(Color.white);
        oLabel.setFont(fontNormal);
        int selectedRow = this.table.getSelectedRow();
        Object firstCell = this.table.getValueAt(row, 0);
        if (firstCell.toString().equals("X")) {
            oLabel.setFont(fontBold);
        }
        if (selectedRow == row) {
            oLabel.setBackground(Color.lightGray);
        }
        if (value instanceof Double) {
            value = formatter.format(value);
        }
        oLabel.setText(value.toString());
        return oLabel;
    }
}

