/*
 * Decompiled with CFR 0.152.
 */
package holmes.tables.managers;

import holmes.petrinet.data.SSAplacesVector;
import java.util.ArrayList;
import javax.swing.table.DefaultTableModel;

public class SSAplacesTableModel
extends DefaultTableModel {
    private static final long serialVersionUID = -7214250232934584183L;
    private String[] columnNames;
    private ArrayList<SSAtableContainer> dataMatrix;
    private int dataSize;

    public SSAplacesTableModel() {
        this.clearModel();
    }

    public void clearModel() {
        this.columnNames = new String[5];
        this.columnNames[0] = "selected";
        this.columnNames[1] = "ID";
        this.columnNames[2] = "Vector description";
        this.columnNames[3] = "Data type";
        this.columnNames[4] = "Volume";
        this.dataMatrix = new ArrayList();
        this.dataSize = 0;
    }

    public void changeType(int row, SSAplacesVector.SSAdataType type) {
        this.dataMatrix.get((int)row).type = type;
    }

    public void addNew(String selected, int id, String description, SSAplacesVector.SSAdataType type, double volume) {
        SSAtableContainer data = new SSAtableContainer();
        data.selected = selected;
        data.ID = id;
        data.description = description;
        data.type = type;
        data.volume = volume;
        this.dataMatrix.add(data);
        ++this.dataSize;
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public int getRowCount() {
        return this.dataSize;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this.columnNames[columnIndex];
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return false;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        if (this.dataMatrix.isEmpty()) {
            return Object.class;
        }
        return switch (columnIndex) {
            case 0, 2, 3 -> String.class;
            case 1 -> Integer.class;
            case 4 -> Double.class;
            default -> Object.class;
        };
    }

    public void setSelected(int row) {
        for (int i = 0; i < this.dataSize; ++i) {
            this.dataMatrix.get((int)i).selected = i == row ? "X" : "";
        }
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        try {
            return switch (columnIndex) {
                case 0 -> this.dataMatrix.get((int)rowIndex).selected;
                case 1 -> this.dataMatrix.get((int)rowIndex).ID;
                case 2 -> this.dataMatrix.get((int)rowIndex).description;
                case 3 -> this.dataMatrix.get((int)rowIndex).type;
                case 4 -> this.dataMatrix.get((int)rowIndex).volume;
                default -> -1;
            };
        }
        catch (Exception e) {
            return -1;
        }
    }

    public static class SSAtableContainer {
        public String selected;
        public int ID;
        public String description;
        public SSAplacesVector.SSAdataType type;
        public double volume;
    }
}

