/*
 * Decompiled with CFR 0.152.
 */
package holmes.tables.managers;

import holmes.darkgui.GUIManager;
import holmes.darkgui.LanguageManager;
import holmes.petrinet.data.SSAplacesVector;
import holmes.windows.managers.HolmesSSAplacesEditor;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.EventObject;
import javax.swing.JOptionPane;
import javax.swing.table.DefaultTableModel;

public class SSAplacesEditorTableModel
extends DefaultTableModel {
    private static final long serialVersionUID = 5334544477964813872L;
    private static final GUIManager overlord = GUIManager.getDefaultGUIManager();
    private static final LanguageManager lang = GUIManager.getLanguageManager();
    private String[] columnNames;
    private ArrayList<SSAdataClass> dataMatrix;
    private int dataSize;
    private HolmesSSAplacesEditor boss;
    private int ssaVectorIndex;
    public boolean changes = false;
    private SSAplacesVector.SSAdataType dataType;

    public SSAplacesEditorTableModel(HolmesSSAplacesEditor boss, int ssaVectorIndex, SSAplacesVector.SSAdataType dataType) {
        this.boss = boss;
        this.ssaVectorIndex = ssaVectorIndex;
        this.dataType = dataType;
        this.clearModel();
    }

    public void clearModel() {
        this.columnNames = new String[3];
        this.columnNames[0] = "ID";
        this.columnNames[1] = "Place Name";
        this.columnNames[2] = "Value";
        this.dataMatrix = new ArrayList();
        this.dataSize = 0;
    }

    public void addNew(int ID, String name, double value) {
        SSAdataClass row = new SSAdataClass();
        row.ID = ID;
        row.name = name;
        row.ssaValue = value;
        this.dataMatrix.add(row);
        ++this.dataSize;
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public int getRowCount() {
        return this.dataSize;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this.columnNames[columnIndex];
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        if (this.dataMatrix.isEmpty()) {
            return Object.class;
        }
        return this.getValueAt(0, columnIndex).getClass();
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return column == 2;
    }

    public boolean isCellEditable(EventObject evt) {
        if (evt instanceof MouseEvent) {
            int clickCount = 1;
            return ((MouseEvent)evt).getClickCount() >= clickCount;
        }
        return true;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return this.dataMatrix.get((int)rowIndex).ID;
            }
            case 1: {
                return this.dataMatrix.get((int)rowIndex).name;
            }
            case 2: {
                return this.dataMatrix.get((int)rowIndex).ssaValue;
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        block8: {
            double newValue = 0.0;
            try {
                if (col != 2) break block8;
                newValue = Double.parseDouble(value.toString());
                if (this.dataType == SSAplacesVector.SSAdataType.MOLECULES) {
                    if (newValue > 0.9) {
                        this.dataMatrix.get((int)row).ssaValue = newValue;
                        this.boss.changeRealValue(this.ssaVectorIndex, row, newValue);
                        break block8;
                    }
                    String strB = "err.";
                    try {
                        strB = String.format(lang.getText("SSAPETM_entry001"), newValue);
                    }
                    catch (Exception e) {
                        overlord.log(lang.getText("LOGentryLNGexc") + " SSAPETM_entry001", "error", true);
                    }
                    JOptionPane.showMessageDialog(this.boss, strB, lang.getText("SSAPETM_entry001t"), 2);
                    break block8;
                }
                if (newValue < 10.0) {
                    this.dataMatrix.get((int)row).ssaValue = newValue;
                    this.boss.changeRealValue(this.ssaVectorIndex, row, newValue);
                } else {
                    JOptionPane.showMessageDialog(this.boss, lang.getText("SSAPETM_entry002"), lang.getText("SSAPETM_entry002t"), 2);
                }
            }
            catch (Exception e) {
                overlord.log(lang.getText("LOGentry00422exception") + "\n" + e.getMessage(), "error", true);
            }
        }
    }

    public static class SSAdataClass {
        public int ID;
        public String name;
        public Double ssaValue;
    }
}

