/*
 * Decompiled with CFR 0.152.
 */
package holmes.tables.managers;

import holmes.petrinet.data.SPNdataVector;
import holmes.windows.managers.HolmesSPNmanager;
import java.util.ArrayList;
import javax.swing.table.DefaultTableModel;

public class SPNdataVectorsTableModel
extends DefaultTableModel {
    private static final long serialVersionUID = 3869824360655880298L;
    private String[] columnNames;
    private ArrayList<SPNvectorTableClass> dataMatrix;
    private int dataSize;
    public boolean changes = false;
    private HolmesSPNmanager boss;

    public SPNdataVectorsTableModel(HolmesSPNmanager boss) {
        this.boss = boss;
        this.clearModel();
    }

    public void clearModel() {
        this.columnNames = new String[4];
        this.columnNames[0] = "Selected";
        this.columnNames[1] = "ID";
        this.columnNames[2] = "Description";
        this.columnNames[3] = "SuperType";
        this.dataMatrix = new ArrayList();
        this.dataSize = 0;
    }

    public void addNew(String selected, int ID, String name, SPNdataVector.SPNvectorSuperType superType) {
        SPNvectorTableClass row = new SPNvectorTableClass();
        row.selected = selected;
        row.ID = ID;
        row.frName = name;
        row.superType = superType;
        this.dataMatrix.add(row);
        ++this.dataSize;
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public int getRowCount() {
        return this.dataSize;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this.columnNames[columnIndex];
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        if (this.dataMatrix.isEmpty()) {
            return Object.class;
        }
        return this.getValueAt(0, columnIndex).getClass();
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return column == 2;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return switch (columnIndex) {
            case 0 -> this.dataMatrix.get((int)rowIndex).selected;
            case 1 -> Integer.valueOf(this.dataMatrix.get((int)rowIndex).ID);
            case 2 -> this.dataMatrix.get((int)rowIndex).frName;
            case 3 -> this.dataMatrix.get((int)rowIndex).superType;
            default -> null;
        };
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        try {
            if (col == 2) {
                this.dataMatrix.get((int)row).frName = value.toString();
                this.boss.changeState(row, col, value.toString());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setSelected(int row) {
        for (int i = 0; i < this.dataSize; ++i) {
            this.dataMatrix.get((int)i).selected = i == row ? "X" : "";
        }
    }

    public static class SPNvectorTableClass {
        public String selected;
        public int ID;
        public String frName;
        public SPNdataVector.SPNvectorSuperType superType;
    }
}

