/*
 * Decompiled with CFR 0.152.
 */
package holmes.tables;

import holmes.tables.InvariantsSimulatorTableModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;

public class PTITableRenderer
implements TableCellRenderer {
    public DefaultTableCellRenderer DEFAULT_RENDERER = new DefaultTableCellRenderer();
    private int mode = 0;
    private JTable table;

    public PTITableRenderer(JTable table) {
        this.table = table;
    }

    public PTITableRenderer(int mode, int rows, JTable table) {
        this(table);
        this.mode = mode;
    }

    public void setSubRows(int rows) {
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (this.mode == 2) {
            return this.paintCellsInvariants(value, isSelected, hasFocus, row, column);
        }
        return this.paintCellsDefault(value, isSelected, hasFocus, row, column);
    }

    private Component paintCellsInvariants(Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Component renderer = this.DEFAULT_RENDERER.getTableCellRendererComponent(this.table, value, isSelected, hasFocus, row, column);
        renderer.setBackground(Color.white);
        renderer.setFont(new Font("Arial", 1, 9));
        InvariantsSimulatorTableModel modelInvariants = (InvariantsSimulatorTableModel)this.table.getModel();
        if (modelInvariants.getInfeasibleInvariants().contains(row)) {
            renderer.setBackground(Color.lightGray);
            if (column > 1 && ((String)modelInvariants.getValueAt(row, column)).contains("(0%)")) {
                renderer.setBackground(Color.gray);
            }
        }
        if (column > 1) {
            if (modelInvariants.getZeroDeadTransitions().get(column - 2) == 0) {
                renderer.setBackground(Color.red);
            } else if (modelInvariants.getZeroDeadTransitions().get(column - 2) == -1) {
                renderer.setBackground(Color.gray);
            }
        }
        return renderer;
    }

    private Component paintCellsDefault(Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Component renderer = this.DEFAULT_RENDERER.getTableCellRendererComponent(this.table, value, isSelected, hasFocus, row, column);
        return renderer;
    }
}

